/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public final class ConcatFieldUpdateProcessorFactory
extends FieldMutatingUpdateProcessorFactory {
    String delimiter = ", ";

    @Override
    public void init(NamedList args) {
        Object d = args.remove("delimiter");
        if (null != d) {
            this.delimiter = d.toString();
        }
        super.init(args);
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return FieldMutatingUpdateProcessor.mutator(this.getSelector(), next, src -> {
            if (src.getValueCount() <= 1) {
                return src;
            }
            SolrInputField result = new SolrInputField(src.getName());
            result.setValue((Object)StringUtils.join((Iterable)src.getValues(), (String)this.delimiter));
            return result;
        });
    }

    @Override
    public FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return fieldName -> {
            IndexSchema schema = core.getLatestSchema();
            FieldType type = schema.getFieldTypeNoEx(fieldName);
            if (null == type) {
                return false;
            }
            if (!TextField.class.isInstance(type) && !StrField.class.isInstance(type)) {
                return false;
            }
            SchemaField sf = schema.getFieldOrNull(fieldName);
            if (null == sf) {
                return false;
            }
            return !sf.multiValued();
        };
    }
}

