/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.users.User;

public final class PassiveScanData {
    private static final Logger LOGGER = Logger.getLogger(PassiveScanData.class);
    private final HttpMessage message;
    private final Context context;
    private final TechSet techSet;
    private List<User> userList = null;

    PassiveScanData(HttpMessage msg) {
        this.message = msg;
        this.context = PassiveScanData.getContext(this.message);
        if (this.getContext() == null) {
            this.userList = Collections.emptyList();
            this.techSet = TechSet.AllTech;
        } else {
            this.techSet = this.getContext().getTechSet();
        }
    }

    private static Context getContext(HttpMessage message) {
        List<Context> contextList = Model.getSingleton().getSession().getContextsForUrl(message.getRequestHeader().getURI().toString());
        if (contextList.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("No Context found for: " + message.getRequestHeader().getURI().toString()));
            }
            return null;
        }
        return contextList.get(0);
    }

    public List<User> getUsers() {
        if (this.userList != null) {
            return this.userList;
        }
        if (PassiveScanData.getExtensionUserManagement() == null) {
            this.userList = Collections.emptyList();
            return this.userList;
        }
        this.userList = Collections.unmodifiableList(new ArrayList<User>(PassiveScanData.getExtensionUserManagement().getContextUserAuthManager(this.getContext().getId()).getUsers()));
        return this.userList;
    }

    private static ExtensionUserManagement getExtensionUserManagement() {
        return Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
    }

    public boolean hasContext() {
        return this.context != null;
    }

    public Context getContext() {
        return this.context;
    }

    public TechSet getTechSet() {
        return this.techSet;
    }
}

