/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Deque;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.jar.JarFile;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Resource;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import org.apache.tomcat.util.compat.Jre7Compat;
import org.apache.tomcat.util.compat.Jre8Compat;
import org.apache.tomcat.util.compat.Jre9Compat;
import org.apache.tomcat.util.res.StringManager;

public class JreCompat {
    private static final int RUNTIME_MAJOR_VERSION = 6;
    private static final JreCompat instance;
    private static StringManager sm;
    private static final boolean jre9Available;
    private static final boolean jre8Available;
    private static final boolean jre7Available;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isJre7Available() {
        return jre7Available;
    }

    public Locale forLanguageTag(String languageTag) {
        String language = null;
        String country = null;
        String variant = null;
        int dash = languageTag.indexOf(45);
        if (dash < 0) {
            language = languageTag;
            country = "";
            variant = "";
        } else {
            language = languageTag.substring(0, dash);
            country = languageTag.substring(dash + 1);
            int vDash = country.indexOf(45);
            if (vDash > 0) {
                String cTemp = country.substring(0, vDash);
                variant = country.substring(vDash + 1);
                country = cTemp;
            } else {
                variant = "";
            }
        }
        if (!(JreCompat.isAlpha(language) && JreCompat.isAlpha(country) && JreCompat.isAlpha(variant))) {
            return null;
        }
        return new Locale(language, country, variant);
    }

    private static final boolean isAlpha(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public GZIPOutputStream getFlushableGZipOutputStream(OutputStream os) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noFlushableGzipOutputStream"));
    }

    public <T> T getObject(CallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public <T> T getObject(CallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setSchema(Connection connection, String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public String getSchema(Connection connection) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void abort(Connection connection, Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNetworkTimeout(Connection connection, Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public int getNetworkTimeout(Connection connection) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public ResultSet getPseudoColumns(DatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public boolean generatedKeyAlwaysReturned(DatabaseMetaData databaseMetaData) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public <T> T getObject(ResultSet resultSet, int parameterIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public <T> T getObject(ResultSet resultSet, String parameterName, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void closeOnCompletion(Statement statement) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public boolean isCloseOnCompletion(Statement statement) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public InetAddress getLoopbackAddress() {
        InetAddress result = null;
        try {
            result = InetAddress.getByName(null);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (result == null) {
            try {
                result = InetAddress.getByName("127.0.0.1");
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isJre8Available() {
        return jre8Available;
    }

    public void setUseServerCipherSuitesOrder(SSLServerSocket socket, boolean useCipherSuitesOrder) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noServerCipherSuiteOrder"));
    }

    public void setUseServerCipherSuitesOrder(SSLEngine engine, boolean useCipherSuitesOrder) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noServerCipherSuiteOrder"));
    }

    public static boolean isJre9Available() {
        return jre9Available;
    }

    public boolean isInstanceOfInaccessibleObjectException(Throwable t) {
        return false;
    }

    public void disableCachingForJarUrlConnections() throws IOException {
        URL url = new URL("jar:file://dummy.jar!/");
        URLConnection uConn = url.openConnection();
        uConn.setDefaultUseCaches(false);
    }

    public void addBootModulePath(Deque<URL> classPathUrlsToProcess) {
    }

    public JarFile jarFileNewInstance(File f) throws IOException {
        return new JarFile(f);
    }

    public boolean jarFileIsMultiRelease(JarFile jarFile) {
        return false;
    }

    public int jarFileRuntimeMajorVersion() {
        return 6;
    }

    public boolean isCommonsAnnotations1_1Available() {
        Method[] methods;
        Class<Resource> clazz = Resource.class;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals("lookup")) continue;
            return true;
        }
        return false;
    }

    public boolean canAcccess(Object base, AccessibleObject accessibleObject) {
        return true;
    }

    public boolean isExported(Class<?> type) {
        return true;
    }

    static {
        sm = StringManager.getManager(JreCompat.class.getPackage().getName());
        if (Jre9Compat.isSupported()) {
            instance = new Jre9Compat();
            jre9Available = true;
            jre8Available = true;
            jre7Available = true;
        } else if (Jre8Compat.isSupported()) {
            instance = new Jre8Compat();
            jre9Available = false;
            jre8Available = true;
            jre7Available = true;
        } else if (Jre7Compat.isSupported()) {
            instance = new Jre7Compat();
            jre9Available = false;
            jre8Available = false;
            jre7Available = true;
        } else {
            instance = new JreCompat();
            jre9Available = false;
            jre8Available = false;
            jre7Available = false;
        }
    }
}

