/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Signature;
import esmska.data.Signatures;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedListener;
import esmska.utils.L10N;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.StringUtils;

public final class SignatureComboBox
extends JComboBox {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Signatures signatures = Signatures.getInstance();
    private static final SignatureComboBoxRenderer cellRenderer = new SignatureComboBoxRenderer();
    private static final String SEPARATOR = "SEPARATOR";
    private static final String NEW = l10n.getString("Signature.new");
    private static final String tooltip = l10n.getString("SignatureComboBox.tooltip");
    private DefaultComboBoxModel model = new DefaultComboBoxModel();

    public SignatureComboBox() {
        this.setToolTipText(tooltip);
        this.updateSignatures();
        this.setModel(this.model);
        this.setRenderer(cellRenderer);
        this.setSelectedItem(Signature.DEFAULT);
        signatures.addValuedListener(new ValuedListener<Signatures.Events, Signature>(){

            @Override
            public void eventOccured(ValuedEvent<Signatures.Events, Signature> e) {
                switch (e.getEvent()) {
                    case UPDATED: {
                        SignatureComboBox.this.updateSignatures();
                    }
                }
            }
        });
    }

    public Signature getSelectedSignature() {
        if (this.getSelectedItem() instanceof Signature) {
            return (Signature)this.getSelectedItem();
        }
        return null;
    }

    public void setSelectedSignature(String signatureName) {
        Signature signature = signatures.get(signatureName);
        if (this.model.getIndexOf(signature) < 0) {
            this.setSelectedItem(Signature.DEFAULT);
        } else {
            this.setSelectedItem(signature);
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (NEW.equals(anObject)) {
            String name = JOptionPane.showInputDialog(this, (Object)l10n.getString("Signature.new.desc"));
            if (StringUtils.isEmpty(name)) {
                super.setSelectedItem(Signature.DEFAULT);
                return;
            }
            Signature sig = new Signature(name, null, null);
            boolean added = signatures.add(sig);
            if (!added) {
                super.setSelectedItem(Signature.DEFAULT);
                return;
            }
            super.setSelectedItem(sig);
            return;
        }
        super.setSelectedItem(anObject);
    }

    public boolean isEditableSelected() {
        Signature signature = this.getSelectedSignature();
        return signature instanceof Signature && !Signature.NONE.equals(signature);
    }

    public boolean isRemovableSelected() {
        Signature signature = this.getSelectedSignature();
        return signature instanceof Signature && !signatures.getSpecial().contains(signature);
    }

    private void updateSignatures() {
        String sigName = this.getSelectedSignature() != null ? this.getSelectedSignature().getProfileName() : null;
        this.model.removeAllElements();
        for (Signature sig : signatures.getSpecial()) {
            this.model.addElement(sig);
        }
        for (Signature sig : signatures.getAll()) {
            this.model.addElement(sig);
        }
        this.model.addElement(SEPARATOR);
        this.model.addElement(NEW);
        this.setSelectedSignature(sigName);
    }

    public static class SignatureComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final ListCellRenderer lafRenderer = new JList().getCellRenderer();
        private static final JSeparator separator = new JSeparator(0);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = lafRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (SignatureComboBox.SEPARATOR.equals(value)) {
                return separator;
            }
            if (!(value instanceof Signature)) {
                return c;
            }
            JLabel label = (JLabel)c;
            Signature signature = (Signature)value;
            String name = signature.getProfileName();
            if (Signature.DEFAULT.equals(signature)) {
                name = l10n.getString("Signature.default");
            } else if (Signature.NONE.equals(signature)) {
                name = l10n.getString("Signature.none");
            }
            label.setText(name);
            return label;
        }
    }
}

