/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.explanationpreferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.explanationpreferences.ExplanationPreferencesPanelPluginLoader;
import org.protege.editor.core.ui.preferences.PreferencesPanel;
import org.protege.editor.core.ui.preferences.PreferencesPanelPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplanationPreferencesPanel
extends PreferencesPanel
implements Disposable {
    private final Map<String, PreferencesPanel> map = new HashMap<String, PreferencesPanel>();
    private final Map<String, JComponent> componentMap = new HashMap<String, JComponent>();
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final Logger logger = LoggerFactory.getLogger(ExplanationPreferencesPanel.class);
    private static final String EXPL_PREFS_HISTORY_PANEL_KEY = "expl.prefs.history.panel";

    @Override
    public void dispose() throws Exception {
        Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences(ExplanationPreferencesPanel.class);
        prefs.putString(EXPL_PREFS_HISTORY_PANEL_KEY, this.getSelectedPanel());
        for (PreferencesPanel panel : new ArrayList<PreferencesPanel>(this.map.values())) {
            try {
                panel.dispose();
            }
            catch (Throwable e) {
                this.logger.warn("An error occurred whilst disposing of the explanation preferences panel plugin '{}': {}", (Object)panel.getLabel(), (Object)e);
            }
        }
        this.map.clear();
    }

    protected String getSelectedPanel() {
        Component c = this.tabbedPane.getSelectedComponent();
        if (c instanceof JScrollPane) {
            c = ((JScrollPane)c).getViewport().getView();
        }
        for (String tabName : this.map.keySet()) {
            if (!c.equals(this.map.get(tabName))) continue;
            return tabName;
        }
        return null;
    }

    public void updatePanelSelection(String selectedPanel) {
        Component c;
        if (selectedPanel == null) {
            Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences(ExplanationPreferencesPanel.class);
            selectedPanel = prefs.getString(EXPL_PREFS_HISTORY_PANEL_KEY, null);
        }
        if ((c = (Component)this.componentMap.get(selectedPanel)) != null) {
            this.tabbedPane.setSelectedComponent(c);
        }
    }

    @Override
    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        ExplanationPreferencesPanelPluginLoader loader = new ExplanationPreferencesPanelPluginLoader(this.getEditorKit());
        TreeSet plugins = new TreeSet((o1, o2) -> {
            String s1 = o1.getLabel();
            String s2 = o2.getLabel();
            return s1.compareTo(s2);
        });
        plugins.addAll(loader.getPlugins());
        for (PreferencesPanelPlugin plugin : plugins) {
            try {
                PreferencesPanel panel = (PreferencesPanel)plugin.newInstance();
                panel.initialise();
                String label = plugin.getLabel();
                JScrollPane sp = new JScrollPane(panel);
                sp.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.map.put(label, panel);
                this.componentMap.put(label, sp);
                this.tabbedPane.addTab(label, sp);
            }
            catch (Throwable e) {
                this.logger.warn("An error occurred whilst trying to instantiate the explanation preferences panel plugin '{}': {}", (Object)plugin.getLabel(), (Object)e);
            }
        }
        this.add(this.tabbedPane);
        this.updatePanelSelection(null);
    }

    @Override
    public void applyChanges() {
        for (PreferencesPanel panel : new ArrayList<PreferencesPanel>(this.map.values())) {
            try {
                panel.applyChanges();
            }
            catch (Throwable e) {
                this.logger.warn("An error occurred whilst trying to save the preferences for the explanation preferences panel '{}': {}", (Object)panel.getLabel(), (Object)e);
            }
        }
    }
}

