/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightPhase;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

final class PercolatorHighlightSubFetchPhase
implements FetchSubPhase {
    private final HighlightPhase highlightPhase;

    PercolatorHighlightSubFetchPhase(Map<String, Highlighter> highlighters) {
        this.highlightPhase = new HighlightPhase(highlighters);
    }

    boolean hitsExecutionNeeded(SearchContext context) {
        return context.highlight() != null && !PercolatorHighlightSubFetchPhase.locatePercolatorQuery(context.query()).isEmpty();
    }

    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!this.hitsExecutionNeeded(context)) {
            return;
        }
        List<PercolateQuery> percolateQueries = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(context.query());
        if (percolateQueries.isEmpty()) {
            throw new IllegalStateException("couldn't locate percolator query");
        }
        boolean singlePercolateQuery = percolateQueries.size() == 1;
        for (PercolateQuery percolateQuery : percolateQueries) {
            String fieldName = singlePercolateQuery ? "_percolator_document_slot" : "_percolator_document_slot_" + percolateQuery.getName();
            List ctxs = context.searcher().getIndexReader().leaves();
            IndexSearcher percolatorIndexSearcher = percolateQuery.getPercolatorIndexSearcher();
            PercolateQuery.QueryStore queryStore = percolateQuery.getQueryStore();
            LeafReaderContext percolatorLeafReaderContext = (LeafReaderContext)percolatorIndexSearcher.getIndexReader().leaves().get(0);
            FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext();
            for (SearchHit hit : hits) {
                DocumentField field;
                LeafReaderContext ctx = (LeafReaderContext)ctxs.get(ReaderUtil.subIndex((int)hit.docId(), (List)ctxs));
                int segmentDocId = hit.docId() - ctx.docBase;
                Query query = (Query)queryStore.getQueries(ctx).apply((Object)segmentDocId);
                if (query == null || (field = hit.field(fieldName)) == null) continue;
                for (Object matchedSlot : field.getValues()) {
                    int slot = (Integer)matchedSlot;
                    BytesReference document = percolateQuery.getDocuments().get(slot);
                    SearchContextHighlight highlight = new SearchContextHighlight(context.highlight().fields());
                    highlight.globalForceSource(true);
                    QueryShardContext shardContext = new QueryShardContext(context.getQueryShardContext());
                    shardContext.freezeContext();
                    shardContext.lookup().source().setSegmentAndDocument(percolatorLeafReaderContext, slot);
                    shardContext.lookup().source().setSource(document);
                    hitContext.reset(new SearchHit(slot, "unknown", new Text(hit.getType()), Collections.emptyMap()), percolatorLeafReaderContext, slot, percolatorIndexSearcher);
                    hitContext.cache().clear();
                    this.highlightPhase.hitExecute(context.shardTarget(), shardContext, query, highlight, hitContext);
                    for (Map.Entry entry : hitContext.hit().getHighlightFields().entrySet()) {
                        String hlFieldName;
                        if (percolateQuery.getDocuments().size() == 1) {
                            hlFieldName = singlePercolateQuery ? (String)entry.getKey() : percolateQuery.getName() + "_" + (String)entry.getKey();
                            hit.getHighlightFields().put(hlFieldName, new HighlightField(hlFieldName, ((HighlightField)entry.getValue()).fragments()));
                            continue;
                        }
                        hlFieldName = singlePercolateQuery ? slot + "_" + (String)entry.getKey() : percolateQuery.getName() + "_" + slot + "_" + (String)entry.getKey();
                        hit.getHighlightFields().put(hlFieldName, new HighlightField(hlFieldName, ((HighlightField)entry.getValue()).fragments()));
                    }
                }
            }
        }
    }

    static List<PercolateQuery> locatePercolatorQuery(Query query) {
        if (query == null) {
            return Collections.emptyList();
        }
        final ArrayList<PercolateQuery> queries = new ArrayList<PercolateQuery>();
        query.visit(new QueryVisitor(){

            public void visitLeaf(Query query) {
                if (query instanceof PercolateQuery) {
                    queries.add((PercolateQuery)query);
                }
            }
        });
        return queries;
    }
}

