/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.query.CollectorResult;

public final class QueryProfileShardResult
implements Writeable,
ToXContentObject {
    public static final String COLLECTOR = "collector";
    public static final String REWRITE_TIME = "rewrite_time";
    public static final String QUERY_ARRAY = "query";
    private final List<ProfileResult> queryProfileResults;
    private final CollectorResult profileCollector;
    private final long rewriteTime;

    public QueryProfileShardResult(List<ProfileResult> queryProfileResults, long rewriteTime, CollectorResult profileCollector) {
        assert (profileCollector != null);
        this.queryProfileResults = queryProfileResults;
        this.profileCollector = profileCollector;
        this.rewriteTime = rewriteTime;
    }

    public QueryProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        this.queryProfileResults = new ArrayList<ProfileResult>(profileSize);
        for (int j = 0; j < profileSize; ++j) {
            this.queryProfileResults.add(new ProfileResult(in));
        }
        this.profileCollector = new CollectorResult(in);
        this.rewriteTime = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.queryProfileResults.size());
        for (ProfileResult p : this.queryProfileResults) {
            p.writeTo(out);
        }
        this.profileCollector.writeTo(out);
        out.writeLong(this.rewriteTime);
    }

    public List<ProfileResult> getQueryResults() {
        return Collections.unmodifiableList(this.queryProfileResults);
    }

    public long getRewriteTime() {
        return this.rewriteTime;
    }

    public CollectorResult getCollectorResult() {
        return this.profileCollector;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(QUERY_ARRAY);
        for (ProfileResult p : this.queryProfileResults) {
            p.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(REWRITE_TIME, this.rewriteTime);
        builder.startArray(COLLECTOR);
        this.profileCollector.toXContent(builder, params);
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static QueryProfileShardResult fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, () -> ((XContentParser)parser).getTokenLocation());
        String currentFieldName = null;
        ArrayList<ProfileResult> queryProfileResults = new ArrayList<ProfileResult>();
        long rewriteTime = 0L;
        CollectorResult collector = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (REWRITE_TIME.equals(currentFieldName)) {
                    rewriteTime = parser.longValue();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (QUERY_ARRAY.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        queryProfileResults.add(ProfileResult.fromXContent(parser));
                    }
                    continue;
                }
                if (COLLECTOR.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        collector = CollectorResult.fromXContent(parser);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        return new QueryProfileShardResult(queryProfileResults, rewriteTime, collector);
    }
}

