/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.io.Closeable;
import java.lang.reflect.Modifier;
import java.util.BitSet;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.SimpleChecksAdapter;
import org.elasticsearch.painless.WriterConstants;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public class ClassWriter
implements Closeable {
    protected final CompilerSettings compilerSettings;
    protected final BitSet statements;
    protected final org.objectweb.asm.ClassWriter classWriter;
    protected final ClassVisitor classVisitor;
    protected MethodWriter clinitWriter = null;

    public static int buildAccess(int modifiers, boolean synthetic) {
        int access;
        int n = access = synthetic ? 4096 : 0;
        if (Modifier.isFinal(modifiers)) {
            access |= 0x10;
        }
        if (Modifier.isInterface(modifiers)) {
            access |= 0x200;
        }
        if (Modifier.isNative(modifiers)) {
            access |= 0x100;
        }
        if (Modifier.isPrivate(modifiers)) {
            access |= 2;
        }
        if (Modifier.isProtected(modifiers)) {
            access |= 4;
        }
        if (Modifier.isPublic(modifiers)) {
            access |= 1;
        }
        if (Modifier.isStatic(modifiers)) {
            access |= 8;
        }
        if (Modifier.isStrict(modifiers)) {
            access |= 0x800;
        }
        if (Modifier.isSynchronized(modifiers)) {
            access |= 0x20;
        }
        if (Modifier.isTransient(modifiers)) {
            access |= 0x80;
        }
        if (Modifier.isVolatile(modifiers)) {
            access |= 0x40;
        }
        return access;
    }

    public ClassWriter(CompilerSettings compilerSettings, BitSet statements, Printer debugStream, Class<?> baseClass, int classFrames, int classAccess, String className, String[] classInterfaces) {
        this.compilerSettings = compilerSettings;
        this.statements = statements;
        Object visitor = this.classWriter = new org.objectweb.asm.ClassWriter(classFrames);
        if (compilerSettings.isPicky()) {
            visitor = new SimpleChecksAdapter((ClassVisitor)visitor);
        }
        if (debugStream != null) {
            visitor = new TraceClassVisitor((ClassVisitor)visitor, debugStream, null);
        }
        this.classVisitor = visitor;
        this.classVisitor.visit(52, classAccess, className, null, Type.getType(baseClass).getInternalName(), classInterfaces);
    }

    public ClassVisitor getClassVisitor() {
        return this.classVisitor;
    }

    public MethodWriter getClinitWriter() {
        if (this.clinitWriter == null) {
            this.clinitWriter = new MethodWriter(8, WriterConstants.CLINIT, this.classVisitor, this.statements, this.compilerSettings);
            this.clinitWriter.visitCode();
        }
        return this.clinitWriter;
    }

    public MethodWriter newMethodWriter(int access, Method method) {
        return new MethodWriter(access, method, this.classVisitor, this.statements, this.compilerSettings);
    }

    @Override
    public void close() {
        if (this.clinitWriter != null) {
            this.clinitWriter.returnValue();
            this.clinitWriter.endMethod();
        }
        this.classVisitor.visitEnd();
    }

    public byte[] getClassBytes() {
        return this.classWriter.toByteArray();
    }
}

