/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadata;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.EnvironmentAnnotationValue;
import io.micronaut.inject.annotation.EnvironmentConvertibleValuesMap;
import io.micronaut.inject.annotation.EnvironmentOptionalValuesMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public abstract class AbstractEnvironmentAnnotationMetadata
extends AbstractAnnotationMetadata
implements AnnotationMetadata {
    private final DefaultAnnotationMetadata annotationMetadata;

    protected AbstractEnvironmentAnnotationMetadata(DefaultAnnotationMetadata targetMetadata) {
        super(targetMetadata.declaredAnnotations, targetMetadata.allAnnotations);
        this.annotationMetadata = targetMetadata;
    }

    public <T> Optional<T> getValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return this.annotationMetadata.getValue(annotation, member, requiredType, o -> {
                PropertyPlaceholderResolver placeholderResolver = environment.getPlaceholderResolver();
                if (o instanceof String) {
                    String v = (String)o;
                    if (v.contains("${")) {
                        return placeholderResolver.resolveRequiredPlaceholders(v);
                    }
                } else if (o instanceof String[]) {
                    return AnnotationValue.resolveStringArray((String[])((String[])o), o1 -> {
                        String v = (String)o1;
                        if (v.contains("${")) {
                            return placeholderResolver.resolveRequiredPlaceholders(v);
                        }
                        return v;
                    });
                }
                return o;
            });
        }
        return this.annotationMetadata.getValue(annotation, member, requiredType);
    }

    public <T> Class<T>[] classValues(@Nonnull String annotation, @Nonnull String member) {
        return this.annotationMetadata.classValues(annotation, member);
    }

    public <T> Class<T>[] classValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return this.annotationMetadata.classValues(annotation, member);
    }

    public boolean isTrue(@Nonnull String annotation, @Nonnull String member) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return this.annotationMetadata.isTrue(annotation, member, o -> {
                String v;
                if (o instanceof String && (v = (String)o).contains("${")) {
                    return environment.getPlaceholderResolver().resolveRequiredPlaceholders(v);
                }
                return o;
            });
        }
        return this.annotationMetadata.isTrue(annotation, member);
    }

    public boolean isFalse(@Nonnull String annotation, @Nonnull String member) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return !this.annotationMetadata.isTrue(annotation, member, o -> {
                String v;
                if (o instanceof String && (v = (String)o).contains("${")) {
                    return environment.getPlaceholderResolver().resolveRequiredPlaceholders(v);
                }
                return o;
            });
        }
        return !this.annotationMetadata.isTrue(annotation, member);
    }

    @Nonnull
    public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nonnull Class<? extends Annotation> stereotype) {
        return this.annotationMetadata.getAnnotationTypeByStereotype(stereotype);
    }

    @Nonnull
    public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nullable String stereotype) {
        return this.annotationMetadata.getAnnotationTypeByStereotype(stereotype);
    }

    @Nonnull
    public Optional<Class> classValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.classValue(annotation, member, valueMapper);
    }

    @Nonnull
    public Optional<Class> classValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.classValue(annotation, member, valueMapper);
    }

    public <E extends Enum> Optional<E> enumValue(@Nonnull String annotation, @Nonnull String member, Class<E> enumType) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.enumValue(annotation, member, enumType, valueMapper);
    }

    public <E extends Enum> Optional<E> enumValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Class<E> enumType) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.enumValue(annotation, member, enumType, valueMapper);
    }

    public Optional<Boolean> booleanValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.booleanValue(annotation, member, valueMapper);
    }

    public Optional<Boolean> booleanValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.booleanValue(annotation, member, valueMapper);
    }

    @Nonnull
    public Optional<String> stringValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.stringValue(annotation, member, valueMapper);
    }

    @Nonnull
    public String[] stringValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            PropertyPlaceholderResolver resolver = environment.getPlaceholderResolver();
            Function<Object, Object> valueMapper = val -> {
                String[] values;
                if (val instanceof CharSequence) {
                    values = new String[]{val.toString()};
                } else if (val instanceof String[]) {
                    values = (String[])val;
                } else {
                    return null;
                }
                return Arrays.stream(values).flatMap(value -> {
                    try {
                        return Arrays.stream((Object[])resolver.resolveRequiredPlaceholder((String)value, String[].class));
                    }
                    catch (ConfigurationException e) {
                        if (value.contains(resolver.getPrefix())) {
                            value = resolver.resolveRequiredPlaceholders((String)value);
                        }
                        return Stream.of(value);
                    }
                }).toArray(String[]::new);
            };
            return this.annotationMetadata.stringValues(annotation, member, valueMapper);
        }
        return this.annotationMetadata.stringValues(annotation, member, null);
    }

    @Nonnull
    public Optional<String> stringValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.stringValue(annotation, member, valueMapper);
    }

    public OptionalLong longValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.longValue(annotation, member, valueMapper);
    }

    public OptionalLong longValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.longValue(annotation, member, valueMapper);
    }

    @Nonnull
    public OptionalInt intValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.intValue(annotation, member, valueMapper);
    }

    @Nonnull
    public OptionalInt intValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.intValue(annotation, member, valueMapper);
    }

    @Nonnull
    public OptionalDouble doubleValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.doubleValue(annotation, member, valueMapper);
    }

    @Nonnull
    public OptionalDouble doubleValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.doubleValue(annotation, member, valueMapper);
    }

    public boolean isTrue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.annotationMetadata.isTrue(annotation, member, valueMapper);
    }

    public boolean isFalse(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return !this.annotationMetadata.isTrue(annotation, member, valueMapper);
    }

    @Nonnull
    public Optional<Class<? extends Annotation>> getAnnotationType(@Nonnull String name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        return this.annotationMetadata.getAnnotationType(name);
    }

    @Nonnull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@Nonnull Class<T> annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", annotationType);
        Environment environment = this.getEnvironment();
        List<AnnotationValue<T>> values = this.annotationMetadata.getAnnotationValuesByType(annotationType);
        if (environment != null) {
            return values.stream().map(entries -> new EnvironmentAnnotationValue(environment, entries)).collect(Collectors.toList());
        }
        return values;
    }

    @Nonnull
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@Nonnull Class<T> annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", annotationType);
        Environment environment = this.getEnvironment();
        List<AnnotationValue<T>> values = this.annotationMetadata.getDeclaredAnnotationValuesByType(annotationType);
        if (environment != null) {
            return values.stream().map(entries -> new EnvironmentAnnotationValue(environment, entries)).collect(Collectors.toList());
        }
        return values;
    }

    @Nonnull
    public <T extends Annotation> T[] synthesizeAnnotationsByType(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull((String)"annotationClass", annotationClass);
        Environment environment = this.getEnvironment();
        if (environment != null) {
            List<AnnotationValue<T>> values = this.annotationMetadata.getAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, EnvironmentConvertibleValuesMap.of(environment, entries.getValues()))).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return this.annotationMetadata.synthesizeAnnotationsByType(annotationClass);
    }

    @Nonnull
    public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull((String)"annotationClass", annotationClass);
        Environment environment = this.getEnvironment();
        if (environment != null) {
            List<AnnotationValue<T>> values = this.annotationMetadata.getDeclaredAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, EnvironmentConvertibleValuesMap.of(environment, entries.getValues()))).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return this.annotationMetadata.synthesizeDeclaredAnnotationsByType(annotationClass);
    }

    public boolean hasDeclaredAnnotation(@Nullable String annotation) {
        return this.annotationMetadata.hasDeclaredAnnotation(annotation);
    }

    public boolean hasAnnotation(@Nullable String annotation) {
        return this.annotationMetadata.hasAnnotation(annotation);
    }

    public boolean hasStereotype(@Nullable String annotation) {
        return this.annotationMetadata.hasStereotype(annotation);
    }

    public boolean hasDeclaredStereotype(@Nullable String annotation) {
        return this.annotationMetadata.hasDeclaredStereotype(annotation);
    }

    @Nonnull
    public List<String> getAnnotationNamesByStereotype(String stereotype) {
        return this.annotationMetadata.getAnnotationNamesByStereotype(stereotype);
    }

    @Nonnull
    public Set<String> getAnnotationNames() {
        return this.annotationMetadata.getAnnotationNames();
    }

    @Nonnull
    public Set<String> getDeclaredAnnotationNames() {
        return this.annotationMetadata.getDeclaredAnnotationNames();
    }

    @Nonnull
    public List<String> getDeclaredAnnotationNamesByStereotype(String stereotype) {
        return this.annotationMetadata.getDeclaredAnnotationNamesByStereotype(stereotype);
    }

    @Nonnull
    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        Environment env = this.getEnvironment();
        Optional<AnnotationValue<AnnotationValue>> values = this.annotationMetadata.findAnnotation(annotation);
        if (env != null) {
            return values.map(av -> new EnvironmentAnnotationValue(env, av));
        }
        return values;
    }

    @Nonnull
    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        Environment env = this.getEnvironment();
        Optional<AnnotationValue<AnnotationValue>> values = this.annotationMetadata.findDeclaredAnnotation(annotation);
        if (env != null) {
            return values.map(av -> new EnvironmentAnnotationValue(env, av));
        }
        return values;
    }

    @Nonnull
    public <T> OptionalValues<T> getValues(@Nonnull String annotation, @Nonnull Class<T> valueType) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"valueType", valueType);
        Map<String, Map<CharSequence, Object>> allAnnotations = this.annotationMetadata.allAnnotations;
        Map<String, Map<CharSequence, Object>> allStereotypes = this.annotationMetadata.allStereotypes;
        Environment environment = this.getEnvironment();
        OptionalValues<T> values = this.resolveOptionalValuesForEnvironment(annotation, valueType, allAnnotations, allStereotypes, environment);
        if (values != null) {
            return values;
        }
        return OptionalValues.empty();
    }

    @Nonnull
    public <T> Optional<T> getDefaultValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Class<T> requiredType) {
        return this.annotationMetadata.getDefaultValue(annotation, member, requiredType);
    }

    @Nonnull
    public <T> Optional<T> getDefaultValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        return this.annotationMetadata.getDefaultValue(annotation, member, requiredType);
    }

    @Nullable
    protected abstract Environment getEnvironment();

    @Override
    protected void addValuesToResults(List<AnnotationValue> results, AnnotationValue values) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            results.add(new EnvironmentAnnotationValue(environment, values));
        } else {
            results.add(values);
        }
    }

    @Nullable
    private Function<Object, Object> getEnvironmentValueMapper() {
        Environment env = this.getEnvironment();
        if (env != null) {
            return o -> {
                String v;
                if (o instanceof String && (v = (String)o).contains("${")) {
                    return env.getPlaceholderResolver().resolveRequiredPlaceholders(v);
                }
                return o;
            };
        }
        return null;
    }

    private <T> OptionalValues<T> resolveOptionalValuesForEnvironment(String annotation, Class<T> valueType, Map<String, Map<CharSequence, Object>> allAnnotations, Map<String, Map<CharSequence, Object>> allStereotypes, Environment environment) {
        if (allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = allAnnotations.get(annotation);
            if (values != null) {
                if (environment != null) {
                    return new EnvironmentOptionalValuesMap(valueType, values, environment);
                }
                return OptionalValues.of(valueType, values);
            }
            values = allStereotypes.get(annotation);
            if (values != null) {
                if (environment != null) {
                    return new EnvironmentOptionalValuesMap(valueType, values, environment);
                }
                return OptionalValues.of(valueType, values);
            }
        }
        return null;
    }
}

