/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.JosmMapViewer;
import org.openstreetmap.josm.gui.bbox.SizeButton;
import org.openstreetmap.josm.gui.bbox.SlippyMapControler;
import org.openstreetmap.josm.gui.bbox.SourceButton;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class SlippyMapBBoxChooser
extends JosmMapViewer
implements BBoxChooser,
ChangeListener,
MainLayerManager.ActiveLayerChangeListener,
LayerManager.LayerChangeListener {
    private static CopyOnWriteArrayList<JosmMapViewer.TileSourceProvider> providers = new CopyOnWriteArrayList();
    private static final StringProperty PROP_MAPSTYLE;
    private static final BooleanProperty PROP_SHOWDLAREA;
    public static final String RESIZE_PROP;
    private final SizeButton iSizeButton;
    private final ButtonModel showDownloadAreaButtonModel;
    private final SourceButton iSourceButton;
    private transient Bounds bbox;
    private transient ICoordinate iSelectionRectStart;
    private transient ICoordinate iSelectionRectEnd;

    public static void addTileSourceProvider(JosmMapViewer.TileSourceProvider tileSourceProvider) {
        providers.addIfAbsent(tileSourceProvider);
    }

    public SlippyMapBBoxChooser() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.setZoomControlsVisible(Config.getPref().getBoolean("slippy_map_chooser.zoomcontrols", false));
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setBounds(new Rectangle(this.getMinimumSize()));
        if (this.cachedLoader == null) {
            this.setFileCacheEnabled(false);
        } else {
            this.setFileCacheEnabled(Config.getPref().getBoolean("slippy_map_chooser.file_cache", true));
        }
        this.setMaxTilesInMemory(Config.getPref().getInt("slippy_map_chooser.max_tiles", 1000));
        ArrayList<TileSource> tileSources = new ArrayList<TileSource>(SlippyMapBBoxChooser.getAllTileSources().values());
        this.showDownloadAreaButtonModel = new JToggleButton.ToggleButtonModel();
        this.showDownloadAreaButtonModel.setSelected(PROP_SHOWDLAREA.get());
        this.showDownloadAreaButtonModel.addChangeListener(this);
        this.iSourceButton = new SourceButton(this, tileSources, this.showDownloadAreaButtonModel);
        this.add(this.iSourceButton);
        springLayout.putConstraint("East", (Component)this.iSourceButton, -2, "East", (Component)this);
        springLayout.putConstraint("North", (Component)this.iSourceButton, 2, "North", (Component)this);
        this.iSizeButton = new SizeButton(this);
        this.add(this.iSizeButton);
        String mapStyle = PROP_MAPSTYLE.get();
        boolean foundSource = false;
        for (TileSource source : tileSources) {
            if (!source.getName().equals(mapStyle)) continue;
            this.setTileSource(source);
            this.iSourceButton.setCurrentMap(source);
            foundSource = true;
            break;
        }
        if (!foundSource) {
            this.setTileSource((TileSource)tileSources.get(0));
            this.iSourceButton.setCurrentMap((TileSource)tileSources.get(0));
        }
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
        new SlippyMapControler(this, this);
    }

    private static LinkedHashMap<String, TileSource> getAllTileSources() {
        return providers.stream().flatMap(provider -> provider.getTileSources().stream()).collect(Collectors.toMap(TileSource::getId, ts -> ts, (oldTs, newTs) -> oldTs, LinkedHashMap::new));
    }

    public boolean handleAttribution(Point p, boolean click) {
        return this.attribution.handleAttribution(p, click);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (ds != null && this.showDownloadAreaButtonModel.isSelected() && !ds.getDataSources().isEmpty()) {
            Rectangle b = this.getBounds();
            b.grow(100, 100);
            Path2D.Float p = new Path2D.Float();
            for (Bounds bounds : ds.getDataSourceBounds()) {
                if (bounds.isCollapsed()) continue;
                Rectangle r = new Rectangle(this.getMapPosition(bounds.getMinLat(), bounds.getMinLon(), false));
                r.add(this.getMapPosition(bounds.getMaxLat(), bounds.getMaxLon(), false));
                p.append(r, false);
            }
            Area a = new Area(b);
            a.subtract(new Area(p));
            g2d.setPaint(new Color(0, 0, 0, 32));
            g2d.fill(a);
        }
        if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
            Rectangle box = new Rectangle(this.getMapPosition(this.iSelectionRectStart, false));
            box.add(this.getMapPosition(this.iSelectionRectEnd, false));
            g.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
            g.fillRect(box.x, box.y, box.width, box.height);
            g.setColor(Color.BLACK);
            g.drawRect(box.x, box.y, box.width, box.height);
        }
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        PROP_SHOWDLAREA.put(this.showDownloadAreaButtonModel.isSelected());
        this.repaint();
    }

    public void setSelection(Point aStart, Point aEnd) {
        if (aStart == null || aEnd == null || aStart.x == aEnd.x || aStart.y == aEnd.y) {
            return;
        }
        Point pMax = new Point(Math.max(aEnd.x, aStart.x), Math.max(aEnd.y, aStart.y));
        Point pMin = new Point(Math.min(aEnd.x, aStart.x), Math.min(aEnd.y, aStart.y));
        this.iSelectionRectStart = this.getPosition(pMin);
        this.iSelectionRectEnd = this.getPosition(pMax);
        Bounds b = new Bounds(new LatLon(Math.min(this.iSelectionRectStart.getLat(), this.iSelectionRectEnd.getLat()), LatLon.toIntervalLon(Math.min(this.iSelectionRectStart.getLon(), this.iSelectionRectEnd.getLon()))), new LatLon(Math.max(this.iSelectionRectStart.getLat(), this.iSelectionRectEnd.getLat()), LatLon.toIntervalLon(Math.max(this.iSelectionRectStart.getLon(), this.iSelectionRectEnd.getLon()))));
        Bounds oldValue = this.bbox;
        this.bbox = b;
        this.repaint();
        this.firePropertyChange(BBOX_PROP, oldValue, this.bbox);
    }

    public void resizeSlippyMap() {
        boolean large = this.iSizeButton.isEnlarged();
        this.firePropertyChange(RESIZE_PROP, !large, large);
    }

    public void toggleMapSource(TileSource tileSource) {
        this.tileController.setTileCache(new MemoryTileCache());
        this.setTileSource(tileSource);
        PROP_MAPSTYLE.put(tileSource.getName());
        this.refreshTileSources();
    }

    @Override
    public Bounds getBoundingBox() {
        return this.bbox;
    }

    @Override
    public void setBoundingBox(Bounds bbox) {
        if (bbox == null || bbox.getMinLat() == 0.0 && bbox.getMinLon() == 0.0 && bbox.getMaxLat() == 0.0 && bbox.getMaxLon() == 0.0) {
            this.bbox = null;
            this.iSelectionRectStart = null;
            this.iSelectionRectEnd = null;
            this.repaint();
            return;
        }
        this.bbox = bbox;
        this.iSelectionRectStart = new Coordinate(bbox.getMinLat(), bbox.getMinLon());
        this.iSelectionRectEnd = new Coordinate(bbox.getMaxLat(), bbox.getMaxLon());
        MapMarkerDot min = new MapMarkerDot(bbox.getMinLat(), bbox.getMinLon());
        MapMarkerDot max = new MapMarkerDot(bbox.getMaxLat(), bbox.getMaxLon());
        ArrayList<MapMarker> marker = new ArrayList<MapMarker>(2);
        marker.add(min);
        marker.add(max);
        this.setMapMarkerList(marker);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
        this.repaint();
    }

    public void setSizeButtonVisible(boolean visible) {
        this.iSizeButton.setVisible(visible);
    }

    public final void refreshTileSources() {
        LinkedHashMap<String, TileSource> newTileSources = SlippyMapBBoxChooser.getAllTileSources();
        TileSource currentTileSource = this.getTileController().getTileSource();
        newTileSources.putIfAbsent(currentTileSource.getId(), currentTileSource);
        this.iSourceButton.setSources(new ArrayList<TileSource>(newTileSources.values()));
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        if (e.getAddedLayer() instanceof ImageryLayer) {
            this.refreshTileSources();
        }
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof ImageryLayer) {
            this.refreshTileSources();
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    static {
        SlippyMapBBoxChooser.addTileSourceProvider(new JosmMapViewer.DefaultOsmTileSourceProvider());
        SlippyMapBBoxChooser.addTileSourceProvider(new JosmMapViewer.TMSTileSourceProvider());
        SlippyMapBBoxChooser.addTileSourceProvider(new JosmMapViewer.CurrentLayersTileSourceProvider());
        PROP_MAPSTYLE = new StringProperty("slippy_map_chooser.mapstyle", "Mapnik");
        PROP_SHOWDLAREA = new BooleanProperty("slippy_map_chooser.show_downloaded_area", true);
        RESIZE_PROP = SlippyMapBBoxChooser.class.getName() + ".resize";
        debug = Logging.isDebugEnabled();
    }
}

