/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractTextComponentValidator
implements ActionListener,
FocusListener,
DocumentListener,
PropertyChangeListener {
    protected static final Color ERROR_COLOR = new NamedColorProperty(I18n.marktr("Input validation: error"), Color.RED).get();
    protected static final Border ERROR_BORDER = BorderFactory.createLineBorder(ERROR_COLOR, 1);
    protected static final Color ERROR_BACKGROUND = new NamedColorProperty(I18n.marktr("Input validation: error background"), new Color(0xFFCCCC)).get();
    protected static final Color WARNING_COLOR = new NamedColorProperty(I18n.marktr("Input validation: warning"), new Color(16753920)).get();
    protected static final Border WARNING_BORDER = BorderFactory.createLineBorder(WARNING_COLOR, 1);
    protected static final Color WARNING_BACKGROUND = new NamedColorProperty(I18n.marktr("Input validation: warning background"), new Color(16772556)).get();
    protected static final Color VALID_COLOR = new NamedColorProperty(I18n.marktr("Input validation: valid"), new Color(32768)).get();
    protected static final Border VALID_BORDER = BorderFactory.createLineBorder(VALID_COLOR, 1);
    private final JTextComponent tc;
    private Status status;
    private String msg;

    protected void feedbackInvalid(String msg) {
        if (this.hasChanged(msg, Status.INVALID)) {
            this.tc.setBorder(ERROR_BORDER);
            this.tc.setBackground(ERROR_BACKGROUND);
            this.tc.setToolTipText(msg);
            this.status = Status.INVALID;
            this.msg = msg;
        }
    }

    protected void feedbackWarning(String msg) {
        if (this.hasChanged(msg, Status.WARNING)) {
            this.tc.setBorder(WARNING_BORDER);
            this.tc.setBackground(WARNING_BACKGROUND);
            this.tc.setToolTipText(msg);
            this.status = Status.WARNING;
            this.msg = msg;
        }
    }

    protected void feedbackDisabled() {
        this.feedbackValid(null);
    }

    protected void feedbackValid(String msg) {
        if (this.hasChanged(msg, Status.VALID)) {
            this.tc.setBorder(msg == null ? UIManager.getBorder("TextField.border") : VALID_BORDER);
            this.tc.setBackground(UIManager.getColor("TextField.background"));
            this.tc.setToolTipText(msg == null ? "" : msg);
            this.status = Status.VALID;
            this.msg = msg;
        }
    }

    private boolean hasChanged(String msg, Status status) {
        return !Objects.equals((Object)status, (Object)this.status) || !Objects.equals(msg, this.msg);
    }

    public JTextComponent getComponent() {
        return this.tc;
    }

    protected AbstractTextComponentValidator(JTextComponent tc) {
        this(tc, true);
    }

    protected AbstractTextComponentValidator(JTextComponent tc, boolean addActionListener) {
        this(tc, true, true, addActionListener);
    }

    protected AbstractTextComponentValidator(JTextComponent tc, boolean addFocusListener, boolean addDocumentListener, boolean addActionListener) {
        CheckParameterUtil.ensureParameterNotNull(tc, "tc");
        this.tc = tc;
        if (addFocusListener) {
            tc.addFocusListener(this);
        }
        if (addDocumentListener) {
            tc.getDocument().addDocumentListener(this);
        }
        if (addActionListener && tc instanceof JosmTextField) {
            ((JosmTextField)tc).addActionListener(this);
        }
        tc.addPropertyChangeListener("enabled", this);
    }

    public abstract void validate();

    public abstract boolean isValid();

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.validate();
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.validate();
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.validate();
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            boolean enabled = (Boolean)evt.getNewValue();
            if (enabled) {
                this.validate();
            } else {
                this.feedbackDisabled();
            }
        }
    }

    static enum Status {
        INVALID,
        WARNING,
        VALID;

    }
}

