/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ProfilingInfo;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedValueProfiler {
    private static final CachedValueProfiler ourInstance = new CachedValueProfiler();
    private volatile ConcurrentMultiMap<StackTraceElement, ProfilingInfo> myStorage = null;
    private final Object myLock = new Object();
    private final ConcurrentMap<CachedValueProvider.Result, ProfilingInfo> myTemporaryResults = ContainerUtil.newConcurrentMap();

    public static boolean canProfile() {
        return ApplicationManager.getApplication().isInternal();
    }

    public boolean isEnabled() {
        return this.myStorage != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean value2) {
        Object object = this.myLock;
        synchronized (object) {
            if (value2) {
                ConcurrentMultiMap<StackTraceElement, ProfilingInfo> storage2 = this.myStorage;
                if (storage2 == null) {
                    this.myStorage = new ConcurrentMultiMap();
                }
            } else {
                this.myStorage = null;
            }
        }
    }

    @NotNull
    public static CachedValueProfiler getInstance() {
        CachedValueProfiler cachedValueProfiler = ourInstance;
        if (cachedValueProfiler == null) {
            CachedValueProfiler.$$$reportNull$$$0(0);
        }
        return cachedValueProfiler;
    }

    public void createInfo(@NotNull CachedValueProvider.Result<?> result2) {
        ConcurrentMultiMap<StackTraceElement, ProfilingInfo> storage2;
        if (result2 == null) {
            CachedValueProfiler.$$$reportNull$$$0(1);
        }
        if ((storage2 = this.myStorage) == null) {
            return;
        }
        StackTraceElement origin = CachedValueProfiler.findOrigin();
        if (origin == null) {
            return;
        }
        ProfilingInfo info = new ProfilingInfo(origin);
        storage2.putValue(origin, info);
        this.myTemporaryResults.put(result2, info);
    }

    @Nullable
    public <T> ProfilingInfo getTemporaryInfo(@NotNull CachedValueProvider.Result<T> result2) {
        if (result2 == null) {
            CachedValueProfiler.$$$reportNull$$$0(2);
        }
        return (ProfilingInfo)this.myTemporaryResults.remove(result2);
    }

    public MultiMap<StackTraceElement, ProfilingInfo> getStorageSnapshot() {
        return this.myStorage.copy();
    }

    @Nullable
    private static StackTraceElement findOrigin() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        return CachedValueProfiler.findFirstStackTraceElementExcluding(stackTrace, CachedValueProfiler.class.getName(), CachedValueProvider.class.getName());
    }

    @Nullable
    private static StackTraceElement findFirstStackTraceElementExcluding(@NotNull StackTraceElement[] stackTraceElements, String ... excludedClasses) {
        if (stackTraceElements == null) {
            CachedValueProfiler.$$$reportNull$$$0(3);
        }
        if (excludedClasses == null) {
            CachedValueProfiler.$$$reportNull$$$0(4);
        }
        for (StackTraceElement element : stackTraceElements) {
            if (CachedValueProfiler.matches(element, excludedClasses)) continue;
            return element;
        }
        return null;
    }

    private static boolean matches(@NotNull StackTraceElement element, @NotNull String[] excludedClasses) {
        if (element == null) {
            CachedValueProfiler.$$$reportNull$$$0(5);
        }
        if (excludedClasses == null) {
            CachedValueProfiler.$$$reportNull$$$0(6);
        }
        for (String aClass2 : excludedClasses) {
            if (!element.getClassName().startsWith(aClass2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/CachedValueProfiler";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceElements";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedClasses";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/CachedValueProfiler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTemporaryInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFirstStackTraceElementExcluding";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

