/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.MaxLocalsCalculator;
import org.jetbrains.kotlin.utils.SmartIdentityTable;
import org.jetbrains.kotlin.utils.SmartSet;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class MaxStackFrameSizeAndLocalsCalculator
extends MaxLocalsCalculator {
    private static final int[] FRAME_SIZE_CHANGE_BY_OPCODE;
    private final LabelWrapper firstLabel;
    private LabelWrapper currentBlock;
    private LabelWrapper previousBlock;
    private int stackSize;
    private int maxStackSize;
    private int maxStack;
    private final Collection<ExceptionHandler> exceptionHandlers = new LinkedList<ExceptionHandler>();
    private final SmartIdentityTable<Label, LabelWrapper> labelWrappersTable = new SmartIdentityTable();

    public MaxStackFrameSizeAndLocalsCalculator(int api, int access, String descriptor2, MethodVisitor mv) {
        super(api, access, descriptor2, mv);
        this.firstLabel = this.getLabelWrapper(new Label());
        this.processLabel(this.firstLabel.label);
    }

    @Override
    public void visitFrame(int type2, int nLocal, Object[] local2, int nStack, Object[] stack) {
        throw new AssertionError((Object)"We don't support visitFrame because currently nobody needs");
    }

    @Override
    public void visitInsn(int opcode) {
        this.increaseStackSize(FRAME_SIZE_CHANGE_BY_OPCODE[opcode]);
        if (opcode >= 172 && opcode <= 177 || opcode == 191) {
            this.noSuccessor();
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (opcode != 188) {
            this.increaseStackSize(1);
        }
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.increaseStackSize(FRAME_SIZE_CHANGE_BY_OPCODE[opcode]);
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, @NotNull String type2) {
        if (type2 == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(0);
        }
        if (opcode == 187) {
            this.increaseStackSize(1);
        }
        super.visitTypeInsn(opcode, type2);
    }

    @Override
    public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc) {
        int stackSizeVariation;
        if (owner == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(1);
        }
        if (name == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(2);
        }
        if (desc == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(3);
        }
        char c = desc.charAt(0);
        switch (opcode) {
            case 178: {
                stackSizeVariation = c == 'D' || c == 'J' ? 2 : 1;
                break;
            }
            case 179: {
                stackSizeVariation = c == 'D' || c == 'J' ? -2 : -1;
                break;
            }
            case 180: {
                stackSizeVariation = c == 'D' || c == 'J' ? 1 : 0;
                break;
            }
            default: {
                stackSizeVariation = c == 'D' || c == 'J' ? -3 : -2;
            }
        }
        this.increaseStackSize(stackSizeVariation);
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        int argSize = Type.getArgumentsAndReturnSizes(desc);
        int sizeVariation = opcode == 184 ? (argSize & 3) - (argSize >> 2) + 1 : (argSize & 3) - (argSize >> 2);
        this.increaseStackSize(sizeVariation);
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitInvokeDynamicInsn(@NotNull String name, @NotNull String desc, @NotNull Handle bsm, Object ... bsmArgs) {
        if (name == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(4);
        }
        if (desc == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(5);
        }
        if (bsm == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(6);
        }
        if (bsmArgs == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(7);
        }
        int argSize = Type.getArgumentsAndReturnSizes(desc);
        this.increaseStackSize((argSize & 3) - (argSize >> 2) + 1);
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    @Override
    public void visitJumpInsn(int opcode, @NotNull Label label) {
        if (label == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(8);
        }
        if (this.currentBlock != null) {
            this.stackSize += FRAME_SIZE_CHANGE_BY_OPCODE[opcode];
            this.addSuccessor(this.getLabelWrapper(label), this.stackSize);
            if (opcode == 167) {
                this.noSuccessor();
            }
        }
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(@NotNull Label label) {
        if (label == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(9);
        }
        this.processLabel(label);
        super.visitLabel(label);
    }

    private void processLabel(Label label) {
        LabelWrapper wrapper = this.getLabelWrapper(label);
        if (this.currentBlock != null) {
            this.currentBlock.outputStackMax = this.maxStackSize;
            this.addSuccessor(wrapper, this.stackSize);
        }
        this.currentBlock = wrapper;
        this.stackSize = 0;
        this.maxStackSize = 0;
        if (this.previousBlock != null) {
            this.previousBlock.nextLabel = wrapper;
        }
        this.previousBlock = wrapper;
    }

    @Override
    public void visitLdcInsn(@NotNull Object cst) {
        if (cst == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(10);
        }
        if (cst instanceof Long || cst instanceof Double) {
            this.increaseStackSize(2);
        } else {
            this.increaseStackSize(1);
        }
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, @NotNull Label dflt, Label ... labels2) {
        if (dflt == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(11);
        }
        if (labels2 == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(12);
        }
        this.visitSwitchInsn(dflt, labels2);
        super.visitTableSwitchInsn(min, max, dflt, labels2);
    }

    @Override
    public void visitLookupSwitchInsn(@NotNull Label dflt, @NotNull int[] keys2, @NotNull Label[] labels2) {
        if (dflt == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(13);
        }
        if (keys2 == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(14);
        }
        if (labels2 == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(15);
        }
        this.visitSwitchInsn(dflt, labels2);
        super.visitLookupSwitchInsn(dflt, keys2, labels2);
    }

    private void visitSwitchInsn(Label dflt, Label[] labels2) {
        if (this.currentBlock != null) {
            --this.stackSize;
            this.addSuccessor(this.getLabelWrapper(dflt), this.stackSize);
            for (Label label : labels2) {
                this.addSuccessor(this.getLabelWrapper(label), this.stackSize);
            }
            this.noSuccessor();
        }
    }

    @Override
    public void visitMultiANewArrayInsn(@NotNull String desc, int dims) {
        if (desc == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(16);
        }
        if (this.currentBlock != null) {
            this.increaseStackSize(dims - 1);
        }
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        for (ExceptionHandler handler2 : this.exceptionHandlers) {
            LabelWrapper l = handler2.start;
            LabelWrapper e = handler2.end;
            while (l != e) {
                if (l == null) {
                    throw new IllegalStateException("Bad exception handler end");
                }
                l.addSuccessor(handler2.handlerLabel, 0, true);
                l = l.nextLabel;
            }
        }
        int max = 0;
        Stack<LabelWrapper> stack = new Stack<LabelWrapper>();
        SmartSet pushed = SmartSet.create();
        stack.push(this.firstLabel);
        pushed.add(this.firstLabel);
        while (!stack.empty()) {
            LabelWrapper current = (LabelWrapper)stack.pop();
            int start = current.inputStackSize;
            int blockMax = start + current.outputStackMax;
            if (blockMax > max) {
                max = blockMax;
            }
            for (ControlFlowEdge edge : current.successors) {
                LabelWrapper successor = edge.successor;
                if (pushed.contains(successor)) continue;
                successor.inputStackSize = edge.isExceptional ? 1 : start + edge.outputStackSize;
                pushed.add(successor);
                stack.push(successor);
            }
        }
        this.maxStack = Math.max(this.maxStack, Math.max(maxStack, max));
        super.visitMaxs(this.maxStack, maxLocals);
    }

    @Override
    public void visitTryCatchBlock(@NotNull Label start, @NotNull Label end, @NotNull Label handler2, String type2) {
        if (start == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(17);
        }
        if (end == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(18);
        }
        if (handler2 == null) {
            MaxStackFrameSizeAndLocalsCalculator.$$$reportNull$$$0(19);
        }
        ExceptionHandler exceptionHandler = new ExceptionHandler(this.getLabelWrapper(start), this.getLabelWrapper(end), this.getLabelWrapper(handler2));
        this.exceptionHandlers.add(exceptionHandler);
        super.visitTryCatchBlock(start, end, handler2, type2);
    }

    private LabelWrapper getLabelWrapper(Label label) {
        return this.labelWrappersTable.getOrCreate(label, () -> new LabelWrapper(label));
    }

    private void increaseStackSize(int variation) {
        this.updateStackSize(this.stackSize + variation);
    }

    private void updateStackSize(int size) {
        if (size > this.maxStackSize) {
            this.maxStackSize = size;
        }
        this.stackSize = size;
    }

    private void addSuccessor(LabelWrapper successor, int outputStackSize) {
        this.currentBlock.addSuccessor(successor, outputStackSize, false);
    }

    private void noSuccessor() {
        if (this.currentBlock != null) {
            this.currentBlock.outputStackMax = this.maxStackSize;
            this.currentBlock = null;
        }
    }

    static {
        int[] b = new int[202];
        String s = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        for (int i = 0; i < b.length; ++i) {
            b[i] = s.charAt(i) - 69;
        }
        FRAME_SIZE_CHANGE_BY_OPCODE = b;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bsm";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bsmArgs";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cst";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dflt";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labels";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeInsn";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFieldInsn";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInvokeDynamicInsn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJumpInsn";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLabel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLdcInsn";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTableSwitchInsn";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLookupSwitchInsn";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMultiANewArrayInsn";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTryCatchBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LabelWrapper {
        private final Label label;
        private LabelWrapper nextLabel = null;
        private final Collection<ControlFlowEdge> successors = new LinkedList<ControlFlowEdge>();
        private int outputStackMax = 0;
        private int inputStackSize = 0;

        public LabelWrapper(Label label) {
            this.label = label;
        }

        private void addSuccessor(LabelWrapper successor, int outputStackSize, boolean isExceptional) {
            this.successors.add(new ControlFlowEdge(successor, outputStackSize, isExceptional));
        }
    }

    private static class ControlFlowEdge {
        private final LabelWrapper successor;
        private final int outputStackSize;
        private final boolean isExceptional;

        public ControlFlowEdge(LabelWrapper successor, int outputStackSize, boolean isExceptional) {
            this.successor = successor;
            this.outputStackSize = outputStackSize;
            this.isExceptional = isExceptional;
        }
    }

    private static class ExceptionHandler {
        private final LabelWrapper start;
        private final LabelWrapper end;
        private final LabelWrapper handlerLabel;

        public ExceptionHandler(LabelWrapper start, LabelWrapper end, LabelWrapper handlerLabel) {
            this.start = start;
            this.end = end;
            this.handlerLabel = handlerLabel;
        }
    }
}

