/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.DefaultNamesKt;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.PersistentMultimap;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002BK\b\u0002\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00052\u001c\u0010\u0017\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00160\u0018H\u0016J(\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00052\u0016\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00160\u001cH\u0016J(\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00052\u0016\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00160\u001cH\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u0012\u0010'\u001a\u00020\u00002\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "()V", "properties", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "functions", "Lorg/jetbrains/kotlin/fir/resolve/PersistentMultimap;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "classes", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lkotlinx/collections/immutable/PersistentMap;Lorg/jetbrains/kotlin/fir/resolve/PersistentMultimap;Lkotlinx/collections/immutable/PersistentMap;)V", "getClasses", "()Lkotlinx/collections/immutable/PersistentMap;", "getFunctions", "()Lorg/jetbrains/kotlin/fir/resolve/PersistentMultimap;", "getProperties", "mayContainName", "", "name", "processClassifiersByNameWithSubstitution", "", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processFunctionsByName", "Lkotlin/Function1;", "processPropertiesByName", "storeBackingField", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "storeClass", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "storeFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "storeVariable", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "resolve"})
public final class FirLocalScope
extends FirScope {
    @NotNull
    private final PersistentMap<Name, FirVariableSymbol<?>> properties;
    @NotNull
    private final PersistentMultimap<Name, FirFunctionSymbol<?>> functions;
    @NotNull
    private final PersistentMap<Name, FirRegularClassSymbol> classes;

    @NotNull
    public final PersistentMap<Name, FirVariableSymbol<?>> getProperties() {
        return this.properties;
    }

    @NotNull
    public final PersistentMultimap<Name, FirFunctionSymbol<?>> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final PersistentMap<Name, FirRegularClassSymbol> getClasses() {
        return this.classes;
    }

    @NotNull
    public final FirLocalScope storeClass(@NotNull FirRegularClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return new FirLocalScope(this.properties, this.functions, this.classes.put(klass.getName(), klass.getSymbol()));
    }

    @NotNull
    public final FirLocalScope storeFunction(@NotNull FirSimpleFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        FirFunctionSymbol<FirSimpleFunction> firFunctionSymbol = function2.getSymbol();
        if (firFunctionSymbol == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
        }
        return new FirLocalScope(this.properties, this.functions.put(function2.getName(), (FirNamedFunctionSymbol)firFunctionSymbol), this.classes);
    }

    @NotNull
    public final FirLocalScope storeVariable(@NotNull FirVariable<?> variable2) {
        Intrinsics.checkNotNullParameter(variable2, "variable");
        return new FirLocalScope(this.properties.put(variable2.getName(), variable2.getSymbol()), this.functions, this.classes);
    }

    @NotNull
    public final FirLocalScope storeBackingField(@NotNull FirProperty property2) {
        Intrinsics.checkNotNullParameter(property2, "property");
        return new FirLocalScope(this.properties.put(DefaultNamesKt.getNAME_FOR_BACKING_FIELD(), property2.getBackingFieldSymbol()), this.functions, this.classes);
    }

    @Override
    public void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirFunctionSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor2, "processor");
        for (FirFunctionSymbol<?> function2 : this.functions.get(name)) {
            processor2.invoke(function2);
        }
    }

    @Override
    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor2, "processor");
        FirVariableSymbol property2 = (FirVariableSymbol)this.properties.get(name);
        if (property2 != null) {
            processor2.invoke(property2);
        }
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor2, "processor");
        FirRegularClassSymbol klass = (FirRegularClassSymbol)this.classes.get(name);
        if (klass != null) {
            processor2.invoke(klass, ConeSubstitutor.Empty.INSTANCE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mayContainName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.properties.containsKey(name)) return true;
        Collection collection = this.functions.get(name);
        boolean bl = false;
        if (!collection.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (!this.classes.containsKey(name)) return false;
        return true;
    }

    private FirLocalScope(PersistentMap<Name, ? extends FirVariableSymbol<?>> properties2, PersistentMultimap<Name, FirFunctionSymbol<?>> functions2, PersistentMap<Name, FirRegularClassSymbol> classes2) {
        this.properties = properties2;
        this.functions = functions2;
        this.classes = classes2;
    }

    public FirLocalScope() {
        this(ExtensionsKt.persistentMapOf(new Pair[0]), new PersistentMultimap(), ExtensionsKt.persistentMapOf(new Pair[0]));
    }
}

