/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TileBuilder;
import eu.hansolo.tilesfx.colors.Bright;
import eu.hansolo.tilesfx.colors.Dark;
import java.text.DecimalFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;

public class Test
extends Application {
    private static final Random RND = new Random();
    private static final double SIZE = 600.0;
    private static final double WIDTH = 600.0;
    private static final double HEIGHT = 400.0;
    private static int noOfNodes = 0;
    private Tile tile1;
    private DoubleProperty value;
    private long lastTimerCall;
    private AnimationTimer timer;

    @Override
    public void init() {
        this.value = new SimpleDoubleProperty();
        this.tile1 = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.TIMELINE)).prefSize(600.0, 400.0)).title("Inside")).unit("\u00b0C")).minValue(-20.0)).maxValue(50.0)).decimals(1)).tickLabelDecimals(0)).customDecimalFormatEnabled(true)).customDecimalFormat(new DecimalFormat("#"))).time(ZonedDateTime.now(ZoneId.of("Europe/Berlin")))).gradientStops(new Stop(0.0, Dark.BLUE), new Stop(0.333, Bright.BLUE), new Stop(0.5, Bright.BLUE_GREEN), new Stop(0.75, Bright.GREEN), new Stop(0.8, Bright.GREEN_YELLOW), new Stop(0.833, Bright.YELLOW_ORANGE), new Stop(0.9, Bright.ORANGE), new Stop(1.0, Bright.RED))).strokeWithGradient(true)).averagingPeriod(10)).smoothing(false)).build();
        this.tile1 = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.LED)).prefSize(600.0, 400.0)).title("Led Tile")).description("Description")).text("Whatever text")).build();
        this.tile1.setActive(true);
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            @Override
            public void handle(long now) {
                if (now > Test.this.lastTimerCall + 1000000000L) {
                    Test.this.lastTimerCall = now;
                }
            }
        };
    }

    @Override
    public void start(Stage stage) {
        StackPane pane = new StackPane(this.tile1);
        pane.setPadding(new Insets(10.0));
        Scene scene = new Scene(pane);
        stage.setTitle("Test");
        stage.setScene(scene);
        stage.show();
        Test.calcNoOfNodes(pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
        this.timer.start();
    }

    @Override
    public void stop() {
        Platform.exit();
        System.exit(0);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList<Node> tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Test.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args2) {
        Test.launch(args2);
    }
}

