#!/usr/bin/env python

# BSD 3-Clause License; see https://github.com/scikit-hep/uproot-methods/blob/master/LICENSE

import importlib
import re

def transformer(name):
    m = re.match("^([a-zA-Z_][a-zA-Z_0-9]*)(\.[a-zA-Z_][a-zA-Z_0-9]*)*$", name)
    if m is None:
        raise ValueError("profile name must match \"identifier(.identifier)*\"")
    return getattr(importlib.import_module("uproot_methods.profiles." + m.string), "transform")
