/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class FeaturesHandler
extends RequestHandler {
    public static final String command = "features";

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        String q = (String)this.args.get("q");
        List<String> handlers = q == null ? null : Arrays.asList(q.split("[,\\s]+", -1));
        this.content = RequestProcessor.getHandlersInfoAsJSON(handlers).toString();
        this.contentType = "application/json";
        if (this.args.containsKey("jsonp")) {
            this.content = (String)this.args.get("jsonp") + " && " + (String)this.args.get("jsonp") + '(' + this.content + ')';
        }
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to report its supported features. This enables web sites to guess a running JOSM version", new Object[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.READ_PROTOCOL_VERSION;
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[0];
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"jsonp", "q"};
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
    }

    @Override
    public String getUsage() {
        return "reports available commands, their parameters and examples";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/features", "/features?q=import,add_node"};
    }
}

