/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.Arrays;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDH;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.util.BigIntegers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsDHDomain
implements TlsDHDomain {
    protected final JcaTlsCrypto crypto;
    protected final TlsDHConfig dhConfig;
    protected final DHParameterSpec dhParameterSpec;

    private static byte[] encodeValue(DHParameterSpec dHParameterSpec, boolean bl, BigInteger bigInteger) {
        return bl ? BigIntegers.asUnsignedByteArray((int)JceTlsDHDomain.getValueLength(dHParameterSpec), (BigInteger)bigInteger) : BigIntegers.asUnsignedByteArray((BigInteger)bigInteger);
    }

    private static int getValueLength(DHParameterSpec dHParameterSpec) {
        return (dHParameterSpec.getP().bitLength() + 7) / 8;
    }

    public static JceTlsSecret calculateDHAgreement(JcaTlsCrypto jcaTlsCrypto, DHPrivateKey dHPrivateKey, DHPublicKey dHPublicKey, boolean bl) throws IOException {
        try {
            byte[] byArray = jcaTlsCrypto.calculateKeyAgreement("DH", dHPrivateKey, dHPublicKey, "TlsPremasterSecret");
            if (bl) {
                int n = JceTlsDHDomain.getValueLength(dHPrivateKey.getParams());
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
                Arrays.fill(byArray, (byte)0);
                byArray = byArray2;
            }
            return jcaTlsCrypto.adoptLocalSecret(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("cannot calculate secret", generalSecurityException);
        }
    }

    public static DHParameterSpec getParameters(TlsDHConfig tlsDHConfig) {
        DHGroup dHGroup = TlsDHUtils.getDHGroup(tlsDHConfig);
        if (dHGroup == null) {
            throw new IllegalArgumentException("No DH configuration provided");
        }
        return new DHParameterSpec(dHGroup.getP(), dHGroup.getG(), dHGroup.getL());
    }

    public JceTlsDHDomain(JcaTlsCrypto jcaTlsCrypto, TlsDHConfig tlsDHConfig) {
        this.crypto = jcaTlsCrypto;
        this.dhConfig = tlsDHConfig;
        this.dhParameterSpec = JceTlsDHDomain.getParameters(tlsDHConfig);
    }

    public JceTlsSecret calculateDHAgreement(DHPrivateKey dHPrivateKey, DHPublicKey dHPublicKey) throws IOException {
        return JceTlsDHDomain.calculateDHAgreement(this.crypto, dHPrivateKey, dHPublicKey, this.dhConfig.isPadded());
    }

    @Override
    public TlsAgreement createDH() {
        return new JceTlsDH(this);
    }

    public BigInteger decodeParameter(byte[] byArray) throws IOException {
        if (this.dhConfig.isPadded() && JceTlsDHDomain.getValueLength(this.dhParameterSpec) != byArray.length) {
            throw new TlsFatalAlert(47);
        }
        return new BigInteger(1, byArray);
    }

    public DHPublicKey decodePublicKey(byte[] byArray) throws IOException {
        try {
            BigInteger bigInteger = this.decodeParameter(byArray);
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("DH");
            return (DHPublicKey)keyFactory.generatePublic(new DHPublicKeySpec(bigInteger, this.dhParameterSpec.getP(), this.dhParameterSpec.getG()));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(40, (Throwable)exception);
        }
    }

    public byte[] encodeParameter(BigInteger bigInteger) throws IOException {
        return JceTlsDHDomain.encodeValue(this.dhParameterSpec, this.dhConfig.isPadded(), bigInteger);
    }

    public byte[] encodePublicKey(DHPublicKey dHPublicKey) throws IOException {
        return JceTlsDHDomain.encodeValue(this.dhParameterSpec, true, dHPublicKey.getY());
    }

    public KeyPair generateKeyPair() throws IOException {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("DH");
            keyPairGenerator.initialize(this.dhParameterSpec, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("unable to create key pair", generalSecurityException);
        }
    }
}

