/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import ca.odell.glazedlists.swing.DefaultEventComboBoxModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import javax.swing.ComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import mediathek.config.MVConfig;
import mediathek.daten.ListeFilme;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.Functions;
import mediathek.tool.Log;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.SenderList;
import org.apache.commons.lang3.SystemUtils;

public class GuiFunktionen
extends MVFunctionSys {
    private static final int WIN_MAX_PATH_LENGTH = 250;
    private static final int X_MAX_NAME_LENGTH = 255;
    private static final int UPDATE_FILME_AUS = 0;
    private static final int UPDATE_FILME_AUTO = 2;

    public static void updateGui(MediathekGui mediathekGui) {
        try {
            SwingUtilities.updateComponentTreeUI(mediathekGui);
            for (Frame f : Frame.getFrames()) {
                SwingUtilities.updateComponentTreeUI(f);
                for (Window w : f.getOwnedWindows()) {
                    SwingUtilities.updateComponentTreeUI(w);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyToClipboard(String s2) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s2), null);
    }

    public static void centerOnScreen(Component c, boolean absolute) {
        int width = c.getWidth();
        int height = c.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screenSize.width / 2 - width / 2;
        int y = screenSize.height / 2 - height / 2;
        if (!absolute) {
            x /= 2;
            y /= 2;
        }
        c.setLocation(x, y);
    }

    public static void getSize(MVConfig.Configs nr, JFrame jFrame) {
        if (jFrame != null) {
            MVConfig.add(nr, jFrame.getSize().width + ":" + jFrame.getSize().height + ":" + jFrame.getLocation().x + ":" + jFrame.getLocation().y);
        }
    }

    public static void getSize(MVConfig.Configs nr, JDialog jDialog) {
        if (jDialog != null) {
            MVConfig.add(nr, jDialog.getSize().width + ":" + jDialog.getSize().height + ":" + jDialog.getLocation().x + ":" + jDialog.getLocation().y);
        }
    }

    public static boolean setSize(MVConfig.Configs nr, JDialog jDialog, Frame relativFrame) {
        boolean ret = false;
        int breite = 0;
        int hoehe = 0;
        int posX = 0;
        int posY = 0;
        String[] arr = MVConfig.get(nr).split(":");
        try {
            if (arr.length == 4) {
                breite = Integer.parseInt(arr[0]);
                hoehe = Integer.parseInt(arr[1]);
                posX = Integer.parseInt(arr[2]);
                posY = Integer.parseInt(arr[3]);
            }
        }
        catch (Exception ex) {
            breite = 0;
            hoehe = 0;
            posX = 0;
            posY = 0;
        }
        if (breite > 0 && hoehe > 0) {
            jDialog.setSize(new Dimension(breite, hoehe));
            ret = true;
        }
        if (posX > 0 && posY > 0) {
            jDialog.setLocation(posX, posY);
        } else if (relativFrame != null) {
            jDialog.setLocationRelativeTo(relativFrame);
        }
        return ret;
    }

    public static String addsPfad(String pfad1, String pfad2) {
        String ret = GuiFunktionen.concatPaths(pfad1, pfad2);
        if (ret.isEmpty()) {
            Log.errorLog(283946015, pfad1 + " - " + pfad2);
        }
        return ret;
    }

    public static String concatPaths(String pfad1, String pfad2) {
        if (pfad1 == null || pfad2 == null) {
            return "";
        }
        if (pfad1.isEmpty() || pfad2.isEmpty()) {
            return pfad1 + pfad2;
        }
        Object ret = pfad1.endsWith(File.separator) ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
        ret = pfad2.charAt(0) == File.separatorChar ? (String)ret + pfad2 : (String)ret + File.separator + pfad2;
        return ret;
    }

    public static String[] checkLengthPath(String[] pathName) {
        if (SystemUtils.IS_OS_WINDOWS) {
            if (pathName[0].length() + 10 > 250) {
                Log.errorLog(102036598, "Pfad zu lang: " + pathName[0]);
                pathName[0] = GuiFunktionen.getHomePath();
            }
            if (pathName[0].length() + pathName[1].length() > 250) {
                Log.errorLog(902367369, "Name zu lang: " + pathName[0]);
                int maxNameL = 250 - pathName[0].length();
                pathName[1] = GuiFunktionen.cutName(pathName[1], maxNameL);
            }
        } else if (pathName[1].length() > 255) {
            Log.errorLog(823012012, "Name zu lang: " + pathName[1]);
            pathName[1] = GuiFunktionen.cutName(pathName[1], 255);
        }
        return pathName;
    }

    public static String cutName(String name, int length) {
        if (((String)name).length() > length) {
            name = ((String)name).substring(0, length - 4) + ((String)name).substring(((String)name).length() - 4);
        }
        return name;
    }

    public static boolean istUrl(String dateiUrl) {
        return dateiUrl.startsWith("http") || dateiUrl.startsWith("www");
    }

    public static String getDateiName(String pfad) {
        String ret = "";
        if (pfad != null && !pfad.isEmpty()) {
            ret = pfad.substring(pfad.lastIndexOf(47) + 1);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf(63));
        }
        if (ret.contains("&")) {
            ret = ret.substring(0, ret.indexOf(38));
        }
        if (ret.isEmpty()) {
            Log.errorLog(395019631, pfad);
        }
        return ret;
    }

    public static String getSuffixFromUrl(String pfad) {
        String ret = "";
        if (pfad != null && !pfad.isEmpty() && pfad.contains(".")) {
            ret = pfad.substring(pfad.lastIndexOf(46) + 1);
        }
        if (ret.isEmpty()) {
            Log.errorLog(969871236, pfad);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf(63));
        }
        if (ret.length() > 5) {
            ret = "---";
            Log.errorLog(821397046, pfad);
        }
        return ret;
    }

    public static String getFileNameWithoutSuffix(String pfad) {
        String ret = "";
        if (pfad != null && !pfad.isEmpty() && pfad.contains(".")) {
            ret = pfad.substring(0, pfad.lastIndexOf(46));
        }
        if (ret.isEmpty()) {
            ret = pfad;
            Log.errorLog(945123647, pfad);
        }
        return ret;
    }

    public static String getHomePath() {
        return System.getProperty("user.home");
    }

    public static String getStandardDownloadPath() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return GuiFunktionen.addsPfad(GuiFunktionen.getHomePath(), "Downloads");
        }
        return GuiFunktionen.addsPfad(GuiFunktionen.getHomePath(), "MediathekView");
    }

    public static ComboBoxModel<String> getSenderListComboBoxModel(ListeFilme listeFilme) {
        DefaultEventComboBoxModel<String> senderModel = new DefaultEventComboBoxModel<String>(new SenderList(listeFilme.getBaseSenderList()));
        senderModel.setSelectedItem("");
        return senderModel;
    }

    public static int getPlatformControlKey() {
        int result = Functions.getOs() == Functions.OperatingSystemType.MAC ? 256 : 128;
        return result;
    }

    public static FilmListUpdateType getImportArtFilme() {
        int ret;
        try {
            ret = Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_IMPORT_ART_FILME));
        }
        catch (Exception ex) {
            MVConfig.add(MVConfig.Configs.SYSTEM_IMPORT_ART_FILME, String.valueOf(2));
            ret = 2;
        }
        FilmListUpdateType result = ret == 0 ? FilmListUpdateType.MANUAL : FilmListUpdateType.AUTOMATIC;
        return result;
    }

    public static void setImportArtFilme(FilmListUpdateType type) {
        int value = type == FilmListUpdateType.MANUAL ? 0 : 2;
        MVConfig.add(MVConfig.Configs.SYSTEM_IMPORT_ART_FILME, String.valueOf(value));
    }

    public static void enableComponents(Container container, boolean enable) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            component.setEnabled(enable);
            if (!(component instanceof Container)) continue;
            GuiFunktionen.enableComponents((Container)component, enable);
        }
    }
}

