/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.util.LinkedList;
import net.sf.sdedit.util.Utilities;
import net.sf.sdedit.util.tree.Tree;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentTree<T extends Node>
implements Tree<T> {
    private Node root;
    private Class<? extends Node> nodeClass;

    public DocumentTree(Node root, Class<T> nodeClass) {
        this.root = root;
        this.nodeClass = nodeClass;
    }

    @Override
    public T[] getChildren(Node node) {
        Object[] nodeArray;
        if (node == null) {
            nodeArray = new Node[]{this.root};
        } else {
            NodeList nodeList = node.getChildNodes();
            LinkedList<Node> children = new LinkedList<Node>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!this.nodeClass.isInstance(nodeList.item(i))) continue;
                children.add(nodeList.item(i));
            }
            nodeArray = children.toArray(new Node[children.size()]);
        }
        return Utilities.castArray(nodeArray, this.nodeClass);
    }

    @Override
    public T getParent(Node node) {
        return (T)node.getParentNode();
    }
}

