/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.FontNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import java.awt.Font;

public class FontFamilyAction
extends NodeGeneralAction
implements NodeActorXml {
    private String actionFont;

    public FontFamilyAction(MindMapController modeController) {
        super(modeController, "font_family", null, (NodeActorXml)null);
        this.addActor(this);
        this.actionFont = modeController.getFrame().getProperty("defaultfont");
    }

    public void actionPerformed(String font) {
        this.actionFont = font;
        super.actionPerformed(null);
    }

    @Override
    public ActionPair apply(MindMap model, MindMapNode selected) {
        return this.getActionPair(selected, this.actionFont);
    }

    @Override
    public Class getDoActionClass() {
        return FontNodeAction.class;
    }

    public void setFontFamily(MindMapNode node, String fontFamilyValue) {
        this.modeController.doTransaction((String)this.getValue("Name"), this.getActionPair(node, fontFamilyValue));
    }

    private ActionPair getActionPair(MindMapNode node, String fontFamilyValue) {
        FontNodeAction fontFamilyAction = this.createFontNodeAction(node, fontFamilyValue);
        FontNodeAction undoFontFamilyAction = this.createFontNodeAction(node, node.getFontFamilyName());
        return new ActionPair((XmlAction)fontFamilyAction, (XmlAction)undoFontFamilyAction);
    }

    private FontNodeAction createFontNodeAction(MindMapNode node, String fontValue) {
        FontNodeAction fontFamilyAction = new FontNodeAction();
        fontFamilyAction.setNode(this.getNodeID(node));
        fontFamilyAction.setFont(fontValue);
        return fontFamilyAction;
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof FontNodeAction) {
            FontNodeAction fontFamilyAction = (FontNodeAction)action;
            NodeAdapter node = this.getNodeFromID(fontFamilyAction.getNode());
            String fontFamily = fontFamilyAction.getFont();
            if (!Tools.safeEquals(node.getFontFamilyName(), fontFamily)) {
                node.establishOwnFont();
                node.setFont(this.modeController.getController().getFontThroughMap(new Font(fontFamily, node.getFont().getStyle(), node.getFont().getSize())));
                this.modeController.nodeChanged(node);
            }
        }
    }
}

