/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.input;

import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.UIManager;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.JEditBeanShellAction;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.gui.ShortcutPrefixActiveEvent;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public abstract class TextAreaInputHandler
extends AbstractInputHandler<JEditBeanShellAction> {
    private final TextArea textArea;

    protected TextAreaInputHandler(TextArea textArea) {
        this.textArea = textArea;
        this.bindings = this.currentBindings = new Hashtable();
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent, int n, boolean bl) {
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event                 : " + TextAreaInputHandler.toString(keyEvent) + " from " + n);
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event (preprocessing) : " + TextAreaInputHandler.toString(keyEvent));
        }
        if ((keyEvent = KeyEventWorkaround.processKeyEvent(keyEvent)) == null) {
            return;
        }
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event after workaround: " + TextAreaInputHandler.toString(keyEvent) + " from " + n);
        }
        boolean bl2 = false;
        switch (keyEvent.getID()) {
            case 400: {
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyTyped(keyEvent);
                } else if (this.isPrefixActive() || this.textArea.hasFocus()) {
                    this.processKeyEventKeyStrokeHandling(keyEvent, n, "type ", bl);
                }
                this.processKeyEventSub(bl2);
                break;
            }
            case 401: {
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyPressed(keyEvent);
                    break;
                }
                if (!KeyEventWorkaround.isBindable(keyEvent.getKeyCode())) break;
                this.processKeyEventKeyStrokeHandling(keyEvent, n, "press", bl);
                this.processKeyEventSub(bl2);
                break;
            }
            case 402: {
                if (this.keyEventInterceptor == null) break;
                this.keyEventInterceptor.keyReleased(keyEvent);
            }
        }
    }

    private void processKeyEventSub(boolean bl) {
        if (this.isPrefixActive() && bl) {
            this.textArea.requestFocus();
        }
    }

    protected abstract JEditBeanShellAction getAction(String var1);

    @Override
    public void invokeAction(String string) {
        this.invokeAction(this.getAction(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAction(JEditBeanShellAction jEditBeanShellAction) {
        JEditBuffer jEditBuffer = this.textArea.getBuffer();
        if (!jEditBeanShellAction.noRememberLast()) {
            if (this.lastAction == jEditBeanShellAction) {
                ++this.lastActionCount;
            } else {
                this.lastAction = jEditBeanShellAction;
                this.lastActionCount = 1;
            }
        }
        int n = this.repeatCount;
        if (jEditBeanShellAction.noRepeat() || n == 1) {
            jEditBeanShellAction.invoke(this.textArea);
        } else {
            try {
                jEditBuffer.beginCompoundEdit();
                for (int i = 0; i < n; ++i) {
                    jEditBeanShellAction.invoke(this.textArea);
                }
            }
            finally {
                jEditBuffer.endCompoundEdit();
            }
        }
        if (n != 1) {
            if (this.readNextChar != null) {
                return;
            }
            this.repeatCount = 1;
        }
    }

    @Override
    public boolean handleKey(KeyEventTranslator.Key key, boolean bl) {
        Object v;
        char c = '\u0000';
        if (key.modifiers == null || key.modifiers.equals("S")) {
            switch (key.key) {
                case 9: 
                case 10: {
                    c = (char)key.key;
                    break;
                }
                default: {
                    c = key.input;
                }
            }
        }
        if (this.readNextChar != null) {
            if (c != '\u0000') {
                if (!bl) {
                    this.setCurrentBindings(this.bindings);
                    this.invokeReadNextChar(c);
                    this.repeatCount = 1;
                }
                return true;
            }
            if (!bl) {
                this.readNextChar = null;
            }
        }
        if ((v = this.currentBindings.get(key)) == null) {
            if (!bl) {
                if (this.currentBindings != this.bindings) {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                    this.repeatCount = 1;
                    this.setCurrentBindings(this.bindings);
                } else if (c != '\u0000' && !key.isFromGlobalContext()) {
                    this.userInput(c);
                }
                this.sendShortcutPrefixOff();
            }
        } else {
            if (v instanceof Hashtable) {
                if (!bl) {
                    this.setCurrentBindings((Hashtable)v);
                    ShortcutPrefixActiveEvent.firePrefixStateChange(this.currentBindings, true);
                    this.shortcutOn = true;
                }
                return true;
            }
            if (v instanceof String) {
                if (!bl) {
                    this.setCurrentBindings(this.bindings);
                    this.sendShortcutPrefixOff();
                    this.invokeAction((String)v);
                }
                return true;
            }
            if (v instanceof JEditBeanShellAction) {
                if (!bl) {
                    this.setCurrentBindings(this.bindings);
                    this.sendShortcutPrefixOff();
                    this.invokeAction((JEditBeanShellAction)v);
                }
                return true;
            }
        }
        if (!bl) {
            this.sendShortcutPrefixOff();
        }
        return false;
    }

    protected void userInput(char c) {
        this.lastActionCount = 0;
        if (this.repeatCount == 1) {
            this.textArea.userInput(c);
        }
        this.repeatCount = 1;
    }

    protected void invokeReadNextChar(char c) {
        int n;
        String string = StandardUtilities.charsToEscapes(String.valueOf(c));
        while ((n = this.readNextChar.indexOf("__char__")) != -1) {
            this.readNextChar = this.readNextChar.substring(0, n) + '\'' + string + '\'' + this.readNextChar.substring(n + 8);
        }
        this.readNextChar = null;
    }
}

