/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.log;

import java.io.PrintStream;
import org.jruby.util.log.OutputStreamLogger;

public class StandardErrorLogger
extends OutputStreamLogger {
    public StandardErrorLogger(String loggerName) {
        super(loggerName);
    }

    public StandardErrorLogger(Class<?> loggerClass) {
        super(loggerClass.getSimpleName());
    }

    public StandardErrorLogger(String loggerName, PrintStream stream) {
        super(loggerName, stream);
    }

    @Override
    protected void write(String message2, String level2, Object[] args2) {
        PrintStream stream = this.stream;
        if (stream == null) {
            stream = System.err;
        }
        CharSequence suble = StandardErrorLogger.substitute(message2, args2);
        stream.println(this.formatMessage(suble, level2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(String message2, String level2, Throwable throwable) {
        PrintStream stream = this.stream;
        if (stream == null) {
            stream = System.err;
        }
        PrintStream printStream = stream;
        synchronized (printStream) {
            stream.println(this.formatMessage(message2, level2));
            StandardErrorLogger.writeStackTrace(stream, throwable);
        }
    }
}

