export = RoomUpgradeHandler;
/**
 * Handles migration of rooms when a room upgrade is performed.
 */
declare class RoomUpgradeHandler {
    /**
     * @param {RoomUpgradeHandler~Options} opts
     * @param {Bridge} bridge The parent bridge.
     */
    constructor(opts: any, bridge: any);
    _opts: any;
    _bridge: any;
    _waitingForInvite: Map<any, any>;
    onTombstone(ev: any): any;
    _joinNewRoom(newRoomId: any, joinVia?: any[]): any;
    onInvite(ev: any): boolean;
    _onJoinedNewRoom(oldRoomId: any, newRoomId: any): Promise<boolean>;
    _migrateStoreEntries(oldRoomId: any, newRoomId: any): Promise<boolean>;
    _migrateEntry(entry: any, newRoomId: any): any;
}
declare namespace RoomUpgradeHandler {
    export { RoomUpgradeHandler };
}
/**
 * ~Options
 */
type RoomUpgradeHandler = {
    /**
     * ~MigrateEntry} migrateEntry Called when
     * the handler wishes to migrate a MatrixRoom entry to a new room_id. If omitted,
     * {@link RoomUpgradeHandler~_migrateEntry} will be used instead.
     */
    "": RoomUpgradeHandler;
    /**
     * Consume tombstone or invite events that
     * are acted on by this handler.
     */
    consumeEvent?: any;
    /**
     * If true, migrate all ghost users across to
     * the new room.
     */
    migrateGhosts?: any;
    /**
     * If true, migrate all ghost users across to
     * the new room.
     */
    migrateStoreEntries?: any;
};
