/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.sequencediagram.teoz.YPositionedTile;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class LinkAnchor {
    private final String anchor1;
    private final String anchor2;
    private final String message;

    public LinkAnchor(String anchor1, String anchor2, String message) {
        this.anchor1 = anchor1;
        this.anchor2 = anchor2;
        this.message = message;
    }

    public String toString() {
        return this.anchor1 + "<->" + this.anchor2 + " " + this.message;
    }

    public final String getAnchor1() {
        return this.anchor1;
    }

    public final String getAnchor2() {
        return this.anchor2;
    }

    public final String getMessage() {
        return this.message;
    }

    public void drawAnchor(UGraphic ug, YPositionedTile tile1, YPositionedTile tile2, ISkinParam param) {
        StringBounder stringBounder = ug.getStringBounder();
        double y1 = tile1.getY(stringBounder);
        double y2 = tile2.getY(stringBounder);
        double xx1 = tile1.getMiddleX(stringBounder);
        double xx2 = tile2.getMiddleX(stringBounder);
        double x = (xx1 + xx2) / 2.0;
        double ymin = Math.min(y1, y2);
        double ymax = Math.max(y1, y2);
        HColor color = new Rose().getHtmlColor(param, ColorParam.arrow);
        Rainbow rainbow = Rainbow.fromColor(color, null);
        Snake snake = new Snake(Arrows.asToUp(), HorizontalAlignment.CENTER, rainbow, Arrows.asToDown());
        Display display = Display.getWithNewlines(this.message);
        TextBlock title = display.create(new FontConfiguration(param, FontParam.ARROW, null), HorizontalAlignment.CENTER, param);
        snake.setLabel(title);
        snake.addPoint(x, ymin + 2.0);
        snake.addPoint(x, ymax - 2.0);
        snake.drawInternal(ug);
    }
}

