/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.cache;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.cache.OWLEntityRenderingCache;
import org.protege.editor.owl.model.util.OWLDataTypeUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.vocab.DublinCoreVocabulary;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLEntityRenderingCacheImpl
implements OWLEntityRenderingCache {
    private SetMultimap<String, OWLClass> owlClassMap = HashMultimap.create();
    private SetMultimap<String, OWLObjectProperty> owlObjectPropertyMap = HashMultimap.create();
    private SetMultimap<String, OWLDataProperty> owlDataPropertyMap = HashMultimap.create();
    private SetMultimap<String, OWLAnnotationProperty> owlAnnotationPropertyMap = HashMultimap.create();
    private SetMultimap<String, OWLNamedIndividual> owlIndividualMap = HashMultimap.create();
    private SetMultimap<String, OWLDatatype> owlDatatypeMap = HashMultimap.create();
    private Map<OWLEntity, String> entityRenderingMap = new HashMap<OWLEntity, String>();
    private OWLModelManager owlModelManager;
    private OWLOntologyChangeListener listener = changes -> this.processChanges(changes);

    @Override
    public void setOWLModelManager(OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
        owlModelManager.addOntologyChangeListener(this.listener);
    }

    private void processChanges(List<? extends OWLOntologyChange> changes) {
        HashSet changedEntities = new HashSet();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!(oWLOntologyChange instanceof OWLAxiomChange)) continue;
            OWLAxiomChange chg = (OWLAxiomChange)oWLOntologyChange;
            changedEntities.addAll(chg.getSignature());
        }
        for (OWLEntity oWLEntity : changedEntities) {
            this.updateRendering(oWLEntity);
        }
    }

    @Override
    public void rebuild() {
        this.clear();
        this.owlModelManager.getOWLEntityRenderer();
        OWLDataFactory factory = this.owlModelManager.getOWLDataFactory();
        this.addRendering((OWLEntity)factory.getOWLThing(), (Multimap)this.owlClassMap);
        this.addRendering((OWLEntity)factory.getOWLNothing(), (Multimap)this.owlClassMap);
        this.addRendering((OWLEntity)factory.getOWLTopObjectProperty(), (Multimap)this.owlObjectPropertyMap);
        this.addRendering((OWLEntity)factory.getOWLBottomObjectProperty(), (Multimap)this.owlObjectPropertyMap);
        this.addRendering((OWLEntity)factory.getOWLTopDataProperty(), (Multimap)this.owlDataPropertyMap);
        this.addRendering((OWLEntity)factory.getOWLBottomDataProperty(), (Multimap)this.owlDataPropertyMap);
        for (OWLOntology ont : this.owlModelManager.getOntologies()) {
            for (OWLClass oWLClass : ont.getClassesInSignature()) {
                this.addRendering((OWLEntity)oWLClass, (Multimap)this.owlClassMap);
            }
            for (OWLObjectProperty oWLObjectProperty : ont.getObjectPropertiesInSignature()) {
                this.addRendering((OWLEntity)oWLObjectProperty, (Multimap)this.owlObjectPropertyMap);
            }
            for (OWLDataProperty oWLDataProperty : ont.getDataPropertiesInSignature()) {
                this.addRendering((OWLEntity)oWLDataProperty, (Multimap)this.owlDataPropertyMap);
            }
            for (OWLIndividual oWLIndividual : ont.getIndividualsInSignature()) {
                if (oWLIndividual.isAnonymous()) continue;
                this.addRendering((OWLEntity)oWLIndividual.asOWLNamedIndividual(), (Multimap)this.owlIndividualMap);
            }
            for (OWLAnnotationProperty oWLAnnotationProperty : ont.getAnnotationPropertiesInSignature()) {
                this.addRendering((OWLEntity)oWLAnnotationProperty, (Multimap)this.owlAnnotationPropertyMap);
            }
        }
        for (IRI uri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            this.addRendering((OWLEntity)factory.getOWLAnnotationProperty(uri), (Multimap)this.owlAnnotationPropertyMap);
        }
        for (Iterator<Object> iterator : DublinCoreVocabulary.values()) {
            this.addRendering((OWLEntity)factory.getOWLAnnotationProperty(iterator.getIRI()), (Multimap)this.owlAnnotationPropertyMap);
        }
        OWLDataTypeUtils datatypeUtils = new OWLDataTypeUtils(this.owlModelManager.getOWLOntologyManager());
        for (OWLDatatype dt : datatypeUtils.getKnownDatatypes(this.owlModelManager.getActiveOntologies())) {
            this.addRendering((OWLEntity)dt, (Multimap)this.owlDatatypeMap);
        }
    }

    public void dispose() {
        this.clear();
        this.owlModelManager.removeOntologyChangeListener(this.listener);
    }

    private void clear() {
        this.owlClassMap.clear();
        this.owlObjectPropertyMap.clear();
        this.owlDataPropertyMap.clear();
        this.owlAnnotationPropertyMap.clear();
        this.owlIndividualMap.clear();
        this.owlDatatypeMap.clear();
        this.entityRenderingMap.clear();
    }

    private static <E extends OWLEntity> E getFirstEntityOrNull(Multimap<String, E> renderingMap, String rendering) {
        return (E)((OWLEntity)renderingMap.get((Object)rendering).stream().findFirst().orElse(null));
    }

    @Override
    public OWLClass getOWLClass(String rendering) {
        return OWLEntityRenderingCacheImpl.getFirstEntityOrNull(this.owlClassMap, rendering);
    }

    @Override
    public Set<OWLEntity> getOWLEntities(String rendering) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)this.owlClassMap.get((Object)rendering));
        builder.addAll((Iterable)this.owlObjectPropertyMap.get((Object)rendering));
        builder.addAll((Iterable)this.owlDataPropertyMap.get((Object)rendering));
        builder.addAll((Iterable)this.owlAnnotationPropertyMap.get((Object)rendering));
        builder.addAll((Iterable)this.owlIndividualMap.get((Object)rendering));
        builder.addAll((Iterable)this.owlDatatypeMap.get((Object)rendering));
        return builder.build();
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(String rendering) {
        return OWLEntityRenderingCacheImpl.getFirstEntityOrNull(this.owlObjectPropertyMap, rendering);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(String rendering) {
        return OWLEntityRenderingCacheImpl.getFirstEntityOrNull(this.owlDataPropertyMap, rendering);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(String rendering) {
        return OWLEntityRenderingCacheImpl.getFirstEntityOrNull(this.owlAnnotationPropertyMap, rendering);
    }

    @Override
    public OWLNamedIndividual getOWLIndividual(String rendering) {
        return OWLEntityRenderingCacheImpl.getFirstEntityOrNull(this.owlIndividualMap, rendering);
    }

    @Override
    public OWLDatatype getOWLDatatype(String rendering) {
        return OWLEntityRenderingCacheImpl.getFirstEntityOrNull(this.owlDatatypeMap, rendering);
    }

    @Override
    public String getRendering(OWLEntity owlEntity) {
        return this.entityRenderingMap.get(owlEntity);
    }

    @Override
    public OWLEntity getOWLEntity(String rendering) {
        OWLClass entity = this.getOWLClass(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLObjectProperty(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLDataProperty(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLIndividual(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLDatatype(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLAnnotationProperty(rendering);
        if (entity != null) {
            return entity;
        }
        return null;
    }

    @Override
    public void addRendering(OWLEntity owlEntity) {
        owlEntity.accept(new OWLEntityVisitor(){

            public void visit(OWLDataProperty entity) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)entity, (Multimap)OWLEntityRenderingCacheImpl.this.owlDataPropertyMap);
            }

            public void visit(OWLObjectProperty entity) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)entity, (Multimap)OWLEntityRenderingCacheImpl.this.owlObjectPropertyMap);
            }

            public void visit(OWLAnnotationProperty owlAnnotationProperty) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)owlAnnotationProperty, (Multimap)OWLEntityRenderingCacheImpl.this.owlAnnotationPropertyMap);
            }

            public void visit(OWLNamedIndividual entity) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)entity, (Multimap)OWLEntityRenderingCacheImpl.this.owlIndividualMap);
            }

            public void visit(OWLClass entity) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)entity, (Multimap)OWLEntityRenderingCacheImpl.this.owlClassMap);
            }

            public void visit(OWLDatatype entity) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)entity, (Multimap)OWLEntityRenderingCacheImpl.this.owlDatatypeMap);
            }
        });
    }

    private <T extends OWLEntity> void addRendering(T entity, Multimap<String, T> map) {
        if (!this.entityRenderingMap.containsKey(entity)) {
            String rendering = this.owlModelManager.getRendering((OWLObject)entity);
            map.put((Object)rendering, entity);
            this.entityRenderingMap.put(entity, rendering);
        }
    }

    @Override
    public void removeRendering(OWLEntity owlEntity) {
        final String oldRendering = this.entityRenderingMap.get(owlEntity);
        this.entityRenderingMap.remove(owlEntity);
        owlEntity.accept(new OWLEntityVisitor(){

            public void visit(OWLClass entity) {
                OWLEntityRenderingCacheImpl.this.owlClassMap.remove((Object)oldRendering, (Object)entity);
            }

            public void visit(OWLDataProperty entity) {
                OWLEntityRenderingCacheImpl.this.owlDataPropertyMap.remove((Object)oldRendering, (Object)entity);
            }

            public void visit(OWLObjectProperty entity) {
                OWLEntityRenderingCacheImpl.this.owlObjectPropertyMap.remove((Object)oldRendering, (Object)entity);
            }

            public void visit(OWLAnnotationProperty entity) {
                OWLEntityRenderingCacheImpl.this.owlAnnotationPropertyMap.remove((Object)oldRendering, (Object)entity);
            }

            public void visit(OWLNamedIndividual entity) {
                OWLEntityRenderingCacheImpl.this.owlIndividualMap.remove((Object)oldRendering, (Object)entity);
            }

            public void visit(OWLDatatype entity) {
                OWLEntityRenderingCacheImpl.this.owlDatatypeMap.remove((Object)oldRendering, (Object)entity);
            }
        });
    }

    @Override
    public void updateRendering(OWLEntity ent) {
        boolean updateRendering = false;
        for (OWLOntology ont : this.owlModelManager.getActiveOntologies()) {
            if (!ont.containsEntityInSignature(ent)) continue;
            updateRendering = true;
            break;
        }
        this.removeRendering(ent);
        if (updateRendering) {
            this.addRendering(ent);
        }
    }

    @Override
    public Set<String> getOWLClassRenderings() {
        return this.owlClassMap.keySet();
    }

    @Override
    public Set<String> getOWLObjectPropertyRenderings() {
        return this.owlObjectPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLDataPropertyRenderings() {
        return this.owlDataPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLAnnotationPropertyRenderings() {
        return this.owlAnnotationPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLIndividualRenderings() {
        return this.owlIndividualMap.keySet();
    }

    @Override
    public Set<String> getOWLDatatypeRenderings() {
        return this.owlDatatypeMap.keySet();
    }

    @Override
    public Set<String> getOWLEntityRenderings() {
        HashSet<String> renderings = new HashSet<String>(this.owlClassMap.size() + this.owlObjectPropertyMap.size() + this.owlDataPropertyMap.size() + this.owlAnnotationPropertyMap.size() + this.owlIndividualMap.size() + this.owlDatatypeMap.size());
        renderings.addAll(this.owlClassMap.keySet());
        renderings.addAll(this.owlObjectPropertyMap.keySet());
        renderings.addAll(this.owlDataPropertyMap.keySet());
        renderings.addAll(this.owlAnnotationPropertyMap.keySet());
        renderings.addAll(this.owlIndividualMap.keySet());
        renderings.addAll(this.owlDatatypeMap.keySet());
        return renderings;
    }
}

