/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.GestureType;
import com.sparshui.common.ClientProtocol;
import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;
import com.sparshui.server.TouchPoint;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import javajs.util.Lst;

public class ServerToClientProtocol
extends ClientProtocol {
    private DataOutputStream _bufferOut;
    private ByteArrayOutputStream _buffer = new ByteArrayOutputStream();

    public ServerToClientProtocol(Socket socket) throws IOException {
        super(socket);
        this._bufferOut = new DataOutputStream(this._buffer);
    }

    public Lst<GestureType> getGestures(int groupID) throws IOException {
        Lst<GestureType> gestures = new Lst<GestureType>();
        this._bufferOut.writeInt(groupID);
        this.sendBuffer(2);
        for (int length = this._in.readInt(); length > 0; length -= 4) {
            int gestureID = this._in.readInt();
            if (gestureID < 0) {
                byte[] bytes = new byte[-gestureID];
                this._in.read(bytes);
                gestures.addLast(new GestureType(Converter.byteArrayToString(bytes)));
                length -= bytes.length;
                continue;
            }
            gestures.addLast(new GestureType(gestureID));
        }
        return gestures;
    }

    public int getGroupID(TouchPoint touchPoint) throws IOException {
        byte[] tempFloat = new byte[4];
        Converter.floatToByteArray(tempFloat, 0, touchPoint.getLocation().getX());
        this._bufferOut.write(tempFloat);
        Converter.floatToByteArray(tempFloat, 0, touchPoint.getLocation().getY());
        this._bufferOut.write(tempFloat);
        this.sendBuffer(1);
        int ret = this._in.readInt();
        return ret;
    }

    public void processEvents(int groupID, Lst<Event> events) throws IOException {
        for (int i = 0; i < events.size(); ++i) {
            this._bufferOut.writeInt(groupID);
            this._bufferOut.write(((Event)events.get(i)).serialize());
            this.sendBuffer(0);
        }
    }

    public void processError(int errCode) throws IOException {
        this._bufferOut.writeInt(-1);
        this._bufferOut.writeInt(errCode);
        this.sendBuffer(0);
    }

    private void sendBuffer(int type) throws IOException {
        this._out.writeByte((byte)type);
        this._out.writeInt(this._buffer.size());
        this._out.write(this._buffer.toByteArray());
        this._buffer.reset();
    }
}

