/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.Point3fi;

public class BoxInfo {
    public static final int X = 4;
    public static final int Y = 2;
    public static final int Z = 1;
    public static final int XYZ = 7;
    public final P3 bbCorner0 = new P3();
    public final P3 bbCorner1 = new P3();
    private final P3 bbCenter = new P3();
    private final V3 bbVector = new V3();
    private final Point3fi[] bbVertices = new Point3fi[8];
    private boolean isScaleSet;
    private float margin;
    public static char[] bbcageTickEdges = new char[]{'z', '\u0000', '\u0000', 'y', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static char[] uccageTickEdges = new char[]{'z', 'y', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static final byte[] edges = new byte[]{0, 1, 0, 2, 0, 4, 1, 3, 1, 5, 2, 3, 2, 6, 3, 7, 4, 5, 4, 6, 5, 7, 6, 7};
    public static final P3[] unitCubePoints = new P3[]{P3.new3(0.0f, 0.0f, 0.0f), P3.new3(0.0f, 0.0f, 1.0f), P3.new3(0.0f, 1.0f, 0.0f), P3.new3(0.0f, 1.0f, 1.0f), P3.new3(1.0f, 0.0f, 0.0f), P3.new3(1.0f, 0.0f, 1.0f), P3.new3(1.0f, 1.0f, 0.0f), P3.new3(1.0f, 1.0f, 1.0f)};
    public static final int[][] facePoints = new int[][]{{4, 0, 6}, {4, 6, 5}, {5, 7, 1}, {1, 3, 0}, {6, 2, 7}, {1, 0, 5}, {0, 2, 6}, {6, 7, 5}, {7, 3, 1}, {3, 2, 0}, {2, 3, 7}, {0, 4, 5}};
    private static final int[] toCanonical = new int[]{0, 3, 4, 7, 1, 2, 5, 6};
    private static final P3[] unitBboxPoints = new P3[8];

    public BoxInfo() {
        int i;
        for (i = 0; i < 8; ++i) {
            BoxInfo.unitBboxPoints[i] = P3.new3(-1.0f, -1.0f, -1.0f);
            unitBboxPoints[i].scaleAdd2(2.0f, unitCubePoints[i], unitBboxPoints[i]);
        }
        i = 8;
        while (--i >= 0) {
            this.bbVertices[i] = new Point3fi();
        }
        this.reset();
    }

    public void reset() {
        this.isScaleSet = false;
        this.bbCorner0.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.bbCorner1.set(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
    }

    public static void scaleBox(P3[] pts, float scale) {
        int i;
        if (scale == 0.0f || scale == 1.0f) {
            return;
        }
        P3 center = new P3();
        V3 v = new V3();
        for (i = 0; i < 8; ++i) {
            center.add(pts[i]);
        }
        center.scale(0.125f);
        for (i = 0; i < 8; ++i) {
            v.sub2(pts[i], center);
            v.scale(scale);
            pts[i].add2(center, v);
        }
    }

    public static final P3[] getVerticesFromOABC(P3[] oabc) {
        P3[] vertices = new P3[8];
        for (int i = 0; i <= 7; ++i) {
            vertices[i] = P3.newP(oabc[0]);
            if ((i & 4) == 4) {
                vertices[i].add(oabc[1]);
            }
            if ((i & 2) == 2) {
                vertices[i].add(oabc[2]);
            }
            if ((i & 1) != 1) continue;
            vertices[i].add(oabc[3]);
        }
        return vertices;
    }

    public static final P3[] getCanonicalCopy(P3[] boxPoints, float scale) {
        P3[] pts = new P3[8];
        for (int i = 0; i < 8; ++i) {
            pts[BoxInfo.toCanonical[i]] = P3.newP(boxPoints[i]);
        }
        BoxInfo.scaleBox(pts, scale);
        return pts;
    }

    public static final P3[] toOABC(P3[] bbVertices, T3 offset) {
        P3 center = P3.newP(bbVertices[0]);
        P3 a = P3.newP(bbVertices[4]);
        P3 b = P3.newP(bbVertices[2]);
        P3 c = P3.newP(bbVertices[1]);
        a.sub(center);
        b.sub(center);
        c.sub(center);
        if (offset != null) {
            center.add(offset);
        }
        return new P3[]{center, a, b, c};
    }

    public P3 getBoundBoxCenter() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return this.bbCenter;
    }

    public V3 getBoundBoxCornerVector() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return this.bbVector;
    }

    public P3[] getBoundBoxPoints(boolean isAll) {
        P3[] p3Array;
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        if (isAll) {
            P3[] p3Array2 = new P3[4];
            p3Array2[0] = this.bbCenter;
            p3Array2[1] = P3.newP(this.bbVector);
            p3Array2[2] = this.bbCorner0;
            p3Array = p3Array2;
            p3Array2[3] = this.bbCorner1;
        } else {
            P3[] p3Array3 = new P3[2];
            p3Array3[0] = this.bbCorner0;
            p3Array = p3Array3;
            p3Array3[1] = this.bbCorner1;
        }
        return p3Array;
    }

    public Point3fi[] getBoundBoxVertices() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return this.bbVertices;
    }

    public void setBoundBoxFromOABC(T3[] points) {
        P3 origin = P3.newP(points[0]);
        P3 pt111 = new P3();
        for (int i = 0; i < 4; ++i) {
            pt111.add(points[i]);
        }
        this.setBoundBox(origin, pt111, true, 1.0f);
    }

    public void setBoundBox(T3 pt1, T3 pt2, boolean byCorner, float scale) {
        if (pt1 != null) {
            if (scale == 0.0f) {
                return;
            }
            if (byCorner) {
                if (pt1.distance(pt2) == 0.0f) {
                    return;
                }
                this.bbCorner0.set(Math.min(pt1.x, pt2.x), Math.min(pt1.y, pt2.y), Math.min(pt1.z, pt2.z));
                this.bbCorner1.set(Math.max(pt1.x, pt2.x), Math.max(pt1.y, pt2.y), Math.max(pt1.z, pt2.z));
            } else {
                if (pt2.x == 0.0f || pt2.y == 0.0f && pt2.z == 0.0f) {
                    return;
                }
                this.bbCorner0.set(pt1.x - pt2.x, pt1.y - pt2.y, pt1.z - pt2.z);
                this.bbCorner1.set(pt1.x + pt2.x, pt1.y + pt2.y, pt1.z + pt2.z);
            }
        }
        this.setBbcage(scale);
    }

    public void setMargin(float m) {
        this.margin = m;
    }

    public void addBoundBoxPoint(T3 pt) {
        this.isScaleSet = false;
        BoxInfo.addPoint(pt, this.bbCorner0, this.bbCorner1, this.margin);
    }

    public static void addPoint(T3 pt, T3 xyzMin, T3 xyzMax, float margin) {
        if (pt.x - margin < xyzMin.x) {
            xyzMin.x = pt.x - margin;
        }
        if (pt.x + margin > xyzMax.x) {
            xyzMax.x = pt.x + margin;
        }
        if (pt.y - margin < xyzMin.y) {
            xyzMin.y = pt.y - margin;
        }
        if (pt.y + margin > xyzMax.y) {
            xyzMax.y = pt.y + margin;
        }
        if (pt.z - margin < xyzMin.z) {
            xyzMin.z = pt.z - margin;
        }
        if (pt.z + margin > xyzMax.z) {
            xyzMax.z = pt.z + margin;
        }
    }

    public static void addPointXYZ(float x, float y, float z, P3 xyzMin, P3 xyzMax, float margin) {
        if (x - margin < xyzMin.x) {
            xyzMin.x = x - margin;
        }
        if (x + margin > xyzMax.x) {
            xyzMax.x = x + margin;
        }
        if (y - margin < xyzMin.y) {
            xyzMin.y = y - margin;
        }
        if (y + margin > xyzMax.y) {
            xyzMax.y = y + margin;
        }
        if (z - margin < xyzMin.z) {
            xyzMin.z = z - margin;
        }
        if (z + margin > xyzMax.z) {
            xyzMax.z = z + margin;
        }
    }

    public void setBbcage(float scale) {
        this.isScaleSet = true;
        this.bbCenter.add2(this.bbCorner0, this.bbCorner1);
        this.bbCenter.scale(0.5f);
        this.bbVector.sub2(this.bbCorner1, this.bbCenter);
        if (scale > 0.0f) {
            this.bbVector.scale(scale);
        } else {
            this.bbVector.x -= scale / 2.0f;
            this.bbVector.y -= scale / 2.0f;
            this.bbVector.z -= scale / 2.0f;
        }
        int i = 8;
        while (--i >= 0) {
            Point3fi pt = this.bbVertices[i];
            pt.setT(unitBboxPoints[i]);
            pt.x *= this.bbVector.x;
            pt.y *= this.bbVector.y;
            pt.z *= this.bbVector.z;
            pt.add(this.bbCenter);
        }
        this.bbCorner0.setT(this.bbVertices[0]);
        this.bbCorner1.setT(this.bbVertices[7]);
    }

    public boolean isWithin(P3 pt) {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return pt.x >= this.bbCorner0.x && pt.x <= this.bbCorner1.x && pt.y >= this.bbCorner0.y && pt.y <= this.bbCorner1.y && pt.z >= this.bbCorner0.z && pt.z <= this.bbCorner1.z;
    }

    public float getMaxDim() {
        return this.bbVector.length() * 2.0f;
    }
}

