/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.StringFactory;
import com.intellij.util.text.StringTokenizer;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final Logger LOG = Logger.getInstance(StringUtil.class);
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    private static final MyHtml2Text html2TextParser = new MyHtml2Text(false);
    public static final NotNullFunction<String, String> QUOTER = s -> "\"" + s + "\"";
    public static final NotNullFunction<String, String> SINGLE_QUOTER = s -> "'" + s + "'";
    @NotNull
    public static final Function<String, String> TRIMMER = StringUtil::trim;
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    private static final String[] TIME_UNITS = new String[]{"ms", "s", "m", "h", "d", "mo", "yr", "c", "ml", "ep"};
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 1000L, 60L, 60L, 24L, 30L, 12L, 100L, 10L, 10000L};
    private static final List<String> REPLACES_REFS = Arrays.asList("&lt;", "&gt;", "&amp;", "&#39;", "&quot;");
    private static final List<String> REPLACES_DISP = Arrays.asList("<", ">", "&", "'", "\"");
    private static final List<String> MN_QUOTED = Arrays.asList("&&", "__");
    private static final List<String> MN_CHARS = Arrays.asList("&", "_");
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-fA-F]{4}");

    @NotNull
    public static MergingCharSequence replaceSubSequence(@NotNull CharSequence charSeq, int start, int end, @NotNull CharSequence replacement) {
        if (charSeq == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        return new MergingCharSequence(new MergingCharSequence(new CharSequenceSubSequence(charSeq, 0, start), replacement), new CharSequenceSubSequence(charSeq, end, charSeq.length()));
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull String oldS, @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        String string2 = StringUtil.replace(text2, oldS, newS, false);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull String oldS, @NotNull String newS, boolean ignoreCase) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(18);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        if (text2.length() < oldS.length()) {
            return text2;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text2.length()) {
            int index2;
            int n = index2 = ignoreCase ? StringUtil.indexOfIgnoreCase(text2, oldS, i) : text2.indexOf(oldS, i);
            if (index2 < 0) {
                if (i == 0) {
                    return text2;
                }
                newText.append(text2, i, text2.length());
                break;
            }
            if (newText == null) {
                if (text2.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text2.length() - i);
            }
            newText.append(text2, i, index2);
            newText.append(newS);
            i = index2 + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        return StringUtil.indexOfIgnoreCase((CharSequence)where, (CharSequence)what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull CharSequence where, @NotNull CharSequence what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(26);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(27);
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ENGLISH);
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(34);
        }
        return StringUtil.getPackageName(fqName2, '.');
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName2, char separator) {
        int lastPointIdx;
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(35);
        }
        if ((lastPointIdx = fqName2.lastIndexOf(separator)) >= 0) {
            String string2 = fqName2.substring(0, lastPointIdx);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(36);
            }
            return string2;
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(37);
        }
        int count = 0;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text2.length() && text2.charAt(i + 1) == '\n') {
                ++i;
            }
            ++count;
        }
        return count;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(41);
        }
        return (len = text2.length()) > 0 && StringUtil.isLineBreak(text2.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text2, int offset2) {
        LineColumn lineColumn;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(43);
        }
        return (lineColumn = StringUtil.offsetToLineColumn(text2, offset2)) != null ? lineColumn.line : -1;
    }

    @Contract(pure=true)
    public static LineColumn offsetToLineColumn(@NotNull CharSequence text2, int offset2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(44);
        }
        int curLine = 0;
        int curLineStart = 0;
        for (int curOffset = 0; curOffset < offset2; ++curOffset) {
            if (curOffset == text2.length()) {
                return null;
            }
            char c = text2.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                curLineStart = curOffset + 1;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset < text2.length() - 1 && text2.charAt(curOffset + 1) == '\n') {
                ++curOffset;
            }
            curLineStart = curOffset + 1;
        }
        return LineColumn.of(curLine, offset2 - curLineStart);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(59);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(60);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(61);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(62);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        String hexCode = StringUtil.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append((CharSequence)hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder2 = buffer;
        if (stringBuilder2 == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        return stringBuilder2;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(74);
        }
        String string2 = StringUtilRt.unquoteString(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(75);
        }
        return string2;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(78);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String decapitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        String string2 = Introspector.decapitalize(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(89);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(90);
        }
        if (s.isEmpty()) {
            String string2 = s;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(91);
            }
            return string2;
        }
        if (s.length() == 1) {
            String string3 = StringUtil.toUpperCase(s);
            if (string3 == null) {
                StringUtil.$$$reportNull$$$0(92);
            }
            return string3;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            String string4 = s;
            if (string4 == null) {
                StringUtil.$$$reportNull$$$0(93);
            }
            return string4;
        }
        String string5 = StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string5 == null) {
            StringUtil.$$$reportNull$$$0(94);
        }
        return string5;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(95);
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string2 = s;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(96);
            }
            return string2;
        }
        return StringUtil.capitalize(s);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(97);
        }
        if (chars instanceof String || chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(98);
        }
        return StringUtil.stringHashCode(chars, from, to, 0);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(99);
        }
        int h = prefixHash;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(101);
        }
        return StringUtil.stringHashCodeInsensitive(chars, from, to, 0);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(102);
        }
        int h = prefixHash;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(103);
        }
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string2, String ... prefixes) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(107);
        }
        if (prefixes == null) {
            StringUtil.$$$reportNull$$$0(108);
        }
        int offset2 = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string2.regionMatches(offset2, prefix, 0, prefixLen)) {
                return false;
            }
            offset2 += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(109);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(110);
        }
        return StringUtil.trimEnd(s, suffix, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(111);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(112);
        }
        boolean bl = endsWith = ignoreCase ? StringUtil.endsWithIgnoreCase(s, suffix) : s.endsWith(suffix);
        if (endsWith) {
            String string2 = s.substring(0, s.length() - suffix.length());
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(113);
            }
            return string2;
        }
        String string3 = s;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(114);
        }
        return string3;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(115);
        }
        if (StringUtil.endsWithChar(s, suffix)) {
            String string2 = s.substring(0, s.length() - 1);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(116);
            }
            return string2;
        }
        String string3 = s;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(117);
        }
        return string3;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLog(@NotNull String text2, int limit) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(118);
        }
        if (limit > 5 && text2.length() > limit) {
            String string2 = text2.substring(0, limit - 5) + " ...\n";
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(119);
            }
            return string2;
        }
        String string3 = text2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(120);
        }
        return string3;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string2, char symbol2) {
        int index2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(125);
        }
        for (index2 = 0; index2 < string2.length() && string2.charAt(index2) == symbol2; ++index2) {
        }
        String string3 = string2.substring(index2);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(126);
        }
        return string3;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string2, char symbol2) {
        int index2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(133);
        }
        for (index2 = string2.length() - 1; index2 >= 0 && string2.charAt(index2) == symbol2; --index2) {
        }
        String string3 = string2.substring(0, index2 + 1);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(134);
        }
        return string3;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol2, int times) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol2);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return !StringUtil.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        String string2 = StringUtilRt.notNullize(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(146);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        String string2 = StringUtilRt.notNullize(s, defaultValue);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(148);
        }
        return string2;
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s) {
        return StringUtil.nullize(s, false);
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        boolean empty = nullizeSpaces ? StringUtil.isEmptyOrSpaces(s) : StringUtil.isEmpty(s);
        return empty ? null : s;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        return StringUtilRt.isEmptyOrSpaces(s);
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(149);
        }
        String string2 = ExceptionUtil.getThrowableText(aThrowable);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(150);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        String string2 = StringFactory.createShared(buffer);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(152);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String repeat(@NotNull String s, int count) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(153);
        }
        if (count == 0) {
            return "";
        }
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(154);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(157);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(158);
        }
        return StringUtil.split(s, separator, true);
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(161);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(162);
        }
        return StringUtil.split(s, separator, excludeSeparator, true);
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(163);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(164);
        }
        return StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index2;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(165);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(166);
        }
        if (separator.length() == 0) {
            List<CharSequence> list2 = Collections.singletonList(s);
            if (list2 == null) {
                StringUtil.$$$reportNull$$$0(167);
            }
            return list2;
        }
        ArrayList<CharSequence> result2 = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index2 = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index2 + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index2 : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result2.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result2.add(s.subSequence(pos, s.length()));
        }
        ArrayList<CharSequence> arrayList = result2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(168);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(169);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(170);
        }
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        Iterable<String> iterable = () -> new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return tokenizer.hasMoreTokens();
            }

            @Override
            public String next() {
                return tokenizer.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(171);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings2, @NotNull String separator) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(180);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(181);
        }
        return StringUtil.join(strings2, 0, strings2.length, separator);
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings2, int startIndex, int endIndex, @NotNull String separator) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(182);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(183);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result2.append(separator);
            }
            result2.append(strings2[i]);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(184);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull T[] items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(192);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(193);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(194);
        }
        return StringUtil.join(Arrays.asList(items), f, separator);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(195);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(196);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(197);
        }
        if (items.isEmpty()) {
            return "";
        }
        if (items.size() == 1) {
            return StringUtil.notNullize(f.fun(items.iterator().next()));
        }
        return StringUtil.join(items, f, separator);
    }

    @Contract(pure=true)
    public static String join(@NotNull Iterable<?> items, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(198);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(199);
        }
        StringBuilder result2 = new StringBuilder();
        for (Object item : items) {
            result2.append(item).append(separator);
        }
        if (result2.length() > 0) {
            result2.setLength(result2.length() - separator.length());
        }
        return result2.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(200);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(201);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(202);
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(items, f, separator, result2);
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(203);
        }
        return string2;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull String separator, @NotNull StringBuilder result2) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(204);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(205);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(206);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(207);
        }
        boolean isFirst = true;
        for (T item : items) {
            String string2 = f.fun(item);
            if (StringUtil.isEmpty(string2)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string2);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull Collection<String> strings2, @NotNull String separator) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(208);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(209);
        }
        if (strings2.size() <= 1) {
            return StringUtil.notNullize(ContainerUtil.getFirstItem(strings2));
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(strings2, separator, result2);
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(210);
        }
        return string2;
    }

    public static void join(@NotNull Collection<String> strings2, @NotNull String separator, @NotNull StringBuilder result2) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(211);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(212);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(213);
        }
        boolean isFirst = true;
        for (String string2 : strings2) {
            if (string2 == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string2);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(String ... strings2) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(217);
        }
        if (strings2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String string2 : strings2) {
            builder.append(string2);
        }
        String string3 = builder.toString();
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(218);
        }
        return string3;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value2, @NotNull String chars) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(230);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(231);
        }
        return chars.length() > value2.length() ? StringUtil.containsAnyChar(value2, chars, 0, value2.length()) : StringUtil.containsAnyChar(chars, value2, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value2, @NotNull String chars, int start, int end) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(232);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(233);
        }
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value2.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value2, char ch) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(234);
        }
        return value2.indexOf(ch) >= 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String strip(@NotNull String s, @NotNull CharFilter filter2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(235);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(236);
        }
        StringBuilder result2 = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter2.accept(ch)) continue;
            result2.append(ch);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(237);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(253);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(254);
        }
        if ((l1 = text2.length()) < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text2.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, int startIndex, @NotNull CharSequence prefix) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(255);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(256);
        }
        int tl = text2.length();
        if (startIndex < 0 || startIndex > tl) {
            throw new IllegalArgumentException("Index is out of bounds: " + startIndex + ", length: " + tl);
        }
        int l1 = tl - startIndex;
        int l2 = prefix.length();
        if (l1 < l2) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text2.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text2, @NotNull CharSequence suffix) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(257);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(258);
        }
        return StringUtilRt.endsWith(text2, suffix);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(275);
        }
        return StringUtil.indexOf(s, c, start, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(276);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix, int start) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(281);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(282);
        }
        return StringUtil.indexOf(sequence2, infix, start, sequence2.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix, int start, int end) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(283);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(284);
        }
        for (int i = start; i <= end - infix.length(); ++i) {
            if (!StringUtil.startsWith(sequence2, i, infix)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    @Contract(pure=true)
    public static String first(@NotNull String text2, int maxLength, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(310);
        }
        String string2 = text2.length() > maxLength ? text2.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(311);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence first(@NotNull CharSequence text2, int length, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(312);
        }
        if (text2.length() <= length) {
            CharSequence charSequence = text2;
            if (charSequence == null) {
                StringUtil.$$$reportNull$$$0(313);
            }
            return charSequence;
        }
        if (appendEllipsis) {
            String string2 = text2.subSequence(0, length) + "...";
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(314);
            }
            return string2;
        }
        CharSequence charSequence = text2.subSequence(0, length);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(315);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence last(@NotNull CharSequence text2, int length, boolean prependEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(316);
        }
        if (text2.length() <= length) {
            CharSequence charSequence = text2;
            if (charSequence == null) {
                StringUtil.$$$reportNull$$$0(317);
            }
            return charSequence;
        }
        if (prependEllipsis) {
            String string2 = "..." + text2.subSequence(text2.length() - length, text2.length());
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(318);
            }
            return string2;
        }
        CharSequence charSequence = text2.subSequence(text2.length() - length, text2.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(319);
        }
        return charSequence;
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text2) {
        return text2 == null ? null : StringUtil.escapeXmlEntities(text2);
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeXmlEntities(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(344);
        }
        return StringUtil.replace(text2, REPLACES_DISP, REPLACES_REFS);
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull List<String> from, @NotNull List<String> to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(361);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(362);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(363);
        }
        assert (from.size() == to.size());
        StringBuilder result2 = null;
        block0: for (int i = 0; i < text2.length(); ++i) {
            for (int j = 0; j < from.size(); ++j) {
                String toReplace = from.get(j);
                String replaceWith = to.get(j);
                int len = toReplace.length();
                if (len == 0 || !text2.regionMatches(i, toReplace, 0, len)) continue;
                if (result2 == null) {
                    result2 = new StringBuilder(text2.length());
                    result2.append(text2, 0, i);
                }
                result2.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            if (result2 == null) continue;
            result2.append(text2.charAt(i));
        }
        String string2 = result2 == null ? text2 : result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(364);
        }
        return string2;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(368);
        }
        return StringUtil.countChars(text2, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(369);
        }
        return StringUtil.countChars(text2, c, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int offset2, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(370);
        }
        return StringUtil.countChars(text2, c, offset2, text2.length(), stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int start, int end, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(371);
        }
        boolean forward = start <= end;
        start = forward ? Math.max(0, start) : Math.min(text2.length(), start);
        end = forward ? Math.min(text2.length(), end) : Math.max(0, end);
        int count = 0;
        int i = forward ? start : start - 1;
        while (forward == i < end) {
            if (text2.charAt(i) == c) {
                ++count;
            } else if (stopAtOtherChar) break;
            i += forward ? 1 : -1;
        }
        return count;
    }

    @Nullable
    @Contract(pure=true)
    public static String getPropertyName(@NotNull String methodName) {
        if (methodName == null) {
            StringUtil.$$$reportNull$$$0(375);
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(376);
        }
        if ((len = text2.length()) == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text2.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String getQualifiedName(@Nullable String packageName, @NotNull String className2) {
        if (className2 == null) {
            StringUtil.$$$reportNull$$$0(379);
        }
        if (packageName == null || packageName.isEmpty()) {
            String string2 = className2;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(380);
            }
            return string2;
        }
        String string3 = packageName + '.' + className2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(381);
        }
        return string3;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[._\\-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts;
            boolean left = part1.length > idx;
            String[] stringArray = parts = left ? part1 : part2;
            while (idx < parts.length) {
                String p = parts[idx];
                int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(391);
        }
        StringBuilder result2 = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result2.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result2.append("_");
            }
            result2.append(ch);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(392);
        }
        return string2;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(393);
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context2 = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context2 = StringUtil.escapeStringCharacters(context2);
            throw new AssertionError((Object)("Wrong line separators: '" + context2 + "' at offset " + slashRIndex));
        }
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal(s1, s2, true);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if (s1.charAt(index1) == s2.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringUtil.isWhiteSpace(s1.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringUtil.isWhiteSpace(s2.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringUtil.isWhiteSpace(s1.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringUtil.isWhiteSpace(s2.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return StringUtil.compare(c1, c2, ignoreCase) == 0;
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @NotNull
    @Contract(pure=true)
    public static String trimMiddle(@NotNull String text2, int maxLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(412);
        }
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, maxLength >> 1, true);
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, @NotNull String symbol2) {
        int textLength;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(413);
        }
        if (symbol2 == null) {
            StringUtil.$$$reportNull$$$0(414);
        }
        if ((textLength = text2.length()) > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol2.length();
            assert (prefixLength > 0);
            String string2 = text2.substring(0, prefixLength) + symbol2 + text2.substring(textLength - suffixLength);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(415);
            }
            return string2;
        }
        String string3 = text2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(416);
        }
        return string3;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(417);
        }
        String symbol2 = useEllipsisSymbol ? "\u2026" : "...";
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, symbol2);
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return StringUtil.charsMatch(a, b, true);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(427);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(428);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2, newSeparator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(429);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(437);
        }
        String string2 = StringUtilRt.getShortName(fqName2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(438);
        }
        return string2;
    }

    @Contract(value="null -> null; !null->!null", pure=true)
    public static String internEmptyString(String s) {
        return s == null ? null : (s.isEmpty() ? "" : s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 33: 
            case 36: 
            case 40: 
            case 52: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 175: 
            case 176: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 203: 
            case 210: 
            case 216: 
            case 218: 
            case 220: 
            case 221: 
            case 222: 
            case 224: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 324: 
            case 332: 
            case 334: 
            case 336: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 355: 
            case 364: 
            case 366: 
            case 367: 
            case 373: 
            case 378: 
            case 380: 
            case 381: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 398: 
            case 400: 
            case 402: 
            case 404: 
            case 410: 
            case 415: 
            case 416: 
            case 424: 
            case 426: 
            case 429: 
            case 432: 
            case 436: 
            case 438: 
            case 440: 
            case 450: 
            case 452: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 33: 
            case 36: 
            case 40: 
            case 52: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 175: 
            case 176: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 203: 
            case 210: 
            case 216: 
            case 218: 
            case 220: 
            case 221: 
            case 222: 
            case 224: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 324: 
            case 332: 
            case 334: 
            case 336: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 355: 
            case 364: 
            case 366: 
            case 367: 
            case 373: 
            case 378: 
            case 380: 
            case 381: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 398: 
            case 400: 
            case 402: 
            case 404: 
            case 410: 
            case 415: 
            case 416: 
            case 424: 
            case 426: 
            case 429: 
            case 432: 
            case 436: 
            case 438: 
            case 440: 
            case 450: 
            case 452: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSeq";
                break;
            }
            case 1: 
            case 250: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "find";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 33: 
            case 36: 
            case 40: 
            case 52: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 175: 
            case 176: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 203: 
            case 210: 
            case 216: 
            case 218: 
            case 220: 
            case 221: 
            case 222: 
            case 224: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 324: 
            case 332: 
            case 334: 
            case 336: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 355: 
            case 364: 
            case 366: 
            case 367: 
            case 373: 
            case 378: 
            case 380: 
            case 381: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 398: 
            case 400: 
            case 402: 
            case 404: 
            case 410: 
            case 415: 
            case 416: 
            case 424: 
            case 426: 
            case 429: 
            case 432: 
            case 436: 
            case 438: 
            case 440: 
            case 450: 
            case 452: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 84: 
            case 85: 
            case 118: 
            case 174: 
            case 177: 
            case 178: 
            case 219: 
            case 252: 
            case 253: 
            case 255: 
            case 257: 
            case 259: 
            case 287: 
            case 299: 
            case 301: 
            case 305: 
            case 307: 
            case 310: 
            case 312: 
            case 316: 
            case 320: 
            case 343: 
            case 344: 
            case 348: 
            case 349: 
            case 351: 
            case 353: 
            case 357: 
            case 358: 
            case 361: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 376: 
            case 382: 
            case 383: 
            case 385: 
            case 411: 
            case 412: 
            case 413: 
            case 417: 
            case 421: 
            case 422: 
            case 423: 
            case 425: 
            case 427: 
            case 430: 
            case 456: 
            case 457: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldS";
                break;
            }
            case 9: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newS";
                break;
            }
            case 15: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 79: 
            case 145: 
            case 444: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 408: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 21: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 28: 
            case 30: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 322: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 331: 
            case 333: 
            case 335: 
            case 338: 
            case 341: 
            case 451: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 29: 
            case 110: 
            case 112: 
            case 190: 
            case 258: 
            case 260: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 31: 
            case 138: 
            case 189: 
            case 254: 
            case 256: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 34: 
            case 35: 
            case 437: 
            case 439: 
            case 441: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 45: 
            case 261: 
            case 264: 
            case 266: 
            case 268: 
            case 271: 
            case 405: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 46: 
            case 262: 
            case 265: 
            case 267: 
            case 269: 
            case 272: 
            case 406: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 88: 
            case 90: 
            case 95: 
            case 109: 
            case 111: 
            case 115: 
            case 137: 
            case 153: 
            case 155: 
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 169: 
            case 235: 
            case 238: 
            case 241: 
            case 243: 
            case 246: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 285: 
            case 286: 
            case 289: 
            case 291: 
            case 293: 
            case 295: 
            case 297: 
            case 309: 
            case 372: 
            case 384: 
            case 386: 
            case 393: 
            case 394: 
            case 403: 
            case 407: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepositions";
                break;
            }
            case 80: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizerDelim";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 231: 
            case 233: 
            case 290: 
            case 292: 
            case 294: 
            case 296: 
            case 298: 
            case 356: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 107: 
            case 121: 
            case 123: 
            case 125: 
            case 129: 
            case 131: 
            case 133: 
            case 248: 
            case 396: 
            case 397: 
            case 399: 
            case 401: 
            case 433: 
            case 446: 
            case 453: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 127: 
            case 135: 
            case 339: 
            case 340: 
            case 354: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 141: 
            case 387: 
            case 391: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 181: 
            case 183: 
            case 194: 
            case 197: 
            case 199: 
            case 202: 
            case 206: 
            case 209: 
            case 212: 
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 180: 
            case 182: 
            case 188: 
            case 208: 
            case 211: 
            case 214: 
            case 217: 
            case 365: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 192: 
            case 195: 
            case 198: 
            case 200: 
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 193: 
            case 196: 
            case 201: 
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 207: 
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 223: 
            case 225: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 229: 
            case 230: 
            case 232: 
            case 234: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 236: 
            case 239: 
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 242: 
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 277: 
            case 279: 
            case 281: 
            case 283: 
            case 420: 
            case 443: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 278: 
            case 280: 
            case 282: 
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 288: 
            case 300: 
            case 302: 
            case 306: 
            case 308: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 325: 
            case 327: 
            case 330: 
            case 337: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 345: 
            case 346: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlString";
                break;
            }
            case 359: 
            case 362: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 360: 
            case 363: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 374: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 375: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 377: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 379: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 409: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 414: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 418: 
            case 419: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 428: 
            case 431: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 434: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 435: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 445: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 447: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallPart";
                break;
            }
            case 448: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigPart";
                break;
            }
            case 449: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstPrefix";
                break;
            }
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsInStringLongestFirst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringFunction";
                break;
            }
            case 10: 
            case 364: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreCase";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceChar";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeLineBreak";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCapitalization";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "escaper";
                break;
            }
            case 65: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringCharacters";
                break;
            }
            case 75: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWords";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 113: 
            case 114: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLog";
                break;
            }
            case 122: 
            case 124: 
            case 126: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 130: 
            case 132: 
            case 134: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExtensions";
                break;
            }
            case 146: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "repeatSymbol";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 171: 
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsIn";
                break;
            }
            case 179: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordIndicesIn";
                break;
            }
            case 184: 
            case 203: 
            case 210: 
            case 216: 
            case 218: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 187: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "surround";
                break;
            }
            case 220: 
            case 221: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesAroundValue";
                break;
            }
            case 222: 
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 227: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 237: {
                objectArray = objectArray2;
                objectArray2[1] = "strip";
                break;
            }
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 245: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatches";
                break;
            }
            case 251: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubstring";
                break;
            }
            case 263: {
                objectArray = objectArray2;
                objectArray2[1] = "commonPrefix";
                break;
            }
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuffix";
                break;
            }
            case 303: 
            case 304: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeLast";
                break;
            }
            case 311: 
            case 313: 
            case 314: 
            case 315: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 317: 
            case 318: 
            case 319: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 321: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLast";
                break;
            }
            case 324: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChars";
                break;
            }
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSlashes";
                break;
            }
            case 334: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackSlashes";
                break;
            }
            case 336: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithDoubleQuote";
                break;
            }
            case 347: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHtmlTags";
                break;
            }
            case 350: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
            case 352: 
            case 355: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 366: 
            case 367: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyStrings";
                break;
            }
            case 373: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalsOnly";
                break;
            }
            case 378: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeProperty";
                break;
            }
            case 380: 
            case 381: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 388: 
            case 389: 
            case 390: {
                objectArray = objectArray2;
                objectArray2[1] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 392: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaIdentifier";
                break;
            }
            case 395: {
                objectArray = objectArray2;
                objectArray2[1] = "tail";
                break;
            }
            case 398: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 400: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesDontTrim";
                break;
            }
            case 402: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesKeepSeparators";
                break;
            }
            case 404: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsWithOffset";
                break;
            }
            case 410: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLinks";
                break;
            }
            case 415: 
            case 416: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextWithEllipsis";
                break;
            }
            case 424: 
            case 426: 
            case 429: 
            case 432: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 436: 
            case 438: 
            case 440: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 450: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
            case 452: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWordsInStringLongestFirst";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 33: 
            case 36: 
            case 40: 
            case 52: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 175: 
            case 176: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 203: 
            case 210: 
            case 216: 
            case 218: 
            case 220: 
            case 221: 
            case 222: 
            case 224: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 324: 
            case 332: 
            case 334: 
            case 336: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 355: 
            case 364: 
            case 366: 
            case 367: 
            case 373: 
            case 378: 
            case 380: 
            case 381: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 398: 
            case 400: 
            case 402: 
            case 404: 
            case 410: 
            case 415: 
            case 416: 
            case 424: 
            case 426: 
            case 429: 
            case 432: 
            case 436: 
            case 438: 
            case 440: 
            case 450: 
            case 452: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapePattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToStringFunction";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreCase";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceChar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIgnoreCase";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreCase";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakCount";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "containsLineBreak";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "escapeLineBreak";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "endsWithLineBreak";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lineColToOffset";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineNumber";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineColumn";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromUpperCase";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromLowerCase";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "toTitleCase";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "fixCapitalization";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isPreposition";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 70: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringCharacters";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isQuoteAt";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 74: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 80: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWords";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenation";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 444: 
            case 445: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "trimLog";
                break;
            }
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
            case 129: 
            case 131: 
            case 133: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "trimExtensions";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "repeatSymbol";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 169: 
            case 170: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "getWordsIn";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getWordIndicesIn";
                break;
            }
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 188: 
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesAroundValue";
                break;
            }
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 225: 
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "formatDuration";
                break;
            }
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "containsAlphaCharacters";
                break;
            }
            case 230: 
            case 231: 
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 238: 
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 241: 
            case 242: 
            case 243: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "findMatches";
                break;
            }
            case 246: 
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 248: 
            case 249: 
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstring";
                break;
            }
            case 252: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 253: 
            case 254: 
            case 255: 
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 261: 
            case 262: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefix";
                break;
            }
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefixLength";
                break;
            }
            case 268: 
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffix";
                break;
            }
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 273: 
            case 277: 
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 274: 
            case 275: 
            case 276: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 287: 
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "indexOfSubstringEnd";
                break;
            }
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 297: 
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfAny";
                break;
            }
            case 299: 
            case 300: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 301: 
            case 302: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 305: 
            case 306: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 307: 
            case 308: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 309: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 310: 
            case 312: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 316: {
                objectArray = objectArray;
                objectArray[2] = "last";
                break;
            }
            case 320: {
                objectArray = objectArray;
                objectArray[2] = "firstLast";
                break;
            }
            case 322: 
            case 325: {
                objectArray = objectArray;
                objectArray[2] = "escapeChar";
                break;
            }
            case 323: {
                objectArray = objectArray;
                objectArray[2] = "escapeChars";
                break;
            }
            case 326: 
            case 327: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 328: 
            case 330: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlashes";
                break;
            }
            case 329: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashes";
                break;
            }
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSlashes";
                break;
            }
            case 333: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackSlashes";
                break;
            }
            case 335: 
            case 337: 
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "unescapeChar";
                break;
            }
            case 339: 
            case 340: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithDoubleQuote";
                break;
            }
            case 343: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlEntities";
                break;
            }
            case 344: {
                objectArray = objectArray;
                objectArray[2] = "escapeXmlEntities";
                break;
            }
            case 345: 
            case 346: {
                objectArray = objectArray;
                objectArray[2] = "removeHtmlTags";
                break;
            }
            case 348: {
                objectArray = objectArray;
                objectArray[2] = "escapeMnemonics";
                break;
            }
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 351: 
            case 353: 
            case 354: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 356: 
            case 357: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedBackslash";
                break;
            }
            case 365: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyStrings";
                break;
            }
            case 368: {
                objectArray = objectArray;
                objectArray[2] = "countNewLines";
                break;
            }
            case 369: 
            case 370: 
            case 371: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 372: {
                objectArray = objectArray;
                objectArray[2] = "capitalsOnly";
                break;
            }
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "joinOrNull";
                break;
            }
            case 375: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 376: {
                objectArray = objectArray;
                objectArray[2] = "isJavaIdentifier";
                break;
            }
            case 377: {
                objectArray = objectArray;
                objectArray[2] = "escapeProperty";
                break;
            }
            case 379: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 382: 
            case 383: 
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 385: 
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreCaseOccurrenceCount";
                break;
            }
            case 387: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaIdentifier";
                break;
            }
            case 393: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 394: {
                objectArray = objectArray;
                objectArray[2] = "tail";
                break;
            }
            case 396: 
            case 397: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 399: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesDontTrim";
                break;
            }
            case 401: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesKeepSeparators";
                break;
            }
            case 403: {
                objectArray = objectArray;
                objectArray[2] = "getWordsWithOffset";
                break;
            }
            case 405: 
            case 406: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 407: {
                objectArray = objectArray;
                objectArray[2] = "collapseWhiteSpace";
                break;
            }
            case 408: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreCase";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "formatLinks";
                break;
            }
            case 411: 
            case 413: 
            case 414: 
            case 417: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextWithEllipsis";
                break;
            }
            case 412: {
                objectArray = objectArray;
                objectArray[2] = "trimMiddle";
                break;
            }
            case 418: 
            case 419: {
                objectArray = objectArray;
                objectArray[2] = "shortenPathWithEllipsis";
                break;
            }
            case 420: {
                objectArray = objectArray;
                objectArray[2] = "isUpperCase";
                break;
            }
            case 421: {
                objectArray = objectArray;
                objectArray[2] = "detectSeparators";
                break;
            }
            case 422: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorAt";
                break;
            }
            case 423: 
            case 425: 
            case 427: 
            case 428: 
            case 430: 
            case 431: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 433: 
            case 434: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 435: 
            case 437: 
            case 439: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 441: 
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "isShortNameOf";
                break;
            }
            case 443: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
            case 446: 
            case 447: 
            case 448: {
                objectArray = objectArray;
                objectArray[2] = "isBetween";
                break;
            }
            case 449: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 451: {
                objectArray = objectArray;
                objectArray[2] = "parseHexString";
                break;
            }
            case 453: 
            case 454: 
            case 455: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenationOf";
                break;
            }
            case 456: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceForward";
                break;
            }
            case 457: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceBackward";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 33: 
            case 36: 
            case 40: 
            case 52: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 175: 
            case 176: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 203: 
            case 210: 
            case 216: 
            case 218: 
            case 220: 
            case 221: 
            case 222: 
            case 224: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 324: 
            case 332: 
            case 334: 
            case 336: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 355: 
            case 364: 
            case 366: 
            case 367: 
            case 373: 
            case 378: 
            case 380: 
            case 381: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 398: 
            case 400: 
            case 402: 
            case 404: 
            case 410: 
            case 415: 
            case 416: 
            case 424: 
            case 426: 
            case 429: 
            case 432: 
            case 436: 
            case 438: 
            case 440: 
            case 450: 
            case 452: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();
        private final boolean myIsSkipStyleTag;
        private boolean myIsStyleTagOpened;

        private MyHtml2Text(boolean isSkipStyleTag) {
            this.myIsSkipStyleTag = isSkipStyleTag;
        }

        @Override
        public void handleText(@NotNull char[] text2, int pos) {
            if (text2 == null) {
                MyHtml2Text.$$$reportNull$$$0(1);
            }
            if (!this.myIsStyleTagOpened) {
                this.myBuffer.append(text2);
            }
        }

        @Override
        public void handleStartTag(@NotNull HTML.Tag tag, MutableAttributeSet set, int i) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(2);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = true;
            }
            this.handleTag(tag);
        }

        @Override
        public void handleEndTag(@NotNull HTML.Tag tag, int pos) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(3);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = false;
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        private void handleTag(@NotNull HTML.Tag tag) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(4);
            }
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(SystemProperties.getLineSeparator());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleStartTag";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleEndTag";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTag";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

