/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.Demo;
import org.languagetool.rules.AbstractSimpleReplaceRule2;

public class AbstractSimpleReplaceRule2Test {
    @Test
    public void testRule() throws IOException {
        Demo lang = new Demo();
        MyCaseSensitiveRule csRule = new MyCaseSensitiveRule(JLanguageTool.getMessageBundle(), lang);
        JLanguageTool lt = new JLanguageTool((Language)lang);
        Assert.assertThat((Object)csRule.match(lt.getAnalyzedSentence("But a propos")).length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)csRule.match(lt.getAnalyzedSentence("But A propos")).length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)csRule.match(lt.getAnalyzedSentence("A propos")).length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)csRule.match(lt.getAnalyzedSentence("a propos")).length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)csRule.match(lt.getAnalyzedSentence("A Pokemon")).length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)csRule.match(lt.getAnalyzedSentence("A pokemon")).length, (Matcher)Is.is((Object)0));
        MyCaseInsensitiveRule ciRule = new MyCaseInsensitiveRule(JLanguageTool.getMessageBundle(), lang);
        Assert.assertThat((Object)ciRule.match(lt.getAnalyzedSentence("But a propos")).length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)ciRule.match(lt.getAnalyzedSentence("But A propos")).length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)ciRule.match(lt.getAnalyzedSentence("A propos")).length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)ciRule.match(lt.getAnalyzedSentence("a propos")).length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)ciRule.match(lt.getAnalyzedSentence("A Pokemon")).length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)ciRule.match(lt.getAnalyzedSentence("A pokemon")).length, (Matcher)Is.is((Object)1));
    }

    static class MyCaseInsensitiveRule
    extends MyCaseSensitiveRule {
        MyCaseInsensitiveRule(ResourceBundle messages, Language language) {
            super(messages, language);
        }

        @Override
        public boolean isCaseSensitive() {
            return false;
        }
    }

    static class MyCaseSensitiveRule
    extends AbstractSimpleReplaceRule2 {
        MyCaseSensitiveRule(ResourceBundle messages, Language language) {
            super(messages, language);
        }

        public String getFileName() {
            return "/xx/abstract_simple_replace2.txt";
        }

        public String getId() {
            return "ABSTRACT_TEST_RULE";
        }

        public String getDescription() {
            return "internal test rule";
        }

        public String getShort() {
            return "internal test rule";
        }

        public String getSuggestion() {
            return "fake suggestion";
        }

        public String getSuggestionsSeparator() {
            return ",";
        }

        public Locale getLocale() {
            return Locale.ENGLISH;
        }

        public boolean isCaseSensitive() {
            return true;
        }
    }
}

