/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;

public class CachingWordListLoader {
    private static final LoadingCache<String, List<String>> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<String>>(){

        public List<String> load(@NotNull String fileInClassPath) throws IOException {
            ArrayList<String> result = new ArrayList<String>();
            if (!JLanguageTool.getDataBroker().resourceExists(fileInClassPath)) {
                return result;
            }
            List<String> lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(fileInClassPath);
            for (String line : lines) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                result.add(StringUtils.substringBefore((String)line.trim(), (String)"#"));
            }
            return Collections.unmodifiableList(result);
        }
    });

    public List<String> loadWords(String filePath) {
        return (List)cache.getUnchecked((Object)filePath);
    }
}

