/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.transcode;

import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.Ptr;
import org.jcodings.exception.InternalException;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.transcode.Buffer;
import org.jcodings.transcode.EConvFlags;
import org.jcodings.transcode.EConvResult;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscoderDB;
import org.jcodings.transcode.Transcoding;
import org.jcodings.util.CaseInsensitiveBytesHash;

public final class EConv
implements EConvFlags {
    int flags;
    public byte[] source;
    public byte[] destination;
    boolean started = false;
    public byte[] replacementString;
    public int replacementLength;
    public byte[] replacementEncoding;
    Buffer inBuf = new Buffer();
    public EConvElement[] elements;
    public int numTranscoders;
    int numFinished;
    public Transcoding lastTranscoding;
    public final LastError lastError = new LastError();
    public Encoding sourceEncoding;
    public Encoding destinationEncoding;
    static final byte[] NULL_STRING = new byte[0];
    static final int[] NULL_POINTER = new int[0];

    public String toString() {
        return new String(this.source) + " => " + new String(this.destination);
    }

    EConv(int nHint) {
        if (nHint <= 0) {
            nHint = 1;
        }
        this.elements = new EConvElement[nHint];
        this.lastError.result = EConvResult.SourceBufferEmpty;
    }

    static boolean decorator(byte[] source2, byte[] destination) {
        return source2.length == 0;
    }

    void addTranscoderAt(Transcoder transcoder, int i2) {
        if (this.numTranscoders == this.elements.length) {
            EConvElement[] tmp = new EConvElement[this.elements.length * 2];
            System.arraycopy(this.elements, 0, tmp, 0, i2);
            System.arraycopy(this.elements, i2, tmp, i2 + 1, this.elements.length - i2);
            this.elements = tmp;
        } else {
            System.arraycopy(this.elements, i2, this.elements, i2 + 1, this.elements.length - i2 - 1);
        }
        this.elements[i2] = new EConvElement(transcoder.transcoding(0));
        this.elements[i2].allocate(4096);
        ++this.numTranscoders;
        if (!EConv.decorator(transcoder.source, transcoder.destination)) {
            for (int j = this.numTranscoders - 1; i2 <= j; --j) {
                Transcoding tc = this.elements[j].transcoding;
                Transcoder tr = tc.transcoder;
                if (EConv.decorator(tr.source, tr.destination)) continue;
                this.lastTranscoding = tc;
                break;
            }
        }
    }

    private int transSweep(byte[] in, Ptr inPtr, int inStop, byte[] out, Ptr outPtr, int outStop, int flags2, int start2) {
        boolean try_ = true;
        Ptr ipp = null;
        Ptr opp = null;
        while (try_) {
            try_ = false;
            block6: for (int i2 = start2; i2 < this.numTranscoders; ++i2) {
                EConvResult res;
                byte[] obytes;
                int os;
                byte[] ibytes;
                int is;
                EConvElement te = this.elements[i2];
                EConvElement previousTE = null;
                boolean ippIsStart = false;
                boolean oppIsEnd = false;
                if (i2 == 0) {
                    ipp = inPtr;
                    is = inStop;
                    ibytes = in;
                } else {
                    previousTE = this.elements[i2 - 1];
                    ipp = new Ptr(previousTE.dataStart);
                    ippIsStart = true;
                    is = previousTE.dataEnd;
                    ibytes = previousTE.bytes;
                }
                if (i2 == this.numTranscoders - 1) {
                    opp = outPtr;
                    os = outStop;
                    obytes = out;
                } else {
                    if (te.bufStart != te.dataStart) {
                        int len = te.dataEnd - te.dataStart;
                        int off = te.dataStart - te.bufStart;
                        System.arraycopy(te.bytes, te.dataStart, te.bytes, te.bufStart, len);
                        te.dataStart = te.bufStart;
                        te.dataEnd -= off;
                    }
                    opp = new Ptr(te.dataEnd);
                    oppIsEnd = true;
                    os = te.bufEnd;
                    obytes = te.bytes;
                }
                int f = flags2;
                if (this.numFinished != i2) {
                    f |= 0x10000;
                }
                if (i2 == 0 && (flags2 & 0x20000) != 0) {
                    start2 = 1;
                    flags2 &= 0xFFFDFFFF;
                }
                if (i2 != 0) {
                    f &= 0xFFFDFFFF;
                }
                int iold = ipp.p;
                int oold = opp.p;
                te.lastResult = res = te.transcoding.convert(ibytes, ipp, is, obytes, opp, os, f);
                if (ippIsStart) {
                    previousTE.dataStart = ipp.p;
                }
                if (oppIsEnd) {
                    te.dataEnd = opp.p;
                }
                if (iold != ipp.p || oold != opp.p) {
                    try_ = true;
                }
                switch (res) {
                    case InvalidByteSequence: 
                    case IncompleteInput: 
                    case UndefinedConversion: 
                    case AfterOutput: {
                        return i2;
                    }
                    case DestinationBufferFull: 
                    case SourceBufferEmpty: {
                        continue block6;
                    }
                    case Finished: {
                        this.numFinished = i2 + 1;
                    }
                }
            }
        }
        return -1;
    }

    private EConvResult transConv(byte[] in, Ptr inPtr, int inStop, byte[] out, Ptr outPtr, int outStop, int flags2, Ptr resultPositionPtr) {
        if (this.elements[0].lastResult == EConvResult.AfterOutput) {
            this.elements[0].lastResult = EConvResult.SourceBufferEmpty;
        }
        block4: for (int i2 = this.numTranscoders - 1; 0 <= i2; --i2) {
            switch (this.elements[i2].lastResult) {
                case InvalidByteSequence: 
                case IncompleteInput: 
                case UndefinedConversion: 
                case AfterOutput: 
                case Finished: {
                    return this.transConvNeedReport(in, inPtr, inStop, out, outPtr, outStop, flags2, resultPositionPtr, i2 + 1, i2);
                }
                case DestinationBufferFull: 
                case SourceBufferEmpty: {
                    continue block4;
                }
                default: {
                    throw new InternalException("unexpected transcode last result");
                }
            }
        }
        if (this.elements[this.numTranscoders - 1].lastResult == EConvResult.DestinationBufferFull && (flags2 & 0x20000) != 0) {
            EConvResult res = this.transConv(NULL_STRING, Ptr.NULL, 0, out, outPtr, outStop, flags2 & 0xFFFDFFFF | 0x10000, resultPositionPtr);
            return res.isSourceBufferEmpty() ? EConvResult.AfterOutput : res;
        }
        return this.transConvNeedReport(in, inPtr, inStop, out, outPtr, outStop, flags2, resultPositionPtr, 0, -1);
    }

    private EConvResult transConvNeedReport(byte[] in, Ptr inPtr, int inStop, byte[] out, Ptr outPtr, int outStop, int flags2, Ptr resultPositionPtr, int sweepStart, int needReportIndex) {
        do {
            needReportIndex = this.transSweep(in, inPtr, inStop, out, outPtr, outStop, flags2, sweepStart);
            sweepStart = needReportIndex + 1;
        } while (needReportIndex != -1 && needReportIndex != this.numTranscoders - 1);
        for (int i2 = this.numTranscoders - 1; i2 >= 0; --i2) {
            if (this.elements[i2].lastResult == EConvResult.SourceBufferEmpty) continue;
            EConvResult res = this.elements[i2].lastResult;
            switch (res) {
                case InvalidByteSequence: 
                case IncompleteInput: 
                case UndefinedConversion: 
                case AfterOutput: {
                    this.elements[i2].lastResult = EConvResult.SourceBufferEmpty;
                }
            }
            if (resultPositionPtr != null) {
                resultPositionPtr.p = i2;
            }
            return res;
        }
        if (resultPositionPtr != null) {
            resultPositionPtr.p = -1;
        }
        return EConvResult.SourceBufferEmpty;
    }

    private EConvResult convertInternal(byte[] in, Ptr inPtr, int inStop, byte[] out, Ptr outPtr, int outStop, int flags2) {
        EConvResult res;
        this.lastError.reset();
        if (this.numTranscoders == 0) {
            int len;
            if (this.inBuf.bytes != null && this.inBuf.dataStart != this.inBuf.dataEnd) {
                if (outStop - outPtr.p < this.inBuf.dataEnd - this.inBuf.dataStart) {
                    int len2 = outStop - outPtr.p;
                    System.arraycopy(this.inBuf.bytes, this.inBuf.dataStart, out, outPtr.p, len2);
                    outPtr.p = outStop;
                    this.inBuf.dataStart += len2;
                    return this.convertInternalResult(EConvResult.DestinationBufferFull, null);
                }
                len = this.inBuf.dataEnd - this.inBuf.dataStart;
                System.arraycopy(this.inBuf.bytes, this.inBuf.dataStart, out, outPtr.p, len);
                outPtr.p += len;
                this.inBuf.dataStart = this.inBuf.dataEnd = this.inBuf.bufStart;
                if ((flags2 & 0x20000) != 0) {
                    return this.convertInternalResult(EConvResult.AfterOutput, null);
                }
            }
            if ((len = outStop - outPtr.p < inStop - inPtr.p ? outStop - outPtr.p : inStop - inPtr.p) > 0 && (flags2 & 0x20000) != 0) {
                out[outPtr.p++] = in[inPtr.p++];
                return this.convertInternalResult(EConvResult.AfterOutput, null);
            }
            System.arraycopy(in, inPtr.p, out, outPtr.p, len);
            outPtr.p += len;
            inPtr.p += len;
            EConvResult res2 = inPtr.p != inStop ? EConvResult.DestinationBufferFull : ((flags2 & 0x10000) != 0 ? EConvResult.SourceBufferEmpty : EConvResult.Finished);
            return this.convertInternalResult(res2, null);
        }
        boolean hasOutput = false;
        EConvElement elem = this.elements[this.numTranscoders - 1];
        if (elem.bytes != null) {
            int dataStart = elem.dataStart;
            int dataEnd = elem.dataEnd;
            byte[] data2 = elem.bytes;
            if (dataStart != dataEnd) {
                if (outStop - outPtr.p < dataEnd - dataStart) {
                    int len = outStop - outPtr.p;
                    System.arraycopy(data2, dataStart, out, outPtr.p, len);
                    outPtr.p = outStop;
                    elem.dataStart += len;
                    return this.convertInternalResult(EConvResult.DestinationBufferFull, null);
                }
                int len = dataEnd - dataStart;
                System.arraycopy(data2, dataStart, out, outPtr.p, len);
                outPtr.p += len;
                elem.dataStart = elem.dataEnd = elem.bufStart;
                hasOutput = true;
            }
        }
        Ptr resultPosition = new Ptr(0);
        if (this.inBuf != null && this.inBuf.dataStart != this.inBuf.dataEnd) {
            Ptr inDataStartPtr = new Ptr(this.inBuf.dataStart);
            res = this.transConv(this.inBuf.bytes, inDataStartPtr, this.inBuf.dataEnd, out, outPtr, outStop, flags2 & 0xFFFDFFFF | 0x10000, resultPosition);
            this.inBuf.dataStart = inDataStartPtr.p;
            if (!res.isSourceBufferEmpty()) {
                return this.convertInternalResult(EConvResult.SourceBufferEmpty, resultPosition);
            }
        }
        if (hasOutput && (flags2 & 0x20000) != 0 && inPtr.p != inStop) {
            inStop = inPtr.p;
            res = this.transConv(in, inPtr, inStop, out, outPtr, outStop, flags2, resultPosition);
            if (res.isSourceBufferEmpty()) {
                res = EConvResult.AfterOutput;
            }
        } else if ((flags2 & 0x20000) != 0 || this.numTranscoders == 1) {
            res = this.transConv(in, inPtr, inStop, out, outPtr, outStop, flags2, resultPosition);
        } else {
            flags2 |= 0x20000;
            while ((res = this.transConv(in, inPtr, inStop, out, outPtr, outStop, flags2, resultPosition)).isAfterOutput()) {
            }
        }
        return this.convertInternalResult(res, resultPosition);
    }

    private EConvResult convertInternalResult(EConvResult res, Ptr resultPosition) {
        this.lastError.result = res;
        switch (res) {
            case InvalidByteSequence: 
            case IncompleteInput: 
            case UndefinedConversion: {
                Transcoding errorTranscoding;
                this.lastError.errorTranscoding = errorTranscoding = this.elements[resultPosition.p].transcoding;
                this.lastError.source = errorTranscoding.transcoder.source;
                this.lastError.destination = errorTranscoding.transcoder.destination;
                this.lastError.errorBytes = errorTranscoding.readBuf;
                this.lastError.errorBytesP = 0;
                this.lastError.errorBytesLength = errorTranscoding.recognizedLength;
                this.lastError.readAgainLength = errorTranscoding.readAgainLength;
            }
        }
        return res;
    }

    public EConvResult convert(byte[] in, Ptr inPtr, int inStop, byte[] out, Ptr outPtr, int outStop, int flags2) {
        EConvResult ret;
        this.started = true;
        if (in == null || inPtr == null) {
            in = NULL_STRING;
            inPtr = Ptr.NULL;
            inStop = 0;
        }
        if (out == null || outPtr == null) {
            out = NULL_STRING;
            outPtr = Ptr.NULL;
            outStop = 0;
        }
        block7: while (true) {
            if ((ret = this.convertInternal(in, inPtr, inStop, out, outPtr, outStop, flags2)).isInvalidByteSequence() || ret.isIncompleteInput()) {
                switch (this.flags & 0xF) {
                    case 2: {
                        if (this.outputReplacementCharacter() != 0) break;
                        continue block7;
                    }
                }
            }
            if (!ret.isUndefinedConversion()) break;
            switch (this.flags & 0xF0) {
                case 32: {
                    if (this.outputReplacementCharacter() != 0) break block7;
                    continue block7;
                }
                case 48: {
                    if (this.outputHexCharref() != 0) break block7;
                    continue block7;
                }
            }
            break;
        }
        return ret;
    }

    private int outputHexCharref() {
        int utfLen;
        int utfP;
        byte[] utfBytes;
        if (CaseInsensitiveBytesHash.caseInsensitiveEquals(this.lastError.source, "UTF-32BE".getBytes())) {
            utfBytes = this.lastError.errorBytes;
            utfP = this.lastError.errorBytesP;
            utfLen = this.lastError.errorBytesLength;
        } else {
            Ptr utfLenA = new Ptr();
            byte[] utfBuf = new byte[this.lastError.errorBytesLength * UTF32BEEncoding.INSTANCE.maxLength()];
            utfBytes = EConv.allocateConvertedString(this.lastError.source, "UTF-32BE".getBytes(), this.lastError.errorBytes, this.lastError.errorBytesP, this.lastError.errorBytesLength, utfBuf, utfLenA);
            if (utfBytes == null) {
                return -1;
            }
            utfP = 0;
            utfLen = utfLenA.p;
        }
        if (utfLen % 4 != 0) {
            return -1;
        }
        int p2 = utfP;
        while (4 <= utfLen) {
            int u = 0;
            u += (utfBytes[p2] & 0xFF) << 24;
            u += (utfBytes[p2 + 1] & 0xFF) << 16;
            u += (utfBytes[p2 + 2] & 0xFF) << 8;
            byte[] charrefbuf = String.format("&#x%X;", u += utfBytes[p2 + 3] & 0xFF).getBytes();
            if (this.insertOutput(charrefbuf, 0, charrefbuf.length, "US-ASCII".getBytes()) == -1) {
                return -1;
            }
            p2 += 4;
            utfLen -= 4;
        }
        return 0;
    }

    public byte[] encodingToInsertOutput() {
        Transcoding transcoding = this.lastTranscoding;
        if (transcoding == null) {
            return NULL_STRING;
        }
        Transcoder transcoder = transcoding.transcoder;
        return transcoder.compatibility.isEncoder() ? transcoder.source : transcoder.destination;
    }

    private static byte[] allocateConvertedString(byte[] source2, byte[] destination, byte[] str, int strP, int strLen, byte[] callerDstBuf, Ptr dstLenPtr) {
        int dstBufSize = callerDstBuf != null ? callerDstBuf.length : (strLen == 0 ? 1 : strLen);
        EConv ec = TranscoderDB.open(source2, destination, 0);
        if (ec == null) {
            return null;
        }
        byte[] dstStr = callerDstBuf != null ? callerDstBuf : new byte[dstBufSize];
        int dstLen = 0;
        Ptr sp = new Ptr(strP);
        Ptr dp = new Ptr(dstLen);
        EConvResult res = ec.convert(str, sp, strP + strLen, dstStr, dp, dstBufSize, 0);
        dstLen = dp.p;
        while (res.isDestinationBufferFull()) {
            byte[] tmp = new byte[dstBufSize *= 2];
            System.arraycopy(dstStr, 0, tmp, 0, dstBufSize / 2);
            dstStr = tmp;
            dp.p = dstLen;
            res = ec.convert(str, sp, strP + strLen, dstStr, dp, dstBufSize, 0);
            dstLen = dp.p;
        }
        if (!res.isFinished()) {
            return null;
        }
        ec.close();
        dstLenPtr.p = dstLen;
        return dstStr;
    }

    public int insertOutput(byte[] str, int strP, int strLen, byte[] strEncoding) {
        Buffer buf;
        Transcoding transcoding;
        int insertLen;
        int insertP;
        byte[] insertStr;
        byte[] insertEncoding = this.encodingToInsertOutput();
        byte[] insertBuf = null;
        this.started = true;
        if (strLen == 0) {
            return 0;
        }
        if (CaseInsensitiveBytesHash.caseInsensitiveEquals(insertEncoding, strEncoding)) {
            insertStr = str;
            insertP = 0;
            insertLen = strLen;
        } else {
            Ptr insertLenP = new Ptr();
            insertBuf = new byte[4096];
            insertStr = EConv.allocateConvertedString(strEncoding, insertEncoding, str, strP, strLen, insertBuf, insertLenP);
            insertLen = insertLenP.p;
            int n = insertP = insertStr == str ? strP : 0;
            if (insertStr == null) {
                return -1;
            }
        }
        int need = insertLen;
        int lastTranscodingIndex = this.numTranscoders - 1;
        if (this.numTranscoders == 0) {
            transcoding = null;
            buf = this.inBuf;
        } else if (this.elements[lastTranscodingIndex].transcoding.transcoder.compatibility.isEncoder()) {
            transcoding = this.elements[lastTranscodingIndex].transcoding;
            if ((need += transcoding.readAgainLength) < insertLen) {
                return -1;
            }
            buf = lastTranscodingIndex == 0 ? this.inBuf : this.elements[lastTranscodingIndex - 1];
        } else {
            transcoding = this.elements[lastTranscodingIndex].transcoding;
            buf = this.elements[lastTranscodingIndex];
        }
        if (buf == null) {
            buf = new Buffer();
            buf.allocate(need);
        } else if (buf.bytes == null) {
            buf.allocate(need);
        } else if (buf.bufEnd - buf.dataEnd < need) {
            System.arraycopy(buf.bytes, buf.dataStart, buf.bytes, buf.bufStart, buf.dataEnd - buf.dataStart);
            buf.dataEnd = buf.bufStart + (buf.dataEnd - buf.dataStart);
            buf.dataStart = buf.bufStart;
            if (buf.bufEnd - buf.dataEnd < need) {
                int s2 = buf.dataEnd - buf.bufStart + need;
                if (s2 < need) {
                    return -1;
                }
                Buffer buf2 = buf = new Buffer();
                buf2.allocate(s2);
                System.arraycopy(buf.bytes, buf.bufStart, buf2.bytes, 0, s2);
                buf2.dataStart = 0;
                buf2.dataEnd = buf.dataEnd - buf.bufStart;
            }
        }
        System.arraycopy(insertStr, insertP, buf.bytes, buf.dataEnd, insertLen);
        buf.dataEnd += insertLen;
        if (transcoding != null && transcoding.transcoder.compatibility.isEncoder()) {
            System.arraycopy(transcoding.readBuf, transcoding.recognizedLength, buf.bytes, buf.dataEnd, transcoding.readAgainLength);
            buf.dataEnd += transcoding.readAgainLength;
            transcoding.readAgainLength = 0;
        }
        return 0;
    }

    public void close() {
        for (int i2 = 0; i2 < this.numTranscoders; ++i2) {
            this.elements[i2].transcoding.close();
        }
    }

    public int putbackable() {
        return this.numTranscoders == 0 ? 0 : this.elements[0].transcoding.readAgainLength;
    }

    public void putback(byte[] bytes2, int p2, int n) {
        if (this.numTranscoders == 0 || n == 0) {
            return;
        }
        Transcoding transcoding = this.elements[0].transcoding;
        System.arraycopy(transcoding.readBuf, transcoding.recognizedLength + transcoding.readAgainLength - n, bytes2, p2, n);
        transcoding.readAgainLength -= n;
    }

    public boolean addConverter(byte[] source2, byte[] destination, int n) {
        if (this.started) {
            return false;
        }
        TranscoderDB.Entry entry = TranscoderDB.getEntry(source2, destination);
        if (entry == null) {
            return false;
        }
        Transcoder transcoder = entry.getTranscoder();
        if (transcoder == null) {
            return false;
        }
        this.addTranscoderAt(transcoder, n);
        return true;
    }

    boolean decorateAt(byte[] decorator, int n) {
        return this.addConverter(NULL_STRING, decorator, n);
    }

    boolean decorateAtFirst(byte[] decorator) {
        if (this.numTranscoders == 0) {
            return this.decorateAt(decorator, 0);
        }
        Transcoder transcoder = this.elements[0].transcoding.transcoder;
        if (!EConv.decorator(transcoder.source, transcoder.destination) && transcoder.compatibility.isDecoder()) {
            return this.decorateAt(decorator, 1);
        }
        return this.decorateAt(decorator, 0);
    }

    boolean decorateAtLast(byte[] decorator) {
        if (this.numTranscoders == 0) {
            return this.decorateAt(decorator, 0);
        }
        Transcoder transcoder = this.elements[this.numTranscoders - 1].transcoding.transcoder;
        if (!EConv.decorator(transcoder.source, transcoder.destination) && transcoder.compatibility.isEncoder()) {
            return this.decorateAt(decorator, this.numTranscoders - 1);
        }
        return this.decorateAt(decorator, this.numTranscoders);
    }

    public void binmode() {
        TranscoderDB.Entry entry;
        Transcoder[] transcoders = new Transcoder[3];
        int n = 0;
        if ((this.flags & 0x100) != 0 && (entry = TranscoderDB.getEntry(NULL_STRING, "universal_newline".getBytes())).getTranscoder() != null) {
            transcoders[n++] = entry.getTranscoder();
        }
        if ((this.flags & 0x1000) != 0 && (entry = TranscoderDB.getEntry(NULL_STRING, "crlf_newline".getBytes())).getTranscoder() != null) {
            transcoders[n++] = entry.getTranscoder();
        }
        if ((this.flags & 0x2000) != 0 && (entry = TranscoderDB.getEntry(NULL_STRING, "cr_newline".getBytes())).getTranscoder() != null) {
            transcoders[n++] = entry.getTranscoder();
        }
        int nTrans = this.numTranscoders;
        int j = 0;
        for (int i2 = 0; i2 < nTrans; ++i2) {
            int k;
            for (k = 0; k < n && transcoders[k] != this.elements[i2].transcoding.transcoder; ++k) {
            }
            if (k == n) {
                this.elements[j] = this.elements[i2];
                ++j;
                continue;
            }
            this.elements[i2].transcoding.close();
            --this.numTranscoders;
        }
        this.flags &= 0xFFFFC0FF;
    }

    public int makeReplacement() {
        byte[] replacement2;
        byte[] replEnc;
        int len;
        if (this.replacementString != null) {
            return 0;
        }
        byte[] insEnc = this.encodingToInsertOutput();
        if (insEnc.length != 0) {
            if (CaseInsensitiveBytesHash.caseInsensitiveEquals(insEnc, "UTF-8".getBytes())) {
                len = 3;
                replEnc = "UTF-8".getBytes();
                replacement2 = new byte[]{-17, -65, -67};
            } else {
                len = 1;
                replEnc = "US-ASCII".getBytes();
                replacement2 = new byte[]{63};
            }
        } else {
            len = 1;
            replEnc = NULL_STRING;
            replacement2 = new byte[]{63};
        }
        this.replacementString = replacement2;
        this.replacementLength = len;
        this.replacementEncoding = replEnc;
        return 0;
    }

    public int setReplacement(byte[] str, int p2, int len, byte[] encname) {
        int len2;
        byte[] str2;
        byte[] encname2 = this.encodingToInsertOutput();
        boolean p22 = false;
        if (encname2.length == 0 || CaseInsensitiveBytesHash.caseInsensitiveEquals(encname, encname2)) {
            str2 = new byte[len];
            System.arraycopy(str, p2, str2, 0, len);
            len2 = len;
            encname2 = encname;
        } else {
            Ptr len2p = new Ptr();
            str2 = EConv.allocateConvertedString(encname, encname2, str, p2, len, null, len2p);
            if (str2 == null) {
                return -1;
            }
            len2 = len2p.p;
        }
        this.replacementString = str2;
        this.replacementLength = len2;
        this.replacementEncoding = encname2;
        return 0;
    }

    int outputReplacementCharacter() {
        if (this.makeReplacement() == -1) {
            return -1;
        }
        if (this.insertOutput(this.replacementString, 0, this.replacementLength, this.replacementEncoding) == -1) {
            return -1;
        }
        return 0;
    }

    public String toStringFull() {
        String s2 = "EConv " + new String(this.source) + " => " + new String(this.destination) + "\n";
        s2 = s2 + "  started: " + this.started + "\n";
        s2 = s2 + "  replacement string: " + (this.replacementString == null ? "null" : new String(this.replacementString, 0, this.replacementLength)) + "\n";
        s2 = s2 + "  replacement encoding: " + (this.replacementEncoding == null ? "null" : new String(this.replacementEncoding)) + "\n";
        s2 = s2 + "\n";
        for (int i2 = 0; i2 < this.numTranscoders; ++i2) {
            s2 = s2 + "  element " + i2 + ": " + this.elements[i2].toString() + "\n";
        }
        s2 = s2 + "\n";
        s2 = s2 + "  lastTranscoding: " + this.lastTranscoding + "\n";
        s2 = s2 + "  last error: " + (this.lastError == null ? "null" : this.lastError.toString());
        return s2;
    }

    public boolean equals(Object other) {
        if (!(other instanceof EConv)) {
            return false;
        }
        EConv ec1 = this;
        EConv ec2 = (EConv)other;
        if (ec2 == null) {
            return false;
        }
        if (ec1.source != ec2.source && !Arrays.equals(ec1.source, ec2.source)) {
            return false;
        }
        if (ec1.destination != ec2.destination && !Arrays.equals(ec1.destination, ec2.destination)) {
            return false;
        }
        if (ec1.flags != ec2.flags) {
            return false;
        }
        if (ec1.replacementEncoding != ec2.replacementEncoding && !Arrays.equals(ec1.replacementEncoding, ec2.replacementEncoding)) {
            return false;
        }
        if (ec1.replacementLength != ec2.replacementLength) {
            return false;
        }
        if (ec1.replacementString != ec2.replacementString && !EConv.memcmp(ec1.replacementString, ec2.replacementString, ec2.replacementLength)) {
            return false;
        }
        if (ec1.numTranscoders != ec2.numTranscoders) {
            return false;
        }
        for (int i2 = 0; i2 < ec1.numTranscoders; ++i2) {
            if (ec1.elements[i2].transcoding.transcoder == ec2.elements[i2].transcoding.transcoder) continue;
            return false;
        }
        return true;
    }

    private static boolean memcmp(byte[] a, byte[] b2, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            if (a[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    public static final class LastError {
        EConvResult result;
        Transcoding errorTranscoding;
        byte[] source;
        byte[] destination;
        byte[] errorBytes;
        int errorBytesP;
        int errorBytesLength;
        int readAgainLength;

        void reset() {
            this.result = null;
            this.errorTranscoding = null;
            this.destination = null;
            this.source = null;
            this.errorBytes = null;
            this.errorBytesLength = 0;
            this.errorBytesP = 0;
            this.readAgainLength = 0;
        }

        public EConvResult getResult() {
            return this.result;
        }

        public Transcoding getErrorTranscoding() {
            return this.errorTranscoding;
        }

        public byte[] getSource() {
            return this.source;
        }

        public byte[] getDestination() {
            return this.destination;
        }

        public byte[] getErrorBytes() {
            return this.errorBytes;
        }

        public int getErrorBytesP() {
            return this.errorBytesP;
        }

        public int getErrorBytesLength() {
            return this.errorBytesLength;
        }

        public int getReadAgainLength() {
            return this.readAgainLength;
        }

        public String toString() {
            String s2 = "Last Error " + (this.source == null ? "null" : new String(this.source)) + " => " + (this.destination == null ? "null" : new String(this.destination)) + "\n";
            s2 = s2 + "  result: " + this.result.toString() + "\n";
            s2 = s2 + "  error bytes: " + (this.errorBytes == null ? "null" : new String(this.errorBytes, this.errorBytesP, this.errorBytesP + this.errorBytesLength)) + "\n";
            s2 = s2 + "  read again length: " + this.readAgainLength;
            return s2;
        }
    }

    public static final class EConvElement
    extends Buffer {
        public final Transcoding transcoding;
        EConvResult lastResult;

        EConvElement(Transcoding transcoding) {
            this.transcoding = transcoding;
            this.lastResult = EConvResult.SourceBufferEmpty;
        }

        public String toString() {
            String s2 = "EConv " + this.transcoding.toString() + "\n";
            s2 = s2 + "  last result: " + (Object)((Object)this.lastResult);
            return s2;
        }
    }
}

