/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.tree;

import java.awt.Component;
import javax.swing.JTree;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;

public class OWLObjectTreeCellRenderer
extends OWLCellRenderer {
    public OWLObjectTreeCellRenderer(OWLEditorKit owlEditorKit) {
        super(owlEditorKit);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object renderedValue;
        this.clearRelationship();
        this.setRelationshipsDisplayed(false);
        if (value instanceof OWLObjectTreeNode) {
            OWLObjectTreeNode node = (OWLObjectTreeNode)value;
            this.setEquivalentObjects(node.getEquivalentObjects());
            Object owlObject = node.getOWLObject();
            renderedValue = owlObject;
            boolean displayRelationships = false;
            if (tree instanceof OWLModelManagerTree) {
                displayRelationships = !((OWLModelManagerTree)tree).getProvider().getDisplayedRelationships().isEmpty();
            }
            this.setRelationshipsDisplayed(displayRelationships && owlObject != null && !owlObject.isTopEntity());
            node.getRelationship().ifPresent(this::setRelationship);
        } else {
            renderedValue = value;
        }
        return super.getTreeCellRendererComponent(tree, renderedValue, selected, expanded, leaf, row, hasFocus);
    }
}

