/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.PushWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.export.BoolFieldWriter;
import org.apache.solr.handler.export.DateFieldWriter;
import org.apache.solr.handler.export.DoubleComp;
import org.apache.solr.handler.export.DoubleFieldWriter;
import org.apache.solr.handler.export.DoubleValue;
import org.apache.solr.handler.export.DoubleValueSortDoc;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.FloatComp;
import org.apache.solr.handler.export.FloatFieldWriter;
import org.apache.solr.handler.export.FloatValue;
import org.apache.solr.handler.export.IntComp;
import org.apache.solr.handler.export.IntFieldWriter;
import org.apache.solr.handler.export.IntValue;
import org.apache.solr.handler.export.LongComp;
import org.apache.solr.handler.export.LongFieldWriter;
import org.apache.solr.handler.export.LongValue;
import org.apache.solr.handler.export.MultiFieldWriter;
import org.apache.solr.handler.export.QuadValueSortDoc;
import org.apache.solr.handler.export.SingleValueSortDoc;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortQueue;
import org.apache.solr.handler.export.SortValue;
import org.apache.solr.handler.export.StringFieldWriter;
import org.apache.solr.handler.export.StringValue;
import org.apache.solr.handler.export.TripleValueSortDoc;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DateValueFieldType;
import org.apache.solr.schema.DoubleValueFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatValueFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IntValueFieldType;
import org.apache.solr.schema.LongValueFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableTextField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportWriter
implements SolrCore.RawWriter,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DOCUMENT_BATCH_SIZE = 30000;
    private static final String EXPORT_WRITER_KEY = "__ew__";
    private static final String SORT_DOCS_KEY = "_ew_docs_";
    private static final String TOTAL_HITS_KEY = "_ew_totalHits_";
    private static final String LEAF_READERS_KEY = "_ew_leaves_";
    private static final String SORT_QUEUE_KEY = "_ew_queue_";
    private static final String SORT_DOC_KEY = "_ew_sort_";
    private OutputStreamWriter respWriter;
    final SolrQueryRequest req;
    final SolrQueryResponse res;
    final StreamContext initialStreamContext;
    StreamExpression streamExpression;
    StreamContext streamContext;
    FieldWriter[] fieldWriters;
    int totalHits = 0;
    FixedBitSet[] sets = null;
    PushWriter writer;
    private String wt;

    public ExportWriter(SolrQueryRequest req, SolrQueryResponse res, String wt, StreamContext initialStreamContext) {
        this.req = req;
        this.res = res;
        this.wt = wt;
        this.initialStreamContext = initialStreamContext;
    }

    @Override
    public String getContentType() {
        if ("javabin".equals(this.wt)) {
            return "application/octet-stream";
        }
        return "json";
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.respWriter != null) {
            this.respWriter.flush();
            this.respWriter.close();
        }
    }

    protected void writeException(Exception e, PushWriter w, boolean logException) throws IOException {
        w.writeMap(mw -> mw.put((CharSequence)"responseHeader", Collections.singletonMap("status", 400)).put((CharSequence)"response", (Object)Utils.makeMap((Object[])new Object[]{"numFound", 0, "docs", Collections.singletonList(Collections.singletonMap("EXCEPTION", e.getMessage()))})));
        if (logException) {
            SolrException.log((Logger)log, (Throwable)e);
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        QueryResponseWriter rw = this.req.getCore().getResponseWriters().get(this.wt);
        if (rw instanceof BinaryResponseWriter) {
            this.writer = new JavaBinCodec(os, null);
        } else {
            this.respWriter = new OutputStreamWriter(os, StandardCharsets.UTF_8);
            this.writer = JSONResponseWriter.getPushWriter(this.respWriter, this.req, this.res);
        }
        Exception exception = this.res.getException();
        if (exception != null) {
            if (!(exception instanceof IgnoreException)) {
                this.writeException(exception, this.writer, false);
            }
            return;
        }
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        SortSpec sortSpec = info.getResponseBuilder().getSortSpec();
        if (sortSpec == null) {
            this.writeException(new IOException(new SyntaxError("No sort criteria was provided.")), this.writer, true);
            return;
        }
        SolrIndexSearcher searcher = this.req.getSearcher();
        Sort sort = searcher.weightSort(sortSpec.getSort());
        if (sort == null) {
            this.writeException(new IOException(new SyntaxError("No sort criteria was provided.")), this.writer, true);
            return;
        }
        if (sort != null && sort.needsScores()) {
            this.writeException(new IOException(new SyntaxError("Scoring is not currently supported with xsort.")), this.writer, true);
            return;
        }
        if (this.req.getContext().get("totalHits") != null) {
            this.totalHits = (Integer)this.req.getContext().get("totalHits");
            this.sets = (FixedBitSet[])this.req.getContext().get("export");
            if (this.sets == null) {
                this.writeException(new IOException(new SyntaxError("xport RankQuery is required for xsort: rq={!xport}")), this.writer, true);
                return;
            }
        }
        SolrParams params = this.req.getParams();
        String fl = params.get("fl");
        String[] fields = null;
        if (fl == null) {
            this.writeException(new IOException(new SyntaxError("export field list (fl) must be specified.")), this.writer, true);
            return;
        }
        fields = fl.split(",");
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fields[i].trim();
            if (!fields[i].equals("score")) continue;
            this.writeException(new IOException(new SyntaxError("Scoring is not currently supported with xsort.")), this.writer, true);
            return;
        }
        try {
            this.fieldWriters = this.getFieldWriters(fields, this.req.getSearcher());
        }
        catch (Exception e) {
            this.writeException(e, this.writer, true);
            return;
        }
        String expr = params.get("expr");
        if (expr != null) {
            StreamFactory streamFactory = this.initialStreamContext.getStreamFactory();
            streamFactory.withDefaultSort(params.get("sort"));
            try {
                StreamExpression expression = StreamExpressionParser.parse((String)expr);
                if (streamFactory.isEvaluator(expression)) {
                    this.streamExpression = new StreamExpression("tuple");
                    this.streamExpression.addParameter((StreamExpressionParameter)new StreamExpressionNamedParameter("return-value", (StreamExpressionParameter)expression));
                } else {
                    this.streamExpression = expression;
                }
            }
            catch (Exception e) {
                this.writeException(e, this.writer, true);
                return;
            }
            this.streamContext = new StreamContext();
            this.streamContext.setRequestParams(params);
            this.streamContext.workerID = 0;
            this.streamContext.numWorkers = 1;
            this.streamContext.setSolrClientCache(this.initialStreamContext.getSolrClientCache());
            this.streamContext.setModelCache(this.initialStreamContext.getModelCache());
            this.streamContext.setObjectCache(this.initialStreamContext.getObjectCache());
            this.streamContext.put((Object)"core", (Object)this.req.getCore().getName());
            this.streamContext.put((Object)"solr-core", (Object)this.req.getCore());
            this.streamContext.put((Object)"sort", (Object)params.get("sort"));
        }
        this.writer.writeMap(m -> {
            m.put((CharSequence)"responseHeader", Collections.singletonMap("status", 0));
            m.put((CharSequence)"response", mw -> {
                mw.put((CharSequence)"numFound", this.totalHits);
                mw.put((CharSequence)"docs", iw -> this.writeDocs(this.req, iw, sort));
            });
        });
        if (this.streamContext != null) {
            this.streamContext = null;
        }
    }

    private TupleStream createTupleStream() throws IOException {
        StreamFactory streamFactory = (StreamFactory)this.initialStreamContext.getStreamFactory().clone();
        streamFactory.withDefaultSort((String)this.streamContext.get((Object)"sort"));
        TupleStream tupleStream = streamFactory.constructStream(this.streamExpression);
        tupleStream.setStreamContext(this.streamContext);
        return tupleStream;
    }

    protected void identifyLowestSortingUnexportedDocs(List<LeafReaderContext> leaves, SortDoc sortDoc, SortQueue queue) throws IOException {
        queue.reset();
        SortDoc top = (SortDoc)queue.top();
        for (int i = 0; i < leaves.size(); ++i) {
            int docId;
            sortDoc.setNextReader(leaves.get(i));
            BitSetIterator it = new BitSetIterator((BitSet)this.sets[i], 0L);
            while ((docId = it.nextDoc()) != Integer.MAX_VALUE) {
                sortDoc.setValues(docId);
                if (!top.lessThan(sortDoc)) continue;
                top.setValues(sortDoc);
                top = (SortDoc)queue.updateTop();
            }
        }
    }

    protected int transferBatchToArrayForOutput(SortQueue queue, SortDoc[] destinationArr) {
        int outDocsIndex = -1;
        for (int i = 0; i < queue.maxSize; ++i) {
            SortDoc s = (SortDoc)queue.pop();
            if (s.docId <= -1) continue;
            destinationArr[++outDocsIndex] = s;
        }
        return outDocsIndex;
    }

    protected void addDocsToItemWriter(List<LeafReaderContext> leaves, IteratorWriter.ItemWriter writer, SortDoc[] docsToExport, int outDocsIndex) throws IOException {
        try {
            for (int i = outDocsIndex; i >= 0; --i) {
                SortDoc s = docsToExport[i];
                writer.add(ew -> {
                    this.writeDoc(s, leaves, ew);
                    s.reset();
                });
            }
        }
        catch (Throwable e) {
            for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                String m = ex.getMessage();
                if (m == null || !m.contains("Broken pipe")) continue;
                throw new IgnoreException();
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    protected void writeDocs(SolrQueryRequest req, IteratorWriter.ItemWriter writer, Sort sort) throws IOException {
        List leaves = req.getSearcher().getTopReaderContext().leaves();
        SortDoc sortDoc = this.getSortDoc(req.getSearcher(), sort.getSort());
        int queueSize = Math.min(30000, this.totalHits);
        SortQueue queue = new SortQueue(queueSize, sortDoc);
        SortDoc[] outDocs = new SortDoc[queueSize];
        if (this.streamExpression != null) {
            Tuple t;
            this.streamContext.put((Object)SORT_DOCS_KEY, (Object)outDocs);
            this.streamContext.put((Object)SORT_QUEUE_KEY, (Object)queue);
            this.streamContext.put((Object)SORT_DOC_KEY, (Object)sortDoc);
            this.streamContext.put((Object)TOTAL_HITS_KEY, (Object)this.totalHits);
            this.streamContext.put((Object)EXPORT_WRITER_KEY, (Object)this);
            this.streamContext.put((Object)LEAF_READERS_KEY, (Object)leaves);
            TupleStream tupleStream = this.createTupleStream();
            tupleStream.open();
            while ((t = tupleStream.read()) != null && !t.EOF) {
                writer.add(ew -> t.writeMap(ew));
            }
            tupleStream.close();
        } else {
            int outDocsIndex;
            for (int count = 0; count < this.totalHits; count += outDocsIndex + 1) {
                outDocsIndex = this.fillOutDocs(leaves, sortDoc, queue, outDocs);
                this.addDocsToItemWriter(leaves, writer, outDocs, outDocsIndex);
            }
        }
    }

    private int fillOutDocs(List<LeafReaderContext> leaves, SortDoc sortDoc, SortQueue sortQueue, SortDoc[] outDocs) throws IOException {
        this.identifyLowestSortingUnexportedDocs(leaves, sortDoc, sortQueue);
        return this.transferBatchToArrayForOutput(sortQueue, outDocs);
    }

    void writeDoc(SortDoc sortDoc, List<LeafReaderContext> leaves, MapWriter.EntryWriter ew) throws IOException {
        int ord = sortDoc.ord;
        FixedBitSet set = this.sets[ord];
        set.clear(sortDoc.docId);
        LeafReaderContext context = leaves.get(ord);
        int fieldIndex = 0;
        for (FieldWriter fieldWriter : this.fieldWriters) {
            if (!fieldWriter.write(sortDoc, context.reader(), ew, fieldIndex)) continue;
            ++fieldIndex;
        }
    }

    protected FieldWriter[] getFieldWriters(String[] fields, SolrIndexSearcher searcher) throws IOException {
        IndexSchema schema = searcher.getSchema();
        FieldWriter[] writers = new FieldWriter[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            SchemaField schemaField = null;
            try {
                schemaField = schema.getField(field);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (!schemaField.hasDocValues()) {
                throw new IOException(schemaField + " must have DocValues to use this feature.");
            }
            boolean multiValued = schemaField.multiValued();
            FieldType fieldType = schemaField.getType();
            if (fieldType instanceof SortableTextField && !schemaField.useDocValuesAsStored()) {
                throw new IOException(schemaField + " Must have useDocValuesAsStored='true' to be used with export writer");
            }
            if (fieldType instanceof IntValueFieldType) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new IntFieldWriter(field);
                continue;
            }
            if (fieldType instanceof LongValueFieldType) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new LongFieldWriter(field);
                continue;
            }
            if (fieldType instanceof FloatValueFieldType) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new FloatFieldWriter(field);
                continue;
            }
            if (fieldType instanceof DoubleValueFieldType) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new DoubleFieldWriter(field);
                continue;
            }
            if (fieldType instanceof StrField || fieldType instanceof SortableTextField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, false);
                    continue;
                }
                writers[i] = new StringFieldWriter(field, fieldType);
                continue;
            }
            if (fieldType instanceof DateValueFieldType) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, false);
                    continue;
                }
                writers[i] = new DateFieldWriter(field);
                continue;
            }
            if (fieldType instanceof BoolField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new BoolFieldWriter(field, fieldType);
                continue;
            }
            throw new IOException("Export fields must be one of the following types: int,float,long,double,string,date,boolean,SortableText");
        }
        return writers;
    }

    private SortDoc getSortDoc(SolrIndexSearcher searcher, SortField[] sortFields) throws IOException {
        SortValue[] sortValues = new SortValue[sortFields.length];
        IndexSchema schema = searcher.getSchema();
        for (int i = 0; i < sortFields.length; ++i) {
            SortedDocValues vals;
            LeafReader reader;
            SortField sf = sortFields[i];
            String field = sf.getField();
            boolean reverse = sf.getReverse();
            SchemaField schemaField = schema.getField(field);
            FieldType ft = schemaField.getType();
            if (!schemaField.hasDocValues()) {
                throw new IOException(field + " must have DocValues to use this feature.");
            }
            if (ft instanceof SortableTextField && !schemaField.useDocValuesAsStored()) {
                throw new IOException(schemaField + " Must have useDocValuesAsStored='true' to be used with export writer");
            }
            if (ft instanceof IntValueFieldType) {
                if (reverse) {
                    sortValues[i] = new IntValue(field, new IntComp.IntDesc());
                    continue;
                }
                sortValues[i] = new IntValue(field, new IntComp.IntAsc());
                continue;
            }
            if (ft instanceof FloatValueFieldType) {
                if (reverse) {
                    sortValues[i] = new FloatValue(field, new FloatComp.FloatDesc());
                    continue;
                }
                sortValues[i] = new FloatValue(field, new FloatComp.FloatAsc());
                continue;
            }
            if (ft instanceof DoubleValueFieldType) {
                if (reverse) {
                    sortValues[i] = new DoubleValue(field, new DoubleComp.DoubleDesc());
                    continue;
                }
                sortValues[i] = new DoubleValue(field, new DoubleComp.DoubleAsc());
                continue;
            }
            if (ft instanceof LongValueFieldType) {
                if (reverse) {
                    sortValues[i] = new LongValue(field, new LongComp.LongDesc());
                    continue;
                }
                sortValues[i] = new LongValue(field, new LongComp.LongAsc());
                continue;
            }
            if (ft instanceof StrField || ft instanceof SortableTextField) {
                reader = searcher.getSlowAtomicReader();
                vals = reader.getSortedDocValues(field);
                if (reverse) {
                    sortValues[i] = new StringValue(vals, field, new IntComp.IntDesc());
                    continue;
                }
                sortValues[i] = new StringValue(vals, field, new IntComp.IntAsc());
                continue;
            }
            if (ft instanceof DateValueFieldType) {
                if (reverse) {
                    sortValues[i] = new LongValue(field, new LongComp.LongDesc());
                    continue;
                }
                sortValues[i] = new LongValue(field, new LongComp.LongAsc());
                continue;
            }
            if (ft instanceof BoolField) {
                reader = searcher.getSlowAtomicReader();
                vals = reader.getSortedDocValues(field);
                if (reverse) {
                    sortValues[i] = new StringValue(vals, field, new IntComp.IntDesc());
                    continue;
                }
                sortValues[i] = new StringValue(vals, field, new IntComp.IntAsc());
                continue;
            }
            throw new IOException("Sort fields must be one of the following types: int,float,long,double,string,date,boolean,SortableText");
        }
        if (sortValues.length == 1) {
            return new SingleValueSortDoc(sortValues[0]);
        }
        if (sortValues.length == 2) {
            return new DoubleValueSortDoc(sortValues[0], sortValues[1]);
        }
        if (sortValues.length == 3) {
            return new TripleValueSortDoc(sortValues[0], sortValues[1], sortValues[2]);
        }
        if (sortValues.length == 4) {
            return new QuadValueSortDoc(sortValues[0], sortValues[1], sortValues[2], sortValues[3]);
        }
        return new SortDoc(sortValues);
    }

    public static class IgnoreException
    extends IOException {
        @Override
        public void printStackTrace(PrintWriter pw) {
            pw.print("Early Client Disconnect");
        }

        @Override
        public String getMessage() {
            return "Early Client Disconnect";
        }
    }

    public static class ExportWriterStream
    extends TupleStream
    implements Expressible {
        StreamContext context;
        StreamComparator streamComparator;
        int pos = -1;
        int outDocIndex = -1;
        int count;
        SortDoc sortDoc;
        SortQueue queue;
        SortDoc[] docs;
        int totalHits;
        ExportWriter exportWriter;
        List<LeafReaderContext> leaves;
        final TupleEntryWriter entryWriter = new TupleEntryWriter();

        public ExportWriterStream(StreamExpression expression, StreamFactory factory) throws IOException {
            this.streamComparator = this.parseComp(factory.getDefaultSort());
        }

        public void setStreamContext(StreamContext context) {
            this.context = context;
        }

        public List<TupleStream> children() {
            return null;
        }

        private StreamComparator parseComp(String sort) throws IOException {
            String[] sorts = sort.split(",");
            StreamComparator[] comps = new StreamComparator[sorts.length];
            for (int i = 0; i < sorts.length; ++i) {
                String s = sorts[i];
                String[] spec = s.trim().split("\\s+");
                if (spec.length != 2) {
                    throw new IOException("Invalid sort spec:" + s);
                }
                String fieldName = spec[0].trim();
                String order = spec[1].trim();
                comps[i] = new FieldComparator(fieldName, order.equalsIgnoreCase("asc") ? ComparatorOrder.ASCENDING : ComparatorOrder.DESCENDING);
            }
            if (comps.length > 1) {
                return new MultipleFieldComparator(comps);
            }
            return comps[0];
        }

        public void open() throws IOException {
            this.docs = (SortDoc[])this.context.get((Object)ExportWriter.SORT_DOCS_KEY);
            this.queue = (SortQueue)this.context.get((Object)ExportWriter.SORT_QUEUE_KEY);
            this.sortDoc = (SortDoc)this.context.get((Object)ExportWriter.SORT_DOC_KEY);
            this.totalHits = (Integer)this.context.get((Object)ExportWriter.TOTAL_HITS_KEY);
            this.exportWriter = (ExportWriter)this.context.get((Object)ExportWriter.EXPORT_WRITER_KEY);
            this.leaves = (List)this.context.get((Object)ExportWriter.LEAF_READERS_KEY);
            this.count = 0;
        }

        public void close() throws IOException {
            this.exportWriter = null;
            this.leaves = null;
        }

        public Tuple read() throws IOException {
            if (this.pos < 0) {
                if (this.count < this.totalHits) {
                    this.outDocIndex = this.exportWriter.fillOutDocs(this.leaves, this.sortDoc, this.queue, this.docs);
                    this.count += this.outDocIndex + 1;
                    this.pos = this.outDocIndex;
                } else {
                    return Tuple.EOF();
                }
            }
            if (this.pos < 0) {
                return Tuple.EOF();
            }
            Tuple tuple = new Tuple();
            this.entryWriter.setTuple(tuple);
            SortDoc s = this.docs[this.pos];
            this.exportWriter.writeDoc(s, this.leaves, this.entryWriter);
            s.reset();
            --this.pos;
            return tuple;
        }

        public StreamComparator getStreamSort() {
            return this.streamComparator;
        }

        public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
            StreamExpression expression = new StreamExpression(factory.getFunctionName(((Object)((Object)this)).getClass()));
            return expression;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("input").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-source").withExpression("--non-expressible--");
        }
    }

    private static class TupleEntryWriter
    implements MapWriter.EntryWriter {
        Tuple tuple;

        private TupleEntryWriter() {
        }

        void setTuple(Tuple tuple) {
            this.tuple = tuple;
        }

        public MapWriter.EntryWriter put(CharSequence k, Object v) throws IOException {
            this.tuple.put((Object)k, v);
            return this;
        }
    }
}

