/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.TimSorter;
import org.apache.lucene.util.automaton.CompiledAutomaton;

class SortingLeafReader
extends FilterLeafReader {
    private final Map<String, CachedNumericDVs> cachedNumericDVs = new HashMap<String, CachedNumericDVs>();
    private final Map<String, CachedBinaryDVs> cachedBinaryDVs = new HashMap<String, CachedBinaryDVs>();
    private final Map<String, int[]> cachedSortedDVs = new HashMap<String, int[]>();
    private final Map<String, long[][]> cachedSortedSetDVs = new HashMap<String, long[][]>();
    private final Map<String, long[][]> cachedSortedNumericDVs = new HashMap<String, long[][]>();
    final Sorter.DocMap docMap;
    private final Map<String, CachedNumericDVs> cachedNorms = new HashMap<String, CachedNumericDVs>();

    public static LeafReader wrap(LeafReader reader, Sort sort) throws IOException {
        return SortingLeafReader.wrap(reader, new Sorter(sort).sort(reader));
    }

    static LeafReader wrap(LeafReader reader, Sorter.DocMap docMap) {
        if (docMap == null) {
            return reader;
        }
        if (reader.maxDoc() != docMap.size()) {
            throw new IllegalArgumentException("reader.maxDoc() should be equal to docMap.size(), got" + reader.maxDoc() + " != " + docMap.size());
        }
        assert (Sorter.isConsistent(docMap));
        return new SortingLeafReader(reader, docMap);
    }

    private SortingLeafReader(LeafReader in, Sorter.DocMap docMap) {
        super(in);
        this.docMap = docMap;
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.in.document(this.docMap.newToOld(docID), visitor);
    }

    @Override
    public Terms terms(String field) throws IOException {
        Terms terms = super.terms(field);
        return terms == null ? null : new SortingTerms(terms, this.in.getFieldInfos().fieldInfo(field).getIndexOptions(), this.docMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        CachedBinaryDVs dvs;
        BinaryDocValues oldDocValues = this.in.getBinaryDocValues(field);
        if (oldDocValues == null) {
            return null;
        }
        Map<String, CachedBinaryDVs> map = this.cachedBinaryDVs;
        synchronized (map) {
            dvs = this.cachedBinaryDVs.get(field);
            if (dvs == null) {
                int docID;
                FixedBitSet docsWithField = new FixedBitSet(this.maxDoc());
                BytesRef[] values = new BytesRef[this.maxDoc()];
                while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
                    int newDocID = this.docMap.oldToNew(docID);
                    docsWithField.set(newDocID);
                    values[newDocID] = BytesRef.deepCopyOf(oldDocValues.binaryValue());
                }
                dvs = new CachedBinaryDVs(values, docsWithField);
                this.cachedBinaryDVs.put(field, dvs);
            }
        }
        return new SortingBinaryDocValues(dvs);
    }

    @Override
    public Bits getLiveDocs() {
        Bits inLiveDocs = this.in.getLiveDocs();
        if (inLiveDocs == null) {
            return null;
        }
        return new SortingBits(inLiveDocs, this.docMap);
    }

    @Override
    public PointValues getPointValues(String fieldName) throws IOException {
        PointValues inPointValues = this.in.getPointValues(fieldName);
        if (inPointValues == null) {
            return null;
        }
        return new SortingPointValues(inPointValues, this.docMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        CachedNumericDVs norms;
        NumericDocValues oldNorms = this.in.getNormValues(field);
        if (oldNorms == null) {
            return null;
        }
        Map<String, CachedNumericDVs> map = this.cachedNorms;
        synchronized (map) {
            norms = this.cachedNorms.get(field);
            if (norms == null) {
                int docID;
                FixedBitSet docsWithField = new FixedBitSet(this.maxDoc());
                long[] values = new long[this.maxDoc()];
                while ((docID = oldNorms.nextDoc()) != Integer.MAX_VALUE) {
                    int newDocID = this.docMap.oldToNew(docID);
                    docsWithField.set(newDocID);
                    values[newDocID] = oldNorms.longValue();
                }
                norms = new CachedNumericDVs(values, docsWithField);
                this.cachedNorms.put(field, norms);
            }
        }
        return new SortingNumericDocValues(norms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        CachedNumericDVs dvs;
        NumericDocValues oldDocValues = this.in.getNumericDocValues(field);
        if (oldDocValues == null) {
            return null;
        }
        Map<String, CachedNumericDVs> map = this.cachedNumericDVs;
        synchronized (map) {
            dvs = this.cachedNumericDVs.get(field);
            if (dvs == null) {
                int docID;
                FixedBitSet docsWithField = new FixedBitSet(this.maxDoc());
                long[] values = new long[this.maxDoc()];
                while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
                    int newDocID = this.docMap.oldToNew(docID);
                    docsWithField.set(newDocID);
                    values[newDocID] = oldDocValues.longValue();
                }
                dvs = new CachedNumericDVs(values, docsWithField);
                this.cachedNumericDVs.put(field, dvs);
            }
        }
        return new SortingNumericDocValues(dvs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        Object values;
        SortedNumericDocValues oldDocValues = this.in.getSortedNumericDocValues(field);
        if (oldDocValues == null) {
            return null;
        }
        Map<String, long[][]> map = this.cachedSortedNumericDVs;
        synchronized (map) {
            values = this.cachedSortedNumericDVs.get(field);
            if (values == null) {
                int docID;
                values = new long[this.maxDoc()][];
                while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
                    int newDocID = this.docMap.oldToNew(docID);
                    long[] docValues = new long[oldDocValues.docValueCount()];
                    for (int i = 0; i < docValues.length; ++i) {
                        docValues[i] = oldDocValues.nextValue();
                    }
                    values[newDocID] = docValues;
                }
                this.cachedSortedNumericDVs.put(field, (long[][])values);
            }
        }
        return new SortingSortedNumericDocValues(oldDocValues, (long[][])values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        int[] ords;
        SortedDocValues oldDocValues = this.in.getSortedDocValues(field);
        if (oldDocValues == null) {
            return null;
        }
        Map<String, int[]> map = this.cachedSortedDVs;
        synchronized (map) {
            ords = this.cachedSortedDVs.get(field);
            if (ords == null) {
                int docID;
                ords = new int[this.maxDoc()];
                Arrays.fill(ords, -1);
                while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
                    int newDocID = this.docMap.oldToNew(docID);
                    ords[newDocID] = oldDocValues.ordValue();
                }
                this.cachedSortedDVs.put(field, ords);
            }
        }
        return new SortingSortedDocValues(oldDocValues, ords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        Object ords;
        SortedSetDocValues oldDocValues = this.in.getSortedSetDocValues(field);
        if (oldDocValues == null) {
            return null;
        }
        Map<String, long[][]> map = this.cachedSortedSetDVs;
        synchronized (map) {
            ords = this.cachedSortedSetDVs.get(field);
            if (ords == null) {
                int docID;
                ords = new long[this.maxDoc()][];
                while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
                    long ord;
                    int newDocID = this.docMap.oldToNew(docID);
                    long[] docOrds = new long[1];
                    int upto = 0;
                    while ((ord = oldDocValues.nextOrd()) != -1L) {
                        if (upto == docOrds.length) {
                            docOrds = ArrayUtil.grow(docOrds);
                        }
                        docOrds[upto++] = ord;
                    }
                    ords[newDocID] = ArrayUtil.copyOfSubArray(docOrds, 0, upto);
                }
                this.cachedSortedSetDVs.put(field, (long[][])ords);
            }
        }
        return new SortingSortedSetDocValues(oldDocValues, (long[][])ords);
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        return this.in.getTermVectors(this.docMap.newToOld(docID));
    }

    @Override
    public String toString() {
        return "SortingLeafReader(" + this.in + ")";
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private static class SortingTerms
    extends FilterLeafReader.FilterTerms {
        private final Sorter.DocMap docMap;
        private final IndexOptions indexOptions;

        public SortingTerms(Terms in, IndexOptions indexOptions, Sorter.DocMap docMap) {
            super(in);
            this.docMap = docMap;
            this.indexOptions = indexOptions;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new SortingTermsEnum(this.in.iterator(), this.docMap, this.indexOptions, this.hasPositions());
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new SortingTermsEnum(this.in.intersect(compiled, startTerm), this.docMap, this.indexOptions, this.hasPositions());
        }
    }

    static class CachedBinaryDVs {
        private final BytesRef[] values;
        private final BitSet docsWithField;

        public CachedBinaryDVs(BytesRef[] values, BitSet docsWithField) {
            this.values = values;
            this.docsWithField = docsWithField;
        }
    }

    static class SortingBinaryDocValues
    extends BinaryDocValues {
        private final CachedBinaryDVs dvs;
        private int docID = -1;

        public SortingBinaryDocValues(CachedBinaryDVs dvs) {
            this.dvs = dvs;
        }

        @Override
        public int nextDoc() {
            this.docID = this.docID + 1 == this.dvs.docsWithField.length() ? Integer.MAX_VALUE : this.dvs.docsWithField.nextSetBit(this.docID + 1);
            return this.docID;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int advance(int target) {
            this.docID = this.dvs.docsWithField.nextSetBit(target);
            return this.docID;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return this.dvs.docsWithField.get(target);
        }

        @Override
        public BytesRef binaryValue() {
            return this.dvs.values[this.docID];
        }

        @Override
        public long cost() {
            return this.dvs.docsWithField.cardinality();
        }
    }

    private static class SortingBits
    implements Bits {
        private final Bits in;
        private final Sorter.DocMap docMap;

        public SortingBits(Bits in, Sorter.DocMap docMap) {
            this.in = in;
            this.docMap = docMap;
        }

        @Override
        public boolean get(int index) {
            return this.in.get(this.docMap.newToOld(index));
        }

        @Override
        public int length() {
            return this.in.length();
        }
    }

    private static class SortingPointValues
    extends PointValues {
        private final PointValues in;
        private final Sorter.DocMap docMap;

        public SortingPointValues(PointValues in, Sorter.DocMap docMap) {
            this.in = in;
            this.docMap = docMap;
        }

        @Override
        public void intersect(final PointValues.IntersectVisitor visitor) throws IOException {
            this.in.intersect(new PointValues.IntersectVisitor(){

                @Override
                public void visit(int docID) throws IOException {
                    visitor.visit(docMap.oldToNew(docID));
                }

                @Override
                public void visit(int docID, byte[] packedValue) throws IOException {
                    visitor.visit(docMap.oldToNew(docID), packedValue);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return visitor.compare(minPackedValue, maxPackedValue);
                }
            });
        }

        @Override
        public long estimatePointCount(PointValues.IntersectVisitor visitor) {
            return this.in.estimatePointCount(visitor);
        }

        @Override
        public byte[] getMinPackedValue() throws IOException {
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() throws IOException {
            return this.in.getMaxPackedValue();
        }

        @Override
        public int getNumDimensions() throws IOException {
            return this.in.getNumDimensions();
        }

        @Override
        public int getNumIndexDimensions() throws IOException {
            return this.in.getNumIndexDimensions();
        }

        @Override
        public int getBytesPerDimension() throws IOException {
            return this.in.getBytesPerDimension();
        }

        @Override
        public long size() {
            return this.in.size();
        }

        @Override
        public int getDocCount() {
            return this.in.getDocCount();
        }
    }

    static class CachedNumericDVs {
        private final long[] values;
        private final BitSet docsWithField;

        public CachedNumericDVs(long[] values, BitSet docsWithField) {
            this.values = values;
            this.docsWithField = docsWithField;
        }
    }

    static class SortingNumericDocValues
    extends NumericDocValues {
        private final CachedNumericDVs dvs;
        private int docID = -1;

        public SortingNumericDocValues(CachedNumericDVs dvs) {
            this.dvs = dvs;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            this.docID = this.docID + 1 == this.dvs.docsWithField.length() ? Integer.MAX_VALUE : this.dvs.docsWithField.nextSetBit(this.docID + 1);
            return this.docID;
        }

        @Override
        public int advance(int target) {
            this.docID = this.dvs.docsWithField.nextSetBit(target);
            return this.docID;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return this.dvs.docsWithField.get(target);
        }

        @Override
        public long longValue() {
            return this.dvs.values[this.docID];
        }

        @Override
        public long cost() {
            return this.dvs.docsWithField.cardinality();
        }
    }

    static class SortingSortedNumericDocValues
    extends SortedNumericDocValues {
        private final SortedNumericDocValues in;
        private final long[][] values;
        private int docID = -1;
        private int upto;

        SortingSortedNumericDocValues(SortedNumericDocValues in, long[][] values) {
            this.in = in;
            this.values = values;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            do {
                ++this.docID;
                if (this.docID != this.values.length) continue;
                this.docID = Integer.MAX_VALUE;
                break;
            } while (this.values[this.docID] == null);
            this.upto = 0;
            return this.docID;
        }

        @Override
        public int advance(int target) {
            if (target >= this.values.length) {
                this.docID = Integer.MAX_VALUE;
                return this.docID;
            }
            this.docID = target - 1;
            return this.nextDoc();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            this.upto = 0;
            return this.values[this.docID] != null;
        }

        @Override
        public long nextValue() {
            if (this.upto == this.values[this.docID].length) {
                throw new AssertionError();
            }
            return this.values[this.docID][this.upto++];
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int docValueCount() {
            return this.values[this.docID].length;
        }
    }

    static class SortingSortedDocValues
    extends SortedDocValues {
        private final SortedDocValues in;
        private final int[] ords;
        private int docID = -1;

        SortingSortedDocValues(SortedDocValues in, int[] ords) {
            this.in = in;
            this.ords = ords;
            assert (ords != null);
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            do {
                ++this.docID;
                if (this.docID != this.ords.length) continue;
                this.docID = Integer.MAX_VALUE;
                break;
            } while (this.ords[this.docID] == -1);
            return this.docID;
        }

        @Override
        public int advance(int target) {
            if (target >= this.ords.length) {
                this.docID = Integer.MAX_VALUE;
            } else {
                this.docID = target;
                if (this.ords[this.docID] == -1) {
                    this.nextDoc();
                }
            }
            return this.docID;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return this.ords[target] != -1;
        }

        @Override
        public int ordValue() {
            return this.ords[this.docID];
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return this.in.getValueCount();
        }
    }

    static class SortingSortedSetDocValues
    extends SortedSetDocValues {
        private final SortedSetDocValues in;
        private final long[][] ords;
        private int docID = -1;
        private int ordUpto;

        SortingSortedSetDocValues(SortedSetDocValues in, long[][] ords) {
            this.in = in;
            this.ords = ords;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            do {
                ++this.docID;
                if (this.docID != this.ords.length) continue;
                this.docID = Integer.MAX_VALUE;
                break;
            } while (this.ords[this.docID] == null);
            this.ordUpto = 0;
            return this.docID;
        }

        @Override
        public int advance(int target) {
            if (target >= this.ords.length) {
                this.docID = Integer.MAX_VALUE;
            } else {
                this.docID = target;
                if (this.ords[this.docID] == null) {
                    this.nextDoc();
                } else {
                    this.ordUpto = 0;
                }
            }
            return this.docID;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            this.ordUpto = 0;
            return this.ords[this.docID] != null;
        }

        @Override
        public long nextOrd() {
            if (this.ordUpto == this.ords[this.docID].length) {
                return -1L;
            }
            return this.ords[this.docID][this.ordUpto++];
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public BytesRef lookupOrd(long ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public long getValueCount() {
            return this.in.getValueCount();
        }
    }

    static class SortingPostingsEnum
    extends FilterLeafReader.FilterPostingsEnum {
        private final int maxDoc;
        private final DocOffsetSorter sorter;
        private int[] docs;
        private long[] offsets;
        private final int upto;
        private final IndexInput postingInput;
        private final boolean storeOffsets;
        private int docIt = -1;
        private int pos;
        private int startOffset = -1;
        private int endOffset = -1;
        private final BytesRef payload;
        private int currFreq;
        private final RAMFile file;

        SortingPostingsEnum(int maxDoc, SortingPostingsEnum reuse, PostingsEnum in, Sorter.DocMap docMap, boolean storeOffsets) throws IOException {
            super(in);
            int doc;
            this.maxDoc = maxDoc;
            this.storeOffsets = storeOffsets;
            if (reuse != null) {
                this.docs = reuse.docs;
                this.offsets = reuse.offsets;
                this.payload = reuse.payload;
                this.file = reuse.file;
                this.sorter = reuse.maxDoc == maxDoc ? reuse.sorter : new DocOffsetSorter(maxDoc);
            } else {
                this.docs = new int[32];
                this.offsets = new long[32];
                this.payload = new BytesRef(32);
                this.file = new RAMFile();
                this.sorter = new DocOffsetSorter(maxDoc);
            }
            RAMOutputStream out = new RAMOutputStream(this.file, false);
            int i = 0;
            while ((doc = in.nextDoc()) != Integer.MAX_VALUE) {
                if (i == this.docs.length) {
                    int newLength = ArrayUtil.oversize(i + 1, 4);
                    this.docs = ArrayUtil.growExact(this.docs, newLength);
                    this.offsets = ArrayUtil.growExact(this.offsets, newLength);
                }
                this.docs[i] = docMap.oldToNew(doc);
                this.offsets[i] = ((IndexOutput)out).getFilePointer();
                this.addPositions(in, out);
                ++i;
            }
            this.upto = i;
            this.sorter.reset(this.docs, this.offsets);
            this.sorter.sort(0, this.upto);
            ((IndexOutput)out).close();
            this.postingInput = new RAMInputStream("", this.file);
        }

        boolean reused(PostingsEnum other) {
            if (other == null || !(other instanceof SortingPostingsEnum)) {
                return false;
            }
            return this.docs == ((SortingPostingsEnum)other).docs;
        }

        private void addPositions(PostingsEnum in, IndexOutput out) throws IOException {
            int freq = in.freq();
            out.writeVInt(freq);
            int previousPosition = 0;
            int previousEndOffset = 0;
            for (int i = 0; i < freq; ++i) {
                int pos = in.nextPosition();
                BytesRef payload = in.getPayload();
                int token = pos - previousPosition << 1 | (payload == null ? 0 : 1);
                out.writeVInt(token);
                previousPosition = pos;
                if (this.storeOffsets) {
                    int startOffset = in.startOffset();
                    int endOffset = in.endOffset();
                    out.writeVInt(startOffset - previousEndOffset);
                    out.writeVInt(endOffset - startOffset);
                    previousEndOffset = endOffset;
                }
                if (payload == null) continue;
                out.writeVInt(payload.length);
                out.writeBytes(payload.bytes, payload.offset, payload.length);
            }
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public int docID() {
            return this.docIt < 0 ? -1 : (this.docIt >= this.upto ? Integer.MAX_VALUE : this.docs[this.docIt]);
        }

        @Override
        public int endOffset() throws IOException {
            return this.endOffset;
        }

        @Override
        public int freq() throws IOException {
            return this.currFreq;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return this.payload.length == 0 ? null : this.payload;
        }

        @Override
        public int nextDoc() throws IOException {
            if (++this.docIt >= this.upto) {
                return Integer.MAX_VALUE;
            }
            this.postingInput.seek(this.offsets[this.docIt]);
            this.currFreq = this.postingInput.readVInt();
            this.pos = 0;
            this.endOffset = 0;
            return this.docs[this.docIt];
        }

        @Override
        public int nextPosition() throws IOException {
            int token = this.postingInput.readVInt();
            this.pos += token >>> 1;
            if (this.storeOffsets) {
                this.startOffset = this.endOffset + this.postingInput.readVInt();
                this.endOffset = this.startOffset + this.postingInput.readVInt();
            }
            if ((token & 1) != 0) {
                this.payload.offset = 0;
                this.payload.length = this.postingInput.readVInt();
                if (this.payload.length > this.payload.bytes.length) {
                    this.payload.bytes = new byte[ArrayUtil.oversize(this.payload.length, 1)];
                }
                this.postingInput.readBytes(this.payload.bytes, 0, this.payload.length);
            } else {
                this.payload.length = 0;
            }
            return this.pos;
        }

        @Override
        public int startOffset() throws IOException {
            return this.startOffset;
        }

        PostingsEnum getWrapped() {
            return this.in;
        }

        private static final class DocOffsetSorter
        extends TimSorter {
            private int[] docs;
            private long[] offsets;
            private final int[] tmpDocs;
            private final long[] tmpOffsets;

            public DocOffsetSorter(int maxDoc) {
                super(maxDoc / 64);
                this.tmpDocs = new int[maxDoc / 64];
                this.tmpOffsets = new long[maxDoc / 64];
            }

            public void reset(int[] docs, long[] offsets) {
                this.docs = docs;
                this.offsets = offsets;
            }

            @Override
            protected int compare(int i, int j) {
                return this.docs[i] - this.docs[j];
            }

            @Override
            protected void swap(int i, int j) {
                int tmpDoc = this.docs[i];
                this.docs[i] = this.docs[j];
                this.docs[j] = tmpDoc;
                long tmpOffset = this.offsets[i];
                this.offsets[i] = this.offsets[j];
                this.offsets[j] = tmpOffset;
            }

            @Override
            protected void copy(int src, int dest) {
                this.docs[dest] = this.docs[src];
                this.offsets[dest] = this.offsets[src];
            }

            @Override
            protected void save(int i, int len) {
                System.arraycopy(this.docs, i, this.tmpDocs, 0, len);
                System.arraycopy(this.offsets, i, this.tmpOffsets, 0, len);
            }

            @Override
            protected void restore(int i, int j) {
                this.docs[j] = this.tmpDocs[i];
                this.offsets[j] = this.tmpOffsets[i];
            }

            @Override
            protected int compareSaved(int i, int j) {
                return this.tmpDocs[i] - this.docs[j];
            }
        }
    }

    static class SortingDocsEnum
    extends FilterLeafReader.FilterPostingsEnum {
        private final int maxDoc;
        private final DocFreqSorter sorter;
        private int[] docs;
        private int[] freqs;
        private int docIt = -1;
        private final int upto;
        private final boolean withFreqs;

        SortingDocsEnum(int maxDoc, SortingDocsEnum reuse, PostingsEnum in, boolean withFreqs, Sorter.DocMap docMap) throws IOException {
            super(in);
            this.maxDoc = maxDoc;
            this.withFreqs = withFreqs;
            if (reuse != null) {
                this.sorter = reuse.maxDoc == maxDoc ? reuse.sorter : new DocFreqSorter(maxDoc);
                this.docs = reuse.docs;
                this.freqs = reuse.freqs;
            } else {
                this.docs = new int[64];
                this.sorter = new DocFreqSorter(maxDoc);
            }
            this.docIt = -1;
            int i = 0;
            if (withFreqs) {
                int doc;
                if (this.freqs == null || this.freqs.length < this.docs.length) {
                    this.freqs = new int[this.docs.length];
                }
                while ((doc = in.nextDoc()) != Integer.MAX_VALUE) {
                    if (i >= this.docs.length) {
                        this.docs = ArrayUtil.grow(this.docs, this.docs.length + 1);
                        this.freqs = ArrayUtil.grow(this.freqs, this.freqs.length + 1);
                    }
                    this.docs[i] = docMap.oldToNew(doc);
                    this.freqs[i] = in.freq();
                    ++i;
                }
            } else {
                int doc;
                this.freqs = null;
                while ((doc = in.nextDoc()) != Integer.MAX_VALUE) {
                    if (i >= this.docs.length) {
                        this.docs = ArrayUtil.grow(this.docs, this.docs.length + 1);
                    }
                    this.docs[i++] = docMap.oldToNew(doc);
                }
            }
            this.sorter.reset(this.docs, this.freqs);
            this.sorter.sort(0, i);
            this.upto = i;
        }

        boolean reused(PostingsEnum other) {
            if (other == null || !(other instanceof SortingDocsEnum)) {
                return false;
            }
            return this.docs == ((SortingDocsEnum)other).docs;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public int docID() {
            return this.docIt < 0 ? -1 : (this.docIt >= this.upto ? Integer.MAX_VALUE : this.docs[this.docIt]);
        }

        @Override
        public int freq() throws IOException {
            return this.withFreqs && this.docIt < this.upto ? this.freqs[this.docIt] : 1;
        }

        @Override
        public int nextDoc() throws IOException {
            if (++this.docIt >= this.upto) {
                return Integer.MAX_VALUE;
            }
            return this.docs[this.docIt];
        }

        PostingsEnum getWrapped() {
            return this.in;
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        private static final class DocFreqSorter
        extends TimSorter {
            private int[] docs;
            private int[] freqs;
            private final int[] tmpDocs;
            private int[] tmpFreqs;

            public DocFreqSorter(int maxDoc) {
                super(maxDoc / 64);
                this.tmpDocs = new int[maxDoc / 64];
            }

            public void reset(int[] docs, int[] freqs) {
                this.docs = docs;
                this.freqs = freqs;
                if (freqs != null && this.tmpFreqs == null) {
                    this.tmpFreqs = new int[this.tmpDocs.length];
                }
            }

            @Override
            protected int compare(int i, int j) {
                return this.docs[i] - this.docs[j];
            }

            @Override
            protected void swap(int i, int j) {
                int tmpDoc = this.docs[i];
                this.docs[i] = this.docs[j];
                this.docs[j] = tmpDoc;
                if (this.freqs != null) {
                    int tmpFreq = this.freqs[i];
                    this.freqs[i] = this.freqs[j];
                    this.freqs[j] = tmpFreq;
                }
            }

            @Override
            protected void copy(int src, int dest) {
                this.docs[dest] = this.docs[src];
                if (this.freqs != null) {
                    this.freqs[dest] = this.freqs[src];
                }
            }

            @Override
            protected void save(int i, int len) {
                System.arraycopy(this.docs, i, this.tmpDocs, 0, len);
                if (this.freqs != null) {
                    System.arraycopy(this.freqs, i, this.tmpFreqs, 0, len);
                }
            }

            @Override
            protected void restore(int i, int j) {
                this.docs[j] = this.tmpDocs[i];
                if (this.freqs != null) {
                    this.freqs[j] = this.tmpFreqs[i];
                }
            }

            @Override
            protected int compareSaved(int i, int j) {
                return this.tmpDocs[i] - this.docs[j];
            }
        }
    }

    private static class SortingTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        final Sorter.DocMap docMap;
        private final IndexOptions indexOptions;
        private final boolean hasPositions;

        public SortingTermsEnum(TermsEnum in, Sorter.DocMap docMap, IndexOptions indexOptions, boolean hasPositions) {
            super(in);
            this.docMap = docMap;
            this.indexOptions = indexOptions;
            this.hasPositions = hasPositions;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            PostingsEnum inReuse;
            SortingDocsEnum wrapReuse;
            if (this.hasPositions && PostingsEnum.featureRequested(flags, (short)24)) {
                PostingsEnum inReuse2;
                SortingPostingsEnum wrapReuse2;
                if (reuse != null && reuse instanceof SortingPostingsEnum) {
                    wrapReuse2 = (SortingPostingsEnum)reuse;
                    inReuse2 = wrapReuse2.getWrapped();
                } else {
                    wrapReuse2 = null;
                    inReuse2 = reuse;
                }
                PostingsEnum inDocsAndPositions = this.in.postings(inReuse2, flags);
                boolean storeOffsets = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                return new SortingPostingsEnum(this.docMap.size(), wrapReuse2, inDocsAndPositions, this.docMap, storeOffsets);
            }
            if (reuse != null && reuse instanceof SortingDocsEnum) {
                wrapReuse = (SortingDocsEnum)reuse;
                inReuse = wrapReuse.getWrapped();
            } else {
                wrapReuse = null;
                inReuse = reuse;
            }
            PostingsEnum inDocs = this.in.postings(inReuse, flags);
            boolean withFreqs = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0 && PostingsEnum.featureRequested(flags, (short)8);
            return new SortingDocsEnum(this.docMap.size(), wrapReuse, inDocs, withFreqs, this.docMap);
        }
    }

    static class SortingFields
    extends FilterLeafReader.FilterFields {
        private final Sorter.DocMap docMap;
        private final FieldInfos infos;

        public SortingFields(Fields in, FieldInfos infos, Sorter.DocMap docMap) {
            super(in);
            this.docMap = docMap;
            this.infos = infos;
        }

        @Override
        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            if (terms == null) {
                return null;
            }
            return new SortingTerms(terms, this.infos.fieldInfo(field).getIndexOptions(), this.docMap);
        }
    }
}

