/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CollectionChangeSupport;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeRecorder;
import com.eteks.sweethome3d.model.UserPreferences;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class HomeApplication {
    private List<Home> homes = new ArrayList<Home>();
    private final CollectionChangeSupport<Home> homesChangeSupport = new CollectionChangeSupport(this);

    public void addHomesListener(CollectionListener<Home> collectionListener) {
        this.homesChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeHomesListener(CollectionListener<Home> collectionListener) {
        this.homesChangeSupport.removeCollectionListener(collectionListener);
    }

    public Home createHome() {
        return new Home(this.getUserPreferences().getNewWallHeight());
    }

    public List<Home> getHomes() {
        return Collections.unmodifiableList(this.homes);
    }

    public void addHome(Home home) {
        this.homes = new ArrayList<Home>(this.homes);
        this.homes.add(home);
        this.homesChangeSupport.fireCollectionChanged(home, this.homes.size() - 1, CollectionEvent.Type.ADD);
    }

    public void deleteHome(Home home) {
        int n = this.homes.indexOf(home);
        if (n != -1) {
            this.homes = new ArrayList<Home>(this.homes);
            this.homes.remove(n);
            this.homesChangeSupport.fireCollectionChanged(home, n, CollectionEvent.Type.DELETE);
        }
    }

    public abstract HomeRecorder getHomeRecorder();

    public HomeRecorder getHomeRecorder(HomeRecorder.Type type) {
        return this.getHomeRecorder();
    }

    public abstract UserPreferences getUserPreferences();

    public String getName() {
        return "Sweet Home 3D";
    }

    public String getVersion() {
        return "";
    }

    public String getId() {
        return null;
    }
}

