/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.ui.ButtonComp;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

public class GainControlComponent
extends Container
implements GainChangeListener {
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected GainControl gain = null;
    protected MuteButton muteButton = null;
    protected VolumeButton upButton = null;
    protected VolumeButton downButton = null;
    protected boolean fUseVolumeControl = true;
    protected static final float VolumeIncrement = 0.05f;
    protected static final int RepeatDelay = 100;

    public GainControlComponent(GainControl gain) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.gain = gain;
        gain.addGainChangeListener(this);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        if (this.canChangeVolume()) {
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.gridheight = 2;
            this.muteButton = new MuteButton();
            this.add(this.muteButton);
            gbl.setConstraints(this.muteButton, gbc);
            gbc.gridx = 1;
            gbc.gridheight = 1;
            this.upButton = new VolumeButton("volumeUp.gif", "volumeUp-active.gif", "volumeUp-pressed.gif", "volumeUp-disabled.gif", "Increase volume", 0.05f);
            this.add(this.upButton);
            gbl.setConstraints(this.upButton, gbc);
            gbc.gridy = 1;
            this.downButton = new VolumeButton("volumeDown.gif", "volumeDown-active.gif", "volumeDown-pressed.gif", "volumeDown-disabled.gif", "Decrease volume", -0.05f);
            this.add(this.downButton);
            gbl.setConstraints(this.downButton, gbc);
        } else {
            this.fUseVolumeControl = false;
            this.muteButton = new MuteButton();
            this.add(this.muteButton);
        }
    }

    public void gainChange(GainChangeEvent e) {
        if (this.fUseVolumeControl) {
            float level = e.getLevel();
            this.upButton.setEnabled(level < 1.0f);
            this.downButton.setEnabled(level > 0.0f);
        }
        this.muteButton.setValue(e.getMute());
    }

    protected boolean canChangeVolume() {
        return this.gain != null && !(this.gain.getLevel() < 0.0f);
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class MuteButton
    extends ButtonComp {
        public MuteButton() {
            super("Mute audio", "audio.gif", "audio-active.gif", "audio-pressed.gif", "audio-disabled.gif", "mute.gif", "mute-active.gif", "mute-pressed.gif", "audio-disabled.gif");
        }

        public void action() {
            if (GainControlComponent.this.gain != null) {
                GainControlComponent.this.gain.setMute(!GainControlComponent.this.gain.getMute());
            }
        }
    }

    class VolumeButton
    extends ButtonComp {
        protected float increment;
        Thread repeater = null;

        public VolumeButton(String imgNormal, String imgActive, String imgDown, String imgDisabled, String tip, float increment) {
            super(tip, imgNormal, imgActive, imgDown, imgDisabled, imgNormal, imgActive, imgDown, imgDisabled);
            this.increment = increment;
        }

        public void action() {
            if (GainControlComponent.this.gain != null) {
                float level = GainControlComponent.this.gain.getLevel() + this.increment;
                if (level < 0.0f) {
                    level = 0.0f;
                } else if (level > 1.0f) {
                    level = 1.0f;
                }
                GainControlComponent.this.gain.setLevel(level);
                GainControlComponent.this.gain.setMute(false);
            }
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (this.repeater == null) {
                this.repeater = new Thread(this){
                    private final /* synthetic */ VolumeButton this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (VolumeButton.access$000((VolumeButton)this.this$1).gain != null) {
                            float lastLevel = VolumeButton.access$000((VolumeButton)this.this$1).gain.getLevel();
                            int unchangedCount = 0;
                            while (this.this$1.mouseDown && unchangedCount < 5) {
                                try {
                                    Thread.sleep(100L);
                                    try {
                                        this.this$1.action();
                                    }
                                    catch (Exception ex) {
                                        this.this$1.mouseDown = false;
                                    }
                                    float newLevel = VolumeButton.access$000((VolumeButton)this.this$1).gain.getLevel();
                                    if (lastLevel == newLevel) {
                                        ++unchangedCount;
                                        continue;
                                    }
                                    lastLevel = newLevel;
                                    unchangedCount = 0;
                                }
                                catch (InterruptedException ex) {
                                    unchangedCount = 10;
                                }
                            }
                        }
                    }
                };
                this.repeater.start();
            }
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (this.repeater != null) {
                Thread killIt = this.repeater;
                this.repeater = null;
                boolean permission = true;
                if (securityPrivelege) {
                    if (jmfSecurity != null) {
                        try {
                            jmfSecurity.requestPermission(GainControlComponent.this.m, GainControlComponent.this.cl, GainControlComponent.this.args, 16);
                            GainControlComponent.this.m[0].invoke((Object)GainControlComponent.this.cl[0], GainControlComponent.this.args[0]);
                        }
                        catch (Exception ex) {
                            permission = false;
                        }
                    }
                } else {
                    permission = false;
                }
                if (permission) {
                    killIt.interrupt();
                }
            }
        }

        public void setEnabled(boolean enabled) {
            if (enabled != this.isEnabled()) {
                super.setEnabled(enabled);
                this.mouseActivity();
            }
        }

        static /* synthetic */ GainControlComponent access$000(VolumeButton x0) {
            return x0.GainControlComponent.this;
        }
    }
}

