use Mozilla::LDAP::Conn;
use Mozilla::LDAP::Utils qw(normalizeDN);
use Mozilla::LDAP::API qw(:constant ldap_url_parse ldap_explode_dn);
use DSUpdate qw(isOffline);

sub runinst {
    my ($inf, $inst, $dseldif, $conn) = @_;
    my $rc, @errs;

    # List of index to be reindexed
    my @toreindex = qw(parentid);
    # rdn-format value.  See $rdn_format set below.
    # If equal to or greater than this value, no need to reindex.
    # If it needs to be unconditionally reindexed, set 0.
    my @rdnconditions = (4);

    my $config = $conn->search("cn=config", "base", "(objectclass=*)");
    if (!$config) {
        push @errs, ['error_finding_config_entry', 'cn=config',
                     $conn->getErrorString()];
        return @errs;
    }

    ($rc, @errs) = isOffline($inf, $inst, $conn);
    if (!$rc) {
        return @errs;
    }

    my $reindex = "/usr/bin/db2index -Z $inst";
    my @errs;
    my $instconf = $conn->search("cn=ldbm database,cn=plugins,cn=config", "onelevel", "(objectclass=*)");
    if (!$instconf) {
        push @errs, ['error_finding_config_entry', 'cn=*,cn=ldbm database,cn=plugins,cn=config', $conn->getErrorString()];
        return @errs;
    }

    my $dbconf = $conn->search("cn=config,cn=ldbm database,cn=plugins,cn=config", "base", "(objectclass=*)");
    if (!$dbconf) {
        push @errs, ['error_finding_config_entry',
                     'cn=config,cn=ldbm database,cn=plugins,cn=config',
                     $conn->getErrorString()];
        return @errs;
    }

    # Get the value of nsslapd-subtree-rename-switch.
    my $switch = $dbconf->getValues('nsslapd-subtree-rename-switch');
    if ("" eq $switch) {
        return (); # subtree-rename-switch does not exist; do nothing.
    } elsif ("off" eq $switch || "OFF" eq $switch) {
        return (); # subtree-rename-switch is OFF; do nothing.
    }

    my $dbdir = $dbconf->getValues('nsslapd-directory');
    my $dbversion0 = $dbdir . "/DBVERSION";
    my $rdn_format = 0;
    my $dbversionstr = "";
    if (!open(DBVERSION, "$dbversion0")) {
        push @errs, ['error_opening_file', $dbversion0, $!];
        return @errs;
    } else {
        while (<DBVERSION>) {
            if ($_ =~ /rdn-format/) {
                $rdn_format = 1;
                $dbversionstr = $_;
                if ($_ =~ /rdn-format-1/) {
                    $rdn_format = 2;
                } elsif ($_ =~ /rdn-format-2/) {
                    $rdn_format = 3;
                } elsif ($_ =~ /rdn-format-3/) {
                    $rdn_format = 4;
                } elsif ($_ =~ /rdn-format-4/) {
                    $rdn_format = 5;
                } elsif ($_ =~ /rdn-format-5/) {
                    $rdn_format = 6;
                } elsif ($_ =~ /rdn-format-/) {
                    # assume greater than -5
                    $rdn_format = 7;
                }
            }
        }
        close DBVERSION;
    }

    while ($instconf) {
        my $backend= $instconf->getValues('cn');
        if (($backend eq "config") || ($backend eq "monitor")) {
            goto NEXT;
        }

        for (my $idx = 0; $ <= $#toreindex; $idx++) {
            if (0 == $rdnconditions[$idx] || $rdnconditions[$idx] > $rdn_format) {
                my $rc = system("$reindex -n $backend -t $idx");
                if ($rc) {
                    push @errs, ["error_reindexng", $idx, $backend, $rc];
                }
            }
        }
NEXT:
        $instconf = $conn->nextEntry();
    }

    return @errs;
}
