/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2GlsAdapter;
import com.dickimawbooks.bib2gls.Bib2GlsBibParser;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.Bib2GlsMessages;
import com.dickimawbooks.bib2gls.Bib2GlsSyntaxException;
import com.dickimawbooks.bib2gls.BibGlsContributor;
import com.dickimawbooks.bib2gls.BibGlsDateTime;
import com.dickimawbooks.bib2gls.EnableTagging;
import com.dickimawbooks.bib2gls.FlattenedPostSort;
import com.dickimawbooks.bib2gls.FlattenedPreSort;
import com.dickimawbooks.bib2gls.GlsEntryFieldValue;
import com.dickimawbooks.bib2gls.GlsEntryParentName;
import com.dickimawbooks.bib2gls.GlsHierName;
import com.dickimawbooks.bib2gls.GlsHyperLink;
import com.dickimawbooks.bib2gls.GlsRecord;
import com.dickimawbooks.bib2gls.GlsRecordNameRef;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GlsSeeRecord;
import com.dickimawbooks.bib2gls.GlsUseField;
import com.dickimawbooks.bib2gls.HrefChar;
import com.dickimawbooks.bib2gls.PatternReplace;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.FontEncoding;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.auxfile.AuxData;
import com.dickimawbooks.texparserlib.auxfile.AuxParser;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.html.L2HStringConverter;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.AtSecondOfTwo;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.NewCommand;
import com.dickimawbooks.texparserlib.latex.fontenc.FontEncSty;
import com.dickimawbooks.texparserlib.latex.mfirstuc.CapitaliseWords;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MakeFirstUc;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MfirstucSty;
import com.dickimawbooks.texparserlib.latex.textcase.MakeTextLowercase;
import com.dickimawbooks.texparserlib.latex.textcase.MakeTextUppercase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bib2Gls
implements TeXApp {
    public static final String NAME = "bib2gls";
    public static final String VERSION = "2.5";
    public static final String DATE = "2020-05-30";
    public int debugLevel = 0;
    public int verboseLevel = 0;
    private char openout_any = (char)112;
    private char openin_any = (char)97;
    private Path cwd;
    private Path texmfoutput = null;
    private Path basePath;
    private File auxFile;
    private File logFile;
    private PrintWriter logWriter = null;
    private StringWriter pending = null;
    private PrintWriter pendingWriter = null;
    public static final Pattern PATTERN_PACKAGE = Pattern.compile("Package: ([^\\s]+)(?:\\s+(\\d{4})/(\\d{2})/(\\d{2}))?.*");
    public static final Pattern PATTERN_ENCDEF = Pattern.compile("File: ([^ ]+)enc\\.def .*");
    private Vector<String> fontencList = null;
    private boolean fontspec = false;
    private boolean hyperref = false;
    private boolean createHyperGroups = true;
    private boolean checkNonBibFields = true;
    private boolean warnUnknownEntryTypes = true;
    private int altModifier = -1;
    private Vector<GlsResource> glsresources;
    private Vector<String> fields;
    private Vector<GlsRecord> records;
    private Vector<GlsSeeRecord> seeRecords;
    private Vector<String> selectedEntries;
    private Vector<String> knownGlossaries = null;
    public static final String[] SPAWN_SPECIAL_FIELDS = new String[]{"progeny", "progenitor", "adoptparents"};
    public static final String[] DUAL_SPECIAL_FIELDS = new String[]{"dualprefix", "dualprefixplural", "dualprefixfirst", "dualprefixfirstplural"};
    private static final String[] NON_BIB_FIELDS = new String[]{"bibtexcontributor", "bibtexentry", "childcount", "childlist", "siblingcount", "siblinglist", "dual", "group", "indexcounter", "location", "loclist", "originalentrytype", "primarylocations", "progenitor", "progeny", "recordcount", "secondarygroup", "secondarysort", "currcount", "desc", "descplural", "firstpl", "flag", "index", "level", "longpl", "prevcount", "prevunitmax", "prevunittotal", "shortpl", "sortvalue", "unitlist", "useri", "userii", "useriii", "useriv", "userv", "uservi"};
    private HashMap<String, String> glsLike;
    private HashMap<String, String> fieldMap;
    private HashMap<String, String> formatMap;
    private HashMap<GlsRecord, Integer> recordCount = null;
    private Vector<File> texFiles;
    private boolean addGroupField = false;
    private boolean saveRecordCount = false;
    private boolean saveRecordCountUnit = false;
    private boolean commonCommandsDone = false;
    private Charset texCharset = null;
    private boolean useCiteAsRecord = false;
    private boolean mergeWrGlossaryLocations = true;
    private byte mergeNameRefOn = (byte)3;
    private static final byte MERGE_NAMEREF_ON_HREF = 0;
    private static final byte MERGE_NAMEREF_ON_TITLE = 1;
    private static final byte MERGE_NAMEREF_ON_LOCATION = 2;
    private static final byte MERGE_NAMEREF_ON_HCOUNTER = 3;
    private Bib2GlsMessages messages;
    private boolean mfirstucProtect = true;
    private boolean mfirstucMProtect = true;
    private String[] mfirstucProtectFields = null;
    private String shortcuts = null;
    private boolean checkAcroShortcuts = false;
    private boolean checkAbbrvShortcuts = false;
    private GlsResource currentResource = null;
    private String docLocale = null;
    private Locale defaultLocale = null;
    private boolean trimFields = false;
    private Vector<String> trimOnlyFields = null;
    private Vector<String> trimExceptFields = null;
    private boolean expandFields = false;
    private boolean interpret = true;
    private Vector<String> packages = null;
    private Vector<String> ignorePackages = null;
    private Vector<String> customPackages = null;
    public static final String[] AUTO_SUPPORT_PACKAGES = new String[]{"amsmath", "amssymb", "bpchem", "fontenc", "fontspec", "fourier", "hyperref", "lipsum", "mhchem", "MnSymbol", "natbib", "pifont", "siunitx", "stix", "textcase", "textcomp", "tipa", "upgreek", "wasysym"};
    public static final String[] EXTRA_SUPPORTED_PACKAGES = new String[]{"booktabs", "color", "datatool-base", "datatool", "etoolbox", "graphics", "graphicx", "ifthen", "jmlrutils", "mfirstuc-english", "probsoln", "shortvrb", "xspace"};
    private TeXParser interpreter = null;
    private boolean useNonBreakSpace = true;
    private boolean forceCrossResourceRefs = false;
    private boolean supportUnicodeSubSuperScripts = true;
    private boolean multiSuppSupported = false;
    private String glossariesExtraVersion = "????/??/??";
    private Vector<String> dependencies = null;
    private HashMap<String, String> kpsewhichResults;
    private int exitCode;
    private boolean shownVersion = false;
    private String[] nestedLinkCheckFields = new String[]{"name", "text", "plural", "first", "firstplural", "long", "longplural", "short", "shortplural", "symbol"};
    public static final String MIN_MULTI_SUPP_VERSION = "1.36";
    public static final int MIN_MULTI_SUPP_YEAR = 2018;
    public static final int MIN_MULTI_SUPP_MONTH = 8;
    public static final int MIN_MULTI_SUPP_DAY = 18;
    public static final int SUPERSCRIPT_ZERO = 8304;
    public static final int SUPERSCRIPT_ONE = 185;
    public static final int SUPERSCRIPT_TWO = 178;
    public static final int SUPERSCRIPT_THREE = 179;
    public static final int SUPERSCRIPT_FOUR = 8308;
    public static final int SUPERSCRIPT_FIVE = 8309;
    public static final int SUPERSCRIPT_SIX = 8310;
    public static final int SUPERSCRIPT_SEVEN = 8311;
    public static final int SUPERSCRIPT_EIGHT = 8312;
    public static final int SUPERSCRIPT_NINE = 8313;
    public static final int SUPERSCRIPT_PLUS = 8314;
    public static final int SUPERSCRIPT_MINUS = 8315;
    public static final int SUBSCRIPT_ZERO = 8320;
    public static final int SUBSCRIPT_ONE = 8321;
    public static final int SUBSCRIPT_TWO = 8322;
    public static final int SUBSCRIPT_THREE = 8323;
    public static final int SUBSCRIPT_FOUR = 8324;
    public static final int SUBSCRIPT_FIVE = 8325;
    public static final int SUBSCRIPT_SIX = 8326;
    public static final int SUBSCRIPT_SEVEN = 8327;
    public static final int SUBSCRIPT_EIGHT = 8328;
    public static final int SUBSCRIPT_NINE = 8329;
    public static final int SUBSCRIPT_PLUS = 8330;
    public static final int SUBSCRIPT_MINUS = 8331;
    public static final int MINUS = 8722;
    public static final String SUBSCRIPT_INT_PATTERN = String.format("[%c%c]?[%c%c%c%c%c%c%c%c%c%c]+", 8330, 8331, 8320, 8321, 8322, 8323, 8324, 8325, 8326, 8327, 8328, 8329);
    public static final String SUPERSCRIPT_INT_PATTERN = String.format("[%c%c]?[%c%c%c%c%c%c%c%c%c%c]+", 8314, 8315, 8304, 185, 178, 179, 8308, 8309, 8310, 8311, 8312, 8313);
    public static final Pattern INT_PATTERN = Pattern.compile(String.format("([+-%c]?\\p{javaDigit}+|%s|%s).*", 8722, SUBSCRIPT_INT_PATTERN, SUPERSCRIPT_INT_PATTERN));

    public Bib2Gls(int n, int n2, String string) throws IOException, InterruptedException, Bib2GlsException {
        this.kpsewhichResults = new HashMap();
        try {
            this.pending = new StringWriter();
            this.pendingWriter = new PrintWriter(this.pending);
        }
        catch (Throwable throwable) {
            this.pendingWriter = null;
        }
        this.debugLevel = n;
        this.verboseLevel = n2;
        this.shownVersion = false;
        if (n > 0 && n2 > -1) {
            this.version();
            this.shownVersion = true;
        }
        this.initMessages(string);
        this.initSecuritySettings();
        if (this.verboseLevel >= 0 && !this.shownVersion) {
            this.version();
            this.shownVersion = true;
        }
        this.formatMap = new HashMap();
        this.texFiles = new Vector();
        this.packages = new Vector();
    }

    private void initSecuritySettings() throws IOException, InterruptedException, Bib2GlsException {
        File file;
        String string;
        int n;
        String string2 = this.kpsewhich("--var-value=openin_any");
        String string3 = this.kpsewhich("--var-value=openout_any");
        int n2 = string2 == null || string2.isEmpty() ? -1 : (int)string2.charAt(0);
        int n3 = n = string3 == null || string3.isEmpty() ? -1 : (int)string3.charAt(0);
        if (n2 == 97 || n2 == 112 || n2 == 114) {
            this.openin_any = (char)n2;
        } else if (n2 == -1) {
            this.debugMessage("error.missing.value", "openin_any");
            this.openin_any = (char)97;
        } else {
            this.warningMessage("error.invalid.opt.value", "openin_any", string2);
            this.openin_any = (char)97;
        }
        if (n == 97 || n == 112 || n == 114) {
            this.openout_any = (char)n;
        } else if (n == -1) {
            this.debugMessage("error.missing.value", "openout_any");
            this.openout_any = (char)112;
        } else {
            this.warningMessage("error.invalid.opt.value", "openout_any", string3);
            this.openout_any = (char)112;
        }
        try {
            string = this.kpsewhich("--var-value=TEXMFOUTPUT");
            if (string != null && !string.isEmpty()) {
                file = new TeXPath(null, string, false).getFile();
                if (file.isDirectory()) {
                    this.texmfoutput = file.toPath();
                } else {
                    System.err.println("TEXMFOUT not a directory: " + string);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = System.getProperty("user.dir");
        if (string == null) {
            throw new IOException("Can't determine current working directory");
        }
        file = new File(string);
        if (!file.isDirectory()) {
            throw new IOException("CWD is not a directory: " + string);
        }
        this.cwd = file.toPath();
    }

    public void checkReadAccess(TeXPath teXPath) throws IOException {
        if (!this.isReadAccessAllowed(teXPath)) {
            throw new IOException(this.getMessage("error.openin.forbidden", teXPath));
        }
    }

    public void checkReadAccess(Path path) throws IOException {
        if (!this.isReadAccessAllowed(path)) {
            throw new IOException(this.getMessage("error.openin.forbidden", path));
        }
    }

    public void checkReadAccess(File file) throws IOException {
        if (!this.isReadAccessAllowed(file.toPath())) {
            throw new IOException(this.getMessage("error.openin.forbidden", Character.valueOf(this.openin_any), file));
        }
    }

    @Override
    public boolean isReadAccessAllowed(TeXPath teXPath) {
        Path path;
        this.debugMessage("message.checking.read", teXPath);
        if (this.openin_any == 'a') {
            return true;
        }
        if (teXPath.isHidden()) {
            return false;
        }
        if (this.openin_any == 'r') {
            return true;
        }
        if (teXPath.wasFoundByKpsewhich()) {
            return true;
        }
        Path path2 = teXPath.getBaseDir();
        Path path3 = teXPath.getRelativePath();
        Path path4 = path = path2 == null ? path3.normalize() : path2.resolve(path3).normalize();
        if (path.isAbsolute()) {
            if (path.startsWith(this.cwd)) {
                return true;
            }
            if (this.texmfoutput != null) {
                return path.startsWith(this.texmfoutput);
            }
            return false;
        }
        return path.toAbsolutePath().normalize().startsWith(this.cwd);
    }

    @Override
    public boolean isReadAccessAllowed(File file) {
        return this.isReadAccessAllowed(file.toPath());
    }

    public boolean isReadAccessAllowed(Path path) {
        this.debugMessage("message.checking.read", path);
        if (this.openin_any == 'a') {
            return true;
        }
        if (this.isHidden(path)) {
            return false;
        }
        if (this.openin_any == 'r') {
            return true;
        }
        if (path.isAbsolute()) {
            if ((path = path.normalize()).startsWith(this.cwd)) {
                return true;
            }
            String string = this.kpsewhichResults.get(path.getName(path.getNameCount() - 1).toString());
            if (string != null) {
                File file;
                if (File.separatorChar == '/') {
                    file = new File(string);
                } else {
                    String[] stringArray = string.split("/");
                    file = new File(stringArray[0] + File.separator);
                    for (int i = 0; i < stringArray.length; ++i) {
                        file = new File(file, stringArray[i]);
                    }
                }
                try {
                    if (Files.isSameFile(path, file.toPath())) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    this.debug(iOException);
                }
            }
            if (this.texmfoutput != null) {
                return path.startsWith(this.texmfoutput);
            }
            return false;
        }
        return path.toAbsolutePath().normalize().startsWith(this.cwd);
    }

    public void checkWriteAccess(Path path) throws IOException {
        if (!this.isWriteAccessAllowed(path)) {
            throw new IOException(this.getMessage("error.openout.forbidden", path));
        }
    }

    public void checkWriteAccess(File file) throws IOException {
        if (!this.isWriteAccessAllowed(file.toPath())) {
            throw new IOException(this.getMessage("error.openout.forbidden", file));
        }
    }

    public void registerTeXFile(File file) throws IOException {
        this.checkWriteAccess(file);
        if (this.texFiles.contains(file)) {
            throw new IOException(this.getMessage("error.duplicate.resource", file));
        }
        this.texFiles.add(file);
    }

    @Override
    public boolean isWriteAccessAllowed(TeXPath teXPath) {
        return this.isWriteAccessAllowed(teXPath.getPath());
    }

    @Override
    public boolean isWriteAccessAllowed(File file) {
        return this.isWriteAccessAllowed(file.toPath());
    }

    public boolean isWriteAccessAllowed(Path path) {
        this.debugMessage("message.checking.write", path);
        String string = path.getName(path.getNameCount() - 1).toString().toLowerCase();
        int n = string.lastIndexOf(".");
        if (n > -1 && ((string = string.substring(n + 1)).equals("tex") || string.equals("ltx") || string.equals("sty") || string.equals("cls") || string.equals("bib") || string.equals("dtx") || string.equals("ins") || string.equals("def") || string.equals("ldf"))) {
            if (this.debugLevel > 0) {
                this.logAndPrintMessage(this.getMessageWithFallback("error.forbidden.ext", "Write access forbidden for extension: {0}", string));
            }
            return false;
        }
        if (this.openout_any == 'a') {
            return true;
        }
        if (this.isHidden(path)) {
            return false;
        }
        if (this.openout_any == 'r') {
            return true;
        }
        if (path.isAbsolute()) {
            if ((path = path.normalize()).startsWith(this.cwd)) {
                return true;
            }
            if (this.texmfoutput != null) {
                return path.startsWith(this.texmfoutput);
            }
            return false;
        }
        return path.toAbsolutePath().normalize().startsWith(this.cwd);
    }

    public boolean isHidden(Path path) {
        for (int i = path.getNameCount() - 1; i >= 0; --i) {
            String string = path.getName(i).toString();
            if (!string.startsWith(".") || string.equals(".") || string.equals("..")) continue;
            return true;
        }
        return false;
    }

    public File getWritableFile(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = this.cwd.toFile();
        }
        if (this.texmfoutput != null && !file2.canWrite()) {
            this.warningMessage("warning.dir.no.write", file2, this.texmfoutput);
            file = new File(this.texmfoutput.toFile(), file.getName());
        }
        this.checkWriteAccess(file);
        return file;
    }

    public Path resolvePath(Path path) {
        return this.basePath.resolve(path).normalize();
    }

    public File resolveFile(File file) {
        file = file.getParentFile() == null ? new File(this.basePath.toFile(), file.getName()) : this.basePath.resolve(file.toPath()).toFile();
        return file;
    }

    public File resolveFile(String string) {
        return this.resolveFile(new File(string));
    }

    private String texToJavaCharset(String string) throws Bib2GlsException {
        if (string.equals("ascii")) {
            return "US-ASCII";
        }
        if (string.equals("latin1")) {
            return "ISO-8859-1";
        }
        if (string.equals("latin2")) {
            return "ISO-8859-2";
        }
        if (string.equals("latin3")) {
            return "ISO-8859-3";
        }
        if (string.equals("latin4")) {
            return "ISO-8859-4";
        }
        if (string.equals("latin5")) {
            return "ISO-8859-9";
        }
        if (string.equals("latin6")) {
            return "ISO-8859-10";
        }
        if (string.equals("latin7")) {
            return "ISO-8859-13";
        }
        if (string.equals("latin8")) {
            return "ISO-8859-14";
        }
        if (string.equals("latin9")) {
            return "ISO-8859-15";
        }
        if (string.equals("latin10")) {
            return "ISO-8859-16";
        }
        if (string.equals("decmulti")) {
            return "DEC-MCS";
        }
        if (string.equals("cp850")) {
            return "Cp850";
        }
        if (string.equals("cp852")) {
            return "Cp852";
        }
        if (string.equals("cp858")) {
            return "Cp858";
        }
        if (string.equals("cp437") || string.equals("cp437de")) {
            return "Cp437";
        }
        if (string.equals("cp865")) {
            return "Cp865";
        }
        if (string.equals("applemac")) {
            return "MacRoman";
        }
        if (string.equals("macce")) {
            return "MacCentralEurope";
        }
        if (!string.equals("next")) {
            if (string.equals("cp1250")) {
                return "Cp1250";
            }
            if (string.equals("cp1252") || string.equals("ansinew")) {
                return "Cp1252";
            }
            if (string.equals("cp1257")) {
                return "Cp1257";
            }
            if (string.equals("utf8")) {
                return "UTF-8";
            }
        }
        throw new Bib2GlsException(string);
    }

    public boolean suppressFieldExpansion() {
        return !this.expandFields;
    }

    public boolean useNonBreakSpace() {
        return this.useNonBreakSpace;
    }

    public boolean useInterpreter() {
        return this.interpret;
    }

    public L2HStringConverter getInterpreterListener() {
        return this.interpreter == null ? null : (L2HStringConverter)this.interpreter.getListener();
    }

    public TeXObjectList getWordExceptionList() {
        ControlSequence controlSequence = this.interpreter.getControlSequence("@mfu@nocaplist");
        if (controlSequence == null) {
            return null;
        }
        TeXObjectList teXObjectList = null;
        if (controlSequence instanceof GenericCommand) {
            teXObjectList = ((GenericCommand)controlSequence).getDefinition();
        }
        return teXObjectList;
    }

    public Vector<String> getPackages() {
        return this.packages;
    }

    public boolean fontSpecLoaded() {
        return this.fontspec;
    }

    public boolean hyperrefLoaded() {
        return this.hyperref;
    }

    public boolean createHyperGroupsOn() {
        return this.createHyperGroups;
    }

    public void setCreateHyperGroups(boolean bl) {
        this.createHyperGroups = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLog() throws IOException {
        String string = this.auxFile.getName();
        String string2 = string;
        int n = string2.lastIndexOf(".aux");
        if (n < 1) {
            this.debug("Can't determine log file from " + this.auxFile);
            return;
        }
        String string3 = string2.substring(0, n);
        string2 = string3 + ".log";
        File file = new File(this.auxFile.getParentFile(), string2);
        BufferedReader bufferedReader = null;
        for (String object : this.packages) {
            if (!object.equals("fontspec")) continue;
            this.fontspec = true;
            break;
        }
        try {
            this.checkReadAccess(file);
            bufferedReader = new BufferedReader(new FileReader(file));
            Iterator<String> iterator = null;
            while ((iterator = bufferedReader.readLine()) != null) {
                Matcher matcher = PATTERN_PACKAGE.matcher((CharSequence)((Object)iterator));
                if (matcher.matches()) {
                    String string4 = matcher.group(1).toLowerCase();
                    if (string4.equals("glossaries-extra")) {
                        try {
                            Calendar calendar = Calendar.getInstance();
                            calendar.set(2017, 1, 3);
                            int n2 = Integer.parseInt(matcher.group(2));
                            int n3 = Integer.parseInt(matcher.group(3));
                            int n4 = Integer.parseInt(matcher.group(4));
                            Calendar calendar2 = Calendar.getInstance();
                            calendar2.set(n2, n3 - 1, n4);
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                            this.glossariesExtraVersion = simpleDateFormat.format(calendar2.getTime());
                            if (calendar2.compareTo(calendar) < 0) {
                                this.warningMessage("error.sty.too.old", "glossaries-extra", this.glossariesExtraVersion, simpleDateFormat.format(calendar.getTime()));
                                continue;
                            }
                            calendar.set(2018, 7, 18);
                            this.multiSuppSupported = calendar2.compareTo(calendar) >= 0;
                        }
                        catch (Exception exception) {
                            this.warningMessage("error.no.sty.version", "glossaries-extra");
                            this.debug(exception);
                        }
                        continue;
                    }
                    if (this.ignorePackages != null && this.ignorePackages.contains(string4)) continue;
                    if (string4.equals("hyperref")) {
                        this.hyperref = true;
                        continue;
                    }
                    if (string4.equals("fontspec")) {
                        this.fontspec = true;
                        continue;
                    }
                    if (!Bib2Gls.isAutoSupportPackage(string4)) continue;
                    this.packages.add(string4);
                    continue;
                }
                Matcher matcher2 = PATTERN_ENCDEF.matcher((CharSequence)((Object)iterator));
                if (matcher2.matches()) {
                    if (this.fontencList == null) {
                        this.fontencList = new Vector();
                    }
                    this.fontencList.add(matcher2.group(1));
                    continue;
                }
                if (!((String)((Object)iterator)).contains(string)) continue;
                break;
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        if (this.debugLevel > 0 && this.packages.size() > 0) {
            if (this.packages.size() == 1) {
                this.debugMessage("message.1.sty", new Object[0]);
            } else {
                this.debugMessage("message.2.sty", this.packages.size());
            }
            for (String string5 : this.packages) {
                this.debug(string5);
            }
            this.debug();
        }
    }

    public String getGlossariesExtraVersion() {
        return this.glossariesExtraVersion;
    }

    public static boolean isAutoSupportPackage(String string) {
        for (String string2 : AUTO_SUPPORT_PACKAGES) {
            if (string2.compareToIgnoreCase(string) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtraSupportedPackage(String string) {
        for (String string2 : EXTRA_SUPPORTED_PACKAGES) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownPackage(String string) {
        return Bib2Gls.isAutoSupportPackage(string) || Bib2Gls.isExtraSupportedPackage(string);
    }

    private void initInterpreter(Vector<AuxData> vector) throws IOException {
        L2HStringConverter l2HStringConverter = new L2HStringConverter(new Bib2GlsAdapter(this), vector, this.customPackages != null){

            @Override
            public void writeCodePoint(int n) throws IOException {
                if (this.getWriter() == null) {
                    return;
                }
                if (n == 38) {
                    this.getWriter().write("&amp;");
                } else if (n == 60) {
                    this.getWriter().write("&le;");
                } else if (n == 62) {
                    this.getWriter().write("&ge;");
                } else {
                    this.getWriter().write(new String(Character.toChars(n)));
                }
            }

            @Override
            public void parsePackageFile(LaTeXSty laTeXSty) throws IOException {
                if (this.isParsePackageSupportOn() && Bib2Gls.this.customPackages.contains(laTeXSty.getName())) {
                    laTeXSty.parseFile();
                }
            }
        };
        l2HStringConverter.setUseMathJax(false);
        l2HStringConverter.setIsInDocEnv(true);
        l2HStringConverter.setSupportUnicodeScript(this.supportUnicodeSubSuperScripts);
        this.interpreter = new TeXParser(l2HStringConverter);
        this.interpreter.setCatCode(64, 11);
        MfirstucSty mfirstucSty = (MfirstucSty)l2HStringConverter.usepackage(null, "mfirstuc", false);
        Vector<String> vector2 = this.getPackages();
        if (vector2 != null) {
            for (String string : vector2) {
                LaTeXSty laTeXSty = l2HStringConverter.usepackage(null, string, false);
                if (this.fontencList == null || !string.equals("fontenc")) continue;
                if (laTeXSty == null || !(laTeXSty instanceof FontEncSty)) {
                    laTeXSty = l2HStringConverter.getFontEncSty();
                }
                if (laTeXSty == null || !(laTeXSty instanceof FontEncSty)) continue;
                for (String string2 : this.fontencList) {
                    this.debugMessage("message.detected.fontenc", string2);
                    FontEncoding fontEncoding = ((FontEncSty)laTeXSty).getEncoding(string2.toUpperCase());
                    if (fontEncoding == null) continue;
                    fontEncoding.addDefinitions(this.interpreter.getSettings());
                }
                this.fontencList = null;
            }
        }
        l2HStringConverter.putControlSequence(new NewCommand("renewcommand", 3));
        l2HStringConverter.putControlSequence(new NewCommand("glsxtrprovidecommand", 3));
        l2HStringConverter.putControlSequence(new MakeTextUppercase("bibglsuppercase"));
        l2HStringConverter.putControlSequence(new MakeTextLowercase("bibglslowercase"));
        l2HStringConverter.putControlSequence(new MakeFirstUc("bibglsfirstuc"));
        l2HStringConverter.putControlSequence(new CapitaliseWords(mfirstucSty, "bibglstitlecase"));
        l2HStringConverter.putControlSequence(new EnableTagging());
        l2HStringConverter.putControlSequence(new AtFirstOfTwo("bibglscontributorlist"));
        l2HStringConverter.putControlSequence(new AtFirstOfTwo("bibglshyperlink"));
        l2HStringConverter.putControlSequence(new GlsHyperLink(this));
        l2HStringConverter.putControlSequence(new BibGlsContributor(this));
        l2HStringConverter.putControlSequence(new BibGlsDateTime());
        l2HStringConverter.putControlSequence(new BibGlsDateTime("bibglsdate", true, false));
        l2HStringConverter.putControlSequence(new BibGlsDateTime("bibglstime", false, true));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryname", "name", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentrytext", "text", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryshort", "short", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentrylong", "long", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryfirst", "first", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentrysymbol", "symbol", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryuseri", "user1", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryuserii", "user2", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryuseriii", "user3", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryuseriv", "user4", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryuserv", "user5", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryuservi", "user6", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryplural", "plural", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryfirstplural", "firstplural", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentryshortpl", "shortplural", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentrylongpl", "longplural", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsentrysymbolplural", "symbolplural", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryname", "name", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentrytext", "text", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryshort", "short", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentrylong", "long", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryfirst", "first", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentrysymbol", "symbol", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryuseri", "user1", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryuserii", "user2", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryuseriii", "user3", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryuseriv", "user4", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryuserv", "user5", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryuservi", "user6", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryplural", "plural", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryfirstplural", "firstplural", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentryshortpl", "shortplural", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentrylongpl", "longplural", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsentrysymbolplural", "symbolplural", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessname", "name", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccesstext", "text", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessshort", "short", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccesslong", "long", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessfirst", "first", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccesssymbol", "symbol", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessuseri", "user1", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessuserii", "user2", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessuseriii", "user3", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessuseriv", "user4", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessuserv", "user5", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessuservi", "user6", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessplural", "plural", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessfirstplural", "firstplural", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccessshortpl", "shortplural", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccesslongpl", "longplural", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("glsaccesssymbolplural", "symbolplural", this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessname", "name", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccesstext", "text", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessshort", "short", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccesslong", "long", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessfirst", "first", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccesssymbol", "symbol", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessuseri", "user1", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessuserii", "user2", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessuseriii", "user3", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessuseriv", "user4", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessuserv", "user5", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessuservi", "user6", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessplural", "plural", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessfirstplural", "firstplural", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccessshortpl", "shortplural", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccesslongpl", "longplural", 1, this));
        l2HStringConverter.putControlSequence(new GlsEntryFieldValue("Glsaccesssymbolplural", "symbolplural", 1, this));
        l2HStringConverter.putControlSequence(new GlsUseField(this));
        l2HStringConverter.putControlSequence(new GlsUseField("Glsxtrusefield", 1, this));
        l2HStringConverter.putControlSequence(new GlsUseField("GLSxtrusefield", 2, this));
        l2HStringConverter.putControlSequence(new GlsUseField("glsentrytitlecase", 3, this));
        l2HStringConverter.putControlSequence(new GlsEntryParentName(this));
        l2HStringConverter.putControlSequence(new GenericCommand("glsxtrhiernamesep", null, l2HStringConverter.createString(".")));
        l2HStringConverter.putControlSequence(new GlsHierName(this));
        l2HStringConverter.putControlSequence(new GlsHierName("Glsxtrhiername", 1, true, this));
        l2HStringConverter.putControlSequence(new GlsHierName("GlsXtrhiername", 1, false, this));
        l2HStringConverter.putControlSequence(new GlsHierName("GLSxtrhiername", 2, true, this));
        l2HStringConverter.putControlSequence(new GlsHierName("GLSXTRhiername", 2, false, this));
        l2HStringConverter.putControlSequence(l2HStringConverter.createSymbol("bibglshashchar", 35));
        l2HStringConverter.putControlSequence(l2HStringConverter.createSymbol("bibglsunderscorechar", 95));
        l2HStringConverter.putControlSequence(l2HStringConverter.createSymbol("bibglsdollarchar", 36));
        l2HStringConverter.putControlSequence(l2HStringConverter.createSymbol("bibglsampersandchar", 38));
        l2HStringConverter.putControlSequence(l2HStringConverter.createSymbol("bibglscircumchar", 94));
        l2HStringConverter.putControlSequence(l2HStringConverter.createSymbol("glsbackslash", 92));
        l2HStringConverter.putControlSequence(l2HStringConverter.createSymbol("glstildechar", 126));
        l2HStringConverter.putControlSequence(new FlattenedPostSort());
        l2HStringConverter.putControlSequence(new FlattenedPreSort());
        l2HStringConverter.putControlSequence(new HrefChar());
        l2HStringConverter.putControlSequence(new AtSecondOfTwo("bibglshrefunicode"));
        if (this.customPackages != null) {
            for (String string : this.customPackages) {
                l2HStringConverter.usepackage(null, string, false);
            }
        }
    }

    public void provideCommand(String string, String string2) {
        if (this.interpreter != null) {
            L2HStringConverter l2HStringConverter = (L2HStringConverter)this.interpreter.getListener();
            l2HStringConverter.putControlSequence(new GenericCommand(string, null, l2HStringConverter.createString(string2)));
        }
    }

    public void processPreamble(BibValueList bibValueList) throws IOException {
        if (this.interpreter == null) {
            return;
        }
        this.interpreter.addAll(bibValueList.expand(this.interpreter));
        if (this.getDebugLevel() > 0) {
            this.logAndPrintMessage(String.format("%n%s%n%s%n%n", this.getMessage("message.parsing.code", new Object[0]), this.interpreter.toString(this.interpreter)));
        }
        while (this.interpreter.size() > 0) {
            TeXObject teXObject = this.interpreter.pop();
            teXObject.process(this.interpreter);
        }
    }

    public String interpret(String string, BibValueList bibValueList, boolean bl) {
        if (this.interpreter == null) {
            return string;
        }
        try {
            Object object;
            L2HStringConverter l2HStringConverter = (L2HStringConverter)this.interpreter.getListener();
            StringWriter stringWriter = new StringWriter();
            l2HStringConverter.setWriter(stringWriter);
            TeXObjectList teXObjectList = bibValueList.expand(this.interpreter);
            if (teXObjectList == null) {
                return string;
            }
            teXObjectList = (TeXObjectList)teXObjectList.clone();
            this.interpreter.addAll(teXObjectList);
            if (this.getDebugLevel() > 0) {
                this.logAndPrintMessage(String.format("%n%s%n%s%n%n", this.getMessage("message.parsing.code", new Object[0]), this.interpreter.toString(this.interpreter)));
            }
            while (this.interpreter.size() > 0) {
                object = this.interpreter.pop();
                object.process(this.interpreter);
            }
            object = stringWriter.toString();
            if (this.getDebugLevel() > 0) {
                this.logAndPrintMessage(String.format("texparserlib:--> %s", object));
            }
            object = ((String)object).replaceAll("<[^>]+>", "");
            object = ((String)object).replaceAll("\\&le;", "<");
            object = ((String)object).replaceAll("\\&ge;", ">");
            object = ((String)object).replaceAll("\\&amp;", "&");
            if (bl) {
                object = ((String)object).trim();
            }
            this.logMessage(String.format("texparserlib: %s -> %s", string, object));
            return object;
        }
        catch (IOException iOException) {
            if (this.getDebugLevel() > 0) {
                this.debug("texparserlib: ");
                this.debug(iOException);
            }
            return string;
        }
    }

    public String convertToLabel(TeXParser teXParser, BibValueList bibValueList, GlsResource glsResource, boolean bl) throws IOException {
        Vector<PatternReplace> vector;
        String string;
        TeXObjectList teXObjectList = bibValueList.expand(teXParser);
        String string2 = string = teXObjectList.toString(teXParser);
        if (string.matches("(?s).*[\\\\\\{\\}\\~\\$].*")) {
            string = this.interpret(string, bibValueList, true);
        }
        if ((vector = glsResource.getLabelifySubstitutions()) != null) {
            for (PatternReplace patternReplace : vector) {
                string = patternReplace.replaceAll(string);
            }
        }
        String string3 = " \\.\\-\\+\\:\\;\\|\\/\\!\\?\\*\\<\\>\\@\\'\\`";
        string = bl ? string.replaceAll("[^," + (String)string3 + "\\p{IsAlphabetic}\\p{IsDigit}]", "") : string.replaceAll("[^" + (String)string3 + "\\p{IsAlphabetic}\\p{IsDigit}]", "");
        if (!this.fontSpecLoaded()) {
            string = Normalizer.normalize(string, Normalizer.Form.NFD);
            string = string.replaceAll("[^," + (String)string3 + "a-zA-Z0-9]", "");
        }
        if (bl) {
            string = string.replaceAll(",,+", ",");
            string = string.replaceAll("^,|,$", "");
        }
        if (!(this.verboseLevel <= 0 || string2.equals(string) && this.debugLevel <= 0)) {
            this.logMessage(String.format("%s: %s -> %s", bl ? "labelify-list" : "labelify", string2, string));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String[] stringArray) throws IOException, InterruptedException, Bib2GlsException {
        int n;
        this.parseArgs(stringArray);
        if (this.saveRecordCount) {
            this.recordCount = new HashMap();
        }
        try {
            this.parseLog();
        }
        catch (IOException iOException) {
            this.warningMessage("warning.cant.parse.file", this.logFile, iOException.getMessage());
            this.debug(iOException);
        }
        if (this.texCharset == null && this.fontspec) {
            try {
                this.texCharset = Charset.forName("UTF-8");
            }
            catch (Exception exception) {
                this.debug(exception);
            }
        }
        AuxParser auxParser = new AuxParser(this, this.texCharset){

            @Override
            protected void addPredefined() {
                super.addPredefined();
                this.addAuxCommand("glsxtr@resource", 2);
                this.addAuxCommand("glsxtr@fields", 1);
                this.addAuxCommand("glsxtr@record", 5);
                this.addAuxCommand("glsxtr@recordsee", 2);
                this.addAuxCommand("glsxtr@record@nameref", 8);
                this.addAuxCommand("glsxtr@texencoding", 1);
                this.addAuxCommand("glsxtr@langtag", 1);
                this.addAuxCommand("glsxtr@shortcutsval", 1);
                this.addAuxCommand("glsxtr@pluralsuffixes", 4);
                this.addAuxCommand("@glsxtr@altmodifier", 1);
                this.addAuxCommand("@glsxtr@newglslike", 2);
                this.addAuxCommand("@glsxtr@prefixlabellist", 1);
                if (Bib2Gls.this.knownGlossaries != null) {
                    this.addAuxCommand("@newglossary", 4);
                }
            }
        };
        TeXParser teXParser = auxParser.parseAuxFile(this.auxFile);
        this.glsresources = new Vector();
        this.fields = new Vector();
        this.fieldMap = new HashMap();
        this.records = new Vector();
        this.seeRecords = new Vector();
        this.selectedEntries = new Vector();
        Vector<AuxData> vector = auxParser.getAuxData();
        if (this.interpret) {
            this.initInterpreter(vector);
        }
        Vector<AuxData> vector2 = new Vector<AuxData>();
        String string = "s";
        String string2 = "s";
        String string3 = "s";
        String string4 = "s";
        for (AuxData auxData : vector) {
            String string5;
            String string6;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string7 = auxData.getName();
            if (string7.equals("glsxtr@resource")) {
                object4 = auxData.getArg(1);
                if (object4 instanceof TeXObjectList) {
                    for (int i = ((TeXObjectList)object4).size() - 1; i >= 0; --i) {
                        object3 = (TeXObject)((TeXObjectList)object4).get(i);
                        if (!(object3 instanceof CharObject) || ((CharObject)object3).getCharCode() != 34) continue;
                        ((TeXObjectList)object4).remove(i);
                    }
                }
                vector2.add(auxData);
                continue;
            }
            if (string7.equals("glsxtr@shortcutsval")) {
                if (this.shortcuts != null) continue;
                this.setShortCuts(auxData.getArg(0).toString(teXParser));
                continue;
            }
            if (string7.equals("glsxtr@pluralsuffixes")) {
                string = auxData.getArg(0).toString(teXParser);
                string2 = auxData.getArg(1).toString(teXParser);
                string3 = auxData.getArg(2).toString(teXParser);
                string4 = auxData.getArg(3).toString(teXParser);
                continue;
            }
            if (string7.equals("@glsxtr@altmodifier")) {
                object4 = auxData.getArg(0).toString(teXParser).trim();
                if (((String)object4).isEmpty()) continue;
                this.altModifier = ((String)object4).codePointAt(0);
                continue;
            }
            if (string7.equals("@glsxtr@newglslike")) {
                this.addGlsLike(auxData.getArg(0).toString(teXParser), auxData.getArg(1).toString(teXParser).substring(1));
                continue;
            }
            if (string7.equals("@glsxtr@prefixlabellist")) {
                String string8;
                object4 = auxData.getArg(0).toString(teXParser).split(",");
                if (object4 == null || ((String[])object4).length <= 0 || (string8 = object4[((String[])object4).length - 1]).isEmpty()) continue;
                this.addGlsLike(string8, "dgls");
                this.addGlsLike(string8, "dGls");
                this.addGlsLike(string8, "dGLS");
                this.addGlsLike(string8, "dglspl");
                this.addGlsLike(string8, "dGlspl");
                this.addGlsLike(string8, "dGLSpl");
                this.addGlsLike(string8, "dglslink");
                this.addGlsLike(string8, "dglsdisp");
                continue;
            }
            if (string7.equals("glsxtr@langtag")) {
                this.setDocDefaultLocale(this.getLocale(auxData.getArg(0).toString(teXParser)));
                continue;
            }
            if (this.texCharset == null && string7.equals("glsxtr@texencoding")) {
                try {
                    object4 = auxData.getArg(0).toString(teXParser).trim();
                    if (((String)object4).equals("\\inputencodingname")) {
                        this.texCharset = Charset.defaultCharset();
                        continue;
                    }
                    this.texCharset = Charset.forName(this.texToJavaCharset((String)object4));
                }
                catch (Bib2GlsException bib2GlsException) {
                    this.texCharset = Charset.defaultCharset();
                    this.warningMessage("error.unknown.tex.charset", bib2GlsException.getMessage(), this.texCharset, "--tex-encoding");
                }
                continue;
            }
            if (string7.equals("glsxtr@fields")) {
                object4 = CsvList.getList(teXParser, auxData.getArg(0));
                Iterator iterator = ((Vector)object4).iterator();
                while (iterator.hasNext()) {
                    object3 = (TeXObject)iterator.next();
                    object2 = (TeXObjectList)object3;
                    object = ((TeXObjectList)object2).popArg(teXParser);
                    string6 = object.toString(teXParser);
                    this.fields.add(string6);
                    object = ((TeXObjectList)object2).popArg(teXParser);
                    string5 = object.toString(teXParser);
                    if (!string5.equals(string6)) {
                        this.fieldMap.put(string6, string5);
                    }
                    if (this.debugLevel <= 0) continue;
                    this.logAndPrintMessage("Adding field: " + string6 + " (" + string5 + ")");
                }
                continue;
            }
            if (string7.equals("glsxtr@recordsee")) {
                this.seeRecords.add(new GlsSeeRecord(auxData.getArg(0), auxData.getArg(1), teXParser));
                continue;
            }
            if (string7.equals("glsxtr@record") || this.useCiteAsRecord && string7.equals("citation") || string7.equals("glsxtr@record@nameref")) {
                Object object5;
                String string9;
                object4 = auxData.getArg(0).toString(teXParser);
                string6 = null;
                string5 = null;
                String string10 = null;
                if (auxData.getNumArgs() >= 5) {
                    string9 = auxData.getArg(1).toString(teXParser);
                    object3 = auxData.getArg(2).toString(teXParser);
                    object2 = auxData.getArg(3).toString(teXParser);
                    object = auxData.getArg(4).toString(teXParser);
                    if (auxData.getNumArgs() == 8) {
                        string6 = auxData.getArg(5).toString(teXParser);
                        string5 = auxData.getArg(6).toString(teXParser);
                        string10 = auxData.getArg(7).toString(teXParser);
                    }
                    if (((String)object3).equals("wrglossary") && (object5 = AuxData.getPageReference(vector, teXParser, "wrglossary." + (String)object)) != null) {
                        object = String.format("\\glsxtr@wrglossarylocation{%s}{%s}", object, object5.toString(teXParser));
                    }
                } else {
                    if (((String)object4).equals("*")) {
                        this.verboseMessage("message.ignored.record", "\\citation{*}");
                        continue;
                    }
                    string9 = "";
                    object3 = "page";
                    object2 = "glsignore";
                    object = "";
                }
                object5 = string6 == null ? new GlsRecord(this, (String)object4, string9, (String)object3, (String)object2, (String)object) : new GlsRecordNameRef(this, (String)object4, string9, (String)object3, (String)object2, (String)object, string6, string5, string10);
                this.incRecordCount((GlsRecord)object5);
                boolean bl = false;
                for (GlsRecord glsRecord : this.records) {
                    if (glsRecord.equals(object5)) {
                        bl = true;
                        break;
                    }
                    if (!glsRecord.partialMatch((GlsRecord)object5)) continue;
                    String string11 = ((GlsRecord)object5).getFormat();
                    String string12 = glsRecord.getFormat();
                    String string13 = "";
                    if (string11.startsWith("(") || string11.startsWith(")")) {
                        string13 = string11.substring(0, 1);
                        string11 = string11.length() == 1 ? "glsnumberformat" : string11.substring(1);
                    }
                    String string14 = "";
                    if (string12.startsWith("(") || string12.startsWith(")")) {
                        string14 = string12.substring(0, 1);
                        string12 = string12.length() == 1 ? "glsnumberformat" : string12.substring(1);
                    }
                    if (string14.equals(")") && string13.equals("(")) {
                        this.records.add((GlsRecord)object5);
                    } else if (string14.equals("(") && string13.equals(")")) {
                        if (string12.equals(string11)) {
                            this.records.add((GlsRecord)object5);
                        } else {
                            this.warningMessage("warning.conflicting.range.format", string14 + string12, string13 + string11, string13 + string12);
                            ((GlsRecord)object5).setFormat(string13 + string12);
                            ((GlsRecord)object5).setLocation(glsRecord.getLocation());
                            this.records.add((GlsRecord)object5);
                        }
                    } else if (string13.isEmpty() && !string14.isEmpty()) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string11, string14 + string12, object5, glsRecord));
                            this.logAndPrintMessage();
                        }
                    } else if (!string13.isEmpty() && string14.isEmpty()) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, glsRecord, object5));
                            this.logAndPrintMessage();
                        }
                        glsRecord.setFormat(string13 + string11);
                        glsRecord.setLocation(((GlsRecord)object5).getLocation());
                    } else if (this.isIgnoredFormat(string11)) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, object5, glsRecord));
                            this.logAndPrintMessage();
                        }
                    } else if (this.isIgnoredFormat(string12)) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, glsRecord, object5));
                            this.logAndPrintMessage();
                        }
                        glsRecord.setFormat(string13 + string11);
                        glsRecord.setLocation(((GlsRecord)object5).getLocation());
                    } else if (string11.equals("glsnumberformat")) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, object5, glsRecord));
                            this.logAndPrintMessage();
                        }
                    } else if (string12.equals("glsnumberformat")) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, glsRecord, object5));
                            this.logAndPrintMessage();
                        }
                        glsRecord.setFormat(string13 + string11);
                        glsRecord.setLocation(((GlsRecord)object5).getLocation());
                    } else {
                        String string15 = this.formatMap.get(string11);
                        String string16 = this.formatMap.get(string12);
                        if (string15 != null && string15.equals(string12)) {
                            if (this.debugLevel > 0) {
                                this.logAndPrintMessage();
                                this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record.using.map", string13 + string11, string13 + string15, object5, glsRecord));
                                this.logAndPrintMessage();
                            }
                        } else if (string16 != null && string16.equals(string11)) {
                            if (this.debugLevel > 0) {
                                this.logAndPrintMessage();
                                this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record.using.map", string12, string16, glsRecord, object5));
                                this.logAndPrintMessage();
                            }
                            glsRecord.setFormat(string13 + string11);
                            glsRecord.setLocation(((GlsRecord)object5).getLocation());
                        } else if (string16 != null && string15 != null && string16.equals(string15)) {
                            if (this.debugLevel > 0) {
                                this.logAndPrintMessage();
                                this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record.using.map2", string12, string16, string11, string15, glsRecord, object5, String.format("{%s}{%s}{%s}{%s}{%s}", glsRecord.getLabel(), glsRecord.getPrefix(), glsRecord.getCounter(), string15, glsRecord.getLocation())));
                                this.logAndPrintMessage();
                            }
                            glsRecord.setFormat(string13 + string15);
                            glsRecord.setLocation(((GlsRecord)object5).getLocation());
                        } else {
                            this.logMessage();
                            this.warningMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, object5, glsRecord);
                            this.logMessage();
                        }
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.records.add((GlsRecord)object5);
                continue;
            }
            if (this.knownGlossaries == null || !string7.equals("@newglossary")) continue;
            this.addGlossary(auxData.getArg(0).toString(teXParser));
        }
        this.provideCommand("glspluralsuffix", string);
        this.provideCommand("abbrvpluralsuffix", string2);
        this.provideCommand("acrpluralsuffix", string3);
        this.provideCommand("glsxtrabbrvpluralsuffix", string4);
        if (this.texCharset == null) {
            this.texCharset = Charset.defaultCharset();
            this.logMessage(this.getMessage("message.unknown.tex.charset", this.texCharset, "--tex-encoding"));
        } else {
            this.verboseMessage("message.tex.charset", this.texCharset);
        }
        if (this.verboseLevel > 0) {
            Object object = this.getDefaultLocale();
            if (object == null) {
                object = Locale.getDefault();
            }
            this.logMessage(this.getMessage("message.default.locale", ((Locale)object).toLanguageTag(), ((Locale)object).getDisplayName()));
        }
        for (AuxData auxData : vector2) {
            this.glsresources.add(new GlsResource(teXParser, auxData, string, string2));
        }
        if (this.glsresources.size() == 0) {
            throw new Bib2GlsException(this.getMessage("error.missing.aux.cs.require_cs_or", "glsxtr@resource", "glsxtrresourcefile", "GlsXtrLoadResources"));
        }
        if (this.fields.size() == 0) {
            this.warning(teXParser, this.getMessage("error.missing.aux.new.cs", "glsxtr@fields", "1.11"));
            this.fields.add("name");
            this.fields.add("sort");
            this.fieldMap.put("sort", "sortvalue");
            this.fields.add("type");
            this.fields.add("first");
            this.fields.add("firstplural");
            this.fieldMap.put("firstplural", "firstpl");
            this.fields.add("text");
            this.fields.add("plural");
            this.fields.add("description");
            this.fieldMap.put("description", "desc");
            this.fields.add("descriptionplural");
            this.fieldMap.put("description", "descplural");
            this.fields.add("symbol");
            this.fields.add("symbolplural");
            this.fields.add("user1");
            this.fieldMap.put("user1", "useri");
            this.fields.add("user2");
            this.fieldMap.put("user2", "userii");
            this.fields.add("user3");
            this.fieldMap.put("user3", "useriii");
            this.fields.add("user4");
            this.fieldMap.put("user4", "useriv");
            this.fields.add("user5");
            this.fieldMap.put("user5", "userv");
            this.fields.add("user6");
            this.fieldMap.put("user6", "uservi");
            this.fields.add("long");
            this.fields.add("longplural");
            this.fieldMap.put("long", "longpl");
            this.fields.add("short");
            this.fields.add("shortplural");
            this.fieldMap.put("short", "shortpl");
            this.fields.add("counter");
            this.fields.add("parent");
            this.fields.add("loclist");
            this.fields.add("see");
            this.fields.add("category");
        }
        if (this.useGroupField() && !this.fields.contains("group")) {
            this.warningMessage("warning.no_group_field", new Object[0]);
        }
        this.addField("dualshort");
        this.addField("dualshortplural");
        this.addField("duallong");
        this.addField("duallongplural");
        int n2 = 0;
        boolean bl = true;
        for (n = 0; n < this.glsresources.size(); ++n) {
            this.currentResource = this.glsresources.get(n);
            this.currentResource.parseBibFiles(teXParser);
            if (!bl || this.forceCrossResourceRefs || this.currentResource.allowsCrossResourceRefs()) continue;
            this.debugMessage("message.cross-resource.notallowed", this.currentResource);
            bl = false;
        }
        if (bl) {
            this.logMessage(this.getMessage("message.cross-resource.dep.allowed", new Object[0]));
            this.dependencies = new Vector();
            for (n = 0; n < this.glsresources.size(); ++n) {
                this.currentResource = this.glsresources.get(n);
                this.currentResource.processBibList(teXParser);
            }
            for (n = 0; n < this.glsresources.size(); ++n) {
                this.currentResource = this.glsresources.get(n);
                int n3 = this.currentResource.processData();
                if (n3 <= 0) continue;
                n2 += n3;
            }
        } else {
            this.logMessage(this.getMessage("message.cross-resource.dep.notallowed", "--force-cross-resource-refs"));
            for (n = 0; n < this.glsresources.size(); ++n) {
                this.currentResource = this.glsresources.get(n);
                this.currentResource.processBibList(teXParser);
                int n4 = this.currentResource.processData();
                if (n4 <= 0) continue;
                n2 += n4;
            }
        }
        this.currentResource = null;
        if (n2 == 0 && this.records.size() == 0) {
            this.error(this.getMessage("error.missing.records", new Object[0]));
        }
        if (this.glsresources.size() > 1) {
            this.message(this.getChoiceMessage("message.written.total", 0, "entry", 3, n2));
        }
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
            }
            finally {
                this.logWriter = null;
            }
            this.message(this.getMessage("message.log.file", this.logFile));
        }
    }

    public void registerDependencies(Bib2GlsEntry bib2GlsEntry) {
        if (this.dependencies == null || !bib2GlsEntry.hasDependencies()) {
            return;
        }
        Iterator<String> iterator = bib2GlsEntry.getDependencyIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.addDependent(string);
        }
    }

    public void addDependent(String string) {
        if (!this.dependencies.contains(string)) {
            this.verboseMessage("message.added.dep", string);
            this.dependencies.add(string);
        }
    }

    public boolean isDependent(String string) {
        return this.dependencies == null ? false : this.dependencies.contains(string);
    }

    public boolean hasCrossResourceDependencies() {
        return this.dependencies != null;
    }

    public Iterator<String> getDependencyIterator() {
        return this.dependencies == null ? null : this.dependencies.iterator();
    }

    private boolean isIgnoredFormat(String string) {
        return string.equals("glsignore") || string.equals("glstriggerrecordformat");
    }

    public GlsResource getCurrentResource() {
        return this.currentResource;
    }

    public boolean isLastResource(GlsResource glsResource) {
        return this.glsresources == null ? false : this.glsresources.lastElement() == glsResource;
    }

    public Vector<GlsResource> getResources() {
        return this.glsresources;
    }

    public Charset getTeXCharset() {
        return this.texCharset;
    }

    public boolean useCiteAsRecord() {
        return this.useCiteAsRecord;
    }

    public boolean mergeNameRefOnLocation() {
        return this.mergeNameRefOn == 2;
    }

    public boolean mergeNameRefOnTitle() {
        return this.mergeNameRefOn == 1;
    }

    public boolean mergeNameRefOnHref() {
        return this.mergeNameRefOn == 0;
    }

    public boolean mergeNameRefOnHcounter() {
        return this.mergeNameRefOn == 3;
    }

    public boolean mergeWrGlossaryLocations() {
        return this.mergeWrGlossaryLocations;
    }

    public boolean checkAcroShortcuts() {
        return this.checkAcroShortcuts;
    }

    public boolean checkAbbrvShortcuts() {
        return this.checkAbbrvShortcuts;
    }

    public int getAltModifier() {
        return this.altModifier;
    }

    public boolean isGlsLike(String string) {
        if (this.glsLike == null) {
            return false;
        }
        return this.glsLike.get(string) != null;
    }

    public void addGlsLike(String string, String string2) {
        if (this.glsLike == null) {
            this.glsLike = new HashMap();
        }
        this.glsLike.put(string2, string);
    }

    public String getGlsLikePrefix(String string) {
        return this.glsLike == null ? null : this.glsLike.get(string);
    }

    public boolean checkNestedLinkTextField(String string) {
        if (this.nestedLinkCheckFields == null) {
            return false;
        }
        for (int i = 0; i < this.nestedLinkCheckFields.length; ++i) {
            if (!string.equals(this.nestedLinkCheckFields[i])) continue;
            return true;
        }
        return false;
    }

    public boolean useGroupField() {
        return this.addGroupField;
    }

    public boolean isMultipleSupplementarySupported() {
        return this.multiSuppSupported;
    }

    public Vector<String> getFields() {
        return this.fields;
    }

    public void addField(String string) {
        if (!this.fields.contains(string)) {
            this.fields.add(string);
        }
    }

    public HashMap<String, String> getFieldMap() {
        return this.fieldMap;
    }

    public boolean isInternalField(String string) {
        return string.startsWith("bib2gls@");
    }

    public boolean isNonBibField(String string) {
        for (String string2 : NON_BIB_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return this.isInternalField(string) || string.startsWith("bibtexentry@") || string.endsWith("endpunc") || string.startsWith("recordcount.") || string.startsWith("currcount@") || string.startsWith("prevcount@");
    }

    public boolean isKnownField(String string) {
        if (this.fields.isEmpty()) {
            this.debug("Empty field list when checking for field '" + string + "'");
        }
        for (String string2 : this.fields) {
            if (string2.equals(string)) {
                return true;
            }
            if (!string.equals(this.fieldMap.get(string2))) continue;
            return true;
        }
        return false;
    }

    public boolean isKnownSpecialField(String string) {
        for (String string2 : SPAWN_SPECIAL_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        for (String string2 : DUAL_SPECIAL_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckNonBibFieldsOn() {
        return this.checkNonBibFields;
    }

    public boolean isWarnUnknownEntryTypesOn() {
        return this.warnUnknownEntryTypes;
    }

    public boolean isProvideGlossariesOn() {
        return this.knownGlossaries != null;
    }

    public boolean isKnownGlossary(String string) {
        return this.knownGlossaries != null && this.knownGlossaries.contains(string);
    }

    public void addGlossary(String string) {
        this.knownGlossaries.add(string);
    }

    public void selectedEntry(String string) {
        this.selectedEntries.add(string);
    }

    public boolean isEntrySelected(String string) {
        return this.selectedEntries.contains(string);
    }

    public GlsSeeRecord getSeeRecord(String string) {
        for (GlsSeeRecord glsSeeRecord : this.seeRecords) {
            if (!glsSeeRecord.getLabel().equals(string)) continue;
            return glsSeeRecord;
        }
        return null;
    }

    public Vector<GlsRecord> getRecords() {
        return this.records;
    }

    public Vector<GlsSeeRecord> getSeeRecords() {
        return this.seeRecords;
    }

    public boolean hasRecord(String string) {
        for (GlsRecord glsRecord : this.records) {
            if (!string.equals(glsRecord.getLabel())) continue;
            return true;
        }
        return false;
    }

    public boolean hasSeeRecord(String string) {
        for (GlsSeeRecord glsSeeRecord : this.seeRecords) {
            if (!string.equals(glsSeeRecord.getLabel())) continue;
            return true;
        }
        return false;
    }

    public GlsRecord getRecordCountKey(GlsRecord glsRecord) {
        if (this.recordCount == null) {
            return null;
        }
        Set<GlsRecord> set = this.recordCount.keySet();
        for (GlsRecord glsRecord2 : set) {
            boolean bl;
            boolean bl2 = bl = glsRecord2.getLabel().equals(glsRecord.getLabel()) && glsRecord2.getCounter().equals(glsRecord.getCounter());
            if (this.saveRecordCountUnit) {
                boolean bl3 = bl = bl && glsRecord2.getLocation().equals(glsRecord.getLocation());
            }
            if (!bl) continue;
            return glsRecord2;
        }
        return null;
    }

    public boolean isRecordCountSet() {
        return this.recordCount != null;
    }

    public Set<GlsRecord> getRecordCountKeySet() {
        return this.recordCount == null ? null : this.recordCount.keySet();
    }

    public Integer getRecordCount(GlsRecord glsRecord) {
        return this.recordCount == null ? null : this.recordCount.get(glsRecord);
    }

    public void writeRecordCount(String string, PrintWriter printWriter) throws IOException {
        Set<GlsRecord> set = this.getRecordCountKeySet();
        if (set == null) {
            return;
        }
        int n = 0;
        for (GlsRecord glsRecord : set) {
            if (!glsRecord.getLabel().equals(string)) continue;
            Integer n2 = this.getRecordCount(glsRecord);
            n += n2.intValue();
            printWriter.format("\\bibglssetrecordcount{%s}{%s}{%d}%n", string, glsRecord.getCounter(), n2);
            if (!this.saveRecordCountUnit) continue;
            printWriter.format("\\bibglssetlocationrecordcount{%s}{%s}{%s}{%d}%n", string, glsRecord.getCounter(), glsRecord.getLocation(), n2);
        }
        printWriter.format("\\bibglssettotalrecordcount{%s}{%d}%n", string, n);
    }

    public static String replaceSpecialChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        block12: while (n < string.length()) {
            int n2 = string.codePointAt(n);
            n += Character.charCount(n2);
            switch (n2) {
                case 92: {
                    if (n < string.length() && string.substring(n).startsWith("char`\\")) {
                        stringBuilder.append(string.substring(n - 1, n + 7));
                        n += 7;
                        continue block12;
                    }
                    stringBuilder.append("\\glsbackslash ");
                    bl = true;
                    continue block12;
                }
                case 37: {
                    stringBuilder.append("\\glspercentchar ");
                    bl = true;
                    continue block12;
                }
                case 123: {
                    stringBuilder.append("\\glsopenbrace ");
                    bl = true;
                    continue block12;
                }
                case 125: {
                    stringBuilder.append("\\glsclosebrace ");
                    bl = true;
                    continue block12;
                }
                case 126: {
                    stringBuilder.append("\\glstildechar ");
                    bl = true;
                    continue block12;
                }
                case 35: {
                    stringBuilder.append(String.format("\\bibglshashchar ", n2));
                    bl = true;
                    continue block12;
                }
                case 95: {
                    stringBuilder.append(String.format("\\bibglsunderscorechar ", n2));
                    bl = true;
                    continue block12;
                }
                case 36: {
                    stringBuilder.append(String.format("\\bibglsdollarchar ", n2));
                    bl = true;
                    continue block12;
                }
                case 38: {
                    stringBuilder.append(String.format("\\bibglsampersandchar ", n2));
                    bl = true;
                    continue block12;
                }
                case 94: {
                    stringBuilder.append(String.format("\\bibglscircumchar ", n2));
                    bl = true;
                    continue block12;
                }
            }
            if (bl && Character.isWhitespace(n2)) {
                stringBuilder.append("\\space");
            }
            bl = false;
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    public void writeCommonCommands(PrintWriter printWriter) throws IOException {
        if (this.commonCommandsDone) {
            return;
        }
        printWriter.println("\\providecommand{\\bibglshashchar}{\\expandafter\\@gobble\\string\\#}");
        printWriter.println("\\providecommand{\\bibglscircumchar}{\\expandafter\\@gobble\\string\\^}");
        printWriter.println("\\providecommand{\\bibglsdollarchar}{\\expandafter\\@gobble\\string\\$}");
        printWriter.println("\\providecommand{\\bibglsampersandchar}{\\expandafter\\@gobble\\string\\&}");
        printWriter.println("\\providecommand{\\bibglsunderscorechar}{\\expandafter\\@gobble\\string\\_}");
        printWriter.println("\\providecommand{\\bibglshrefchar}[2]{\\glspercentchar #1}");
        if (this.fontspec) {
            printWriter.println("\\providecommand{\\bibglshrefunicode}[2]{#2}");
        }
        printWriter.println("\\providecommand{\\bibglsusesee}[1]{\\glsxtrusesee{#1}}");
        printWriter.println("\\providecommand{\\bibglsusealias}[1]{%");
        printWriter.println(" \\glsxtrifhasfield{alias}{#1}%");
        printWriter.println(" {\\expandafter\\glsseeformat\\expandafter{\\glscurrentfieldvalue}{}}%");
        printWriter.println(" {}%");
        printWriter.println("}");
        printWriter.println("\\providecommand{\\bibglsuseseealso}[1]{\\glsxtruseseealso{#1}}");
        printWriter.println("\\providecommand{\\bibglsdelimN}{\\delimN}");
        printWriter.println("\\providecommand{\\bibglslastDelimN}{,~}");
        printWriter.println("\\providecommand{\\bibglsrange}[1]{#1}");
        printWriter.println("\\providecommand{\\bibglsinterloper}[1]{#1\\bibglsdelimN }");
        printWriter.format("\\providecommand{\\bibglspassimname}{%s}%n", this.getMessage("tag.passim", new Object[0]));
        printWriter.println("\\providecommand{\\bibglspassim}{ \\bibglspassimname}");
        printWriter.println("\\providecommand*{\\bibglshyperlink}[2]{\\glshyperlink[#1]{#2}}");
        printWriter.println();
        printWriter.println("\\providecommand{\\bibglsuppercase}{\\MakeTextUppercase}");
        printWriter.println("\\providecommand{\\bibglslowercase}{\\MakeTextLowercase}");
        printWriter.println("\\providecommand{\\bibglsfirstuc}{\\makefirstuc}");
        printWriter.println("\\providecommand{\\bibglstitlecase}{\\capitalisewords}");
        printWriter.println();
        printWriter.println("\\providecommand{\\bibglsprimaryprefixlabel}[1]{}");
        printWriter.println("\\providecommand{\\bibglsdualprefixlabel}[1]{}");
        printWriter.println("\\providecommand{\\bibglstertiaryprefixlabel}[1]{}");
        printWriter.println("\\providecommand{\\bibglsexternalprefixlabel}[2]{}");
        printWriter.println();
        if (this.recordCount != null) {
            printWriter.println("\\ifdef\\glsxtrenablerecordcount %glossaries-extra.sty v1.21+");
            printWriter.println("{\\glsxtrenablerecordcount}");
            printWriter.println("{");
            printWriter.println(" \\PackageWarning{bib2gls}{You need at least v1.21 of glossaries-extra with --record-count or --record-count-unit}");
            printWriter.println("}");
            printWriter.println();
            printWriter.println("\\providecommand*{\\bibglssetrecordcount}[3]{%");
            printWriter.println("   \\GlsXtrSetField{#1}{recordcount.#2}{#3}%");
            printWriter.println("}");
            printWriter.println("\\providecommand*{\\bibglssettotalrecordcount}[2]{%");
            printWriter.println("   \\GlsXtrSetField{#1}{recordcount}{#2}%");
            printWriter.println("}");
            if (this.saveRecordCountUnit) {
                printWriter.println("\\ifdef\\glsxtrdetoklocation");
                printWriter.println("{% glossaries-extra v1.21+");
                printWriter.println("  \\providecommand*{\\bibglssetlocationrecordcount}[4]{%");
                printWriter.println("     \\GlsXtrSetField{#1}{recordcount.#2.\\glsxtrdetoklocation{#3}}{#4}%");
                printWriter.println("  }");
                printWriter.println("}");
                printWriter.println("{");
                printWriter.println("  \\providecommand*{\\bibglssetlocationrecordcount}[4]{%");
                printWriter.println("     \\GlsXtrSetField{#1}{recordcount.#2.#3}{#4}%");
                printWriter.println("  }");
                printWriter.println("}");
            }
        }
        this.commonCommandsDone = true;
    }

    public void incRecordCount(GlsRecord glsRecord) {
        if (this.recordCount == null) {
            return;
        }
        GlsRecord glsRecord2 = this.getRecordCountKey(glsRecord);
        if (glsRecord2 == null) {
            this.recordCount.put(glsRecord, 1);
        } else {
            Integer n = this.recordCount.get(glsRecord2);
            this.recordCount.put(glsRecord2, n + 1);
        }
    }

    public boolean mfirstucProtection() {
        return this.mfirstucProtect;
    }

    public boolean mfirstucMathShiftProtection() {
        return this.mfirstucMProtect;
    }

    public String[] mfirstucProtectionFields() {
        return this.mfirstucProtectFields;
    }

    public void logEncodingDetected(Charset charset) {
        this.logMessage(this.getMessage("message.detected.charset", charset));
    }

    public void logEncoding(Charset charset) {
        if (charset == null) {
            this.logMessage(this.getMessage("message.charset", this.getMessage("message.null", new Object[0])));
        } else {
            this.logMessage(this.getMessage("message.charset", charset.name()));
        }
    }

    public void logEncoding(String string) {
        if (string == null) {
            this.logMessage(this.getMessage("message.charset", this.getMessage("message.null", new Object[0])));
        } else {
            this.logMessage(this.getMessage("message.charset", string));
        }
    }

    public void logDefaultEncoding(Charset charset) {
        if (charset == null) {
            this.logMessage(this.getMessage("message.default.charset", this.getMessage("message.null", new Object[0])));
        } else {
            this.logMessage(this.getMessage("message.default.charset", charset.name()));
        }
    }

    public void logDefaultEncoding(String string) {
        if (string == null) {
            this.logMessage(this.getMessage("message.default.charset", this.getMessage("message.null", new Object[0])));
        } else {
            this.logMessage(this.getMessage("message.default.charset", string));
        }
    }

    public void logMessageNoLn(String string) {
        if (this.logWriter != null) {
            this.logWriter.print(string);
        } else if (this.pendingWriter != null) {
            this.pendingWriter.print(string);
        }
    }

    public void logMessage(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        } else if (this.pendingWriter != null) {
            this.pendingWriter.println(string);
        }
    }

    public void logMessage() {
        if (this.logWriter != null) {
            this.logWriter.println();
        } else if (this.pendingWriter != null) {
            this.pendingWriter.println();
        }
    }

    public void logAndPrintMessage(String string) {
        this.logMessage(string);
        System.out.println(string);
    }

    public void logAndPrintMessage() {
        this.logMessage();
        System.out.println();
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void debugMessage(String string, Object ... objectArray) {
        if (this.debugLevel > 0) {
            this.logAndPrintMessage(this.getMessage(string, objectArray));
        }
    }

    public void debug(String string) {
        if (this.debugLevel > 0) {
            this.logAndPrintMessage(string);
        }
    }

    public void debug(Throwable throwable) {
        if (this.debugLevel > 0) {
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.getClass().getSimpleName();
            }
            this.logAndPrintMessage(string);
            throwable.printStackTrace();
            if (this.logWriter != null) {
                throwable.printStackTrace(this.logWriter);
            } else if (this.pendingWriter != null) {
                throwable.printStackTrace(this.pendingWriter);
            }
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.debugLevel > 0) {
            String string2 = throwable.getMessage();
            if (string2 == null) {
                string2 = throwable.getClass().getSimpleName();
            }
            if (string != null) {
                string2 = string + string2;
            }
            this.logAndPrintMessage(string2);
            throwable.printStackTrace();
            if (this.logWriter != null) {
                throwable.printStackTrace(this.logWriter);
            } else if (this.pendingWriter != null) {
                throwable.printStackTrace(this.pendingWriter);
            }
        }
    }

    public void debug() {
        if (this.debugLevel > 0) {
            System.out.println();
            this.logMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String kpsewhich(String string) throws IOException, InterruptedException {
        String string2 = this.kpsewhichResults.get(string);
        if (string2 != null) {
            return string2;
        }
        this.debug(this.getMessageWithFallback("message.running", "Running {0}", String.format("kpsewhich '%s'", string)));
        Process process = null;
        int n = -1;
        try {
            process = new ProcessBuilder("kpsewhich", string).start();
            n = process.waitFor();
        }
        catch (Exception exception) {
            this.debug(exception);
            return null;
        }
        String string3 = null;
        if (n == 0) {
            InputStream inputStream = process.getInputStream();
            if (inputStream == null) {
                throw new IOException(this.getMessageWithFallback("error.cant.open.process.stream", "Unable to open input stream from process: {0}", String.format("kpsewhich '%s'", string)));
            }
            try (BufferedReader bufferedReader = null;){
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                string3 = bufferedReader.readLine();
                this.debug(this.getMessageWithFallback("message.process.result", "Processed returned: {0}", string3));
            }
        } else if (this.debugLevel > 0) {
            this.logAndPrintMessage(this.getMessageWithFallback("error.app_failed", "{0} failed with exit code {1}", String.format("kpsewhich '%s'", string), n));
        }
        this.kpsewhichResults.put(string, string3);
        return string3;
    }

    public TeXPath getBibFilePath(TeXParser teXParser, String string) throws IOException, InterruptedException {
        TeXPath teXPath = new TeXPath(teXParser, string, "bib", false);
        File file = teXPath.getFile();
        if (!file.exists()) {
            Object object;
            this.debug(this.getMessage("error.file.not.found", file));
            File file2 = file;
            if (this.basePath.equals(this.cwd)) {
                object = this.auxFile.getParentFile();
                file2 = new File((File)object, file.getName());
            } else {
                file2 = this.resolvePath(teXPath.getRelativePath()).toFile();
                if (!file2.exists()) {
                    this.debug(this.getMessage("error.file.not.found", file2));
                    object = this.auxFile.getParentFile();
                    file2 = new File((File)object, file.getName());
                }
            }
            if (!file2.exists() && (object = this.kpsewhich(file.getName())) != null && !((String)object).isEmpty()) {
                return new TeXPath(teXParser, (String)object, "", false);
            }
            if (file2.exists()) {
                teXPath = new TeXPath(teXParser, file2);
            } else {
                this.debug(this.getMessage("error.file.not.found", file2));
            }
        }
        return teXPath;
    }

    public String getTeXPathHref(TeXPath teXPath) {
        int n;
        String string = teXPath.toString();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n == 45 || n == 46 || n == 58 || n >= 47 && n <= 57 || n >= 65 && n <= 90 || n >= 97 && n <= 122) {
                stringBuilder.appendCodePoint(n);
                continue;
            }
            if (this.fontspec && n > 127) {
                stringBuilder.append(String.format("\\bibglshrefunicode{%02X}{%s}", n, new String(Character.toChars(n))));
                continue;
            }
            if (n == 92) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glsbackslash }", n));
                continue;
            }
            if (n == 37) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glspercentchar }", n));
                continue;
            }
            if (n == 35) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglshashchar }", n));
                continue;
            }
            if (n == 36) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglsdollarchar }", n));
                continue;
            }
            if (n == 95) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglsunderscorechar }", n));
                continue;
            }
            if (n == 38) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglsampersandchar }", n));
                continue;
            }
            if (n == 94) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglscircumchar }", n));
                continue;
            }
            if (n == 123) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glsopenbrace }", n));
                continue;
            }
            if (n == 125) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glsclosebrace }", n));
                continue;
            }
            if (n == 126) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glstildechar }", n));
                continue;
            }
            stringBuilder.append(String.format("\\bibglshrefchar{%02X}{%s}", n, new String(Character.toChars(n))));
        }
        return stringBuilder.toString();
    }

    @Override
    public void epstopdf(File file, File file2) throws IOException, InterruptedException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public void wmftoeps(File file, File file2) throws IOException, InterruptedException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public void substituting(TeXParser teXParser, String string, String string2) {
        this.verboseMessage("warning.substituting", string, string2);
    }

    @Override
    public void progress(int n) {
    }

    @Override
    public String getMessage(String string, Object ... objectArray) {
        if (this.messages == null) {
            String string2 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string2 = string2 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    public String getMessage(TeXParser teXParser, String string, Object ... objectArray) {
        if (teXParser == null) {
            return this.getMessage(string, objectArray);
        }
        int n = teXParser.getLineNumber();
        File file = teXParser.getCurrentFile();
        if (n == -1 || file == null) {
            return this.getMessage(string, objectArray);
        }
        return Bib2Gls.fileLineMessage(file, n, this.getMessage(string, objectArray));
    }

    public String getMessageWithFallback(String string, String string2, Object ... objectArray) {
        if (this.messages == null) {
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
        try {
            return this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
    }

    public String getMessageIfExists(String string) {
        if (this.messages == null) {
            return null;
        }
        return this.messages.getMessageIfExists(string, new Object[0]);
    }

    public String getChoiceMessage(String string, int n, String string2, int n2, Object ... objectArray) {
        if (this.messages == null) {
            String string3 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string3 = string3 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string3);
        }
        String string4 = string;
        try {
            string4 = this.messages.getChoiceMessage(string, n, string2, n2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string4;
    }

    @Override
    public void message(String string) {
        if (this.verboseLevel >= 0) {
            System.out.println(string);
        }
        this.logMessage(string);
    }

    public void verboseMessage(String string, Object ... objectArray) {
        this.verbose(this.getMessage(string, objectArray));
    }

    public void verbose(String string) {
        if (this.verboseLevel > 0) {
            System.out.println(string);
        }
        this.logMessage(string);
    }

    public void verbose() {
        if (this.verboseLevel > 0) {
            System.out.println();
        }
        this.logMessage();
    }

    public void verbose(TeXParser teXParser, String string) {
        int n = teXParser.getLineNumber();
        File file = teXParser.getCurrentFile();
        if (n != -1 && file != null) {
            string = Bib2Gls.fileLineMessage(file, n, string);
        }
        this.verbose(string);
    }

    public static String fileLineMessage(File file, int n, String string) {
        return String.format("%s:%d: %s", file.toString(), n, string);
    }

    public static boolean isScriptDigit(int n) {
        return Bib2Gls.isSubscriptDigit(n) || Bib2Gls.isSuperscriptDigit(n);
    }

    public static boolean isSubscriptDigit(int n) {
        switch (n) {
            case 8320: 
            case 8321: 
            case 8322: 
            case 8323: 
            case 8324: 
            case 8325: 
            case 8326: 
            case 8327: 
            case 8328: 
            case 8329: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSuperscriptDigit(int n) {
        switch (n) {
            case 178: 
            case 179: 
            case 185: 
            case 8304: 
            case 8308: 
            case 8309: 
            case 8310: 
            case 8311: 
            case 8312: 
            case 8313: {
                return true;
            }
        }
        return false;
    }

    public static Integer parseInt(String string) throws NumberFormatException {
        try {
            if (string.codePointAt(0) == 8722) {
                return Integer.valueOf("-" + string.substring(1));
            }
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            block16: for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                n = string.codePointAt(i);
                switch (n) {
                    case 8304: 
                    case 8320: {
                        stringBuilder.append('0');
                        continue block16;
                    }
                    case 185: 
                    case 8321: {
                        stringBuilder.append('1');
                        continue block16;
                    }
                    case 178: 
                    case 8322: {
                        stringBuilder.append('2');
                        continue block16;
                    }
                    case 179: 
                    case 8323: {
                        stringBuilder.append('3');
                        continue block16;
                    }
                    case 8308: 
                    case 8324: {
                        stringBuilder.append('4');
                        continue block16;
                    }
                    case 8309: 
                    case 8325: {
                        stringBuilder.append('5');
                        continue block16;
                    }
                    case 8310: 
                    case 8326: {
                        stringBuilder.append('6');
                        continue block16;
                    }
                    case 8311: 
                    case 8327: {
                        stringBuilder.append('7');
                        continue block16;
                    }
                    case 8312: 
                    case 8328: {
                        stringBuilder.append('8');
                        continue block16;
                    }
                    case 8313: 
                    case 8329: {
                        stringBuilder.append('9');
                        continue block16;
                    }
                    case 8314: 
                    case 8330: {
                        stringBuilder.append('+');
                        continue block16;
                    }
                    case 8315: 
                    case 8331: {
                        stringBuilder.append('-');
                        continue block16;
                    }
                }
                stringBuilder.appendCodePoint(n);
            }
            return Integer.valueOf(stringBuilder.toString());
        }
    }

    @Override
    public void warning(TeXParser teXParser, String string) {
        if (this.verboseLevel >= 0) {
            int n = teXParser.getLineNumber();
            File file = teXParser.getCurrentFile();
            if (n == -1 || file == null) {
                this.warning(string);
            } else {
                this.warning(file, n, string);
            }
        }
    }

    public void warning(File file, int n, String string) {
        if (this.verboseLevel >= 0) {
            this.warning(Bib2Gls.fileLineMessage(file, n, string));
        }
    }

    public void warning(File file, int n, String string, Exception exception) {
        if (this.verboseLevel >= 0) {
            this.warning(Bib2Gls.fileLineMessage(file, n, string), exception);
        }
    }

    public void warning(String string) {
        string = this.getMessageWithFallback("warning.title", "Warning: {0}", string);
        if (this.verboseLevel >= 0) {
            System.err.println(string);
        }
        this.logMessage(string);
    }

    public void warningMessage(String string, Object ... objectArray) {
        this.warning(this.getMessage(string, objectArray));
    }

    public void warning() {
        if (this.verboseLevel >= 0) {
            System.err.println();
        }
        this.logMessage();
    }

    public void warning(String string, Exception exception) {
        if (this.verboseLevel >= 0) {
            System.err.println(string);
        }
        this.logMessage(string);
        if (this.debugLevel > 0) {
            exception.printStackTrace();
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                this.logMessage(stackTraceElement.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void error(Exception exception) {
        block8: {
            void var2_5;
            if (exception instanceof TeXSyntaxException) {
                TeXParser teXParser = ((TeXSyntaxException)exception).getParser();
                if (teXParser == null || teXParser.getListener() instanceof Bib2GlsBibParser) {
                    this.error(((TeXSyntaxException)exception).getMessage(this));
                    break block8;
                } else {
                    this.warning(((TeXSyntaxException)exception).getMessage(this));
                    if (this.debugLevel > 0) {
                        exception.printStackTrace();
                        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                            this.logMessage(stackTraceElement.toString());
                        }
                    }
                    return;
                }
            }
            String string = exception.getMessage();
            if (string == null) {
                String string2 = exception.getClass().getSimpleName();
            }
            this.error((String)var2_5);
        }
        if (this.debugLevel > 0) {
            exception.printStackTrace();
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                this.logMessage(stackTraceElement.toString());
            }
        }
        this.exitCode = 2;
    }

    public void error(String string) {
        string = this.getMessageWithFallback("error.title", "Error: {0}", string);
        System.err.println(string);
        this.logMessage(string);
    }

    @Override
    public void copyFile(File file, File file2) throws IOException, InterruptedException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request to copy files %s -> %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public String requestUserInput(String string) throws IOException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request for user input. Message: %s%n", string);
        }
        return "";
    }

    public void version() {
        System.out.println(this.getMessageWithFallback("about.version", "{0} version {1} ({2})", NAME, VERSION, DATE));
    }

    public void license() {
        System.out.println("https://github.com/nlct/bib2gls");
        System.out.println();
        System.out.format("Copyright 2017-%s Nicola Talbot%n", DATE.substring(0, 4));
        System.out.println(this.getMessage("about.license", new Object[0]));
    }

    public void libraryVersion() {
        System.out.println();
        System.out.println(this.getMessageWithFallback("about.library.version", "Bundled with {0} version {1} ({2})", "texparserlib.jar", "0.9.2.4b", DATE));
        System.out.println("https://github.com/nlct/texparser");
    }

    public void help() {
        System.out.println(this.getMessage("syntax.usage", NAME));
        System.out.println();
        System.out.println(this.getMessage("syntax.info", new Object[0]));
        System.out.println();
        System.out.println(this.getMessage("syntax.options", new Object[0]));
        System.out.println();
        System.out.println(this.getMessage("syntax.help", "--help", "-h"));
        System.out.println(this.getMessage("syntax.version", "--version", "-v"));
        System.out.println(this.getMessage("syntax.debug", "--debug"));
        System.out.println(this.getMessage("syntax.nodebug", "--no-debug", "--nodebug"));
        System.out.println(this.getMessage("syntax.verbose", "--verbose"));
        System.out.println(this.getMessage("syntax.noverbose", "--no-verbose", "--noverbose"));
        System.out.println(this.getMessage("syntax.silent", "--silent"));
        System.out.println();
        System.out.println(this.getMessage("syntax.locale", "--locale", "-l"));
        System.out.println(this.getMessage("syntax.log", "--log-file", "-t"));
        System.out.println(this.getMessage("syntax.dir", "--dir", "-d"));
        System.out.println();
        System.out.println(this.getMessage("syntax.interpret", "--interpret"));
        System.out.println(this.getMessage("syntax.no.interpret", "--no-interpret"));
        System.out.println();
        System.out.println();
        System.out.println(this.getMessage("syntax.break.space", "--break-space"));
        System.out.println(this.getMessage("syntax.no.break.space", "--no-break-space"));
        System.out.println();
        System.out.println(this.getMessage("syntax.cite.as.record", "--cite-as-record"));
        System.out.println(this.getMessage("syntax.no.cite.as.record", "--no-cite-as-record"));
        System.out.println();
        System.out.println(this.getMessage("syntax.warn.non.bib.fields", "--warn-non-bib-fields"));
        System.out.println(this.getMessage("syntax.no.warn.non.bib.fields", "--no-warn-non-bib-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.warn.unknown.entry.types", "--warn-unknown-entry-types"));
        System.out.println(this.getMessage("syntax.no.warn.unknown.entry.types", "--no-warn-unknown-entry-types"));
        System.out.println();
        System.out.println(this.getMessage("syntax.merge.wrglossary.records", "--merge-wrglossary-records"));
        System.out.println(this.getMessage("syntax.no.merge.wrglossary.records", "--no-merge-wrglossary-records"));
        System.out.println();
        System.out.println(this.getMessage("syntax.merge.nameref.on", "--merge-nameref-on"));
        System.out.println();
        System.out.println(this.getMessage("syntax.force.cross.resource.refs", "--force-cross-resource-refs", "-x"));
        System.out.println(this.getMessage("syntax.no.force.cross.resource.refs", "--no-force-cross-resource-refs"));
        System.out.println();
        System.out.println(this.getMessage("syntax.support.unicode.script", "--support-unicode-script"));
        System.out.println(this.getMessage("syntax.no.support.unicode.script", "--no-support-unicode-script"));
        System.out.println();
        System.out.println(this.getMessage("syntax.packages", "--packages", "-p"));
        System.out.println();
        System.out.println(this.getMessage("syntax.ignore.packages", "--ignore-packages", "-k"));
        System.out.println();
        System.out.println(this.getMessage("syntax.custom.packages", "--custom-packages"));
        System.out.println();
        System.out.println(this.getMessage("syntax.list.known.packages", "--list-known-packages"));
        System.out.println();
        System.out.println();
        System.out.println(this.getMessage("syntax.mfirstuc", "--mfirstuc-protection", "-u"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.mfirstuc", "--no-mfirstuc-protection"));
        System.out.println();
        System.out.println(this.getMessage("syntax.math.mfirstuc", "--mfirstuc-math-protection", "--no-mfirstuc-protection"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.math.mfirstuc", "--no-mfirstuc-math-protection"));
        System.out.println();
        System.out.println(this.getMessage("syntax.check.shortcuts", "--shortcuts"));
        System.out.println();
        System.out.println(this.getMessage("syntax.check.nested", "--nested-link-check"));
        System.out.println();
        System.out.println(this.getMessage("syntax.nocheck.nested", "--no-nested-link-check", "--nested-link-check"));
        System.out.println();
        System.out.println(this.getMessage("syntax.format.map", "--map-format", "-m"));
        System.out.println();
        System.out.println(this.getMessage("syntax.group", "--group", "-g"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.group", "--no-group"));
        System.out.println();
        System.out.println(this.getMessage("syntax.record.count", "--record-count", "-c"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.record.count", "--no-record-count", "--no-record-count-unit"));
        System.out.println();
        System.out.println(this.getMessage("syntax.record.count.unit", "--record-count-unit", "-n", "--record-count"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.record.count.unit", "--no-record-count-unit"));
        System.out.println();
        System.out.println(this.getMessage("syntax.trim.fields", "--trim-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.trim.only.fields", "--trim-only-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.trim.except.fields", "--trim-except-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.trim.fields", "--no-trim-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.expand.fields", "--expand-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.expand.fields", "--no-expand-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.provide.glossaries", "--provide-glossaries"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.provide.glossaries", "--no-provide-glossaries"));
        System.out.println();
        System.out.println(this.getMessage("syntax.tex.encoding", "--tex-encoding"));
        System.exit(0);
    }

    private String getLanguageFileName(String string) {
        return String.format("/resources/bib2gls-%s.xml", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMessages(String string) throws Bib2GlsException, IOException {
        Object object;
        Locale locale;
        if (string == null || "".equals(string)) {
            locale = this.defaultLocale == null ? Locale.getDefault() : this.defaultLocale;
        } else {
            try {
                this.setDocDefaultLocale(string);
                locale = this.getDefaultLocale();
            }
            catch (IllformedLocaleException illformedLocaleException) {
                locale = Locale.getDefault();
                this.setDocDefaultLocale(locale);
                this.error(illformedLocaleException.getMessage());
                this.debug(illformedLocaleException);
            }
        }
        String string2 = locale.toLanguageTag();
        String string3 = this.getLanguageFileName(string2);
        URL uRL = this.getClass().getResource(string3);
        String string4 = null;
        if (this.debugLevel > 0) {
            string4 = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        if (uRL == null) {
            if (string4 != null) {
                this.debug(String.format("Can't find language resource: %s!%s", string4, string3));
            }
            string2 = locale.getLanguage();
            string3 = this.getLanguageFileName(string2);
            this.debug("Trying: " + string3);
            uRL = this.getClass().getResource(string3);
            if (uRL == null) {
                this.debug(String.format("Can't find language resource: %s!%s", string4, string3));
                object = locale.getScript();
                if (object != null && !((String)object).isEmpty()) {
                    string3 = this.getLanguageFileName(String.format("%s-%s", string2, object));
                    this.debug("Trying: " + string3);
                    uRL = this.getClass().getResource(string3);
                    if (uRL == null && !string2.equals("en")) {
                        this.debug(String.format("Can't find language resource: %s!%s%nDefaulting to 'en'", string4, string3));
                        uRL = this.getClass().getResource(this.getLanguageFileName("en"));
                    }
                } else if (!string2.equals("en")) {
                    this.debug("Defaulting to 'en'");
                    uRL = this.getClass().getResource(this.getLanguageFileName("en"));
                }
                if (uRL == null) {
                    throw new Bib2GlsException("Can't find language resource file.");
                }
            }
        }
        object = null;
        try {
            this.debug("Reading " + uRL);
            object = uRL.openStream();
            Properties properties = new Properties();
            properties.loadFromXML((InputStream)object);
            ((InputStream)object).close();
            object = null;
            this.messages = new Bib2GlsMessages(properties);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    private void setShortCuts(String string) {
        if (string.equals("acro") || string.equals("acronyms") || string.equals("ac")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = true;
        } else if (string.equals("abbr") || string.equals("abbreviations")) {
            this.shortcuts = string;
            this.checkAbbrvShortcuts = true;
        } else if (string.equals("all") || string.equals("true")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = true;
            this.checkAbbrvShortcuts = true;
        } else if (string.equals("none") || string.equals("false")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = false;
            this.checkAbbrvShortcuts = false;
        } else {
            throw new IllegalArgumentException("Invalid shortcut value: " + string);
        }
    }

    public void setDocDefaultLocale(Locale locale) {
        this.docLocale = locale.toLanguageTag();
        this.defaultLocale = locale;
    }

    public void setDocDefaultLocale(String string) throws IllformedLocaleException {
        this.docLocale = string;
        this.defaultLocale = new Locale.Builder().setLanguageTag(string).build();
    }

    public String getDocDefaultLocale() {
        return this.docLocale;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public Locale getLocale(String string) {
        try {
            return new Locale.Builder().setLanguageTag(string).build();
        }
        catch (IllformedLocaleException illformedLocaleException) {
            Locale locale = this.defaultLocale;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.warningMessage("warning.invalid.locale", string, locale);
            return locale;
        }
    }

    public void setTrimFields(boolean bl) {
        this.trimFields = bl;
    }

    @Deprecated
    public boolean trimFields() {
        return this.trimFields;
    }

    public boolean isTrimFieldOn(String string) {
        if (this.trimOnlyFields == null && this.trimExceptFields == null) {
            return this.trimFields;
        }
        if (this.trimOnlyFields != null) {
            return this.trimOnlyFields.contains(string);
        }
        return !this.trimExceptFields.contains(string);
    }

    private static int parseArgVal(String[] stringArray, int n, Object[] objectArray) {
        String[] stringArray2 = stringArray[n].startsWith("--") ? stringArray[n].split("=", 2) : new String[]{stringArray[n]};
        objectArray[0] = stringArray2[0];
        if (stringArray2.length == 2) {
            objectArray[1] = stringArray2[1];
            return n;
        }
        if (n == stringArray.length - 1 || stringArray[n + 1].startsWith("-")) {
            objectArray[1] = null;
            return n;
        }
        objectArray[1] = stringArray[++n];
        return n;
    }

    private int parseArgInt(String[] stringArray, int n, Object[] objectArray) {
        return Bib2Gls.parseArgInt(stringArray, n, objectArray, this);
    }

    private int parseArgInt(String[] stringArray, int n, Object[] objectArray, int n2) {
        return Bib2Gls.parseArgInt(stringArray, n, objectArray, n2, this);
    }

    private static int parseArgInt(String[] stringArray, int n, Object[] objectArray, Bib2Gls bib2Gls) {
        n = Bib2Gls.parseArgVal(stringArray, n, objectArray);
        if (objectArray[1] != null) {
            try {
                objectArray[1] = new Integer((String)objectArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                if (bib2Gls == null) {
                    throw new IllegalArgumentException("Invalid integer argument", numberFormatException);
                }
                throw new IllegalArgumentException(bib2Gls.getMessage("error.invalid.opt.int.value", objectArray[0], objectArray[1]), numberFormatException);
            }
        }
        return n;
    }

    private static int parseArgInt(String[] stringArray, int n, Object[] objectArray, int n2, Bib2Gls bib2Gls) {
        n = Bib2Gls.parseArgVal(stringArray, n, objectArray);
        if (objectArray[1] == null) {
            objectArray[1] = new Integer(n2);
        } else {
            try {
                objectArray[1] = new Integer((String)objectArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                objectArray[1] = new Integer(n2);
                return n - 1;
            }
        }
        return n;
    }

    private static boolean isArg(String string, String string2, String string3) {
        return string.equals("-" + string2) || string.equals("--" + string3) || string.startsWith("--" + string3 + "=");
    }

    private static boolean isArg(String string, String string2) {
        return string.equals("--" + string2) || string.startsWith("--" + string2 + "=");
    }

    private void parseArgs(String[] stringArray) throws IOException, Bib2GlsSyntaxException {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        Object[] objectArray = new Object[2];
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String[] stringArray2;
            if (Bib2Gls.isArg(stringArray[i], "debug")) {
                i = this.parseArgInt(stringArray, i, objectArray, 1);
                int n2 = (Integer)objectArray[1];
                if (n2 < 0) {
                    throw new IllegalArgumentException(this.getMessage("error.invalid.opt.minint.value", objectArray[0], n2, 0));
                }
                this.verboseLevel = this.debugLevel = n2;
                continue;
            }
            if (stringArray[i].equals("--no-debug") || stringArray[i].equals("--nodebug")) {
                this.debugLevel = 0;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                this.verboseLevel = 1;
                continue;
            }
            if (stringArray[i].equals("--no-verbose") || stringArray[i].equals("--noverbose")) {
                this.verboseLevel = 0;
                continue;
            }
            if (stringArray[i].equals("--silent")) {
                this.verboseLevel = -1;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "l", "locale")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] != null) continue;
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
            }
            if (stringArray[i].equals("-h") || stringArray[i].equals("--help")) {
                this.help();
                continue;
            }
            if (stringArray[i].equals("-v") || stringArray[i].equals("--version")) {
                if (!this.shownVersion) {
                    this.version();
                }
                this.license();
                this.libraryVersion();
                System.exit(0);
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "t", "log-file")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                string3 = (String)objectArray[1];
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "p", "packages")) {
                String[] stringArray3;
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                stringArray2 = stringArray3 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                int n3 = stringArray2.length;
                for (n = 0; n < n3; ++n) {
                    String string4 = stringArray2[n];
                    if (!Bib2Gls.isKnownPackage(string4)) {
                        throw new Bib2GlsSyntaxException(this.getMessage("error.unsupported.package", string4, "--custom-packages"));
                    }
                    this.packages.add(string4);
                }
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "custom-packages")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray4 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                if (this.customPackages == null) {
                    this.customPackages = new Vector();
                }
                stringArray2 = stringArray4;
                int n4 = stringArray2.length;
                for (n = 0; n < n4; ++n) {
                    String string5 = stringArray2[n];
                    if (Bib2Gls.isKnownPackage(string5)) {
                        throw new Bib2GlsSyntaxException(this.getMessage("error.supported.package", string5, "--packages"));
                    }
                    this.customPackages.add(string5);
                }
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "k", "ignore-packages")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray5 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                if (this.ignorePackages == null) {
                    this.ignorePackages = new Vector();
                }
                stringArray2 = stringArray5;
                int n5 = stringArray2.length;
                for (n = 0; n < n5; ++n) {
                    String string6 = stringArray2[n];
                    if (Bib2Gls.isKnownPackage(string6)) {
                        this.ignorePackages.add(string6);
                        continue;
                    }
                    this.warningMessage("error.invalid.opt.value", objectArray[0], string6);
                }
                continue;
            }
            if (stringArray[i].equals("--list-known-packages")) {
                int n6;
                System.out.println(this.getMessage("message.list.known.packages.auto", new Object[0]));
                for (n6 = 0; n6 < AUTO_SUPPORT_PACKAGES.length; ++n6) {
                    if (n6 % 5 == 0) {
                        if (n6 > 0) {
                            System.out.print(",");
                        }
                        System.out.println();
                        System.out.print("\t");
                    } else {
                        System.out.print(", ");
                    }
                    System.out.print(AUTO_SUPPORT_PACKAGES[n6]);
                }
                System.out.println();
                System.out.println();
                System.out.println(this.getMessage("message.list.known.packages.extra", new Object[0]));
                for (n6 = 0; n6 < EXTRA_SUPPORTED_PACKAGES.length; ++n6) {
                    if (n6 % 5 == 0) {
                        if (n6 > 0) {
                            System.out.print(",");
                        }
                        System.out.println();
                        System.out.print("\t");
                    } else {
                        System.out.print(", ");
                    }
                    System.out.print(EXTRA_SUPPORTED_PACKAGES[n6]);
                }
                System.out.println();
                System.out.println(this.getMessage("message.list.known.packages.info", new Object[0]));
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("--expand-fields")) {
                this.expandFields = true;
                continue;
            }
            if (stringArray[i].equals("--no-expand-fields")) {
                this.expandFields = false;
                continue;
            }
            if (stringArray[i].equals("--warn-non-bib-fields")) {
                this.checkNonBibFields = true;
                continue;
            }
            if (stringArray[i].equals("--no-warn-non-bib-fields")) {
                this.checkNonBibFields = false;
                continue;
            }
            if (stringArray[i].equals("--warn-unknown-entry-types")) {
                this.warnUnknownEntryTypes = true;
                continue;
            }
            if (stringArray[i].equals("--no-warn-unknown-entry-types")) {
                this.warnUnknownEntryTypes = false;
                continue;
            }
            if (stringArray[i].equals("--interpret")) {
                this.interpret = true;
                continue;
            }
            if (stringArray[i].equals("--no-interpret")) {
                this.interpret = false;
                continue;
            }
            if (stringArray[i].equals("--break-space")) {
                this.useNonBreakSpace = false;
                continue;
            }
            if (stringArray[i].equals("--no-break-space")) {
                this.useNonBreakSpace = true;
                continue;
            }
            if (stringArray[i].equals("--cite-as-record")) {
                this.useCiteAsRecord = true;
                continue;
            }
            if (stringArray[i].equals("--no-cite-as-record")) {
                this.useCiteAsRecord = false;
                continue;
            }
            if (stringArray[i].equals("--merge-wrglossary-records")) {
                this.mergeWrGlossaryLocations = true;
                continue;
            }
            if (stringArray[i].equals("--no-merge-wrglossary-records")) {
                this.mergeWrGlossaryLocations = false;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "merge-nameref-on")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string7 = (String)objectArray[1];
                if (string7 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                if (string7.equals("href")) {
                    this.mergeNameRefOn = 0;
                    continue;
                }
                if (string7.equals("title")) {
                    this.mergeNameRefOn = 1;
                    continue;
                }
                if (string7.equals("location")) {
                    this.mergeNameRefOn = (byte)2;
                    continue;
                }
                if (string7.equals("hcounter")) {
                    this.mergeNameRefOn = (byte)3;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", objectArray[0], string7));
            }
            if (stringArray[i].equals("--force-cross-resource-refs") || stringArray[i].equals("-x")) {
                this.forceCrossResourceRefs = true;
                continue;
            }
            if (stringArray[i].equals("--no-force-cross-resource-refs")) {
                this.forceCrossResourceRefs = false;
                continue;
            }
            if (stringArray[i].equals("--support-unicode-script")) {
                this.supportUnicodeSubSuperScripts = true;
                continue;
            }
            if (stringArray[i].equals("--no-support-unicode-script")) {
                this.supportUnicodeSubSuperScripts = false;
                continue;
            }
            if (stringArray[i].equals("--no-mfirstuc-protection")) {
                this.mfirstucProtect = false;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "u", "mfirstuc-protection")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                this.mfirstucProtect = true;
                String string8 = (String)objectArray[1];
                if (string8 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                if (string8.equals("all")) {
                    this.mfirstucProtectFields = null;
                    continue;
                }
                if (string8.isEmpty()) {
                    this.mfirstucProtect = false;
                    continue;
                }
                this.mfirstucProtectFields = string8.split(" *, *");
                continue;
            }
            if (stringArray[i].equals("--no-mfirstuc-math-protection")) {
                this.mfirstucMProtect = false;
                continue;
            }
            if (stringArray[i].equals("--mfirstuc-math-protection")) {
                this.mfirstucMProtect = true;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "shortcuts")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string9 = (String)objectArray[1];
                if (string9 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                try {
                    this.setShortCuts(string9);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", objectArray[0], string9), illegalArgumentException);
                }
            }
            if (Bib2Gls.isArg(stringArray[i], "nested-link-check")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string10 = (String)objectArray[1];
                if (string10 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                if (string10.equals("none") || string10.isEmpty()) {
                    this.nestedLinkCheckFields = null;
                    continue;
                }
                this.nestedLinkCheckFields = string10.split(" *, *");
                continue;
            }
            if (stringArray[i].equals("--no-nested-link-check")) {
                this.nestedLinkCheckFields = null;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "d", "dir")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                string = (String)objectArray[1];
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "m", "map-format")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string11 = (String)objectArray[1];
                if (string11 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray6 = stringArray2 = string11.trim().split(" *, *");
                n = stringArray6.length;
                for (int j = 0; j < n; ++j) {
                    String string12 = stringArray6[j];
                    String[] stringArray7 = string12.split(" *: *");
                    if (stringArray7.length != 2) {
                        throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.value", objectArray[0], string11));
                    }
                    this.formatMap.put(stringArray7[0], stringArray7[1]);
                }
                continue;
            }
            if (stringArray[i].equals("--group") || stringArray[i].equals("-g")) {
                this.addGroupField = true;
                continue;
            }
            if (stringArray[i].equals("--no-group")) {
                this.addGroupField = false;
                continue;
            }
            if (stringArray[i].equals("--record-count") || stringArray[i].equals("-c")) {
                this.saveRecordCount = true;
                continue;
            }
            if (stringArray[i].equals("--no-record-count")) {
                this.saveRecordCount = false;
                this.saveRecordCountUnit = false;
                continue;
            }
            if (stringArray[i].equals("--record-count-unit") || stringArray[i].equals("-n")) {
                this.saveRecordCountUnit = true;
                this.saveRecordCount = true;
                continue;
            }
            if (stringArray[i].equals("--no-record-count-unit")) {
                this.saveRecordCountUnit = false;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "tex-encoding")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string13 = (String)objectArray[1];
                if (string13 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                this.texCharset = Charset.forName(string13);
                continue;
            }
            if (stringArray[i].equals("--trim-fields")) {
                this.trimFields = true;
                this.trimOnlyFields = null;
                this.trimExceptFields = null;
                continue;
            }
            if (stringArray[i].equals("--no-trim-fields")) {
                this.trimFields = false;
                this.trimOnlyFields = null;
                this.trimExceptFields = null;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "trim-only-fields")) {
                if (this.trimExceptFields != null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.option.clash", "--trim-only-fields", "--trim-except-fields"));
                }
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray8 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                if (this.trimOnlyFields == null) {
                    this.trimOnlyFields = new Vector();
                }
                stringArray2 = stringArray8;
                int n7 = stringArray2.length;
                for (n = 0; n < n7; ++n) {
                    String string14 = stringArray2[n];
                    this.trimOnlyFields.add(string14);
                }
                this.trimFields = true;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "trim-except-fields")) {
                if (this.trimOnlyFields != null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.option.clash", "--trim-only-fields", "--trim-except-fields"));
                }
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray9 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                if (this.trimExceptFields == null) {
                    this.trimExceptFields = new Vector();
                }
                stringArray2 = stringArray9;
                int n8 = stringArray2.length;
                for (n = 0; n < n8; ++n) {
                    String string15 = stringArray2[n];
                    this.trimExceptFields.add(string15);
                }
                this.trimFields = true;
                continue;
            }
            if (stringArray[i].equals("--provide-glossaries")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("--no-provide-glossaries")) {
                bl = false;
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.syntax.unknown_option", stringArray[i]));
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            throw new Bib2GlsSyntaxException(this.getMessage("error.only.one.aux", new Object[0]));
        }
        if (bl) {
            this.knownGlossaries = new Vector();
        }
        if (string2 == null) {
            throw new Bib2GlsSyntaxException(this.getMessage("error.no.aux", new Object[0]));
        }
        if (!string2.endsWith(".aux")) {
            string2 = string2 + ".aux";
        }
        File file = null;
        this.auxFile = new File(string2);
        if (string != null) {
            file = new File(string);
            this.basePath = file.toPath();
            if (!file.exists()) {
                System.err.println(this.getMessage("error.dir.not.found", string));
                System.exit(1);
            }
            if (!file.isDirectory()) {
                System.err.println(this.getMessage("error.not.dir", string));
                System.exit(1);
            }
            this.auxFile = this.auxFile.getParentFile() == null ? new File(file, string2) : file.toPath().resolve(this.auxFile.toPath()).toFile();
        } else {
            file = this.auxFile.getParentFile();
            this.basePath = this.cwd;
        }
        if (!this.auxFile.exists()) {
            System.err.println(this.getMessage("error.file.not.found", string2));
            System.exit(0);
        }
        this.logFile = null;
        if (string3 == null) {
            String string16 = this.auxFile.getName();
            this.logFile = new File(file, string16.substring(0, string16.lastIndexOf(".")) + ".glg");
        } else {
            this.logFile = this.resolveFile(string3);
        }
        this.logFile = this.getWritableFile(this.logFile);
        try {
            this.logWriter = new PrintWriter(new FileWriter(this.logFile));
        }
        catch (IOException iOException) {
            this.logWriter = null;
            System.err.println(this.getMessage("error.cant.open.log", this.logFile.toString()));
            this.error(iOException);
        }
        this.logMessage(this.getMessage("about.version", NAME, VERSION, DATE));
        if (this.getDebugLevel() > 0) {
            this.logMessage("Java " + System.getProperty("java.version"));
            this.logMessage(String.format("texparserlib.jar %s (%s)", "0.9.2.4b", DATE));
        }
        if (this.logWriter != null) {
            this.logWriter.print(this.pending.toString());
        }
        this.pendingWriter.close();
        this.pendingWriter = null;
        this.pending = null;
        if (this.getDebugLevel() > 0) {
            this.logAndPrintMessage(String.format("openin_any=%s%nopenout_any=%s%nTEXMFOUTPUT=%s%ncwd=%s", Character.valueOf(this.openin_any), Character.valueOf(this.openout_any), this.texmfoutput == null ? "" : this.texmfoutput, this.cwd));
        }
    }

    public static void exit(Bib2Gls bib2Gls, int n) {
        if (bib2Gls != null && bib2Gls.logWriter != null) {
            bib2Gls.logWriter.close();
            bib2Gls.message(bib2Gls.getMessageWithFallback("message.log.file", "Transcript written to {0}.", bib2Gls.logFile));
            bib2Gls.logWriter = null;
        }
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        Bib2Gls bib2Gls = null;
        int n = 0;
        int n2 = 0;
        String string = null;
        Object[] objectArray = new Object[2];
        for (int i = 0; i < stringArray.length; ++i) {
            if (Bib2Gls.isArg(stringArray[i], "debug")) {
                try {
                    i = Bib2Gls.parseArgInt(stringArray, i, objectArray, 1, null);
                    n = (Integer)objectArray[1];
                }
                catch (Exception exception) {
                    n = 1;
                }
                continue;
            }
            if (stringArray[i].equals("--no-debug") || stringArray[i].equals("--nodebug")) {
                n = 0;
                continue;
            }
            if (stringArray[i].equals("--silent")) {
                n2 = -1;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                n2 = 1;
                continue;
            }
            if (stringArray[i].equals("--noverbose")) {
                n2 = 0;
                continue;
            }
            if (!Bib2Gls.isArg(stringArray[i], "l", "locale")) continue;
            i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
            string = (String)objectArray[1];
        }
        try {
            bib2Gls = new Bib2Gls(n, n2, string);
            bib2Gls.process(stringArray);
            if (bib2Gls.exitCode != 0) {
                Bib2Gls.exit(bib2Gls, bib2Gls.exitCode);
            }
        }
        catch (Bib2GlsSyntaxException bib2GlsSyntaxException) {
            System.err.println(bib2GlsSyntaxException.getMessage());
            System.err.println(bib2Gls.getMessage("syntax.use.help", new Object[0]));
            System.exit(1);
        }
        catch (Exception exception) {
            if (bib2Gls == null) {
                System.err.println("Fatal error: " + exception.getMessage());
                if (n > 0) {
                    exception.printStackTrace();
                }
            } else {
                bib2Gls.error(exception);
            }
            Bib2Gls.exit(bib2Gls, 3);
        }
    }
}

