/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.filehandling;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.filehandling.Database;
import org.islandoftex.arara.filehandling.DatabaseUtils;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u000b\u001a\u00020\u0004J\u001e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\rJ$\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001f\u001a\u00020\rR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/islandoftex/arara/filehandling/FileHandlingUtils;", "", "()V", "currentFile", "Ljava/io/File;", "getCurrentFile", "()Ljava/io/File;", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "calculateHash", "", "file", "exists", "", "extension", "getBasename", "getCanonicalFile", "getCanonicalPath", "getFileExtension", "getLastModifiedInformation", "getParentCanonicalFile", "getParentCanonicalPath", "getPath", "hasChanged", "isSubDirectory", "child", "parent", "readFromFile", "", "writeToFile", "text", "append", "lines", "application"})
public final class FileHandlingUtils {
    private static final LanguageController messages;
    public static final FileHandlingUtils INSTANCE;

    private final File getCurrentFile() {
        return (File)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getFile());
    }

    public final boolean writeToFile(@NotNull File file2, @NotNull String text2, boolean append) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Intrinsics.checkParameterIsNotNull(text2, "text");
        try {
            if (append) {
                FilesKt.appendText(file2, text2, Charsets.UTF_8);
            } else {
                FilesKt.writeText(file2, text2, Charsets.UTF_8);
            }
            bl = true;
        }
        catch (IOException _) {
            bl = false;
        }
        return bl;
    }

    public final boolean writeToFile(@NotNull File file2, @NotNull List<String> lines, boolean append) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Intrinsics.checkParameterIsNotNull(lines, "lines");
        try {
            Iterable iterable = lines;
            String string = System.lineSeparator();
            Intrinsics.checkExpressionValueIsNotNull(string, "System.lineSeparator()");
            bl = this.writeToFile(file2, CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, null, 62, null), append);
        }
        catch (IOException _) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<String> readFromFile(@NotNull File file2) {
        List<String> list2;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        try {
            list2 = FilesKt.readLines(file2, Charsets.UTF_8);
        }
        catch (IOException _) {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final boolean exists(@NotNull String extension) throws AraraException {
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        File file2 = new File(this.getPath(extension));
        return file2.exists();
    }

    @NotNull
    public final String getParentCanonicalPath(@NotNull File file2) throws AraraException {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        String string = this.getParentCanonicalFile(file2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "getParentCanonicalFile(file).toString()");
        return string;
    }

    @NotNull
    public final File getParentCanonicalFile(@NotNull File file2) throws AraraException {
        Object object;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Object object2 = file2;
        boolean bl = false;
        try {
            object = Result.Companion;
            File $this$runCatching = object2;
            boolean bl2 = false;
            File file3 = $this$runCatching.getCanonicalFile();
            Intrinsics.checkExpressionValueIsNotNull(file3, "this.canonicalFile");
            $this$runCatching = file3.getParentFile();
            bl2 = false;
            object = Result.constructor-impl($this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl(ResultKt.createFailure($this$runCatching));
        }
        object2 = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl5 = false;
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_GETPARENTCANONICALPATH_IO_EXCEPTION), it);
        }
        Object object3 = object2;
        Intrinsics.checkExpressionValueIsNotNull(object3, "file.runCatching {\n     \u2026EXCEPTION), it)\n        }");
        return (File)object3;
    }

    @NotNull
    public final String getPath(@NotNull String extension) throws AraraException {
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        String name = FilesKt.getNameWithoutExtension(this.getCurrentFile()) + '.' + extension;
        File path = this.getParentCanonicalFile(this.getCurrentFile());
        String string = FilesKt.resolve(path, name).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "path.resolve(name).toString()");
        return string;
    }

    @NotNull
    public final String getCanonicalPath(@NotNull File file2) throws AraraException {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        String string = this.getCanonicalFile(file2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "getCanonicalFile(file).toString()");
        return string;
    }

    @NotNull
    public final File getCanonicalFile(@NotNull File file2) throws AraraException {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        try {
            File file3 = file2.getCanonicalFile();
            Intrinsics.checkExpressionValueIsNotNull(file3, "file.canonicalFile");
            return file3;
        }
        catch (IOException exception) {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_GETCANONICALFILE_IO_EXCEPTION), exception);
        }
    }

    @NotNull
    public final String getLastModifiedInformation(@NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        String string = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(file2.lastModified());
        Intrinsics.checkExpressionValueIsNotNull(string, "SimpleDateFormat(\"MM/dd/\u2026rmat(file.lastModified())");
        return string;
    }

    @NotNull
    public final String calculateHash(@NotNull File file2) throws AraraException {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        try {
            Object[] objectArray;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%08x";
            Object[] objectArray2 = new CRC32();
            int n = 0;
            Object[] objectArray3 = objectArray = new Object[1];
            boolean bl = false;
            boolean bl2 = false;
            Object[] $this$run = objectArray2;
            boolean bl3 = false;
            $this$run.update(FilesKt.readBytes(file2));
            Long l = $this$run.getValue();
            objectArray[n] = l;
            objectArray2 = objectArray3;
            bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(format, *args)");
            return string2;
        }
        catch (IOException exception) {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_CALCULATEHASH_IO_EXCEPTION), exception);
        }
    }

    @NotNull
    public final String getFileExtension(@NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        return FilesKt.getExtension(file2);
    }

    @NotNull
    public final String getBasename(@NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        return FilesKt.getNameWithoutExtension(file2);
    }

    public final boolean hasChanged(@NotNull File file2) throws AraraException {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Database database = DatabaseUtils.INSTANCE.load();
        String path = this.getCanonicalPath(file2);
        if (!file2.exists()) {
            if (database.containsKey((Object)path)) {
                database.remove((Object)path);
                DatabaseUtils.INSTANCE.save(database);
                bl = true;
            } else {
                bl = false;
            }
        } else {
            String hash = this.calculateHash(file2);
            if (database.containsKey((Object)path)) {
                String value2 = (String)database.get((Object)path);
                if (Intrinsics.areEqual(hash, value2)) {
                    bl = false;
                } else {
                    ((Map)database).put(path, hash);
                    DatabaseUtils.INSTANCE.save(database);
                    bl = true;
                }
            } else {
                ((Map)database).put(path, hash);
                DatabaseUtils.INSTANCE.save(database);
                bl = true;
            }
        }
        return bl;
    }

    public final boolean hasChanged(@NotNull String extension) throws AraraException {
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        return this.hasChanged(new File(this.getPath(extension)));
    }

    public final boolean isSubDirectory(@NotNull File child, @NotNull File parent) throws AraraException {
        Intrinsics.checkParameterIsNotNull(child, "child");
        Intrinsics.checkParameterIsNotNull(parent, "parent");
        if (!child.isDirectory() || !parent.isDirectory()) {
            Enum enum_ = Messages.ERROR_ISSUBDIRECTORY_NOT_A_DIRECTORY;
            Object[] objectArray = new Object[1];
            String string = child.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "child.name");
            objectArray[0] = string;
            throw (Throwable)new AraraException(messages.getMessage(enum_, objectArray));
        }
        return StringsKt.startsWith$default(this.getCanonicalPath(child), this.getParentCanonicalPath(parent) + File.separator, false, 2, null);
    }

    private FileHandlingUtils() {
    }

    static {
        FileHandlingUtils fileHandlingUtils;
        INSTANCE = fileHandlingUtils = new FileHandlingUtils();
        messages = LanguageController.INSTANCE;
    }
}

