/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.ui.cpu.CPUView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.McsTimeRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class CPUTableView
extends CPUView {
    private CPUTableModel tableModel;
    private ProfilerTable table;
    private FlatProfileContainer data;
    private Map<Integer, ClientUtils.SourceCodeSelection> idMap;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private boolean sampled = true;
    private boolean twoTimeStamps;
    private boolean hitsVisible = false;
    private boolean invocationsVisible = true;
    private HideableBarRenderer[] renderers;

    public CPUTableView(Set<ClientUtils.SourceCodeSelection> set) {
        this.selection = set;
        this.initUI();
    }

    void setData(FlatProfileContainer flatProfileContainer, Map<Integer, ClientUtils.SourceCodeSelection> map, boolean bl, boolean bl2) {
        Object object;
        boolean bl3 = this.sampled != bl;
        this.sampled = bl;
        this.twoTimeStamps = flatProfileContainer == null ? false : flatProfileContainer.isCollectingTwoTimeStamps();
        this.idMap = map;
        if (this.tableModel != null) {
            long[] lArray;
            this.data = flatProfileContainer;
            if (bl2) {
                lArray = new long[4];
                object = new long[4];
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                    lArray[0] = Math.max(lArray[0], this.data.getTimeInMcs0AtRow(i));
                    object[0] = Math.min(object[0], this.data.getTimeInMcs0AtRow(i));
                    if (this.twoTimeStamps) {
                        lArray[1] = Math.max(lArray[1], this.data.getTimeInMcs1AtRow(i));
                        object[1] = Math.min(object[1], this.data.getTimeInMcs1AtRow(i));
                    }
                    lArray[2] = Math.max(lArray[2], this.data.getTotalTimeInMcs0AtRow(i));
                    object[2] = Math.min(object[2], this.data.getTotalTimeInMcs0AtRow(i));
                    if (this.twoTimeStamps) {
                        lArray[3] = Math.max(lArray[3], this.data.getTotalTimeInMcs1AtRow(i));
                        object[3] = Math.min(object[3], this.data.getTotalTimeInMcs1AtRow(i));
                    }
                    n = Math.max(n, this.data.getNInvocationsAtRow(i));
                    n2 = Math.min(n2, this.data.getNInvocationsAtRow(i));
                }
                this.renderers[0].setMaxValue(Math.max(Math.abs(lArray[0]), Math.abs(object[0])));
                this.renderers[1].setMaxValue(Math.max(Math.abs(lArray[1]), Math.abs(object[1])));
                this.renderers[2].setMaxValue(Math.max(Math.abs(lArray[2]), Math.abs(object[2])));
                this.renderers[3].setMaxValue(Math.max(Math.abs(lArray[3]), Math.abs(object[3])));
                this.renderers[4].setMaxValue(Math.max(Math.abs(n), Math.abs(n2)));
            } else {
                lArray = new long[4];
                int n = 0;
                for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                    lArray[0] = lArray[0] + this.data.getTimeInMcs0AtRow(i);
                    if (this.twoTimeStamps) {
                        lArray[1] = lArray[1] + this.data.getTimeInMcs1AtRow(i);
                    }
                    lArray[2] = lArray[2] + this.data.getTotalTimeInMcs0AtRow(i);
                    if (this.twoTimeStamps) {
                        lArray[3] = lArray[3] + this.data.getTotalTimeInMcs1AtRow(i);
                    }
                    n += this.data.getNInvocationsAtRow(i);
                }
                this.renderers[0].setMaxValue(lArray[0]);
                this.renderers[1].setMaxValue(lArray[1]);
                this.renderers[2].setMaxValue(lArray[2]);
                this.renderers[3].setMaxValue(lArray[3]);
                this.renderers[4].setMaxValue(n);
            }
            this.renderers[0].setDiffMode(bl2);
            this.renderers[1].setDiffMode(bl2);
            this.renderers[2].setDiffMode(bl2);
            this.renderers[3].setDiffMode(bl2);
            this.renderers[4].setDiffMode(bl2);
            this.tableModel.fireTableDataChanged();
        }
        if (bl3) {
            int n = this.table.convertColumnIndexToView(this.selection == null ? 5 : 6);
            object = this.tableModel.getColumnName(this.selection == null ? 5 : 6);
            if (this.sampled) {
                this.invocationsVisible = this.table.isColumnVisible(n);
            } else {
                this.hitsVisible = this.table.isColumnVisible(n);
            }
            this.table.getColumnModel().getColumn(n).setHeaderValue(object);
            this.table.setColumnVisibility(n, this.sampled ? this.hitsVisible : this.invocationsVisible);
            this.setToolTips();
            this.repaint();
        }
        if (flatProfileContainer != null && !this.twoTimeStamps) {
            int n;
            int n3 = this.selection == null ? 2 : 3;
            int n4 = n = this.selection == null ? 4 : 5;
            if (this.table.isColumnVisible(n3)) {
                this.table.setColumnVisibility(n3, false);
                this.table.setColumnVisibility(n3 - 1, true);
            }
            if (this.table.isColumnVisible(n)) {
                this.table.setColumnVisibility(n, false);
                this.table.setColumnVisibility(n - 1, true);
            }
        }
    }

    public void resetData() {
        this.setData(null, null, this.sampled, false);
    }

    public void showSelectionColumn() {
        this.table.setColumnVisibility(0, true);
    }

    public void refreshSelection() {
        this.tableModel.fireTableDataChanged();
    }

    ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.table.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.table);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider(this.table, EXPORT_HOTSPOTS);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider(this.table, EXPORT_HOTSPOTS);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.table);
        }
        return exportProviderArray;
    }

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    HideableBarRenderer.BarDiffMode barDiffMode() {
        return HideableBarRenderer.BarDiffMode.MODE_BAR_DIFF;
    }

    private void initUI() {
        int n;
        this.tableModel = new CPUTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
                return CPUTableView.this.getUserValueForRow(n);
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, Object object2) {
                CPUTableView.this.populatePopup(jPopupMenu, object, (ClientUtils.SourceCodeSelection)object2);
            }

            @Override
            protected void popupShowing() {
                CPUTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                CPUTableView.this.popupHidden();
            }
        };
        this.setToolTips();
        this.table.providePopupMenu(true);
        this.installDefaultAction();
        int n2 = this.selection == null ? -1 : 0;
        this.table.setMainColumn(1 + n2);
        this.table.setFitWidthColumn(1 + n2);
        this.table.setSortColumn(3 + n2);
        this.table.setDefaultSortOrder(1 + n2, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.table.setColumnVisibility(0, false);
        }
        this.table.setColumnVisibility(2 + n2, false);
        this.table.setColumnVisibility(4 + n2, false);
        this.table.setColumnVisibility(6 + n2, false);
        this.renderers = new HideableBarRenderer[5];
        HideableBarRenderer.BarDiffMode barDiffMode = this.barDiffMode();
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer()));
        this.renderers[0].setBarDiffMode(barDiffMode);
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer()));
        this.renderers[1].setBarDiffMode(barDiffMode);
        this.renderers[2] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer()));
        this.renderers[2].setBarDiffMode(barDiffMode);
        this.renderers[3] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer()));
        this.renderers[3].setBarDiffMode(barDiffMode);
        this.renderers[4] = new HideableBarRenderer(new NumberRenderer());
        this.renderers[4].setBarDiffMode(barDiffMode);
        long l = 123456L;
        this.renderers[0].setMaxValue(l);
        this.renderers[1].setMaxValue(l);
        this.renderers[2].setMaxValue(l);
        this.renderers[3].setMaxValue(l);
        this.renderers[4].setMaxValue(l);
        if (this.selection != null) {
            this.table.setColumnRenderer(0, new CheckBoxRenderer(){
                private boolean visible;

                @Override
                public void setValue(Object object, int n) {
                    this.visible = CPUTableView.isSelectable((ClientUtils.SourceCodeSelection)CPUTableView.this.idMap.get(CPUTableView.this.data.getMethodIdAtRow(n)));
                    if (this.visible) {
                        super.setValue(object, n);
                    }
                }

                @Override
                public void paint(Graphics graphics) {
                    if (this.visible) {
                        super.paint(graphics);
                    } else {
                        graphics.setColor(this.getBackground());
                        graphics.fillRect(0, 0, this.size.width, this.size.height);
                    }
                }
            });
        }
        this.table.setColumnRenderer(1 + n2, new JavaNameRenderer(Icons.getIcon((String)"ProfilerIcons.NodeLeaf")));
        this.table.setColumnRenderer(2 + n2, this.renderers[0]);
        this.table.setColumnRenderer(3 + n2, this.renderers[1]);
        this.table.setColumnRenderer(4 + n2, this.renderers[2]);
        this.table.setColumnRenderer(5 + n2, this.renderers[3]);
        this.table.setColumnRenderer(6 + n2, this.renderers[4]);
        if (this.selection != null) {
            n = new JLabel((String)this.table.getColumnName((int)0)).getPreferredSize().width;
            this.table.setDefaultColumnWidth(0, n + 15);
        }
        this.table.setDefaultColumnWidth(2 + n2, this.renderers[0].getMaxNoBarWidth());
        this.table.setDefaultColumnWidth(3 + n2, this.renderers[1].getOptimalWidth());
        this.table.setDefaultColumnWidth(4 + n2, this.renderers[2].getMaxNoBarWidth());
        this.table.setDefaultColumnWidth(5 + n2, this.renderers[3].getMaxNoBarWidth());
        this.sampled = !this.sampled;
        n = new JLabel((String)this.table.getColumnName((int)(6 + n2))).getPreferredSize().width;
        this.sampled = !this.sampled;
        n = Math.max(n, new JLabel((String)this.table.getColumnName((int)(6 + n2))).getPreferredSize().width);
        this.table.setDefaultColumnWidth(6 + n2, Math.max(this.renderers[4].getNoBarWidth(), n + 15));
        ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(this.table, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)profilerTableContainer, "Center");
    }

    private void setToolTips() {
        String[] stringArray;
        if (this.selection == null) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = SELF_TIME_COLUMN_TOOLTIP;
            stringArray2[2] = SELF_TIME_CPU_COLUMN_TOOLTIP;
            stringArray2[3] = TOTAL_TIME_COLUMN_TOOLTIP;
            stringArray2[4] = TOTAL_TIME_CPU_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[5] = this.sampled ? HITS_COLUMN_TOOLTIP : INVOCATIONS_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[7];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = SELF_TIME_COLUMN_TOOLTIP;
            stringArray3[3] = SELF_TIME_CPU_COLUMN_TOOLTIP;
            stringArray3[4] = TOTAL_TIME_COLUMN_TOOLTIP;
            stringArray3[5] = TOTAL_TIME_CPU_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[6] = this.sampled ? HITS_COLUMN_TOOLTIP : INVOCATIONS_COLUMN_TOOLTIP;
        }
        this.table.setColumnToolTips(stringArray);
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.table;
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
        if (this.data == null || n == -1) {
            return null;
        }
        if (n >= this.tableModel.getRowCount()) {
            return null;
        }
        n = this.table.convertRowIndexToModel(n);
        return this.idMap.get(this.data.getMethodIdAtRow(n));
    }

    static boolean isSelectable(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        return !sourceCodeSelection.getMethodName().endsWith("[native]");
    }

    private class CPUTableModel
    extends AbstractTableModel {
        private CPUTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            if (CPUTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return CPUView.COLUMN_NAME;
            }
            if (n == 2) {
                return CPUView.COLUMN_SELFTIME;
            }
            if (n == 3) {
                return CPUView.COLUMN_SELFTIME_CPU;
            }
            if (n == 4) {
                return CPUView.COLUMN_TOTALTIME;
            }
            if (n == 5) {
                return CPUView.COLUMN_TOTALTIME_CPU;
            }
            if (n == 6) {
                return CPUTableView.this.sampled ? CPUView.COLUMN_HITS : CPUView.COLUMN_INVOCATIONS;
            }
            if (n == 0) {
                return CPUView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (CPUTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return String.class;
            }
            if (n == 6) {
                return Integer.class;
            }
            if (n == 0) {
                return Boolean.class;
            }
            return Long.class;
        }

        @Override
        public int getRowCount() {
            return CPUTableView.this.data == null ? 0 : CPUTableView.this.data.getNRows();
        }

        @Override
        public int getColumnCount() {
            return CPUTableView.this.selection == null ? 6 : 7;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (CPUTableView.this.data == null) {
                return null;
            }
            if (CPUTableView.this.selection == null) {
                ++n2;
            }
            if (n2 == 1) {
                return CPUTableView.this.data.getMethodNameAtRow(n);
            }
            if (n2 == 2) {
                return CPUTableView.this.data.getTimeInMcs0AtRow(n);
            }
            if (n2 == 3) {
                return CPUTableView.this.twoTimeStamps ? CPUTableView.this.data.getTimeInMcs1AtRow(n) : 0L;
            }
            if (n2 == 4) {
                return CPUTableView.this.data.getTotalTimeInMcs0AtRow(n);
            }
            if (n2 == 5) {
                return CPUTableView.this.twoTimeStamps ? CPUTableView.this.data.getTotalTimeInMcs1AtRow(n) : 0L;
            }
            if (n2 == 6) {
                return CPUTableView.this.data.getNInvocationsAtRow(n);
            }
            if (n2 == 0) {
                if (CPUTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return CPUTableView.this.selection.contains(CPUTableView.this.idMap.get(CPUTableView.this.data.getMethodIdAtRow(n)));
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (CPUTableView.this.selection == null) {
                ++n2;
            }
            if (n2 == 0) {
                int n3 = CPUTableView.this.data.getMethodIdAtRow(n);
                if (Boolean.TRUE.equals(object)) {
                    CPUTableView.this.selection.add(CPUTableView.this.idMap.get(n3));
                } else {
                    CPUTableView.this.selection.remove(CPUTableView.this.idMap.get(n3));
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (CPUTableView.this.selection == null) {
                ++n2;
            }
            if (n2 != 0) {
                return false;
            }
            return CPUTableView.isSelectable((ClientUtils.SourceCodeSelection)CPUTableView.this.idMap.get(CPUTableView.this.data.getMethodIdAtRow(n)));
        }
    }
}

