/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.cpu;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeansFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public final class ThreadInfoProvider {
    private static final Logger LOGGER = Logger.getLogger(ThreadInfoProvider.class.getName());
    private final String status;
    private boolean useGetThreadInfo;
    private ThreadMXBean threadBean;

    public ThreadInfoProvider(Application app) {
        this.status = this.initialize(app);
    }

    public String getStatus() {
        return this.status;
    }

    public ThreadMXBean getThreadMXBean() {
        return this.threadBean;
    }

    private String initialize(Application application) {
        if (application.getState() != 1) {
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable");
        }
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
        if (jmxModel == null) {
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_init_jmx");
        }
        if (jmxModel.getConnectionState() != JmxModel.ConnectionState.CONNECTED) {
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_create_jmx");
        }
        JvmMXBeans mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel);
        if (mxbeans == null) {
            LOGGER.log(Level.INFO, "JvmMXBeansFactory.getJvmMXBeans(jmxModel) returns null for " + application);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads");
        }
        this.threadBean = mxbeans.getThreadMXBean();
        if (this.threadBean == null) {
            LOGGER.log(Level.INFO, "mxbeans.getThreadMXBean() returns null for " + application);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads");
        }
        this.useGetThreadInfo = JvmFactory.getJVMFor((Application)application).is15();
        try {
            this.dumpAllThreads();
        }
        catch (SecurityException e) {
            LOGGER.log(Level.INFO, "threadBean.getThreadInfo(ids, maxDepth) throws SecurityException for " + application, e);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads");
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "threadBean.getThreadInfo(ids, maxDepth) throws Throwable for " + application, t);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads");
        }
        return null;
    }

    ThreadInfo[] dumpAllThreads() {
        if (this.useGetThreadInfo) {
            return this.threadBean.getThreadInfo(this.threadBean.getAllThreadIds(), Integer.MAX_VALUE);
        }
        return this.threadBean.dumpAllThreads(false, false);
    }
}

