/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;

public class SplittedPanel
extends JComponent
implements Accessible {
    static final long serialVersionUID = 5058424218525927233L;
    public static final int NONE = 0;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    public static final Object ADD_SPLITTER = new Integer(0);
    public static final Object ADD_FIRST = new Integer(1);
    public static final Object ADD_SECOND = new Integer(2);
    public static final Object ADD_LEFT = ADD_FIRST;
    public static final Object ADD_TOP = ADD_FIRST;
    public static final Object ADD_RIGHT = ADD_SECOND;
    public static final Object ADD_BOTTOM = ADD_SECOND;
    public static final int FIRST_PREFERRED = -1;
    public static final int SECOND_PREFERRED = -2;
    public static final int RAISED_SPLITTER = 0;
    public static final int EMPTY_SPLITTER = 1;
    public static final int DEFAULT_SPLITTER = 0;
    private static MessageFormat nameFormat = null;
    private static MessageFormat descriptionFormat = null;
    private static final int DEFAULT_SPLIT_TYPE = 2;
    private int resetPosition = -1;
    private Boolean popupMenuEnabled;
    private boolean drawBumps;
    private Component firstComponent = null;
    private Component secondComponent = null;
    private Component splitter = new DefaultSplitter(this.getDefaultSplitterSize());
    private int splitterType = 0;
    private transient MouseListenerAdapter mouseAdapter;
    private int splitType = 0;
    private int splitPosition = 50;
    private boolean absolute = false;
    private boolean dragable = true;
    private boolean continuousLayout = true;
    private boolean splitTypeChangeEnabled = true;
    private boolean swapPanesEnabled = true;
    private boolean keepSecondSame = false;
    private boolean keepFirstSame = false;
    private transient boolean splitIsChanging = false;
    private int dragPos = -1;
    private boolean panesSwapped = false;
    private transient JPopupMenu popupMenu;
    private transient JRadioButtonMenuItem verticalCMI;
    private transient JRadioButtonMenuItem horizontalCMI;
    private transient JMenuItem swapCMI;
    private transient JMenuItem splitterCMI;
    private transient Vector<SplitChangeListener> listeners;
    private AccessibleContext accessibleContext = null;

    public SplittedPanel() {
        this.setLayout(new SplitLayout());
        this.add(this.splitter, ADD_SPLITTER);
        this.init();
        RuntimeException runtimeException = new RuntimeException("SplittedPanel is deprecated.  Please use JSplitPane instead");
        Logger.getLogger(SplittedPanel.class.getName()).log(Level.WARNING, null, runtimeException);
    }

    private void init() {
        this.setSplitterCursor();
        this.mouseAdapter = new MouseListenerAdapter();
        if (this.dragable) {
            this.splitter.addMouseMotionListener(this.mouseAdapter);
            this.splitter.addMouseListener(this.mouseAdapter);
            this.addSplitChangeListener(this.mouseAdapter);
        }
        this.initAccessible();
    }

    public void updateUI() {
        super.updateUI();
        this.updateSplitting();
        Object object = UIManager.get("nb.SplittedPanel.drawBumps");
        this.drawBumps = Boolean.TRUE.equals(object);
    }

    protected void updateSplitting() {
        if (this.firstComponent != null && this.secondComponent != null) {
            this.invalidate();
            this.firstComponent.invalidate();
            this.splitter.invalidate();
            this.secondComponent.invalidate();
            this.validate();
        }
    }

    protected void computeSizesAfterFlip() {
        if (this.firstComponent == null || this.secondComponent == null) {
            return;
        }
        Dimension dimension = this.getSize();
        switch (this.splitType) {
            case 1: {
                if (dimension.width == 0) break;
                int n = this.splitter.getPreferredSize().height;
                int n2 = (dimension.height - n) * this.firstComponent.getSize().width / dimension.width;
                this.firstComponent.setSize(new Dimension(dimension.width, n2));
                this.secondComponent.setSize(new Dimension(dimension.width, dimension.height - n2 - n));
                break;
            }
            case 2: {
                if (dimension.height == 0) break;
                int n = this.splitter.getPreferredSize().width;
                int n3 = (dimension.width - n) * this.firstComponent.getSize().height / dimension.height;
                this.firstComponent.setSize(new Dimension(n3, dimension.height));
                this.secondComponent.setSize(new Dimension(dimension.width - n3 - n, dimension.height));
            }
        }
    }

    protected void setSplitterCursor() {
        if (this.dragable) {
            if (this.splitType == 1) {
                this.splitter.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                this.splitter.setCursor(Cursor.getPredefinedCursor(10));
            }
        } else {
            this.splitter.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private boolean isPopupMenuEnabled() {
        if (this.popupMenuEnabled == null) {
            Object object = this.getClientProperty("popupMenuEnabled");
            this.popupMenuEnabled = object instanceof Boolean ? (Boolean)object : Boolean.TRUE;
        }
        return this.popupMenuEnabled;
    }

    protected void updatePopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            ResourceBundle resourceBundle = NbBundle.getBundle(SplittedPanel.class);
            this.verticalCMI = new JRadioButtonMenuItem(resourceBundle.getString("SplittedPanelVertical"));
            this.popupMenu.add(this.verticalCMI);
            this.horizontalCMI = new JRadioButtonMenuItem(resourceBundle.getString("SplittedPanelHorizontal"));
            this.popupMenu.add(this.horizontalCMI);
            this.popupMenu.add(new JSeparator());
            this.swapCMI = new JMenuItem(resourceBundle.getString("SplittedPanelSwap"));
            this.popupMenu.add(this.swapCMI);
            this.popupMenu.add(new JSeparator());
            this.splitterCMI = new JMenuItem(resourceBundle.getString("ResetSplitter"));
            this.popupMenu.add(this.splitterCMI);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SplittedPanel.this.horizontalCMI.equals(actionEvent.getSource())) {
                        SplittedPanel.this.setSplitType(2);
                    } else {
                        SplittedPanel.this.setSplitType(1);
                    }
                }
            };
            this.verticalCMI.addActionListener(actionListener);
            this.horizontalCMI.addActionListener(actionListener);
            this.swapCMI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SplittedPanel.this.swapPanes();
                }
            });
            this.splitterCMI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SplittedPanel.this.resetSplitter();
                }
            });
        }
        if (this.splitType == 1) {
            this.verticalCMI.setSelected(true);
            this.horizontalCMI.setSelected(false);
        } else {
            this.verticalCMI.setSelected(false);
            this.horizontalCMI.setSelected(true);
        }
        if (this.splitTypeChangeEnabled) {
            this.verticalCMI.setEnabled(true);
            this.horizontalCMI.setEnabled(true);
        } else {
            this.verticalCMI.setEnabled(false);
            this.horizontalCMI.setEnabled(false);
        }
        if (this.swapPanesEnabled) {
            this.swapCMI.setEnabled(true);
        } else {
            this.swapCMI.setEnabled(false);
        }
        this.splitterCMI.setEnabled(this.getSplitPosition() != -1 && this.getSplitPosition() != -2);
    }

    private void resetSplitter() {
        if (this.getSplitPosition() != -1 && this.getSplitPosition() != -2) {
            this.setSplitPosition(this.resetPosition);
            if (this.splitterCMI != null) {
                this.splitterCMI.setEnabled(false);
            }
        }
    }

    public void swapPanes() {
        if (!this.swapPanesEnabled) {
            return;
        }
        if (this.firstComponent == null || this.secondComponent == null) {
            return;
        }
        this.splitIsChanging = true;
        boolean bl = this.panesSwapped = !this.panesSwapped;
        if (this.keepSecondSame) {
            this.keepSecondSame = false;
            this.keepFirstSame = true;
        } else if (this.keepFirstSame) {
            this.keepSecondSame = true;
            this.keepFirstSame = false;
        }
        Component component = this.firstComponent;
        Component component2 = this.secondComponent;
        this.remove(component);
        this.remove(component2);
        this.add(component2, ADD_FIRST);
        this.add(component, ADD_SECOND);
        this.updateSplitting();
        this.splitIsChanging = false;
    }

    public boolean getPanesSwapped() {
        return this.panesSwapped;
    }

    public int getSplitType() {
        return this.splitType;
    }

    public void setSplitType(int n) {
        if (this.splitType == n) {
            return;
        }
        int n2 = this.splitType;
        this.splitType = n;
        if (n2 != 0 && this.splitType != 0) {
            this.computeSizesAfterFlip();
        }
        this.setSplitterCursor();
        this.updateSplitting();
        this.updatePopupMenu();
        this.initAccessible();
    }

    public int getSplitPosition() {
        return this.splitPosition;
    }

    public void setSplitPosition(int n) {
        if (this.splitPosition == n) {
            return;
        }
        int n2 = this.splitPosition;
        this.splitPosition = n;
        this.splitIsChanging = true;
        this.updateSplitting();
        this.fireSplitChange(n2, this.splitPosition);
        this.splitIsChanging = false;
    }

    public int getSplitterType() {
        return this.splitterType;
    }

    private int getDefaultSplitterSize() {
        Object object = UIManager.get("nb.SplittedPanel.dividerSize");
        if (object != null) {
            return (Integer)object;
        }
        object = UIManager.get("SplitPane.dividerSize");
        if (object != null) {
            return (Integer)object;
        }
        return 6;
    }

    public void setSplitterType(int n) {
        if (this.splitterType == n) {
            return;
        }
        this.splitterType = n;
        switch (this.splitterType) {
            case 1: {
                this.splitter = new EmptySplitter();
                break;
            }
            default: {
                this.splitter = new DefaultSplitter(this.getDefaultSplitterSize());
            }
        }
        this.add(this.splitter, ADD_SPLITTER);
        this.updateSplitting();
    }

    public Component getSplitterComponent() {
        return this.splitter;
    }

    public void setSplitterComponent(Component component) {
        if (this.splitter == component) {
            return;
        }
        if (this.dragable) {
            this.splitter.removeMouseMotionListener(this.mouseAdapter);
            this.splitter.removeMouseListener(this.mouseAdapter);
        }
        this.remove(this.splitter);
        this.splitter = component;
        this.add(this.splitter, ADD_SPLITTER);
        if (this.dragable) {
            this.splitter.addMouseMotionListener(this.mouseAdapter);
            this.splitter.addMouseListener(this.mouseAdapter);
        }
        this.setSplitterCursor();
        this.updateSplitting();
    }

    public boolean isSplitAbsolute() {
        return this.absolute;
    }

    public void setSplitAbsolute(boolean bl) {
        if (this.absolute == bl) {
            return;
        }
        this.absolute = bl;
        this.updateSplitting();
    }

    public boolean isSplitDragable() {
        return this.dragable;
    }

    public void setSplitDragable(boolean bl) {
        if (this.dragable == bl) {
            return;
        }
        this.dragable = bl;
        if (this.dragable) {
            this.splitter.addMouseMotionListener(this.mouseAdapter);
            this.splitter.addMouseListener(this.mouseAdapter);
        } else {
            this.splitter.removeMouseMotionListener(this.mouseAdapter);
            this.splitter.removeMouseListener(this.mouseAdapter);
        }
        this.setSplitterCursor();
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void setContinuousLayout(boolean bl) {
        this.continuousLayout = bl;
    }

    public boolean getKeepFirstSame() {
        return this.keepFirstSame;
    }

    public void setKeepFirstSame(boolean bl) {
        this.keepFirstSame = bl;
    }

    public boolean getKeepSecondSame() {
        return this.keepSecondSame;
    }

    public void setKeepSecondSame(boolean bl) {
        this.keepSecondSame = bl;
    }

    public boolean isSplitTypeChangeEnabled() {
        return this.splitTypeChangeEnabled;
    }

    public void setSplitTypeChangeEnabled(boolean bl) {
        if (this.splitTypeChangeEnabled == bl) {
            return;
        }
        this.splitTypeChangeEnabled = bl;
        this.updatePopupMenu();
    }

    public boolean isSwapPanesEnabled() {
        return this.swapPanesEnabled;
    }

    public void setSwapPanesEnabled(boolean bl) {
        if (this.swapPanesEnabled == bl) {
            return;
        }
        this.swapPanesEnabled = bl;
        this.updatePopupMenu();
    }

    public void addSplitChangeListener(SplitChangeListener splitChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(splitChangeListener);
    }

    public void removeSplitChangeListener(SplitChangeListener splitChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(splitChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSplitChange(int n, int n2) {
        Vector vector;
        if (this.listeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.listeners.clone();
        }
        object = vector.elements();
        SplitChangeEvent splitChangeEvent = new SplitChangeEvent(this, n, n2);
        while (object.hasMoreElements()) {
            SplitChangeListener splitChangeListener = (SplitChangeListener)object.nextElement();
            splitChangeListener.splitChanged(splitChangeEvent);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.SPLIT_PANE;
                }
            };
            this.initAccessible();
        }
        return this.accessibleContext;
    }

    private void initAccessible() {
        ResourceBundle resourceBundle;
        if (nameFormat == null) {
            resourceBundle = NbBundle.getBundle(SplittedPanel.class);
            nameFormat = new MessageFormat(resourceBundle.getString("ACS_SplittedPanel_Name"));
        }
        this.getAccessibleContext().setAccessibleName(nameFormat.format(new Object[]{this.firstComponent == null || !(this.firstComponent instanceof Accessible) ? null : this.firstComponent.getAccessibleContext().getAccessibleName(), this.secondComponent == null || !(this.secondComponent instanceof Accessible) ? null : this.secondComponent.getAccessibleContext().getAccessibleName()}));
        if (descriptionFormat == null) {
            resourceBundle = NbBundle.getBundle(SplittedPanel.class);
            descriptionFormat = new MessageFormat(resourceBundle.getString("ACS_SplittedPanel_Description"));
        }
        this.getAccessibleContext().setAccessibleDescription(descriptionFormat.format(new Object[]{this.firstComponent == null || !(this.firstComponent instanceof Accessible) ? null : this.firstComponent.getAccessibleContext().getAccessibleDescription(), this.secondComponent == null || !(this.secondComponent instanceof Accessible) ? null : this.secondComponent.getAccessibleContext().getAccessibleDescription()}));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    class DefaultSplitter
    extends JComponent
    implements Accessible {
        static final long serialVersionUID = -4223135481223014719L;
        private int splitterSize;

        public DefaultSplitter(int n) {
            this.splitterSize = n;
            if (this.splitterSize < 2) {
                this.splitterSize = 2;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.splitterSize, this.splitterSize);
        }

        public void paint(Graphics graphics) {
            Border border;
            super.paint(graphics);
            if (this.splitterSize <= 2) {
                return;
            }
            Dimension dimension = this.getSize();
            int n = dimension.height - 1;
            graphics.setColor(this.getBackground());
            Color color = UIManager.getColor("controlLtHighlight");
            Color color2 = UIManager.getColor("controlDkShadow");
            boolean bl = UIManager.getLookAndFeel().getClass() == MetalLookAndFeel.class;
            boolean bl2 = true;
            boolean bl3 = true;
            if (SplittedPanel.this.firstComponent instanceof JComponent) {
                border = ((JComponent)SplittedPanel.this.firstComponent).getBorder();
                boolean bl4 = bl2 = border != null && !(border instanceof EmptyBorder);
            }
            if (SplittedPanel.this.secondComponent instanceof JComponent) {
                border = ((JComponent)SplittedPanel.this.secondComponent).getBorder();
                boolean bl5 = bl3 = border != null && !(border instanceof EmptyBorder);
            }
            if (SplittedPanel.this.panesSwapped) {
                boolean bl6 = bl2;
                bl2 = bl3;
                bl3 = bl6;
            }
            if (bl && this.splitterSize > 3 && SplittedPanel.this.drawBumps) {
                int n2;
                int n3 = bl2 && SplittedPanel.this.splitType == 1 ? 0 : 2;
                int n4 = n2 = bl2 && SplittedPanel.this.splitType == 2 ? 0 : 2;
                while (n4 + 1 < dimension.width) {
                    int n5 = n3;
                    while (n5 + 1 < n) {
                        graphics.setColor(this.getBackground().brighter());
                        graphics.drawLine(n4, n5, n4, n5);
                        if (n4 < dimension.width && n5 < n) {
                            graphics.drawLine(n4 + 2, n5 + 2, n4 + 2, n5 + 2);
                        }
                        graphics.setColor(this.getBackground().darker().darker());
                        graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                        if (n4 < dimension.width && n5 < n) {
                            graphics.drawLine(n4 + 3, n5 + 3, n4 + 3, n5 + 3);
                        }
                        n5 += 4;
                    }
                    n4 += 4;
                }
            }
            if (SplittedPanel.this.splitType == 2) {
                int n6 = (dimension.width - this.splitterSize) / 2;
                if (!bl2) {
                    graphics.setColor(bl ? color2 : color);
                    graphics.drawLine(n6, 0, n6, dimension.height - 1);
                    if (bl) {
                        graphics.setColor(color);
                        graphics.drawLine(n6 + 1, 0, n6 + 1, dimension.height - 1);
                    }
                }
                if (!bl3) {
                    graphics.setColor(bl ? color : color2);
                    graphics.drawLine(n6 + this.splitterSize - 1, 0, n6 + this.splitterSize - 1, dimension.height - 1);
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.drawLine(n6 + this.splitterSize - 2, 0, n6 + this.splitterSize - 2, dimension.height - 1);
                    }
                }
            } else if (SplittedPanel.this.splitType == 1) {
                int n7 = (dimension.height - this.splitterSize) / 2;
                if (!bl2) {
                    graphics.setColor(bl ? color2 : color);
                    graphics.drawLine(0, n7, dimension.width - 1, n7);
                    if (bl) {
                        graphics.setColor(color);
                        graphics.drawLine(0, n7 + 1, dimension.width - 1, n7 + 1);
                    }
                }
                if (!bl3) {
                    graphics.setColor(bl ? color : color2);
                    graphics.drawLine(0, n7 + this.splitterSize - 1, dimension.width - 1, n7 + this.splitterSize - 1);
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.drawLine(0, n7 + this.splitterSize - 2, dimension.width - 1, n7 + this.splitterSize - 2);
                    }
                }
            }
        }

        public AccessibleContext getAccessibleContext() {
            return SplittedPanel.this.getAccessibleContext();
        }
    }

    public static class EmptySplitter
    extends JComponent
    implements Accessible {
        static final long serialVersionUID = 929648193440460693L;
        private int width;
        private AccessibleContext accessibleContext;

        public EmptySplitter() {
            this(0);
        }

        public EmptySplitter(int n) {
            ResourceBundle resourceBundle = NbBundle.getBundle(SplittedPanel.class);
            this.accessibleContext = null;
            this.width = n;
            this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_SplittedPanel_EmptySplitter"));
            this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_SplittedPanel_EmptySplitter"));
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.width);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JComponent.AccessibleJComponent(){

                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.SPLIT_PANE;
                    }
                };
            }
            return this.accessibleContext;
        }
    }

    class MouseListenerAdapter
    extends MouseUtils.PopupMouseAdapter
    implements MouseListener,
    MouseMotionListener,
    SplitChangeListener {
        MouseListenerAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            SplittedPanel.this.updatePopupMenu();
            if (SplittedPanel.this.isPopupMenuEnabled()) {
                SplittedPanel.this.popupMenu.show(SplittedPanel.this.splitter, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (!SplittedPanel.this.continuousLayout) {
                if (SplittedPanel.this.dragPos == -1) {
                    return;
                }
                if (!SplittedPanel.this.absolute) {
                    Dimension dimension = SplittedPanel.this.getSize();
                    if (SplittedPanel.this.splitType == 1) {
                        SplittedPanel.this.dragPos = 100 * SplittedPanel.this.dragPos / dimension.height;
                    } else {
                        SplittedPanel.this.dragPos = 100 * SplittedPanel.this.dragPos / dimension.width;
                    }
                }
                SplittedPanel.this.setSplitPosition(SplittedPanel.this.dragPos);
                SplittedPanel.this.dragPos = -1;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SplittedPanel.this.continuousLayout) {
                Dimension dimension = SplittedPanel.this.getSize();
                Point point = SplittedPanel.this.splitter.getLocation();
                mouseEvent.translatePoint(point.x, point.y);
                if (SplittedPanel.this.splitType == 1) {
                    SplittedPanel.this.dragPos = mouseEvent.getY();
                    if (SplittedPanel.this.dragPos > dimension.height) {
                        SplittedPanel.this.dragPos = dimension.height;
                    }
                } else {
                    SplittedPanel.this.dragPos = mouseEvent.getX();
                    if (SplittedPanel.this.dragPos > dimension.width) {
                        SplittedPanel.this.dragPos = dimension.width;
                    }
                }
                if (SplittedPanel.this.dragPos < 0) {
                    SplittedPanel.this.dragPos = 0;
                }
                if (SplittedPanel.this.continuousLayout) {
                    if (SplittedPanel.this.dragPos == -1) {
                        return;
                    }
                    int n = SplittedPanel.this.dragPos;
                    if (!SplittedPanel.this.absolute) {
                        n = SplittedPanel.this.splitType == 1 ? 100 * SplittedPanel.this.dragPos / dimension.height : 100 * SplittedPanel.this.dragPos / dimension.width;
                    }
                    SplittedPanel.this.setSplitPosition(n);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            if (mouseEvent.getClickCount() == 2 && SplittedPanel.this.isPopupMenuEnabled()) {
                SplittedPanel.this.resetSplitter();
            }
        }

        public void splitChanged(SplitChangeEvent splitChangeEvent) {
            if (splitChangeEvent.getNewValue() == -1 || splitChangeEvent.getNewValue() == -2) {
                SplittedPanel.this.resetPosition = splitChangeEvent.getNewValue();
                if (SplittedPanel.this.splitterCMI != null) {
                    SplittedPanel.this.splitterCMI.setEnabled(true);
                }
            }
        }
    }

    public static class SplitChangeEvent
    extends EventObject {
        static final long serialVersionUID = 6748966611210836878L;
        private int oldValue;
        private int newValue;

        public SplitChangeEvent(SplittedPanel splittedPanel, int n, int n2) {
            super(splittedPanel);
            this.oldValue = n;
            this.newValue = n2;
        }

        public int getOldValue() {
            return this.oldValue;
        }

        public int getNewValue() {
            return this.newValue;
        }
    }

    public static interface SplitChangeListener {
        public void splitChanged(SplitChangeEvent var1);
    }

    class SplitLayout
    implements LayoutManager2,
    Serializable {
        static final long serialVersionUID = 2034500275182524789L;

        SplitLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            throw new IllegalArgumentException("You must use the add(Component, Object) method for adding");
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object == ADD_SPLITTER) {
                SplittedPanel.this.splitter = component;
            } else if (object == ADD_FIRST) {
                if (SplittedPanel.this.firstComponent != null && SplittedPanel.this.secondComponent == null) {
                    SplittedPanel.this.secondComponent = SplittedPanel.this.firstComponent;
                }
                SplittedPanel.this.firstComponent = component;
                if (SplittedPanel.this.secondComponent != null && SplittedPanel.this.splitType == 0) {
                    SplittedPanel.this.splitType = 2;
                }
            } else if (object == ADD_SECOND) {
                if (SplittedPanel.this.firstComponent == null) {
                    SplittedPanel.this.firstComponent = component;
                } else {
                    SplittedPanel.this.secondComponent = component;
                    if (SplittedPanel.this.splitType == 0) {
                        SplittedPanel.this.splitType = 2;
                    }
                }
            } else {
                throw new IllegalArgumentException("You must use one of the SplittedPanel.ADD_XXX constraints Objects");
            }
            SplittedPanel.this.initAccessible();
        }

        public void removeLayoutComponent(Component component) {
            if (component.equals(SplittedPanel.this.secondComponent)) {
                SplittedPanel.this.secondComponent = null;
            } else if (component.equals(SplittedPanel.this.firstComponent)) {
                SplittedPanel.this.firstComponent = null;
                if (SplittedPanel.this.secondComponent != null) {
                    SplittedPanel.this.firstComponent = SplittedPanel.this.secondComponent;
                    SplittedPanel.this.secondComponent = null;
                }
            }
            SplittedPanel.this.initAccessible();
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            int n = 0;
            int n2 = 0;
            if (SplittedPanel.this.firstComponent != null) {
                dimension = SplittedPanel.this.firstComponent.getPreferredSize();
                n = dimension.width;
                n2 = dimension.height;
            }
            if (SplittedPanel.this.secondComponent != null) {
                dimension = SplittedPanel.this.secondComponent.getPreferredSize();
                if (SplittedPanel.this.splitType == 1) {
                    int n3 = ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().height;
                    if (n < dimension.width) {
                        n = dimension.width;
                    }
                    n2 += n3 + dimension.height;
                } else {
                    int n4 = ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().width;
                    if (n2 < dimension.height) {
                        n2 = dimension.height;
                    }
                    n += n4 + dimension.width;
                }
            }
            return new Dimension(n, n2);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            int n = 0;
            int n2 = 0;
            if (SplittedPanel.this.firstComponent != null) {
                dimension = SplittedPanel.this.firstComponent.getMinimumSize();
                n = dimension.width;
                n2 = dimension.height;
            }
            if (SplittedPanel.this.secondComponent != null) {
                dimension = SplittedPanel.this.secondComponent.getMinimumSize();
                if (SplittedPanel.this.splitType == 1) {
                    int n3 = ((SplittedPanel)SplittedPanel.this).splitter.getMinimumSize().height;
                    if (n < dimension.width) {
                        n = dimension.width;
                    }
                    n2 += n3 + dimension.height;
                } else {
                    int n4 = ((SplittedPanel)SplittedPanel.this).splitter.getMinimumSize().width;
                    if (n2 < dimension.height) {
                        n2 = dimension.height;
                    }
                    n += n4 + dimension.width;
                }
            }
            return new Dimension(n, n2);
        }

        public void layoutContainer(Container container) {
            int n;
            Dimension dimension = container.getSize();
            int n2 = SplittedPanel.this.splitPosition;
            if (SplittedPanel.this.splitPosition == -1) {
                n2 = SplittedPanel.this.splitType == 1 ? ((SplittedPanel)SplittedPanel.this).firstComponent.getPreferredSize().height : ((SplittedPanel)SplittedPanel.this).firstComponent.getPreferredSize().width;
            } else if (SplittedPanel.this.splitPosition == -2) {
                n2 = SplittedPanel.this.splitType == 1 ? dimension.height - ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().width - ((SplittedPanel)SplittedPanel.this).secondComponent.getPreferredSize().height : dimension.width - ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().height - ((SplittedPanel)SplittedPanel.this).secondComponent.getPreferredSize().width;
            } else if (!SplittedPanel.this.absolute) {
                n = SplittedPanel.this.splitPosition;
                if (n > 100) {
                    n = 100;
                }
                n2 = SplittedPanel.this.splitType == 1 ? dimension.height * n / 100 : dimension.width * n / 100;
            }
            if (SplittedPanel.this.splitType != 0 && SplittedPanel.this.firstComponent != null && SplittedPanel.this.secondComponent != null) {
                if (SplittedPanel.this.splitType == 1) {
                    n = ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().height;
                    if (SplittedPanel.this.firstComponent == null || SplittedPanel.this.secondComponent == null) {
                        n = 0;
                    }
                    if (SplittedPanel.this.keepSecondSame && !SplittedPanel.this.splitIsChanging) {
                        Dimension dimension2 = SplittedPanel.this.secondComponent.getSize();
                        if (dimension2.height != 0) {
                            n2 = dimension.height - dimension2.height - n;
                        }
                    }
                    if (n2 + n > dimension.height) {
                        n2 = dimension.height - n;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    SplittedPanel.this.firstComponent.setBounds(new Rectangle(0, 0, dimension.width, n2));
                    SplittedPanel.this.splitter.setBounds(new Rectangle(0, n2, dimension.width, n));
                    SplittedPanel.this.secondComponent.setBounds(new Rectangle(0, n2 + n, dimension.width, dimension.height - n2 - n));
                } else {
                    n = ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().width;
                    if (SplittedPanel.this.firstComponent == null || SplittedPanel.this.secondComponent == null) {
                        n = 0;
                    }
                    if (SplittedPanel.this.keepSecondSame && !SplittedPanel.this.splitIsChanging) {
                        Dimension dimension3 = SplittedPanel.this.secondComponent.getSize();
                        if (dimension3.width != 0) {
                            n2 = dimension.width - dimension3.width - n;
                        }
                    }
                    if (n2 + n > dimension.width) {
                        n2 = dimension.width - n;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    SplittedPanel.this.firstComponent.setBounds(new Rectangle(0, 0, n2, dimension.height));
                    SplittedPanel.this.splitter.setBounds(new Rectangle(n2, 0, n, dimension.height));
                    SplittedPanel.this.secondComponent.setBounds(new Rectangle(n2 + n, 0, dimension.width - n2 - n, dimension.height));
                }
            } else if (SplittedPanel.this.firstComponent != null) {
                SplittedPanel.this.firstComponent.setBounds(new Rectangle(0, 0, dimension.width - 1, dimension.height - 1));
                if (SplittedPanel.this.splitter != null) {
                    SplittedPanel.this.splitter.setBounds(0, 0, 0, 0);
                }
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

