export = StoredEvent;
/**
 * Create a store event.
 * @constructor
 * @param {string} roomId The matrix room ID
 * @param {string} eventId The matrix event ID
 * @param {string} remoteRoomId The remote room ID
 * @param {string} remoteEventId The remote event ID
 * @param {any} extras Any extra data that may be included with the event.
 */
declare function StoredEvent(roomId: string, eventId: string, remoteRoomId: string, remoteEventId: string, extras: any): void;
declare class StoredEvent {
    /**
     * Create a store event.
     * @constructor
     * @param {string} roomId The matrix room ID
     * @param {string} eventId The matrix event ID
     * @param {string} remoteRoomId The remote room ID
     * @param {string} remoteEventId The remote event ID
     * @param {any} extras Any extra data that may be included with the event.
     */
    constructor(roomId: string, eventId: string, remoteRoomId: string, remoteEventId: string, extras: any);
    roomId: string;
    eventId: string;
    remoteRoomId: string;
    remoteEventId: string;
    _extras: any;
    getId(): string;
    getMatrixRoomId(): string;
    getMatrixEventId(): string;
    getRemoteRoomId(): string;
    getRemoteEventId(): string;
    get(key: string): any;
    set(key: string, val: any): void;
    serialize(): Object;
}
declare namespace StoredEvent {
    export function deserialize(data: Object): StoredEvent;
}
