/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockArrow;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.svek.DirectionalTextBlock;
import net.sourceforge.plantuml.svek.GuideLine;

public class StringWithArrow {
    private final String label;
    private final LinkArrow linkArrow;

    public StringWithArrow(String completeLabel) {
        if (completeLabel == null) {
            this.linkArrow = LinkArrow.NONE_OR_SEVERAL;
            this.label = null;
            return;
        }
        if (Display.hasSeveralGuideLines(completeLabel = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(completeLabel, "\""))) {
            this.linkArrow = LinkArrow.NONE_OR_SEVERAL;
            this.label = completeLabel;
        } else if ("<".equals(completeLabel)) {
            this.linkArrow = LinkArrow.BACKWARD;
            this.label = null;
        } else if (">".equals(completeLabel)) {
            this.linkArrow = LinkArrow.DIRECT_NORMAL;
            this.label = null;
        } else if (completeLabel.startsWith("< ")) {
            this.linkArrow = LinkArrow.BACKWARD;
            this.label = StringUtils.trin(completeLabel.substring(2));
        } else if (completeLabel.startsWith("> ")) {
            this.linkArrow = LinkArrow.DIRECT_NORMAL;
            this.label = StringUtils.trin(completeLabel.substring(2));
        } else if (completeLabel.endsWith(" >")) {
            this.linkArrow = LinkArrow.DIRECT_NORMAL;
            this.label = StringUtils.trin(completeLabel.substring(0, completeLabel.length() - 2));
        } else if (completeLabel.endsWith(" <")) {
            this.linkArrow = LinkArrow.BACKWARD;
            this.label = StringUtils.trin(completeLabel.substring(0, completeLabel.length() - 2));
        } else {
            this.linkArrow = LinkArrow.NONE_OR_SEVERAL;
            this.label = completeLabel;
        }
    }

    public final String getLabel() {
        return this.label;
    }

    public final LinkArrow getLinkArrow() {
        return this.linkArrow;
    }

    public final Display getDisplay() {
        return Display.getWithNewlines(this.label);
    }

    public static TextBlock addMagicArrow(TextBlock label, GuideLine guide, FontConfiguration font) {
        TextBlockArrow arrowRight = new TextBlockArrow(Direction.RIGHT, font);
        TextBlockArrow arrowLeft = new TextBlockArrow(Direction.LEFT, font);
        TextBlockArrow arrowUp = new TextBlockArrow(Direction.UP, font);
        TextBlockArrow arrowDown = new TextBlockArrow(Direction.DOWN, font);
        TextBlock right = TextBlockUtils.mergeLR(label, arrowRight, VerticalAlignment.CENTER);
        TextBlock left = TextBlockUtils.mergeLR(arrowLeft, label, VerticalAlignment.CENTER);
        TextBlock up = TextBlockUtils.mergeTB(arrowUp, label, HorizontalAlignment.CENTER);
        TextBlock down = TextBlockUtils.mergeTB(label, arrowDown, HorizontalAlignment.CENTER);
        return new DirectionalTextBlock(guide, right, left, up, down);
    }

    private static TextBlock addMagicArrow2(TextBlock label, GuideLine guide, FontConfiguration font) {
        TextBlockArrow arrowRight = new TextBlockArrow(Direction.RIGHT, font);
        TextBlockArrow arrowLeft = new TextBlockArrow(Direction.LEFT, font);
        TextBlockArrow arrowUp = new TextBlockArrow(Direction.UP, font);
        TextBlockArrow arrowDown = new TextBlockArrow(Direction.DOWN, font);
        TextBlock right = TextBlockUtils.mergeLR(label, arrowRight, VerticalAlignment.CENTER);
        TextBlock left = TextBlockUtils.mergeLR(arrowLeft, label, VerticalAlignment.CENTER);
        TextBlock up = TextBlockUtils.mergeLR(arrowUp, label, VerticalAlignment.CENTER);
        TextBlock down = TextBlockUtils.mergeLR(label, arrowDown, VerticalAlignment.CENTER);
        return new DirectionalTextBlock(guide, right, left, up, down);
    }

    public static TextBlock addSeveralMagicArrows(Display label, GuideLine guide, FontConfiguration font, HorizontalAlignment alignment, ISkinParam skinParam) {
        TextBlock result = TextBlockUtils.EMPTY_TEXT_BLOCK;
        for (CharSequence cs : label) {
            StringWithArrow tmp = new StringWithArrow(cs.toString());
            TextBlock block = tmp.getDisplay().create9(font, alignment, skinParam, skinParam.maxMessageSize());
            if (tmp.getLinkArrow() != LinkArrow.NONE_OR_SEVERAL) {
                block = StringWithArrow.addMagicArrow2(block, tmp.getLinkArrow().mute(guide), font);
            }
            result = TextBlockUtils.mergeTB(result, block, alignment);
        }
        return result;
    }
}

