/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.DaysAsDates;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.SubjectPattern;
import net.sourceforge.plantuml.project.lang.VerbIsOrAre;
import net.sourceforge.plantuml.project.lang.VerbIsOrAreNamed;
import net.sourceforge.plantuml.project.lang.VerbPattern;
import net.sourceforge.plantuml.project.time.Day;

public class SubjectDaysAsDates
implements SubjectPattern {
    @Override
    public Collection<VerbPattern> getVerbs() {
        return Arrays.asList(new VerbIsOrAre(), new VerbIsOrAreNamed());
    }

    @Override
    public IRegex toRegex() {
        return new RegexOr(this.regexTo(), this.regexAnd(), this.regexThen());
    }

    private IRegex regexTo() {
        return new RegexConcat(new RegexLeaf("YEAR1", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH1", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY1", "([\\d]{1,2})"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("to"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("YEAR2", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH2", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY2", "([\\d]{1,2})"));
    }

    private IRegex regexAnd() {
        return new RegexConcat(new RegexLeaf("YEAR3", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH3", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY3", "([\\d]{1,2})"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("and"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("COUNT_AND", "([\\d]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("days?"));
    }

    private IRegex regexThen() {
        return new RegexConcat(new RegexLeaf("then"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("COUNT_THEN", "([\\d]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("days?"));
    }

    @Override
    public Subject getSubject(GanttDiagram project, RegexResult arg) {
        String countAnd = arg.get("COUNT_AND", 0);
        if (countAnd != null) {
            Day date3 = this.getDate(arg, "3");
            int nb = Integer.parseInt(countAnd);
            return new DaysAsDates(project, date3, nb);
        }
        String countThen = arg.get("COUNT_THEN", 0);
        if (countThen != null) {
            Day date3 = project.getThenDate();
            int nb = Integer.parseInt(countThen);
            return new DaysAsDates(project, date3, nb);
        }
        Day date1 = this.getDate(arg, "1");
        Day date2 = this.getDate(arg, "2");
        return new DaysAsDates(date1, date2);
    }

    private Day getDate(RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("DAY" + suffix, 0));
        int month = Integer.parseInt(arg.get("MONTH" + suffix, 0));
        int year = Integer.parseInt(arg.get("YEAR" + suffix, 0));
        return Day.create(year, month, day);
    }
}

