# -*- coding: utf-8 -*-
info = {
    "name": "sq",
    "date_order": "DMY",
    "january": [
        "janar",
        "jan"
    ],
    "february": [
        "shkurt",
        "shk"
    ],
    "march": [
        "mars",
        "mar"
    ],
    "april": [
        "prill",
        "pri"
    ],
    "may": [
        "maj"
    ],
    "june": [
        "qershor",
        "qer"
    ],
    "july": [
        "korrik",
        "kor"
    ],
    "august": [
        "gusht",
        "gsh"
    ],
    "september": [
        "shtator",
        "sht"
    ],
    "october": [
        "tetor",
        "tet"
    ],
    "november": [
        "nëntor",
        "nën"
    ],
    "december": [
        "dhjetor",
        "dhj"
    ],
    "monday": [
        "e hënë",
        "hën"
    ],
    "tuesday": [
        "e martë",
        "mar"
    ],
    "wednesday": [
        "e mërkurë",
        "mër"
    ],
    "thursday": [
        "e enjte",
        "enj"
    ],
    "friday": [
        "e premte",
        "pre"
    ],
    "saturday": [
        "e shtunë",
        "sht"
    ],
    "sunday": [
        "e diel",
        "die"
    ],
    "am": [
        "paradite",
        "e paradites"
    ],
    "pm": [
        "pasdite",
        "e pasdites"
    ],
    "year": [
        "vit"
    ],
    "month": [
        "muaj"
    ],
    "week": [
        "javë"
    ],
    "day": [
        "ditë"
    ],
    "hour": [
        "orë"
    ],
    "minute": [
        "minutë",
        "min"
    ],
    "second": [
        "sekondë",
        "sek"
    ],
    "relative-type": {
        "1 year ago": [
            "vitin e kaluar"
        ],
        "0 year ago": [
            "këtë vit"
        ],
        "in 1 year": [
            "vitin e ardhshëm"
        ],
        "1 month ago": [
            "muajin e kaluar"
        ],
        "0 month ago": [
            "këtë muaj"
        ],
        "in 1 month": [
            "muajin e ardhshëm"
        ],
        "1 week ago": [
            "javën e kaluar"
        ],
        "0 week ago": [
            "këtë javë"
        ],
        "in 1 week": [
            "javën e ardhshme"
        ],
        "1 day ago": [
            "dje"
        ],
        "0 day ago": [
            "sot"
        ],
        "in 1 day": [
            "nesër"
        ],
        "0 hour ago": [
            "këtë orë"
        ],
        "0 minute ago": [
            "këtë minutë"
        ],
        "0 second ago": [
            "tani"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "pas (\\d+) viti",
            "pas (\\d+) vjetësh"
        ],
        "\\1 year ago": [
            "(\\d+) vit më parë",
            "(\\d+) vjet më parë"
        ],
        "in \\1 month": [
            "pas (\\d+) muaji",
            "pas (\\d+) muajsh"
        ],
        "\\1 month ago": [
            "(\\d+) muaj më parë"
        ],
        "in \\1 week": [
            "pas (\\d+) jave",
            "pas (\\d+) javësh"
        ],
        "\\1 week ago": [
            "(\\d+) javë më parë"
        ],
        "in \\1 day": [
            "pas (\\d+) dite",
            "pas (\\d+) ditësh"
        ],
        "\\1 day ago": [
            "(\\d+) ditë më parë"
        ],
        "in \\1 hour": [
            "pas (\\d+) ore",
            "pas (\\d+) orësh"
        ],
        "\\1 hour ago": [
            "(\\d+) orë më parë"
        ],
        "in \\1 minute": [
            "pas (\\d+) minute",
            "pas (\\d+) minutash",
            "pas (\\d+) min"
        ],
        "\\1 minute ago": [
            "(\\d+) minutë më parë",
            "(\\d+) minuta më parë",
            "(\\d+) min më parë"
        ],
        "in \\1 second": [
            "pas (\\d+) sekonde",
            "pas (\\d+) sekondash",
            "pas (\\d+) sek"
        ],
        "\\1 second ago": [
            "(\\d+) sekondë më parë",
            "(\\d+) sekonda më parë",
            "(\\d+) sek më parë"
        ]
    },
    "locale_specific": {
        "sq-MK": {
            "name": "sq-MK"
        },
        "sq-XK": {
            "name": "sq-XK"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
