/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.font.Font;
import com.jogamp.opengl.math.geom.AABBox;

public final class TypecastGlyph
implements Font.Glyph {
    public static final short INVALID_ID = -1;
    public static final short MAX_ID = -2;
    private final char symbol;
    private final OutlineShape shape;
    private final short id;
    private final Metrics metrics;

    protected TypecastGlyph(Font font, char c, short s, AABBox aABBox, int n, OutlineShape outlineShape) {
        this.symbol = c;
        this.shape = outlineShape;
        this.id = s;
        this.metrics = new Metrics(font, aABBox, n);
    }

    @Override
    public final Font getFont() {
        return this.metrics.getFont();
    }

    @Override
    public final char getSymbol() {
        return this.symbol;
    }

    final AABBox getBBoxUnsized() {
        return this.metrics.getBBox();
    }

    @Override
    public final AABBox getBBox() {
        return this.metrics.getBBox();
    }

    public final Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public final short getID() {
        return this.id;
    }

    @Override
    public final float getScale(float f) {
        return this.metrics.getScale(f);
    }

    @Override
    public final AABBox getBBox(AABBox aABBox, float f, float[] fArray) {
        return aABBox.copy(this.getBBox()).scale(this.getScale(f), fArray);
    }

    protected final void addAdvance(float f, float f2) {
        this.metrics.addAdvance(f, f2);
    }

    @Override
    public final float getAdvance(float f, boolean bl) {
        return this.metrics.getAdvance(f, bl);
    }

    @Override
    public final OutlineShape getShape() {
        return this.shape;
    }

    @Override
    public final int hashCode() {
        int n = 31 + this.getFont().getName(3).hashCode();
        return (n << 5) - n + this.id;
    }

    public static final class Advance {
        private final Font font;
        private final float advance;
        private final IntIntHashMap size2advanceI = new IntIntHashMap();

        public Advance(Font font, float f) {
            this.font = font;
            this.advance = f;
            this.size2advanceI.setKeyNotFoundValue(0);
        }

        public final void reset() {
            this.size2advanceI.clear();
        }

        public final Font getFont() {
            return this.font;
        }

        public final float getScale(float f) {
            return this.font.getMetrics().getScale(f);
        }

        public final void add(float f, float f2) {
            this.size2advanceI.put(Float.floatToIntBits(f2), Float.floatToIntBits(f));
        }

        public final float get(float f, boolean bl) {
            int n = Float.floatToIntBits(f);
            int n2 = this.size2advanceI.get(n);
            if (0 != n2) {
                return Float.intBitsToFloat(n2);
            }
            float f2 = bl ? this.advance * this.getScale(f) : (float)Math.round(this.advance * this.getScale(f));
            this.size2advanceI.put(n, Float.floatToIntBits(f2));
            return f2;
        }

        public final String toString() {
            return "\nAdvance:\n  advance: " + this.advance + "\n advances: \n" + this.size2advanceI;
        }
    }

    public static final class Metrics {
        private final AABBox bbox;
        private final Advance advance;

        public Metrics(Font font, AABBox aABBox, float f) {
            this.bbox = aABBox;
            this.advance = new Advance(font, f);
        }

        public final void reset() {
            this.advance.reset();
        }

        public final Font getFont() {
            return this.advance.getFont();
        }

        public final float getScale(float f) {
            return this.advance.getScale(f);
        }

        public final AABBox getBBox() {
            return this.bbox;
        }

        public final void addAdvance(float f, float f2) {
            this.advance.add(f, f2);
        }

        public final float getAdvance(float f, boolean bl) {
            return this.advance.get(f, bl);
        }

        public final String toString() {
            return "\nMetrics:\n  bbox: " + this.bbox + this.advance;
        }
    }
}

