/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.MemOutStream;
import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.ConnParams;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Region;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class DecodeManager {
    static LogWriter vlog = new LogWriter("DecodeManager");
    private CConnection conn;
    private Decoder[] decoders;
    private ArrayDeque<MemOutStream> freeBuffers;
    private ArrayDeque<QueueEntry> workQueue;
    private ReentrantLock queueMutex;
    private Condition producerCond;
    private Condition consumerCond;
    private List<DecodeThread> threads;
    private com.tigervnc.rdr.Exception threadException;

    public DecodeManager(CConnection cConnection) {
        this.conn = cConnection;
        this.threadException = null;
        this.decoders = new Decoder[256];
        this.queueMutex = new ReentrantLock();
        this.producerCond = this.queueMutex.newCondition();
        this.consumerCond = this.queueMutex.newCondition();
        int n = Runtime.getRuntime().availableProcessors();
        if (n == 0) {
            vlog.error("Unable to determine the number of CPU cores on this system", new Object[0]);
            n = 1;
        } else {
            vlog.info("Detected " + n + " CPU core(s)", new Object[0]);
            if (n > 4) {
                n = 4;
            }
            if (n == 1) {
                vlog.info("Decoding data on main thread", new Object[0]);
            } else {
                vlog.info("Creating " + n + " decoder thread(s)", new Object[0]);
            }
        }
        this.freeBuffers = new ArrayDeque(n * 2);
        this.workQueue = new ArrayDeque(n);
        this.threads = new ArrayList<DecodeThread>(n);
        while (n-- > 0) {
            try {
                this.freeBuffers.addLast(new MemOutStream());
                this.freeBuffers.addLast(new MemOutStream());
                this.threads.add(new DecodeThread(this));
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeRect(Rect rect, int n, ModifiablePixelBuffer modifiablePixelBuffer) {
        MemOutStream memOutStream;
        assert (modifiablePixelBuffer != null);
        if (!Decoder.supported(n)) {
            vlog.error("Unknown encoding " + n, new Object[0]);
            throw new com.tigervnc.rdr.Exception("Unknown encoding");
        }
        if (this.decoders[n] == null) {
            this.decoders[n] = Decoder.createDecoder(n);
            if (this.decoders[n] == null) {
                vlog.error("Unknown encoding " + n, new Object[0]);
                throw new com.tigervnc.rdr.Exception("Unknown encoding");
            }
        }
        Decoder decoder = this.decoders[n];
        if (this.threads.size() == 1) {
            MemOutStream memOutStream2 = this.freeBuffers.getFirst();
            memOutStream2.clear();
            decoder.readRect(rect, this.conn.getInStream(), this.conn.cp, memOutStream2);
            decoder.decodeRect(rect, memOutStream2.data(), memOutStream2.length(), this.conn.cp, modifiablePixelBuffer);
            return;
        }
        this.queueMutex.lock();
        try {
            while (this.freeBuffers.isEmpty()) {
                try {
                    this.producerCond.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            memOutStream = this.freeBuffers.getFirst();
        }
        finally {
            this.queueMutex.unlock();
        }
        this.throwThreadException();
        memOutStream.clear();
        decoder.readRect(rect, this.conn.getInStream(), this.conn.cp, memOutStream);
        QueueEntry queueEntry = new QueueEntry();
        queueEntry.active = false;
        queueEntry.rect = rect;
        queueEntry.encoding = n;
        queueEntry.decoder = decoder;
        queueEntry.cp = this.conn.cp;
        queueEntry.pb = modifiablePixelBuffer;
        queueEntry.bufferStream = memOutStream;
        decoder.getAffectedRegion(rect, memOutStream.data(), memOutStream.length(), this.conn.cp, queueEntry.affectedRegion);
        this.queueMutex.lock();
        try {
            this.freeBuffers.removeFirst();
            this.workQueue.addLast(queueEntry);
            this.consumerCond.signal();
        }
        finally {
            this.queueMutex.unlock();
        }
    }

    public void flush() {
        this.queueMutex.lock();
        try {
            while (!this.workQueue.isEmpty()) {
                try {
                    this.producerCond.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.queueMutex.unlock();
        }
        this.throwThreadException();
    }

    private void setThreadException(com.tigervnc.rdr.Exception exception) {
        this.queueMutex.lock();
        try {
            if (this.threadException != null) {
                return;
            }
            this.threadException = new com.tigervnc.rdr.Exception("Exception on worker thread: " + exception.getMessage());
        }
        finally {
            this.queueMutex.unlock();
        }
    }

    private void throwThreadException() {
        this.queueMutex.lock();
        try {
            if (this.threadException == null) {
                return;
            }
            com.tigervnc.rdr.Exception exception = new com.tigervnc.rdr.Exception(this.threadException.getMessage());
            this.threadException = null;
            throw exception;
        }
        finally {
            this.queueMutex.unlock();
        }
    }

    private class DecodeThread
    implements Runnable {
        private DecodeManager manager;
        private boolean stopRequested;
        private Thread thread;

        public DecodeThread(DecodeManager decodeManager2) {
            this.manager = decodeManager2;
            this.stopRequested = false;
            this.thread = new Thread((Runnable)this, "Decoder Thread");
            this.thread.start();
        }

        public void stop() {
            this.manager.queueMutex.lock();
            try {
                if (!this.thread.isAlive()) {
                    return;
                }
                this.stopRequested = true;
                this.manager.consumerCond.signalAll();
            }
            finally {
                this.manager.queueMutex.unlock();
            }
        }

        @Override
        public void run() {
            this.manager.queueMutex.lock();
            while (!this.stopRequested) {
                QueueEntry queueEntry;
                block7: {
                    queueEntry = this.findEntry();
                    if (queueEntry == null) {
                        try {
                            this.manager.consumerCond.await();
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    queueEntry.active = true;
                    this.manager.queueMutex.unlock();
                    try {
                        queueEntry.decoder.decodeRect(queueEntry.rect, queueEntry.bufferStream.data(), queueEntry.bufferStream.length(), queueEntry.cp, queueEntry.pb);
                    }
                    catch (com.tigervnc.rdr.Exception exception) {
                        this.manager.setThreadException(exception);
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled) break block7;
                        throw new AssertionError();
                    }
                }
                this.manager.queueMutex.lock();
                this.manager.freeBuffers.addLast(queueEntry.bufferStream);
                this.manager.workQueue.remove(queueEntry);
                queueEntry = null;
                this.manager.producerCond.signal();
                if (this.manager.workQueue.size() <= 1) continue;
                this.manager.consumerCond.signalAll();
            }
            this.manager.queueMutex.unlock();
        }

        protected QueueEntry findEntry() {
            Region region = new Region();
            if (this.manager.workQueue.isEmpty()) {
                return null;
            }
            if (!((QueueEntry)((DecodeManager)this.manager).workQueue.peek()).active) {
                return (QueueEntry)this.manager.workQueue.peek();
            }
            block0: for (QueueEntry queueEntry : this.manager.workQueue) {
                QueueEntry queueEntry2;
                Iterator iterator;
                if (queueEntry.active) {
                    region.assign_union(queueEntry.affectedRegion);
                    continue;
                }
                if ((queueEntry.decoder.flags & Decoder.DecoderFlags.DecoderOrdered) != 0) {
                    iterator = this.manager.workQueue.iterator();
                    while (iterator.hasNext() && !(queueEntry2 = (QueueEntry)iterator.next()).equals(queueEntry)) {
                        if (queueEntry.encoding != queueEntry2.encoding) continue;
                        region.assign_union(queueEntry.affectedRegion);
                        continue block0;
                    }
                }
                if ((queueEntry.decoder.flags & Decoder.DecoderFlags.DecoderPartiallyOrdered) != 0) {
                    iterator = this.manager.workQueue.iterator();
                    while (iterator.hasNext() && !(queueEntry2 = (QueueEntry)iterator.next()).equals(queueEntry)) {
                        if (queueEntry.encoding != queueEntry2.encoding) continue;
                        if (!queueEntry.decoder.doRectsConflict(queueEntry.rect, queueEntry.bufferStream.data(), queueEntry.bufferStream.length(), queueEntry2.rect, queueEntry2.bufferStream.data(), queueEntry2.bufferStream.length(), queueEntry.cp)) continue block0;
                        region.assign_union(queueEntry.affectedRegion);
                        continue block0;
                    }
                }
                if (!region.intersect(queueEntry.affectedRegion).is_empty()) {
                    region.assign_union(queueEntry.affectedRegion);
                    continue;
                }
                return queueEntry;
            }
            return null;
        }
    }

    private class QueueEntry {
        public boolean active;
        public Rect rect;
        public int encoding;
        public Decoder decoder;
        public ConnParams cp;
        public ModifiablePixelBuffer pb;
        public MemOutStream bufferStream;
        public Region affectedRegion = new Region();
    }
}

