/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.util.Classes;
import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.Message;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;

public final class Messages {
    private static final Collection<Converter<?>> converters = ImmutableList.of(new Converter<Class>(Class.class){

        @Override
        public String toString(Class c) {
            return c.getName();
        }
    }, new Converter<Member>(Member.class){

        @Override
        public String toString(Member member) {
            return Classes.toString(member);
        }
    }, new Converter<Key>(Key.class){

        @Override
        public String toString(Key key2) {
            if (key2.getAnnotationType() != null) {
                return key2.getTypeLiteral() + " annotated with " + (key2.getAnnotation() != null ? key2.getAnnotation() : key2.getAnnotationType());
            }
            return key2.getTypeLiteral().toString();
        }
    });

    private Messages() {
    }

    static Message mergeSources(List<Object> sources, Message message) {
        List<Object> messageSources = message.getSources();
        if (!sources.isEmpty() && !messageSources.isEmpty() && Objects.equal(messageSources.get(0), sources.get(sources.size() - 1))) {
            messageSources = messageSources.subList(1, messageSources.size());
        }
        return new Message((List<Object>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(sources)).addAll(messageSources)).build()), message.getMessage(), message.getCause());
    }

    public static String format(String messageFormat, Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = Messages.convert(arguments[i]);
        }
        return String.format(messageFormat, arguments);
    }

    public static String formatMessages(String heading, Collection<Message> errorMessages) {
        Formatter fmt = new Formatter().format(heading, new Object[0]).format(":%n%n", new Object[0]);
        int index2 = 1;
        boolean displayCauses = Messages.getOnlyCause(errorMessages) == null;
        HashMap<Equivalence.Wrapper<Throwable>, Integer> causes = Maps.newHashMap();
        for (Message errorMessage : errorMessages) {
            int thisIdx = index2++;
            fmt.format("%s) %s%n", thisIdx, errorMessage.getMessage());
            List<Object> dependencies = errorMessage.getSources();
            for (int i = dependencies.size() - 1; i >= 0; --i) {
                Object source2 = dependencies.get(i);
                Messages.formatSource(fmt, source2);
            }
            Throwable cause = errorMessage.getCause();
            if (displayCauses && cause != null) {
                Equivalence.Wrapper<Throwable> causeEquivalence = ThrowableEquivalence.INSTANCE.wrap(cause);
                if (!causes.containsKey(causeEquivalence)) {
                    causes.put(causeEquivalence, thisIdx);
                    fmt.format("Caused by: %s", Throwables.getStackTraceAsString(cause));
                } else {
                    int causeIdx = (Integer)causes.get(causeEquivalence);
                    fmt.format("Caused by: %s (same stack trace as error #%s)", cause.getClass().getName(), causeIdx);
                }
            }
            fmt.format("%n", new Object[0]);
        }
        if (errorMessages.size() == 1) {
            fmt.format("1 error", new Object[0]);
        } else {
            fmt.format("%s errors", errorMessages.size());
        }
        return fmt.toString();
    }

    public static Message create(String messageFormat, Object ... arguments) {
        return Messages.create(null, messageFormat, arguments);
    }

    public static Message create(Throwable cause, String messageFormat, Object ... arguments) {
        return Messages.create(cause, ImmutableList.of(), messageFormat, arguments);
    }

    public static Message create(Throwable cause, List<Object> sources, String messageFormat, Object ... arguments) {
        String message = Messages.format(messageFormat, arguments);
        return new Message(sources, message, cause);
    }

    static Object convert(Object o) {
        ElementSource source2 = null;
        if (o instanceof ElementSource) {
            source2 = (ElementSource)o;
            o = source2.getDeclaringSource();
        }
        return Messages.convert(o, source2);
    }

    static Object convert(Object o, ElementSource source2) {
        for (Converter<?> converter : converters) {
            if (!converter.appliesTo(o)) continue;
            return Messages.appendModules(converter.convert(o), source2);
        }
        return Messages.appendModules(o, source2);
    }

    private static Object appendModules(Object source2, ElementSource elementSource) {
        String modules = Messages.moduleSourceString(elementSource);
        if (modules.length() == 0) {
            return source2;
        }
        return source2 + modules;
    }

    private static String moduleSourceString(ElementSource elementSource) {
        if (elementSource == null) {
            return "";
        }
        ArrayList<String> modules = Lists.newArrayList(elementSource.getModuleClassNames());
        while (elementSource.getOriginalElementSource() != null) {
            elementSource = elementSource.getOriginalElementSource();
            modules.addAll(0, elementSource.getModuleClassNames());
        }
        if (modules.size() <= 1) {
            return "";
        }
        StringBuilder builder = new StringBuilder(" (via modules: ");
        for (int i = modules.size() - 1; i >= 0; --i) {
            builder.append((String)modules.get(i));
            if (i == 0) continue;
            builder.append(" -> ");
        }
        builder.append(")");
        return builder.toString();
    }

    static void formatSource(Formatter formatter2, Object source2) {
        ElementSource elementSource = null;
        if (source2 instanceof ElementSource) {
            elementSource = (ElementSource)source2;
            source2 = elementSource.getDeclaringSource();
        }
        Messages.formatSource(formatter2, source2, elementSource);
    }

    static void formatSource(Formatter formatter2, Object source2, ElementSource elementSource) {
        String modules = Messages.moduleSourceString(elementSource);
        if (source2 instanceof Dependency) {
            Dependency dependency = (Dependency)source2;
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            if (injectionPoint != null) {
                Messages.formatInjectionPoint(formatter2, dependency, injectionPoint, elementSource);
            } else {
                Messages.formatSource(formatter2, dependency.getKey(), elementSource);
            }
        } else if (source2 instanceof InjectionPoint) {
            Messages.formatInjectionPoint(formatter2, null, (InjectionPoint)source2, elementSource);
        } else if (source2 instanceof Class) {
            formatter2.format("  at %s%s%n", StackTraceElements.forType((Class)source2), modules);
        } else if (source2 instanceof Member) {
            formatter2.format("  at %s%s%n", StackTraceElements.forMember((Member)source2), modules);
        } else if (source2 instanceof TypeLiteral) {
            formatter2.format("  while locating %s%s%n", source2, modules);
        } else if (source2 instanceof Key) {
            Key key2 = (Key)source2;
            formatter2.format("  while locating %s%n", Messages.convert(key2, elementSource));
        } else if (source2 instanceof Thread) {
            formatter2.format("  in thread %s%n", source2);
        } else {
            formatter2.format("  at %s%s%n", source2, modules);
        }
    }

    private static void formatInjectionPoint(Formatter formatter2, Dependency<?> dependency, InjectionPoint injectionPoint, ElementSource elementSource) {
        Member member = injectionPoint.getMember();
        Class<? extends Member> memberType = Classes.memberType(member);
        if (memberType == Field.class) {
            dependency = injectionPoint.getDependencies().get(0);
            formatter2.format("  while locating %s%n", Messages.convert(dependency.getKey(), elementSource));
            formatter2.format("    for field at %s%n", StackTraceElements.forMember(member));
        } else if (dependency != null) {
            formatter2.format("  while locating %s%n", Messages.convert(dependency.getKey(), elementSource));
            formatter2.format("    for %s%n", Messages.formatParameter(dependency));
        } else {
            Messages.formatSource(formatter2, injectionPoint.getMember());
        }
    }

    static String formatParameter(Dependency<?> dependency) {
        int ordinal = dependency.getParameterIndex() + 1;
        return String.format("the %s%s parameter of %s", ordinal, Messages.getOrdinalSuffix(ordinal), StackTraceElements.forMember(dependency.getInjectionPoint().getMember()));
    }

    private static String getOrdinalSuffix(int ordinal) {
        Preconditions.checkArgument(ordinal >= 0);
        if (ordinal / 10 % 10 == 1) {
            return "th";
        }
        switch (ordinal % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public static Throwable getOnlyCause(Collection<Message> messages) {
        Throwable onlyCause = null;
        for (Message message : messages) {
            Throwable messageCause = message.getCause();
            if (messageCause == null) continue;
            if (onlyCause != null && !ThrowableEquivalence.INSTANCE.equivalent(onlyCause, messageCause)) {
                return null;
            }
            onlyCause = messageCause;
        }
        return onlyCause;
    }

    private static final class ThrowableEquivalence
    extends Equivalence<Throwable> {
        static final ThrowableEquivalence INSTANCE = new ThrowableEquivalence();

        private ThrowableEquivalence() {
        }

        @Override
        protected boolean doEquivalent(Throwable a, Throwable b) {
            return a.getClass().equals(b.getClass()) && Objects.equal(a.getMessage(), b.getMessage()) && Arrays.equals(a.getStackTrace(), b.getStackTrace()) && this.equivalent(a.getCause(), b.getCause());
        }

        @Override
        protected int doHash(Throwable t) {
            return Objects.hashCode(t.getClass().hashCode(), t.getMessage(), this.hash(t.getCause()));
        }
    }

    private static abstract class Converter<T> {
        final Class<T> type;

        Converter(Class<T> type2) {
            this.type = type2;
        }

        boolean appliesTo(Object o) {
            return o != null && this.type.isAssignableFrom(o.getClass());
        }

        String convert(Object o) {
            return this.toString(this.type.cast(o));
        }

        abstract String toString(T var1);
    }
}

